/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.cimxml.sax.node;

import javax.cim.CIMObjectPath;
import javax.cim.CIMProperty;
import org.sblim.cimclient.internal.cimxml.LocalPathBuilder;
import org.sblim.cimclient.internal.cimxml.sax.SAXSession;
import org.sblim.cimclient.internal.cimxml.sax.node.AbstractObjectPathNode;
import org.sblim.cimclient.internal.cimxml.sax.node.InstanceNameNode;
import org.sblim.cimclient.internal.cimxml.sax.node.LocalNameSpacePathNode;
import org.sblim.cimclient.internal.cimxml.sax.node.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LocalInstancePathNode
extends AbstractObjectPathNode {
    private boolean iHasLocalNameSpacePath;
    private String iNameSpaceStr;
    private boolean iHasInstanceName;
    private String iClassNameStr;
    private CIMProperty<?>[] iKeys;
    private CIMObjectPath iLocalPath;

    public LocalInstancePathNode() {
        super("LOCALINSTANCEPATH");
    }

    public void init(Attributes pAttribs, SAXSession pSession) {
        this.iLocalPath = pSession.getDefLocalPath();
        this.iHasInstanceName = false;
        this.iHasLocalNameSpacePath = false;
        this.iClassNameStr = null;
        this.iNameSpaceStr = null;
        this.iKeys = null;
    }

    public void parseData(String pData) {
    }

    public void testChild(String pNodeNameEnum) throws SAXException {
        if (pNodeNameEnum == "LOCALNAMESPACEPATH") {
            if (this.iHasLocalNameSpacePath) {
                throw new SAXException(this.getNodeName() + " node can have only one LOCALNAMESPACEPATH child node!");
            }
        } else if (pNodeNameEnum == "INSTANCENAME") {
            if (this.iHasInstanceName) {
                throw new SAXException(this.getNodeName() + " node can have only one INSTANCENAME child node!");
            }
        } else {
            throw new SAXException(this.getNodeName() + " node cannot have " + pNodeNameEnum + " child node!");
        }
    }

    public void childParsed(Node pChild) {
        if (pChild instanceof LocalNameSpacePathNode) {
            this.iHasLocalNameSpacePath = true;
            this.iNameSpaceStr = ((LocalNameSpacePathNode)pChild).getNameSpace();
        } else {
            this.iHasInstanceName = true;
            InstanceNameNode instNameNode = (InstanceNameNode)pChild;
            this.iClassNameStr = instNameNode.getClassName();
            this.iKeys = instNameNode.getKeys();
        }
    }

    public void testCompletness() throws SAXException {
        if (!this.iHasLocalNameSpacePath) {
            throw new SAXException(this.getNodeName() + " node must have a LOCALNAMESPACEPATH child node!");
        }
        if (!this.iHasInstanceName) {
            throw new SAXException(this.getNodeName() + " node must have a INSTANCENAME child node!");
        }
    }

    public CIMObjectPath getCIMObjectPath() {
        return LocalPathBuilder.build(this.iLocalPath, this.iClassNameStr, this.iNameSpaceStr, this.iKeys);
    }
}

