/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.cimxml.sax.node;

import javax.cim.CIMDataType;
import org.sblim.cimclient.internal.cim.CIMHelper;
import org.sblim.cimclient.internal.cimxml.sax.CIMObjectFactory;
import org.sblim.cimclient.internal.cimxml.sax.NodeConstIf;
import org.sblim.cimclient.internal.cimxml.sax.SAXSession;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class Node
implements NodeConstIf {
    private String iNameEnum;
    private boolean iCompleted;

    public Node(String pNameEnum) {
        this.iNameEnum = pNameEnum;
    }

    public String getNodeName() {
        return this.iNameEnum;
    }

    public abstract void init(Attributes var1, SAXSession var2) throws SAXException;

    public abstract void parseData(String var1) throws SAXException;

    public abstract void testChild(String var1) throws SAXException;

    public abstract void testCompletness() throws SAXException;

    public abstract void childParsed(Node var1) throws SAXException;

    public boolean isCompleted() {
        return this.iCompleted;
    }

    public void setCompleted() {
        this.iCompleted = true;
    }

    public void clearCompleted() {
        this.iCompleted = false;
    }

    public static String getCIMName(Attributes pAttribs) throws SAXException {
        String name = pAttribs.getValue("NAME");
        if (name == null) {
            throw new SAXException("NAME attribute not found!");
        }
        return name;
    }

    public static String getClassName(Attributes pAttribs) throws SAXException {
        String name = pAttribs.getValue("CLASSNAME");
        if (name == null) {
            throw new SAXException("CLASSNAME attribute not found!");
        }
        return name;
    }

    public static String getReferenceClass(Attributes pAttribs) {
        return pAttribs.getValue("REFERENCECLASS");
    }

    public static String getClassOrigin(Attributes pAttribs) {
        return pAttribs.getValue("CLASSORIGIN");
    }

    public static boolean getPropagated(Attributes pAttribs) {
        String str = pAttribs.getValue("PROPAGATED");
        return "true".equalsIgnoreCase(str);
    }

    public static int getArraySize(Attributes pAttribs) throws SAXException {
        String arraySizeStr = pAttribs.getValue("ARRAYSIZE");
        int size = 0;
        try {
            size = arraySizeStr == null || arraySizeStr.length() == 0 ? 0 : Integer.parseInt(arraySizeStr);
        }
        catch (NumberFormatException e) {
            throw new SAXException(arraySizeStr + " is not a valid ARRAYSIZE attribute!");
        }
        if (size < 0) {
            throw new SAXException("ARRAYSIZE cannot be " + size + "!");
        }
        return size;
    }

    public static CIMDataType getCIMType(Attributes pAttribs, boolean pOptional) throws SAXException {
        int arraySize;
        String typeStr = pAttribs.getValue("TYPE");
        if (typeStr == null) {
            if (pOptional) {
                return null;
            }
            throw new SAXException("TYPE attribute not found!");
        }
        CIMDataType type = CIMObjectFactory.getType(typeStr);
        if (type == null) {
            throw new SAXException(typeStr + " is not a valid TYPE attribute!");
        }
        if (type.getType() == 14) {
            throw new SAXException("TYPE attribute cannot be \"reference\"!");
        }
        boolean isArray = Node.hasTrueAttribute(pAttribs, "ISARRAY");
        String arraySizeStr = pAttribs.getValue("ARRAYSIZE");
        try {
            arraySize = arraySizeStr == null || arraySizeStr.length() == 0 ? (isArray ? 0 : -1) : Integer.parseInt(arraySizeStr);
        }
        catch (NumberFormatException e) {
            throw new SAXException(arraySizeStr + " is not a valid ARRAYSIZE attribute!");
        }
        if (isArray || arraySize >= 0) {
            if (arraySize > 0) {
                return new CIMDataType(type.getType(), arraySize);
            }
            return CIMHelper.UnboundedArrayDataType(type.getType());
        }
        return type;
    }

    public static CIMDataType getCIMType(Attributes pAttribs) throws SAXException {
        return Node.getCIMType(pAttribs, false);
    }

    public static CIMDataType getParamType(Attributes pAttribs) throws SAXException {
        String typeStr = pAttribs.getValue("PARAMTYPE");
        return CIMObjectFactory.getType(typeStr);
    }

    public int getQualifierFlavor(Attributes pAttribs) {
        int flavors = 0;
        if (!Node.getBoolAttribute(pAttribs, "OVERRIDABLE", true)) {
            flavors |= 1;
        }
        if (!Node.getBoolAttribute(pAttribs, "TOSUBCLASS", true)) {
            flavors |= 2;
        }
        if (Node.getBoolAttribute(pAttribs, "TRANSLATABLE", false)) {
            flavors |= 4;
        }
        return flavors;
    }

    public static boolean hasTrueAttribute(Attributes pAttribs, String pName) {
        return "true".equalsIgnoreCase(pAttribs.getValue(pName));
    }

    public static boolean getBoolAttribute(Attributes pAttribs, String pName, boolean pDefVal) {
        String val = pAttribs.getValue(pName);
        if ("true".equalsIgnoreCase(val)) {
            return true;
        }
        if ("false".equalsIgnoreCase(val)) {
            return false;
        }
        return pDefVal;
    }

    public void duplicatedNode(String pParsedNodeName, String pNewNodeName) throws SAXException {
        throw new SAXException(this.getNodeName() + " has a " + pParsedNodeName + " child node which disallows an additional " + pNewNodeName + " child node!");
    }

    public void illegalChildNodePair(String pNodeName0, String pNodeName1) throws SAXException {
        throw new SAXException(pNodeName0 + ", " + pNodeName1 + " child node pair is illegal for " + this.getNodeName() + " node!");
    }
}

