/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.cimxml.sax.node;

import javax.cim.CIMDataType;
import javax.cim.CIMObjectPath;
import javax.cim.CIMQualifierType;
import org.sblim.cimclient.internal.cim.CIMHelper;
import org.sblim.cimclient.internal.cimxml.sax.CIMObjectFactory;
import org.sblim.cimclient.internal.cimxml.sax.SAXSession;
import org.sblim.cimclient.internal.cimxml.sax.node.Node;
import org.sblim.cimclient.internal.cimxml.sax.node.ScopeNode;
import org.sblim.cimclient.internal.cimxml.sax.node.TypedIf;
import org.sblim.cimclient.internal.cimxml.sax.node.ValueArrayNode;
import org.sblim.cimclient.internal.cimxml.sax.node.ValueIf;
import org.sblim.cimclient.internal.cimxml.sax.node.ValueNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualiDeclNode
extends Node
implements TypedIf,
ValueIf {
    private boolean iHasScope;
    private int iScope;
    private String iValueNodeName;
    private Object iValue;
    private String iName;
    private CIMDataType iType;
    private int iFlavor;

    public QualiDeclNode() {
        super("QUALIFIER.DECLARATION");
    }

    public String getName() {
        return this.iName;
    }

    @Override
    public CIMDataType getType() {
        return this.iType;
    }

    public int getFlavor() {
        return this.iFlavor;
    }

    @Override
    public void init(Attributes pAttribs, SAXSession pSession) throws SAXException {
        this.iHasScope = false;
        this.iScope = 0;
        this.iValueNodeName = null;
        this.iValue = null;
        this.iName = QualiDeclNode.getCIMName(pAttribs);
        this.iType = QualiDeclNode.getCIMType(pAttribs, true);
        this.iFlavor = this.getQualifierFlavor(pAttribs);
    }

    @Override
    public void parseData(String pData) {
    }

    @Override
    public void testChild(String pNodeNameEnum) throws SAXException {
        if (pNodeNameEnum == "VALUE" || pNodeNameEnum == "VALUE.ARRAY") {
            if (this.iValueNodeName != null) {
                throw new SAXException("Cannot add " + pNodeNameEnum + " node, this " + this.getNodeName() + " node has already got a " + this.iValueNodeName + " node!");
            }
        } else if (pNodeNameEnum == "SCOPE") {
            if (this.iHasScope) {
                throw new SAXException("Cannot add " + pNodeNameEnum + " node, this " + this.getNodeName() + " node has already got one!");
            }
        } else {
            throw new SAXException(this.getNodeName() + " node cannot have " + pNodeNameEnum + " child node!");
        }
    }

    private void setType(TypedIf pTypedIf) throws SAXException {
        if (this.iType != null) {
            return;
        }
        this.iType = pTypedIf.getType();
        if (this.iType == null) {
            throw new SAXException("Unknown type for Qualifier declaration in " + this.getNodeName() + " node!");
        }
    }

    @Override
    public void childParsed(Node pChild) throws SAXException {
        if (pChild instanceof ScopeNode) {
            this.iHasScope = true;
            this.iScope = ((ScopeNode)pChild).getScope();
        } else {
            this.iValueNodeName = pChild.getNodeName();
            if (pChild instanceof ValueArrayNode) {
                ValueArrayNode valAChild = (ValueArrayNode)pChild;
                this.setType(valAChild);
                this.iValue = CIMObjectFactory.getObject(this.iType, valAChild);
                if (!this.iType.isArray()) {
                    this.iType = CIMHelper.UnboundedArrayDataType(this.iType.getType());
                }
            } else if (pChild instanceof ValueNode) {
                ValueNode valChild = (ValueNode)pChild;
                this.setType(valChild);
                this.iValue = CIMObjectFactory.getObject(this.iType, valChild);
            } else {
                this.iValue = null;
            }
        }
    }

    @Override
    public void testCompletness() throws SAXException {
        if (this.iType == null) {
            throw new SAXException("Unknown type for Qualifier declaration in " + this.getNodeName() + " node!");
        }
    }

    public CIMQualifierType<Object> getCIMQualifierType() {
        return new CIMQualifierType<Object>(new CIMObjectPath(null, null, null, null, this.iName, null), this.iType, this.iValue, this.iScope, this.iFlavor);
    }

    @Override
    public Object getValue() {
        return this.getCIMQualifierType();
    }
}

