/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.cimxml.sax.node;

import java.util.ArrayList;
import javax.cim.CIMDataType;
import javax.cim.CIMQualifier;
import org.sblim.cimclient.GenericExts;
import org.sblim.cimclient.internal.cim.CIMQualifiedElementInterfaceImpl;
import org.sblim.cimclient.internal.cimxml.sax.node.Node;
import org.sblim.cimclient.internal.cimxml.sax.node.QualifierNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifiedNodeHandler {
    private static final Boolean TRUE = Boolean.TRUE;
    private ArrayList<CIMQualifier<?>> iQualiAL;
    private CIMQualifiedElementInterfaceImpl iQualiImpl;
    private boolean iHasEmbObjQuali;
    private boolean iHasEmbInstQuali;
    private boolean iHasKeyQuali;
    private boolean iHasAssocQuali;
    private static final CIMQualifier<?>[] EMPTY_QA = new CIMQualifier[0];

    public static QualifiedNodeHandler init(QualifiedNodeHandler pQNH) {
        if (pQNH == null) {
            pQNH = new QualifiedNodeHandler();
        }
        pQNH.init();
        return pQNH;
    }

    public void init() {
        this.iQualiAL = GenericExts.initClearArrayList(this.iQualiAL);
        this.iHasAssocQuali = false;
        this.iHasKeyQuali = false;
        this.iHasEmbInstQuali = false;
        this.iHasEmbObjQuali = false;
        this.iQualiImpl = null;
    }

    public boolean addQualifierNode(Node pNode) {
        CIMQualifier<Object> quali;
        if (!(pNode instanceof QualifierNode)) {
            return false;
        }
        if (this.iQualiAL == null) {
            this.iQualiAL = new ArrayList();
        }
        if ((quali = ((QualifierNode)pNode).getQualifier()) != null) {
            if (CIMDataType.BOOLEAN_T.equals(quali.getDataType()) && TRUE.equals(quali.getValue())) {
                if ("EmbeddedObject".equalsIgnoreCase(quali.getName())) {
                    this.iHasEmbObjQuali = true;
                } else if ("KEY".equalsIgnoreCase(quali.getName())) {
                    this.iHasKeyQuali = true;
                } else if ("ASSOCIATION".equalsIgnoreCase(quali.getName())) {
                    this.iHasAssocQuali = true;
                }
            } else if (CIMDataType.STRING_T.equals(quali.getDataType()) && "EMBEDDEDINSTANCE".equalsIgnoreCase(quali.getName())) {
                this.iHasEmbInstQuali = true;
            }
            this.iQualiAL.add(quali);
        }
        return true;
    }

    public CIMQualifier<?>[] getQualis() {
        return this.getQualis(false);
    }

    public CIMQualifier<?>[] getQualis(boolean pIncludeEmbObj) {
        this.makeQualiImpl(pIncludeEmbObj);
        return this.iQualiImpl.getQualifiers();
    }

    public boolean isKeyed() {
        return this.iHasKeyQuali;
    }

    public boolean isAssociation() {
        return this.iHasAssocQuali;
    }

    public boolean isEmbeddedObject() {
        return this.iHasEmbObjQuali;
    }

    public boolean isEmbeddedInstance() {
        return this.iHasEmbInstQuali;
    }

    private void makeQualiImpl(boolean pIncludeEmbObj) {
        if (this.iQualiImpl != null) {
            return;
        }
        if (this.iQualiAL == null) {
            this.iQualiImpl = new CIMQualifiedElementInterfaceImpl(null);
            return;
        }
        this.iQualiImpl = new CIMQualifiedElementInterfaceImpl(this.iQualiAL.toArray(EMPTY_QA), this.iHasKeyQuali, pIncludeEmbObj);
        this.iQualiAL = null;
    }
}

