/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.cimxml.sax.node;

import javax.cim.CIMDataType;
import javax.cim.CIMQualifier;
import org.sblim.cimclient.internal.cim.CIMHelper;
import org.sblim.cimclient.internal.cimxml.sax.CIMObjectFactory;
import org.sblim.cimclient.internal.cimxml.sax.SAXSession;
import org.sblim.cimclient.internal.cimxml.sax.node.AbstractValueNode;
import org.sblim.cimclient.internal.cimxml.sax.node.Node;
import org.sblim.cimclient.internal.cimxml.sax.node.TypedIf;
import org.sblim.cimclient.internal.cimxml.sax.node.ValueArrayNode;
import org.sblim.cimclient.internal.cimxml.sax.node.ValueNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifierNode
extends Node {
    private String iName;
    private CIMDataType iType;
    private boolean iPropagated;
    private int iFlavor;
    private CIMQualifier<Object> iQuali;

    public QualifierNode() {
        super("QUALIFIER");
    }

    @Override
    public void init(Attributes pAttribs, SAXSession pSession) throws SAXException {
        this.iQuali = null;
        this.iName = QualifierNode.getCIMName(pAttribs);
        this.iType = QualifierNode.getCIMType(pAttribs, true);
        this.iPropagated = QualifierNode.getPropagated(pAttribs);
        this.iFlavor = this.getQualifierFlavor(pAttribs);
    }

    @Override
    public void parseData(String pData) {
    }

    @Override
    public void testChild(String pNodeNameEnum) throws SAXException {
        if (this.iQuali != null) {
            throw new SAXException(this.getNodeName() + " node can have only one VALUE or VALUE.ARRAY child node!");
        }
        if (pNodeNameEnum != "VALUE" && pNodeNameEnum != "VALUE.ARRAY") {
            throw new SAXException(pNodeNameEnum + " child node is not valid for " + this.getNodeName() + " node!");
        }
    }

    @Override
    public void childParsed(Node pChild) throws SAXException {
        CIMDataType type;
        Object value;
        AbstractValueNode absValNode = (AbstractValueNode)pChild;
        if (absValNode instanceof ValueArrayNode) {
            ValueArrayNode valANode = (ValueArrayNode)absValNode;
            this.setType(valANode);
            value = CIMObjectFactory.getObject(this.iType, valANode);
            type = this.iType.isArray() ? this.iType : CIMHelper.UnboundedArrayDataType(this.iType.getType());
        } else if (absValNode instanceof ValueNode) {
            ValueNode valNode = (ValueNode)absValNode;
            this.setType(valNode);
            String valueStr = (String)valNode.getValue();
            type = this.iType;
            value = CIMObjectFactory.getObject(type, valueStr);
        } else {
            type = CIMDataType.STRING_T;
            value = null;
        }
        this.iQuali = new CIMQualifier<Object>(this.iName, type, value, this.iFlavor, this.iPropagated);
    }

    @Override
    public void testCompletness() {
    }

    public CIMQualifier<Object> getQualifier() {
        return this.iQuali;
    }

    private void setType(TypedIf pTypedIf) throws SAXException {
        if (this.iType != null) {
            return;
        }
        this.iType = pTypedIf.getType();
        if (this.iType == null) {
            throw new SAXException("Unknown type for Qualifier declaration in " + this.getNodeName() + " node!");
        }
    }
}

