/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.http;

import java.util.Vector;
import org.sblim.cimclient.internal.http.HttpHeader;
import org.sblim.cimclient.internal.http.HttpParseException;

public class Challenge {
    private String iScheme;
    private HttpHeader iParams;

    private Challenge() {
    }

    public HttpHeader getParams() {
        return this.iParams;
    }

    public String getScheme() {
        return this.iScheme;
    }

    public String getRealm() {
        return this.iParams.getField("realm");
    }

    public static Challenge[] parseChallenge(String pLine) throws HttpParseException {
        if (pLine == null || pLine.length() == 0) {
            throw new IllegalArgumentException("Invalid challenge, empty");
        }
        if ((pLine = pLine.trim()).length() == 0) {
            throw new IllegalArgumentException("Invalid challenge, empty");
        }
        Vector<Challenge> challenges = new Vector<Challenge>();
        try {
            int start = 0;
            int end = 0;
            Vector<String> tokensBetweenCommas = new Vector<String>();
            while ((end = Challenge.indexOfOutsideQuotedString(pLine, 44, start)) > 0) {
                tokensBetweenCommas.add(Challenge.removeWhitespace(pLine.substring(start, end)));
                start = end + 1;
            }
            if (start < pLine.length()) {
                tokensBetweenCommas.add(Challenge.removeWhitespace(pLine.substring(start)));
            }
            Vector<String> tokens = new Vector<String>();
            for (int i = 0; i < tokensBetweenCommas.size(); ++i) {
                String token = (String)tokensBetweenCommas.elementAt(i);
                if (token.length() == 0) continue;
                start = 0;
                end = Challenge.indexOfOutsideQuotedString(token, 32, start);
                if (end == -1) {
                    tokens.add(token);
                    continue;
                }
                tokens.add(token.substring(0, end));
                start = end + 1;
                end = Challenge.indexOfOutsideQuotedString(token, 32, start);
                if (end == -1) {
                    if (Challenge.indexOfOutsideQuotedString(token, 61, start) == -1) continue;
                    tokens.add(token.substring(start));
                    continue;
                }
                throw new HttpParseException("Invalid challenge, too many tokens in " + token);
            }
            Challenge challenge = new Challenge();
            challenge.iScheme = null;
            challenge.iParams = new HttpHeader();
            for (int i = 0; i < tokens.size(); ++i) {
                String token = (String)tokens.elementAt(i);
                int equalSign = Challenge.indexOfOutsideQuotedString(token, 61, 0);
                if (equalSign == 0) {
                    throw new HttpParseException("Invalid challenge, no token before equal sign in " + token);
                }
                if (equalSign > 0) {
                    if (challenge.iScheme == null) {
                        throw new HttpParseException("Invalid challenge, param without scheme");
                    }
                    String name = token.substring(0, equalSign);
                    String value = token.substring(equalSign + 1);
                    if (value.length() == 0) {
                        throw new HttpParseException("Invalid challenge, no token after equal sign in " + token);
                    }
                    if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
                        challenge.iParams.addField(name, value.substring(1, value.length() - 1));
                        continue;
                    }
                    challenge.iParams.addField(name, value);
                    continue;
                }
                if (challenge.iScheme != null) {
                    challenges.add(challenge);
                    challenge = new Challenge();
                    challenge.iParams = new HttpHeader();
                }
                challenge.iScheme = new String(token);
            }
            if (challenge.iScheme != null) {
                challenges.add(challenge);
            }
        }
        catch (HttpParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HttpParseException("Invalid challenge, " + e.getMessage());
        }
        return challenges.toArray(new Challenge[challenges.size()]);
    }

    private static String removeWhitespace(String str) throws HttpParseException {
        char[] inBuf = str.trim().toCharArray();
        StringBuilder outStr = new StringBuilder();
        boolean inQuotes = false;
        for (int inIdx = 0; inIdx < inBuf.length; ++inIdx) {
            if (inQuotes || !Character.isSpaceChar(inBuf[inIdx])) {
                if (inBuf[inIdx] == '=' && outStr.length() == 0) {
                    throw new HttpParseException("Invalid challenge, no token before equal sign in " + str);
                }
                outStr.append(inBuf[inIdx]);
            } else {
                int i = Challenge.skipSpaces(inBuf, inIdx + 1);
                if (i >= inBuf.length) {
                    throw new HttpParseException("Invalid challenge, no token after space in " + str);
                }
                if (inBuf[i] == '=') {
                    if ((i = Challenge.skipSpaces(inBuf, i + 1)) >= inBuf.length) {
                        throw new HttpParseException("Invalid challenge, no token after equal sign in " + str);
                    }
                    outStr.append('=');
                } else {
                    outStr.append(' ');
                }
                outStr.append(inBuf[i]);
                inIdx = i;
            }
            if (inBuf[inIdx] != '\"') continue;
            inQuotes = !inQuotes;
        }
        if (inQuotes) {
            throw new HttpParseException("Invalid challenge, quoted string not terminated in " + str);
        }
        return outStr.toString();
    }

    private static int skipSpaces(char[] buf, int pos) {
        while (pos < buf.length && Character.isSpaceChar(buf[pos])) {
            ++pos;
        }
        return pos;
    }

    private static int indexOfOutsideQuotedString(String str, int ch, int pos) throws HttpParseException {
        int len = str.length();
        boolean inQuotes = false;
        while (pos < len) {
            if (str.charAt(pos) == '\"') {
                inQuotes = !inQuotes;
            } else if (str.charAt(pos) == ch && !inQuotes) {
                return pos;
            }
            ++pos;
        }
        if (inQuotes) {
            throw new HttpParseException("Invalid callenge, quoted string not terminated in " + str);
        }
        return -1;
    }
}

