/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.http;

import java.io.IOException;
import java.io.InputStream;
import org.sblim.cimclient.internal.http.HttpException;
import org.sblim.cimclient.internal.http.HttpMethod;
import org.sblim.cimclient.internal.http.io.ASCIIPrintStream;

public class HttpClientMethod
extends HttpMethod {
    private boolean iIncomming = true;
    private String iHttpHeader;
    private int iMinor;
    private int iMajor;
    private int iStatus;
    private String iMethod;
    private String iRequest;
    private String iResponse;

    public HttpClientMethod(String pMethod, String pRequest, int pMajor, int pMinor) {
        this.iMinor = pMinor;
        this.iMajor = pMajor;
        this.iRequest = pRequest;
        this.iMethod = pMethod;
        this.iIncomming = false;
    }

    public HttpClientMethod(InputStream pReader) throws IOException {
        String line = null;
        while ((line = HttpClientMethod.readLine(pReader)) == null || line.length() == 0) {
        }
        int rqt = line.indexOf(32);
        int prev = 0;
        if (rqt > -1) {
            int next = rqt;
            this.iHttpHeader = line.substring(prev, next).toUpperCase();
            prev = this.iHttpHeader.indexOf(47);
            if (prev > 0 && this.iHttpHeader.substring(0, prev).equalsIgnoreCase("HTTP")) {
                next = this.iHttpHeader.indexOf(46, prev + 1);
                try {
                    this.iMajor = Integer.parseInt(this.iHttpHeader.substring(prev + 1, next));
                    this.iMinor = Integer.parseInt(this.iHttpHeader.substring(next + 1));
                }
                catch (Exception e) {
                    throw new HttpException(405, "Bad method");
                }
                prev = rqt;
                rqt = line.indexOf(32, prev + 1);
                if (rqt > -1) {
                    try {
                        this.iStatus = Integer.parseInt(line.substring(prev + 1, rqt));
                    }
                    catch (Exception e) {
                        throw new HttpException(405, "Bad method");
                    }
                    this.iResponse = line.substring(rqt + 1);
                    return;
                }
            } else {
                throw new HttpException(405, "Bad method");
            }
        }
        throw new HttpException(405, "Bad method");
    }

    public int getMajorVersion() {
        return this.iMajor;
    }

    public int getMinorVersion() {
        return this.iMinor;
    }

    public String getMethodName() {
        return this.iMethod;
    }

    public int getStatus() {
        return this.iStatus;
    }

    public void write(ASCIIPrintStream pStream) {
        pStream.print(this.iMethod + " " + this.iRequest + " HTTP/" + this.iMajor + "." + this.iMinor + "\r\n");
    }

    public String getResponseMessage() {
        return this.iResponse;
    }

    public String toString() {
        if (this.iIncomming) {
            return this.iHttpHeader + " " + this.iStatus + " " + this.iResponse;
        }
        return this.iMethod + " " + this.iRequest + " HTTP/" + this.iMajor + "." + this.iMinor;
    }
}

