/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import org.sblim.cimclient.internal.http.HttpConnectionHandler;
import org.sblim.cimclient.internal.http.HttpServerMethod;
import org.sblim.cimclient.internal.http.HttpServerWorker;
import org.sblim.cimclient.internal.http.HttpSocketFactory;
import org.sblim.cimclient.internal.http.MessageWriter;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.sblim.cimclient.internal.util.ThreadPool;
import org.sblim.cimclient.internal.util.Util;
import org.sblim.cimclient.internal.util.WBEMConfiguration;

public class HttpServerConnection
implements Runnable {
    private int iPort;
    private ServerSocket iServerSocket;
    private HttpConnectionHandler iHandler;
    private HttpConnectionDispatcher iDispatcher;
    private volatile boolean iClose = true;
    private String iServerName;
    private boolean iSsl;
    private Thread iRunner;
    private WBEMConfiguration iSessionProperties;
    private final int iTimeout;

    public HttpServerConnection(HttpConnectionHandler pHandler, String pLocalAddress, int pPort, boolean pSsl, WBEMConfiguration pProperties) throws IOException {
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.iPort = pPort;
        this.iHandler = pHandler;
        this.iSsl = pSsl;
        this.iServerName = pSsl ? "HTTPS Server" : "HTTP Server";
        this.iSessionProperties = pProperties != null ? pProperties : WBEMConfiguration.getGlobalConfiguration();
        SSLContext sslContext = pSsl ? HttpSocketFactory.getInstance().getServerSSLContext(this.iSessionProperties) : null;
        ServerSocket serverSocket = this.iServerSocket = pLocalAddress != null && pLocalAddress.length() > 0 ? HttpSocketFactory.getInstance().getServerSocketFactory(sslContext).createServerSocket(pPort, 50, InetAddress.getByName(pLocalAddress)) : HttpSocketFactory.getInstance().getServerSocketFactory(sslContext).createServerSocket(pPort);
        if (this.iServerSocket instanceof SSLServerSocket) {
            if (this.iSessionProperties.getSslListenerPeerVerification().equalsIgnoreCase("ignore")) {
                logger.trace(Level.FINER, "Listener peer verification: ignore");
                ((SSLServerSocket)this.iServerSocket).setNeedClientAuth(false);
            } else if (this.iSessionProperties.getSslListenerPeerVerification().equalsIgnoreCase("accept")) {
                logger.trace(Level.FINER, "Listener peer verification: accept");
                ((SSLServerSocket)this.iServerSocket).setWantClientAuth(true);
            } else {
                logger.trace(Level.FINER, "Listener peer verification: require");
                ((SSLServerSocket)this.iServerSocket).setNeedClientAuth(true);
            }
            String disableCipherSuites = this.iSessionProperties.getSslListenerCipherSuitesToDisable();
            if (disableCipherSuites != null) {
                SSLServerSocket sslSock = (SSLServerSocket)this.iServerSocket;
                String[] currentCipherSuites = sslSock.getEnabledCipherSuites();
                String[] updatedCipherSuites = Util.getFilteredStringArray(currentCipherSuites, disableCipherSuites);
                sslSock.setEnabledCipherSuites(updatedCipherSuites);
                int before = currentCipherSuites.length;
                int after = updatedCipherSuites.length;
                if (before > 0 && after == 0) {
                    logger.trace(Level.WARNING, "All cipher suites disabled for listener!");
                } else if (before > after) {
                    logger.trace(Level.FINE, "Some (" + (before - after) + ") cipher suites disabled for listener");
                } else if (before == after) {
                    logger.trace(Level.FINER, "No cipher suites disabled for listener");
                }
            }
        }
        this.iTimeout = this.iSessionProperties.getListenerHttpTimeout();
        logger.exit();
    }

    public void setName(String pName) {
        if (this.iRunner != null) {
            this.iRunner.setName(pName);
        }
    }

    public int getPort() {
        return this.iServerSocket.getLocalPort();
    }

    public String getLocalIp() throws UnknownHostException {
        String ip = this.iServerSocket.getInetAddress().getHostAddress();
        String localhost = InetAddress.getLocalHost().getHostAddress();
        return "0.0.0.0".equals(ip) ? localhost : ip;
    }

    public String getLocalHostName() throws UnknownHostException {
        String ip = this.iServerSocket.getInetAddress().getHostName();
        String localhost = InetAddress.getLocalHost().getHostName();
        return "0.0.0.0".equals(ip) ? localhost : ip;
    }

    public boolean isSSL() {
        return this.iSsl;
    }

    public void start() {
        if (this.iClose) {
            this.iClose = false;
            ThreadGroup group = new ThreadGroup("CIMListener on port " + String.valueOf(this.iPort));
            this.iDispatcher = new HttpConnectionDispatcher(group, this.iHandler, new ThreadPool(this.iSessionProperties.getListenerMinPoolSize(), this.iSessionProperties.getListenerMaxPoolSize(), this.iSessionProperties.getListenerBacklog(), this.iSessionProperties.getListenerMaxIdle(), group, "Handler "), this.iSessionProperties.getListenerMaxQueueSize());
            this.iDispatcher.start();
            this.iRunner = new Thread(group, this, this.iServerName);
            this.iRunner.setDaemon(true);
            this.iRunner.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.iClose) {
            try {
                Socket socket = this.iServerSocket.accept();
                try {
                    socket.setTcpNoDelay(true);
                    socket.setSoTimeout(this.iTimeout);
                }
                catch (IOException e) {
                    LogAndTraceBroker.getBroker().trace(Level.FINE, "Exception while adjusting socket options", e);
                }
                boolean dispatched = this.iDispatcher.dispatch(socket);
                if (!dispatched) {
                    MessageWriter writer = new MessageWriter(socket.getOutputStream(), false, false);
                    try {
                        writer.setMethod(new HttpServerMethod(1, 1, 503, "Service temporarily overloaded"));
                        writer.getHeader().addField("Retry-After", "10");
                        writer.close();
                    }
                    catch (IOException e) {
                        LogAndTraceBroker.getBroker().trace(Level.FINE, "Exception while sending HTTP 503", e);
                    }
                    finally {
                        socket.close();
                    }
                    LogAndTraceBroker.getBroker().trace(Level.FINE, "HttpServerConnection failed to dispatch incoming connection, sent 503");
                    continue;
                }
                LogAndTraceBroker.getBroker().trace(Level.FINE, "HttpServerConnection dispatched incoming connection");
            }
            catch (Throwable t) {
                if (t instanceof SocketException && this.iClose) break;
                try {
                    LogAndTraceBroker.getBroker().trace(Level.FINE, "Exception while waiting for incoming http connections");
                }
                catch (Throwable throwable) {}
            }
        }
        try {
            LogAndTraceBroker.getBroker().trace(Level.FINE, "Shutting down CIMListener on port " + this.iPort);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException t) {
            // empty catch block
        }
        try {
            this.iDispatcher.close();
        }
        catch (Exception e) {
            LogAndTraceBroker.getBroker().trace(Level.FINE, "Exception while closing http connection dispatcher", e);
        }
        this.iDispatcher = null;
        this.iRunner = null;
    }

    public void close() {
        if (!this.iClose) {
            this.iClose = true;
            try {
                this.iServerSocket.close();
                this.iServerSocket = null;
            }
            catch (Exception e) {
                LogAndTraceBroker.getBroker().trace(Level.FINE, "Exception while closing server socket", e);
            }
        }
    }

    private static class HttpConnectionDispatcher
    extends Thread {
        private BlockingQueue<Socket> iConnectionPool;
        private volatile boolean iAlive = true;
        private HttpConnectionHandler iHandler;
        private ThreadPool iThreadPool;

        public HttpConnectionDispatcher(ThreadGroup pGroup, HttpConnectionHandler pHandler, ThreadPool pPool, int pQueueSize) {
            super(pGroup, "Connection Dispatcher");
            this.setDaemon(true);
            this.iConnectionPool = new ArrayBlockingQueue<Socket>(pQueueSize > 0 ? pQueueSize : 1);
            this.iHandler = pHandler;
            this.iThreadPool = pPool;
        }

        public boolean dispatch(Socket pSocket) {
            try {
                return this.iConnectionPool.offer(pSocket, 20L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }

        public Socket getConnection() {
            try {
                return this.iConnectionPool.poll(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }

        public void run() {
            while (this.iAlive) {
                try {
                    Socket socket = this.getConnection();
                    if (socket == null) continue;
                    this.iThreadPool.execute(new HttpServerWorker(this.iHandler, socket));
                }
                catch (Throwable t) {
                    try {
                        LogAndTraceBroker.getBroker().trace(Level.FINE, "Exception while submitting worker to thread pool", t);
                    }
                    catch (Throwable throwable) {}
                }
            }
            try {
                this.iHandler.close();
            }
            catch (Exception e) {
                LogAndTraceBroker.getBroker().trace(Level.FINE, "Exception while closing http connection handler", e);
            }
            try {
                this.iThreadPool.shutdown();
            }
            catch (Exception e) {
                LogAndTraceBroker.getBroker().trace(Level.FINE, "Exception during shut down of thread pool", e);
            }
        }

        public void close() {
            this.iAlive = false;
        }
    }
}

