/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.logging;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.sblim.cimclient.CIMXMLTraceListener;
import org.sblim.cimclient.LogAndTraceManager;
import org.sblim.cimclient.LogListener;
import org.sblim.cimclient.TraceListener;
import org.sblim.cimclient.internal.logging.LogFormatter;
import org.sblim.cimclient.internal.logging.MessageLoader;
import org.sblim.cimclient.internal.logging.TraceFormatter;
import org.sblim.cimclient.internal.util.WBEMConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogAndTraceBroker {
    private static final String TRACE_LOGGER = "org.sblim.cimclient.trace";
    private static final String FILE_LOGGER = "org.sblim.cimclient.file";
    private static final String CONSOLE_LOGGER = "org.sblim.cimclient.console";
    private static LogAndTraceBroker cBroker = new LogAndTraceBroker();
    private volatile ArrayList<LogListener> iLogListeners;
    private volatile ArrayList<TraceListener> iTraceListeners;
    private volatile ArrayList<CIMXMLTraceListener> iCIMXMLTraceListeners;
    private String iProductName = "SBLIM CIM Client for Java";
    private String iCopyright = "COPYRIGHT (C) 2006, 2014 IBM Corp.";
    private String iVersion = "?";
    private String iBuildDate = "?";
    private String iBuildTime = "?";
    private OutputStream iXmlTraceStream = null;
    private OutputStream iXmlTraceFile = null;
    private final String iTHIS_CLASS = this.getClass().getName();
    private final String iTHROWABLE = Throwable.class.getName();
    private int iInternalLevelConsole = Level.OFF.intValue();
    private int iInternalLevelLogFile = Level.OFF.intValue();
    private int iInternalLevelTraceFile = Level.OFF.intValue();
    private LogListener iInternalListenerLogConsole = null;
    private LogListener iInternalListenerLogFile = null;
    private TraceListener iInternalListenerTraceConsole = null;
    private TraceListener iInternalListenerTraceFile = null;
    private int iNumInternalLogListeners = 0;
    private int iNumExternalLogListeners = 0;
    private int iNumInternalTraceListeners = 0;
    private int iNumExternalTraceListeners = 0;

    public static LogAndTraceBroker getBroker() {
        return cBroker;
    }

    public static boolean isLoggingStarted() {
        return cBroker != null;
    }

    private LogAndTraceBroker() {
        this.iLogListeners = new ArrayList();
        this.iTraceListeners = new ArrayList();
        this.iCIMXMLTraceListeners = new ArrayList();
        this.loadVersionTxt();
        this.registerInternalListeners();
        this.initXmlTraceFile();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.iXmlTraceFile != null && !this.iXmlTraceFile.equals(System.out) && !this.iXmlTraceFile.equals(System.err)) {
                this.iXmlTraceFile.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.iXmlTraceFile = null;
            super.finalize();
        }
    }

    public void registerInternalListeners() {
        FileHandler handler;
        Logger logger;
        String location;
        String type;
        Level level2;
        try {
            level2 = WBEMConfiguration.getGlobalConfiguration().getLogConsoleLevel();
            type = WBEMConfiguration.getGlobalConfiguration().getLogConsoleType();
            if (level2.intValue() < Level.OFF.intValue() && "MESSAGE".equals(type)) {
                final Logger logger2 = Logger.getLogger(CONSOLE_LOGGER);
                ConsoleHandler handler2 = new ConsoleHandler();
                handler2.setFormatter(new LogFormatter());
                handler2.setLevel(level2);
                logger2.addHandler(handler2);
                logger2.setLevel(level2);
                logger2.setUseParentHandlers(false);
                this.iInternalLevelConsole = level2.intValue();
                if (this.iInternalListenerLogConsole != null) {
                    this.removeLogListener(this.iInternalListenerLogConsole);
                }
                this.iInternalListenerLogConsole = new LogListener(){

                    public void log(Level pLevel, String pMessageKey, String pMessage, Object[] pParameters) {
                        LogRecord record = new LogRecord(pLevel, pMessageKey + " " + pMessage);
                        record.setParameters(pParameters);
                        logger2.log(record);
                    }
                };
                this.addLogListener(this.iInternalListenerLogConsole);
            }
        }
        catch (Exception level2) {
            // empty catch block
        }
        try {
            level2 = WBEMConfiguration.getGlobalConfiguration().getLogFileLevel();
            location = WBEMConfiguration.getGlobalConfiguration().getLogFileLocation();
            int size = WBEMConfiguration.getGlobalConfiguration().getLogFileSizeLimit();
            int count = WBEMConfiguration.getGlobalConfiguration().getLogFileCount();
            if (level2.intValue() < Level.OFF.intValue()) {
                logger = Logger.getLogger(FILE_LOGGER);
                handler = new FileHandler(location, size, count);
                handler.setFormatter(new LogFormatter());
                handler.setLevel(level2);
                logger.addHandler(handler);
                logger.setLevel(level2);
                logger.setUseParentHandlers(false);
                this.iInternalLevelLogFile = level2.intValue();
                if (this.iInternalListenerLogFile != null) {
                    this.removeLogListener(this.iInternalListenerLogFile);
                }
                this.iInternalListenerLogFile = new LogListener(){

                    public void log(Level pLevel, String pMessageKey, String pMessage, Object[] pParameters) {
                        LogRecord record = new LogRecord(pLevel, pMessageKey + " " + pMessage);
                        record.setParameters(pParameters);
                        logger.log(record);
                    }
                };
                this.addLogListener(this.iInternalListenerLogFile);
            }
        }
        catch (Exception level3) {
            // empty catch block
        }
        try {
            level2 = WBEMConfiguration.getGlobalConfiguration().getLogConsoleLevel();
            type = WBEMConfiguration.getGlobalConfiguration().getLogConsoleType();
            if (level2.intValue() < Level.OFF.intValue() && "TRACE".equals(type)) {
                final Logger logger3 = Logger.getLogger(CONSOLE_LOGGER);
                ConsoleHandler handler3 = new ConsoleHandler();
                handler3.setFormatter(new TraceFormatter());
                handler3.setLevel(level2);
                logger3.addHandler(handler3);
                logger3.setLevel(level2);
                logger3.setUseParentHandlers(false);
                this.iInternalLevelConsole = level2.intValue();
                if (this.iInternalListenerTraceConsole != null) {
                    this.removeTraceListener(this.iInternalListenerTraceConsole);
                }
                this.iInternalListenerTraceConsole = new TraceListener(){

                    public void trace(Level pLevel, StackTraceElement pOrigin, String pMessage) {
                        LogRecord record = new LogRecord(pLevel, pMessage);
                        record.setSourceMethodName(String.valueOf(pOrigin));
                        logger3.log(record);
                    }

                    public void trace(Level pLevel, StackTraceElement pOrigin, String pMessage, Throwable pThrown) {
                        LogRecord record = new LogRecord(pLevel, pMessage);
                        record.setSourceMethodName(String.valueOf(pOrigin));
                        record.setThrown(pThrown);
                        logger3.log(record);
                    }
                };
                this.addTraceListener(this.iInternalListenerTraceConsole);
            }
        }
        catch (Exception level4) {
            // empty catch block
        }
        try {
            level2 = WBEMConfiguration.getGlobalConfiguration().getTraceFileLevel();
            location = WBEMConfiguration.getGlobalConfiguration().getTraceFileLocation();
            int size = WBEMConfiguration.getGlobalConfiguration().getTraceFileSizeLimit();
            int count = WBEMConfiguration.getGlobalConfiguration().getTraceFileCount();
            if (level2.intValue() < Level.OFF.intValue()) {
                logger = Logger.getLogger(TRACE_LOGGER);
                handler = new FileHandler(location, size, count);
                handler.setFormatter(new TraceFormatter());
                handler.setLevel(level2);
                logger.addHandler(handler);
                logger.setLevel(level2);
                logger.setUseParentHandlers(false);
                this.iInternalLevelTraceFile = level2.intValue();
                if (this.iInternalListenerTraceFile != null) {
                    this.removeTraceListener(this.iInternalListenerTraceFile);
                }
                this.iInternalListenerTraceFile = new TraceListener(){

                    public void trace(Level pLevel, StackTraceElement pOrigin, String pMessage) {
                        LogRecord record = new LogRecord(pLevel, pMessage);
                        record.setSourceMethodName(String.valueOf(pOrigin));
                        logger.log(record);
                    }

                    public void trace(Level pLevel, StackTraceElement pOrigin, String pMessage, Throwable pThrown) {
                        LogRecord record = new LogRecord(pLevel, pMessage);
                        record.setSourceMethodName(String.valueOf(pOrigin));
                        record.setThrown(pThrown);
                        logger.log(record);
                    }
                };
                this.addTraceListener(this.iInternalListenerTraceFile);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void addLogListener(LogListener pListener) {
        if (pListener == null) {
            return;
        }
        this.sendGreetings(pListener);
        ArrayList<LogListener> newListeners = new ArrayList<LogListener>(this.iLogListeners);
        newListeners.add(pListener);
        this.iLogListeners = newListeners;
        if (this.iInternalListenerLogFile != null && this.iInternalListenerLogFile.equals(pListener) || this.iInternalListenerLogConsole != null && this.iInternalListenerLogConsole.equals(pListener)) {
            ++this.iNumInternalLogListeners;
        } else {
            ++this.iNumExternalLogListeners;
        }
    }

    private void loadVersionTxt() {
        InputStream is = null;
        try {
            Properties version = new Properties();
            is = LogAndTraceManager.class.getResourceAsStream("version.txt");
            version.load(is);
            this.iProductName = version.getProperty("PRODUCTNAME");
            this.iCopyright = version.getProperty("COPYRIGHT");
            this.iVersion = version.getProperty("VERSION");
            this.iBuildDate = version.getProperty("BUILDDATE");
            this.iBuildTime = version.getProperty("BUILDTIME");
        }
        catch (Exception exception) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void sendGreetings(LogListener pListener) {
        pListener.log(MessageLoader.getLevel("CIM0001I"), "CIM0001I", MessageLoader.getLocalizedMessage("CIM0001I"), new Object[]{this.iProductName, this.iCopyright});
        pListener.log(MessageLoader.getLevel("CIM0002I"), "CIM0002I", MessageLoader.getLocalizedMessage("CIM0002I"), new Object[]{this.iVersion, this.iBuildDate, this.iBuildTime});
        pListener.log(MessageLoader.getLevel("CIM0003I"), "CIM0003I", MessageLoader.getLocalizedMessage("CIM0003I"), new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")});
        pListener.log(MessageLoader.getLevel("CIM0004I"), "CIM0004I", MessageLoader.getLocalizedMessage("CIM0004I"), new Object[]{System.getProperty("java.version"), System.getProperty("java.vendor")});
        pListener.log(MessageLoader.getLevel("CIM0005I"), "CIM0005I", MessageLoader.getLocalizedMessage("CIM0005I"), new Object[]{System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), System.getProperty("java.vm.vendor")});
        pListener.log(MessageLoader.getLevel("CIM1001C"), "CIM1001C", MessageLoader.getLocalizedMessage("CIM1001C"), new Object[]{WBEMConfiguration.getActiveConfigFullURL()});
        if (!WBEMConfiguration.isConfigurationLoadSuccessful()) {
            pListener.log(MessageLoader.getLevel("CIM1002C"), "CIM1002C", MessageLoader.getLocalizedMessage("CIM1002C"), null);
            if (WBEMConfiguration.getConfigurationLoadException() != null) {
                pListener.log(MessageLoader.getLevel("CIM1003S"), "CIM1003S", MessageLoader.getLocalizedMessage("CIM1003S"), new Object[]{WBEMConfiguration.getConfigurationLoadException().getMessage()});
            }
        }
    }

    private void sendGreetings(TraceListener pListener) {
        StackTraceElement origin = new Throwable().getStackTrace()[0];
        pListener.trace(MessageLoader.getLevel("CIM0001I"), origin, MessageFormat.format(MessageLoader.getMessage("CIM0001I"), this.iProductName, this.iCopyright));
        pListener.trace(MessageLoader.getLevel("CIM0002I"), origin, MessageFormat.format(MessageLoader.getMessage("CIM0002I"), this.iVersion, this.iBuildDate, this.iBuildTime));
        pListener.trace(MessageLoader.getLevel("CIM0003I"), origin, MessageFormat.format(MessageLoader.getMessage("CIM0003I"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")));
        pListener.trace(MessageLoader.getLevel("CIM0004I"), origin, MessageFormat.format(MessageLoader.getMessage("CIM0004I"), System.getProperty("java.version"), System.getProperty("java.vendor")));
        pListener.trace(MessageLoader.getLevel("CIM0005I"), origin, MessageFormat.format(MessageLoader.getMessage("CIM0005I"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), System.getProperty("java.vm.vendor")));
        pListener.trace(MessageLoader.getLevel("CIM1001C"), origin, MessageFormat.format(MessageLoader.getMessage("CIM1001C"), WBEMConfiguration.getActiveConfigURL()));
        if (!WBEMConfiguration.isConfigurationLoadSuccessful()) {
            pListener.trace(MessageLoader.getLevel("CIM1002C"), origin, MessageLoader.getMessage("CIM1002C"));
            if (WBEMConfiguration.getConfigurationLoadException() != null) {
                pListener.trace(MessageLoader.getLevel("CIM1003S"), origin, MessageLoader.getMessage("CIM1003S"), WBEMConfiguration.getConfigurationLoadException());
            }
        }
    }

    public synchronized void removeLogListener(LogListener pListener) {
        ArrayList<LogListener> newListeners = new ArrayList<LogListener>(this.iLogListeners);
        if (!newListeners.remove(pListener)) {
            return;
        }
        this.iLogListeners = newListeners;
        if (this.iInternalListenerLogFile != null && this.iInternalListenerLogFile.equals(pListener)) {
            this.iInternalListenerLogFile = null;
            --this.iNumInternalLogListeners;
        } else if (this.iInternalListenerLogConsole != null && this.iInternalListenerLogConsole.equals(pListener)) {
            this.iInternalListenerLogConsole = null;
            --this.iNumInternalLogListeners;
        } else {
            --this.iNumExternalLogListeners;
        }
    }

    public synchronized void clearLogListeners() {
        this.iLogListeners = new ArrayList();
        this.removeHandlers(Logger.getLogger(CONSOLE_LOGGER));
        this.removeHandlers(Logger.getLogger(FILE_LOGGER));
        this.iInternalListenerLogFile = null;
        this.iInternalListenerLogConsole = null;
        this.iNumInternalLogListeners = 0;
        this.iNumExternalLogListeners = 0;
    }

    public List<LogListener> getLogListeners() {
        return this.iLogListeners;
    }

    public synchronized void addTraceListener(TraceListener pListener) {
        if (pListener == null) {
            return;
        }
        this.sendGreetings(pListener);
        ArrayList<TraceListener> newListeners = new ArrayList<TraceListener>(this.iTraceListeners);
        newListeners.add(pListener);
        this.iTraceListeners = newListeners;
        if (this.iInternalListenerTraceFile != null && this.iInternalListenerTraceFile.equals(pListener) || this.iInternalListenerTraceConsole != null && this.iInternalListenerTraceConsole.equals(pListener)) {
            ++this.iNumInternalTraceListeners;
        } else {
            ++this.iNumExternalTraceListeners;
        }
    }

    public synchronized void removeTraceListener(TraceListener pListener) {
        ArrayList<TraceListener> newListeners = new ArrayList<TraceListener>(this.iTraceListeners);
        if (!newListeners.remove(pListener)) {
            return;
        }
        this.iTraceListeners = newListeners;
        if (this.iInternalListenerTraceFile != null && this.iInternalListenerTraceFile.equals(pListener)) {
            this.iInternalListenerTraceFile = null;
            --this.iNumInternalTraceListeners;
        } else if (this.iInternalListenerTraceConsole != null && this.iInternalListenerTraceConsole.equals(pListener)) {
            this.iInternalListenerTraceConsole = null;
            --this.iNumInternalTraceListeners;
        } else {
            --this.iNumExternalTraceListeners;
        }
    }

    public synchronized void clearTraceListeners() {
        this.iTraceListeners = new ArrayList();
        this.removeHandlers(Logger.getLogger(TRACE_LOGGER));
        this.iInternalListenerTraceFile = null;
        this.iInternalListenerTraceConsole = null;
        this.iNumInternalTraceListeners = 0;
        this.iNumExternalTraceListeners = 0;
    }

    public List<TraceListener> getTraceListeners() {
        return this.iTraceListeners;
    }

    public synchronized void addCIMXMLTraceListener(CIMXMLTraceListener pListener) {
        if (pListener == null) {
            return;
        }
        ArrayList<CIMXMLTraceListener> newListeners = new ArrayList<CIMXMLTraceListener>(this.iCIMXMLTraceListeners);
        newListeners.add(pListener);
        this.iCIMXMLTraceListeners = newListeners;
    }

    public synchronized void removeCIMXMLTraceListener(CIMXMLTraceListener pListener) {
        ArrayList<CIMXMLTraceListener> newListeners = new ArrayList<CIMXMLTraceListener>(this.iCIMXMLTraceListeners);
        if (!newListeners.remove(pListener)) {
            return;
        }
        this.iCIMXMLTraceListeners = newListeners;
    }

    public synchronized void clearCIMXMLTraceListeners() {
        if (this.iCIMXMLTraceListeners.size() > 0) {
            this.iCIMXMLTraceListeners = new ArrayList();
        }
    }

    public List<CIMXMLTraceListener> getCIMXMLTraceListeners() {
        return this.iCIMXMLTraceListeners;
    }

    public void message(String pKey) {
        this.message(pKey, null);
    }

    public void message(String pKey, Object pParameter) {
        this.message(pKey, new Object[]{pParameter});
    }

    public void message(String pKey, Object[] pParameters) {
        try {
            String message = MessageLoader.getMessage(pKey);
            String localMessage = MessageLoader.getLocalizedMessage(pKey);
            Level level = MessageLoader.getLevel(pKey);
            if (this.isLoggableTrace(level)) {
                List<TraceListener> traceListeners = this.getTraceListeners();
                StackTraceElement caller = this.getCaller();
                for (int i = 0; i < traceListeners.size(); ++i) {
                    traceListeners.get(i).trace(level, caller, pKey + " " + MessageFormat.format(message, pParameters));
                }
            }
            List<LogListener> logListeners = this.getLogListeners();
            for (int i = 0; i < logListeners.size(); ++i) {
                logListeners.get(i).log(level, pKey, localMessage, pParameters);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void trace(Level pLevel, String pMessage) {
        try {
            if (this.isLoggableTrace(pLevel)) {
                List<TraceListener> traceListeners = this.getTraceListeners();
                StackTraceElement caller = this.getCaller();
                for (int i = 0; i < traceListeners.size(); ++i) {
                    traceListeners.get(i).trace(pLevel, caller, pMessage);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void trace(Level pLevel, String pMessage, Throwable pThrown) {
        try {
            if (this.isLoggableTrace(pLevel)) {
                List<TraceListener> traceListeners = this.getTraceListeners();
                StackTraceElement caller = this.getCaller();
                for (int i = 0; i < traceListeners.size(); ++i) {
                    traceListeners.get(i).trace(pLevel, caller, pMessage, pThrown);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void traceCIMXML(Level pLevel, String pMessage, boolean pOutgoing) {
        try {
            if (this.iCIMXMLTraceListeners.size() > 0) {
                List<CIMXMLTraceListener> traceListeners = this.getCIMXMLTraceListeners();
                for (int i = 0; i < traceListeners.size(); ++i) {
                    traceListeners.get(i).traceCIMXML(pLevel, pMessage, pOutgoing);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void entry() {
        this.trace(Level.FINEST, "Entering method");
    }

    public void exit() {
        this.trace(Level.FINEST, "Exiting method");
    }

    public OutputStream getXmlTraceStream() {
        return this.iXmlTraceStream;
    }

    public void setXmlTraceStream(OutputStream pStream) {
        this.iXmlTraceStream = pStream;
    }

    private void initXmlTraceFile() {
        block8: {
            try {
                String filename;
                if (!WBEMConfiguration.getGlobalConfiguration().isCimXmlTracingEnabled() || (filename = WBEMConfiguration.getGlobalConfiguration().getCimXmlTraceStream()) == null || filename.length() <= 0 || this.iXmlTraceFile != null || this.getXmlTraceStream() != null) break block8;
                if (filename.equalsIgnoreCase("System.out")) {
                    this.iXmlTraceFile = System.out;
                } else if (filename.equalsIgnoreCase("System.err")) {
                    this.iXmlTraceFile = System.err;
                } else {
                    try {
                        this.iXmlTraceFile = new FileOutputStream(filename);
                    }
                    catch (IOException e) {
                        this.trace(Level.FINE, "Unable to open sblim.wbem.cimxmlTraceStream=" + filename, e);
                    }
                }
                this.setXmlTraceStream(this.iXmlTraceFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private StackTraceElement getCaller() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            StackTraceElement frame = stack[i];
            String cname = frame.getClassName();
            if (this.iTHIS_CLASS.equals(cname) || this.iTHROWABLE.equals(cname)) continue;
            return frame;
        }
        return null;
    }

    private void removeHandlers(Logger pLogger) {
        Handler[] handlers = pLogger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            pLogger.removeHandler(handlers[i]);
            handlers[i].close();
        }
    }

    public boolean isLoggableTrace(Level pLevel) {
        if (this.iTraceListeners.size() == 0 || pLevel.intValue() == Level.OFF.intValue()) {
            return false;
        }
        if (this.iNumExternalTraceListeners > 0) {
            return true;
        }
        if (this.iNumInternalTraceListeners > 0) {
            int level = Level.OFF.intValue();
            if (this.iInternalListenerTraceFile != null) {
                level = this.iInternalLevelTraceFile;
            }
            if (this.iInternalListenerTraceConsole != null && level > this.iInternalLevelConsole) {
                level = this.iInternalLevelConsole;
            }
            return level <= pLevel.intValue();
        }
        return true;
    }

    public boolean isLoggableMessage(Level pLevel) {
        if (this.isLoggableTrace(pLevel)) {
            return true;
        }
        if (this.iLogListeners.size() == 0 || pLevel.intValue() == Level.OFF.intValue()) {
            return false;
        }
        if (this.iNumExternalLogListeners > 0) {
            return true;
        }
        if (this.iNumInternalLogListeners > 0) {
            int level = Level.OFF.intValue();
            if (this.iInternalListenerLogFile != null) {
                level = this.iInternalLevelLogFile;
            }
            if (this.iInternalListenerLogConsole != null && level > this.iInternalLevelConsole) {
                level = this.iInternalLevelConsole;
            }
            return level <= pLevel.intValue();
        }
        return true;
    }

    public boolean isLoggableCIMXMLTrace(Level pLevel) {
        return this.iCIMXMLTraceListeners.size() != 0 && pLevel.intValue() != Level.OFF.intValue();
    }
}

