/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.uri;

import java.util.regex.Pattern;
import org.sblim.cimclient.internal.uri.NamespaceHandle;
import org.sblim.cimclient.internal.uri.URIString;

public class NamespacePath {
    private String iNamespaceType;
    private NamespaceHandle iNamespaceHandle;
    private static final Pattern TYPE_PAT = Pattern.compile("^(http(s?)|cimxml\\.wbem(s?)).*");

    protected NamespacePath(String pNamespaceType, NamespaceHandle pNamespaceHandle) {
        this.iNamespaceType = pNamespaceType;
        this.iNamespaceHandle = pNamespaceHandle;
    }

    public NamespacePath(String pNamespaceName) {
        this.iNamespaceHandle = new NamespaceHandle(pNamespaceName);
    }

    public static NamespacePath parse(URIString pUriStr) {
        URIString uriStr = pUriStr.deepCopy();
        String namespaceType = NamespacePath.parseNamespaceType(uriStr);
        if (namespaceType != null && !uriStr.cutStarting(':')) {
            return null;
        }
        NamespaceHandle namespaceHandle = NamespaceHandle.parse(uriStr);
        if (namespaceHandle == null) {
            return null;
        }
        pUriStr.set(uriStr);
        return new NamespacePath(namespaceType, namespaceHandle);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.iNamespaceType != null) {
            buf.append(this.iNamespaceType + ':');
        }
        buf.append(this.iNamespaceHandle.toString());
        return buf.toString();
    }

    public String getNamespaceType() {
        return this.iNamespaceType;
    }

    public String getNamespaceName() {
        return this.iNamespaceHandle == null ? null : this.iNamespaceHandle.getName();
    }

    public String getUserInfo() {
        return this.iNamespaceHandle == null ? null : this.iNamespaceHandle.getUserInfo();
    }

    public String getHost() {
        return this.iNamespaceHandle == null ? null : this.iNamespaceHandle.getHost();
    }

    public String getPort() {
        return this.iNamespaceHandle == null ? null : this.iNamespaceHandle.getPort();
    }

    private static String parseNamespaceType(URIString pUriStr) {
        if (!pUriStr.matchAndCut(TYPE_PAT, 1)) {
            return null;
        }
        return pUriStr.group(1);
    }
}

