/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.uri;

import org.sblim.cimclient.internal.uri.BooleanValue;
import org.sblim.cimclient.internal.uri.CharValue;
import org.sblim.cimclient.internal.uri.DateTimeValue;
import org.sblim.cimclient.internal.uri.IntegerValue;
import org.sblim.cimclient.internal.uri.RealValue;
import org.sblim.cimclient.internal.uri.ReferenceValue;
import org.sblim.cimclient.internal.uri.StringValue;
import org.sblim.cimclient.internal.uri.URI;
import org.sblim.cimclient.internal.uri.URIString;

public abstract class Value {
    public static Value parse(boolean pTyped, URIString pUriStr) throws IllegalArgumentException {
        if (pTyped) {
            return Value.parseTypedValue(pUriStr);
        }
        URIString uriStr = pUriStr.deepCopy();
        try {
            Value value;
            block6: {
                StringValue strVal = (StringValue)StringValue.parse(uriStr);
                try {
                    URI ref = URI.parseRef(new URIString(strVal.toString()), false);
                    value = new ReferenceValue(ref);
                }
                catch (IllegalArgumentException e) {
                    value = DateTimeValue.parse(strVal.toString());
                    if (value != null) break block6;
                    value = strVal;
                }
            }
            pUriStr.set(uriStr);
            return value;
        }
        catch (IllegalArgumentException e) {
            Value value = IntegerValue.parse(uriStr);
            if (value != null || (value = RealValue.parse(uriStr)) != null || (value = BooleanValue.parse(uriStr)) != null || (value = CharValue.parse(uriStr)) != null) {
                pUriStr.set(uriStr);
                return value;
            }
            String msg = "Failed to parse untyped value!\n" + uriStr.markPosition();
            throw new IllegalArgumentException(msg);
        }
    }

    public abstract String getTypeInfo();

    private static Value parseTypedValue(URIString pUriStr) throws IllegalArgumentException {
        Value val;
        URIString uriStr = pUriStr.deepCopy();
        int typeInfoPos = uriStr.getPos();
        String typeInfo = Value.parseTypeInfo(uriStr);
        if (typeInfo == null) {
            String msg = "typeInfo expected!\n" + uriStr.markPosition();
            throw new IllegalArgumentException(msg);
        }
        int valuePos = uriStr.getPos();
        try {
            val = typeInfo.equalsIgnoreCase("string") ? StringValue.parse(uriStr) : (typeInfo.equalsIgnoreCase("reference") ? Value.parseTypedReference(uriStr) : (typeInfo.equalsIgnoreCase("datetime") ? Value.parseTypedDateTime(uriStr) : (typeInfo.equalsIgnoreCase("char16") ? CharValue.parse(uriStr) : (typeInfo.equalsIgnoreCase("boolean") ? BooleanValue.parse(uriStr) : (typeInfo.equalsIgnoreCase("sint8") ? IntegerValue.parseSigned(uriStr, 8) : (typeInfo.equalsIgnoreCase("sint16") ? IntegerValue.parseSigned(uriStr, 16) : (typeInfo.equalsIgnoreCase("sint32") ? IntegerValue.parseSigned(uriStr, 32) : (typeInfo.equalsIgnoreCase("sint64") ? IntegerValue.parseSigned(uriStr, 64) : (typeInfo.equalsIgnoreCase("uint8") ? IntegerValue.parseUnsigned(uriStr, 8) : (typeInfo.equalsIgnoreCase("uint16") ? IntegerValue.parseUnsigned(uriStr, 16) : (typeInfo.equalsIgnoreCase("uint32") ? IntegerValue.parseUnsigned(uriStr, 32) : (typeInfo.equalsIgnoreCase("uint64") ? IntegerValue.parseUnsigned(uriStr, 64) : (typeInfo.equalsIgnoreCase("real32") ? RealValue.parseFloat(uriStr) : (typeInfo.equalsIgnoreCase("real64") ? RealValue.parseDouble(uriStr) : null))))))))))))));
        }
        catch (IllegalArgumentException e) {
            String msg = "Failed to parse " + typeInfo + " value!\n" + uriStr.markPosition(valuePos) + "Nested message:\n" + e.getMessage();
            throw new IllegalArgumentException(msg);
        }
        if (val == null) {
            String msg = "Unknown type:" + typeInfo + "!\n" + uriStr.markPosition(typeInfoPos);
            throw new IllegalArgumentException(msg);
        }
        pUriStr.set(uriStr);
        return val;
    }

    private static Value parseTypedReference(URIString pUriStr) throws IllegalArgumentException {
        Value strVal;
        int pos = pUriStr.getPos();
        try {
            strVal = StringValue.parse(pUriStr);
        }
        catch (IllegalArgumentException e) {
            String msg = "Failed to retrieve typed reference string!\n" + pUriStr.markPosition() + "Nested message is:\n" + e.getMessage();
            throw new IllegalArgumentException(msg);
        }
        URIString refUriStr = new URIString(strVal.toString());
        try {
            URI ref = URI.parseRef(refUriStr, true);
            return new ReferenceValue(ref);
        }
        catch (IllegalArgumentException e) {
            String msg = "Failed to parse typed reference value!\n" + pUriStr.markPosition(pos) + "Nested message is:\n" + e.getMessage();
            throw new IllegalArgumentException(msg);
        }
    }

    private static Value parseTypedDateTime(URIString pUriStr) throws IllegalArgumentException {
        Value strVal;
        try {
            strVal = StringValue.parse(pUriStr);
        }
        catch (IllegalArgumentException e) {
            String msg = "Failed to retrieve typed datetime string!\n" + pUriStr.markPosition() + "Nested message is:\n" + e.getMessage();
            throw new IllegalArgumentException(msg);
        }
        return DateTimeValue.parse(strVal.toString(), true);
    }

    private static String parseTypeInfo(URIString pUriStr) {
        URIString uriStr = pUriStr.deepCopy();
        if (!uriStr.cutStarting('(')) {
            return null;
        }
        String typeInfo = uriStr.removeTill(')', true, true);
        if (typeInfo == null) {
            return null;
        }
        pUriStr.set(uriStr);
        return typeInfo;
    }
}

