/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.util;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;

public class ThreadPool {
    private ThreadGroup iGroup;
    private AtomicInteger iIdleThreads = new AtomicInteger(0);
    private List<Worker> iThreadPool = new LinkedList<Worker>();
    private BlockingQueue<Runnable> iQueue = new LinkedBlockingQueue<Runnable>();
    private long iIdleTimeout;
    private int iMaxPoolSize;
    private int iMinPoolSize;
    private int iToleratedBacklog;
    private int iCntr = 0;
    private boolean iShutdown = false;
    private String iWorkerName;

    public ThreadPool(int pMinPoolSize, int pMaxPoolSize, int pToleratedBacklog, long pToleratedIdle, ThreadGroup pGroup, String pWorkerName) {
        this.iGroup = pGroup != null ? pGroup : new ThreadGroup("TreadPool Group");
        this.iMinPoolSize = pMinPoolSize;
        this.iMaxPoolSize = pMaxPoolSize;
        this.iToleratedBacklog = pToleratedBacklog;
        this.iIdleTimeout = pToleratedIdle;
        this.iWorkerName = pWorkerName != null ? pWorkerName : "Worker ";
    }

    public synchronized boolean execute(Runnable task) {
        boolean mayCreateWorker;
        if (this.iShutdown) {
            return false;
        }
        for (int i = this.iThreadPool.size(); i < this.iMinPoolSize; ++i) {
            this.createWorker();
        }
        int totalIdle = this.iIdleThreads.get();
        boolean added = this.iQueue.offer(task);
        if (totalIdle > 0) {
            return added;
        }
        boolean bl = mayCreateWorker = this.iMaxPoolSize == -1 || this.iThreadPool.size() < this.iMaxPoolSize;
        if (mayCreateWorker && (this.iQueue.size() > this.iToleratedBacklog || this.iThreadPool.size() == 0)) {
            this.createWorker();
        }
        return added;
    }

    private synchronized void createWorker() {
        Worker worker = new Worker(this, this.iWorkerName + this.getID());
        this.iThreadPool.add(worker);
        this.iIdleThreads.incrementAndGet();
        worker.start();
    }

    protected synchronized void removeWorker(Worker worker) {
        if (worker != null && this.iThreadPool != null) {
            this.iIdleThreads.decrementAndGet();
            this.iThreadPool.remove(worker);
            if (this.iThreadPool.isEmpty() && !this.iQueue.isEmpty()) {
                this.createWorker();
            }
        }
    }

    protected ThreadGroup getGroup() {
        return this.iGroup;
    }

    public Runnable getNextTask(Worker worker) throws InterruptedException {
        Runnable task = this.iQueue.poll(this.iIdleTimeout, TimeUnit.MILLISECONDS);
        if (task == null && this.iThreadPool.size() > this.iMinPoolSize) {
            worker.kill();
        }
        return task;
    }

    public void taskStarted() {
        this.iIdleThreads.decrementAndGet();
    }

    public void taskCompleted() {
        this.iIdleThreads.incrementAndGet();
    }

    public synchronized void shutdown() {
        if (!this.iShutdown) {
            this.iShutdown = true;
            if (this.iThreadPool != null) {
                List<Worker> workers = this.iThreadPool;
                this.iThreadPool = null;
                for (Worker worker : workers) {
                    worker.kill();
                }
            }
        }
    }

    private String getID() {
        if (++this.iCntr >= 10000) {
            this.iCntr = 1;
        }
        return String.valueOf(this.iCntr);
    }

    private static class Worker
    extends Thread {
        private volatile boolean iAlive;
        private final ThreadPool iPool;
        private Runnable iTask;
        private Thread iRunThread;

        public Worker(ThreadPool pool, String name) {
            super(pool.getGroup(), name);
            this.iPool = pool;
            this.setDaemon(true);
        }

        public void start() {
            this.iAlive = true;
            super.start();
        }

        public void kill() {
            this.iAlive = false;
            if (this.iRunThread != null) {
                this.iRunThread.interrupt();
            }
        }

        private Runnable waitForTask() throws InterruptedException {
            if (this.iTask != null) {
                Runnable tsk = this.iTask;
                this.iTask = null;
                return tsk;
            }
            if (this.iAlive && this.iTask == null) {
                this.iTask = this.iPool.getNextTask(this);
            }
            return null;
        }

        public void run() {
            this.iRunThread = Thread.currentThread();
            while (this.iAlive) {
                try {
                    Runnable tsk = this.waitForTask();
                    if (tsk == null) continue;
                    this.iPool.taskStarted();
                    try {
                        tsk.run();
                    }
                    catch (Throwable t) {
                        LogAndTraceBroker.getBroker().trace(Level.FINE, "Exception while executing task from thread pool", t);
                    }
                    this.iPool.taskCompleted();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.iPool.removeWorker(this);
        }
    }
}

