/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.net.SocketFactory;
import org.sblim.cimclient.internal.util.WBEMConfigurationDefaults;

public class WBEMConfiguration {
    private static WBEMConfiguration cConfiguration;
    private static String cConfigURL;
    private static String cConfigFullURL;
    private static boolean cLoadSuccessful;
    private static Exception cLoadException;
    private final ThreadLocal<Object> iLocalProperties = new InheritableThreadLocal<Object>(){

        @Override
        protected Object childValue(Object parentValue) {
            if (parentValue instanceof Properties) {
                return ((Properties)parentValue).clone();
            }
            return super.childValue(parentValue);
        }
    };
    private Properties iDomainProperties = null;
    private SocketFactory iCustomSocketFactory = null;
    private boolean iIsGlobal = false;

    public static void loadGlobalConfiguration() {
        Properties wbemProperties = new Properties(new Properties());
        try {
            cConfigURL = null;
            cLoadSuccessful = false;
            cLoadException = null;
            InputStream inputstream = WBEMConfiguration.getConfigURLStream();
            if (inputstream != null) {
                wbemProperties.load(inputstream);
                cLoadSuccessful = true;
            }
            for (Map.Entry<Object, Object> entry : wbemProperties.entrySet()) {
                String value;
                String key = String.valueOf(entry.getKey());
                if (key.startsWith("sblim.wbem.") || key.startsWith("javax.net.ssl.") || key.startsWith("net.slp.")) {
                    value = String.valueOf(entry.getValue());
                    System.setProperty(key, value);
                    continue;
                }
                if (!key.startsWith("ssl.")) continue;
                value = String.valueOf(entry.getValue());
                Security.setProperty(key, value);
            }
        }
        catch (IOException e) {
            cLoadException = e;
        }
    }

    public static String getActiveConfigURL() {
        return cConfigURL;
    }

    public static String getActiveConfigFullURL() {
        return cConfigFullURL;
    }

    public static boolean isConfigurationLoadSuccessful() {
        return cLoadSuccessful;
    }

    private static InputStream getConfigURLStream() {
        String configURL = System.getProperty("sblim.wbem.configURL");
        if (configURL != null) {
            if (configURL.trim().length() > 0) {
                try {
                    cConfigURL = configURL;
                    URL url = new URL(configURL);
                    cConfigFullURL = WBEMConfiguration.getFullURL(url);
                    InputStream inputstream = url.openStream();
                    return inputstream;
                }
                catch (Exception e) {
                    cLoadException = e;
                }
            }
        } else {
            for (int i = 0; i < WBEMConfigurationDefaults.CONFIG_URL.length; ++i) {
                configURL = WBEMConfigurationDefaults.CONFIG_URL[i];
                try {
                    cConfigURL = configURL;
                    URL url = new URL(configURL);
                    cConfigFullURL = WBEMConfiguration.getFullURL(url);
                    InputStream inputstream = url.openStream();
                    return inputstream;
                }
                catch (FileNotFoundException url) {
                    continue;
                }
                catch (Exception e) {
                    cLoadException = e;
                }
            }
            cConfigURL = Arrays.asList(WBEMConfigurationDefaults.CONFIG_URL).toString();
        }
        return null;
    }

    private static String getFullURL(URL url) {
        if (url.getProtocol().equalsIgnoreCase("file")) {
            try {
                String file;
                String dir;
                int lastSep;
                String path = url.getPath();
                int lastSlash = path.lastIndexOf(47);
                int lastBackslash = path.lastIndexOf(92);
                int n = lastSep = lastSlash > lastBackslash ? lastSlash : lastBackslash;
                if (lastSep == -1) {
                    dir = ".";
                    file = path;
                } else if (lastSep == 0) {
                    dir = "/";
                    file = path.substring(1);
                } else {
                    dir = path.substring(0, lastSep);
                    file = path.substring(lastSep + 1);
                }
                String cp = new File(dir).getCanonicalPath();
                if (cp.endsWith(System.getProperty("file.separator"))) {
                    return cp + file;
                }
                return cp + System.getProperty("file.separator") + file;
            }
            catch (IOException iOException) {
                return url.getPath();
            }
        }
        return url.toString();
    }

    public static WBEMConfiguration getGlobalConfiguration() {
        return cConfiguration;
    }

    public static Exception getConfigurationLoadException() {
        return cLoadException;
    }

    private WBEMConfiguration() {
    }

    public WBEMConfiguration(Properties pDomainProperties) {
        if (pDomainProperties == null) {
            throw new NullPointerException("Domain properties shall not be null");
        }
        this.iDomainProperties = pDomainProperties;
    }

    public boolean isGlobal() {
        return this.iIsGlobal;
    }

    public synchronized Properties getDomainProperties() {
        return this.iDomainProperties;
    }

    public synchronized void setDomainProperties(Properties pDomainProperties) {
        if (this.isGlobal()) {
            throw new IllegalStateException("Global configuration cannot be modified by setDomainProperties()");
        }
        this.iDomainProperties = pDomainProperties;
    }

    public synchronized String getDomainProperty(String pKey) {
        return this.iDomainProperties != null ? this.iDomainProperties.getProperty(pKey) : null;
    }

    public synchronized void setDomainProperty(String pKey, String pValue) {
        if (this.isGlobal()) {
            throw new IllegalStateException("Global configuration cannot be modified by setDomainProperty()");
        }
        this.iDomainProperties.setProperty(pKey, pValue);
    }

    public Properties getLocalProperties() {
        return (Properties)this.iLocalProperties.get();
    }

    public void setLocalProperties(Properties pLocalProperties) {
        if (this.isGlobal()) {
            throw new IllegalStateException("Global configuration cannot be modified by setLocalProperties()");
        }
        this.iLocalProperties.set(pLocalProperties);
    }

    public String getLocalProperty(String pKey) {
        Properties localProperties = (Properties)this.iLocalProperties.get();
        return localProperties != null ? localProperties.getProperty(pKey) : null;
    }

    public void setLocalProperty(String pKey, String pValue) {
        if (this.isGlobal()) {
            throw new IllegalStateException("Global configuration cannot be modified by setLocalProperty()");
        }
        Properties localProperties = (Properties)this.iLocalProperties.get();
        if (localProperties == null) {
            localProperties = new Properties();
            this.iLocalProperties.set(localProperties);
        }
        localProperties.setProperty(pKey, pValue);
    }

    private String getProperty(String pProperty, String pDefault) {
        String globalProperty = System.getProperty(pProperty, pDefault);
        String domainProperty = this.getDomainProperty(pProperty);
        String localProperty = this.getLocalProperty(pProperty);
        return localProperty != null ? localProperty : (domainProperty != null ? domainProperty : (globalProperty != null ? globalProperty : pDefault));
    }

    private String getSecurityProperty(String pProperty, String pDefault) {
        String globalProperty = Security.getProperty(pProperty);
        String domainProperty = this.getDomainProperty(pProperty);
        String localProperty = this.getLocalProperty(pProperty);
        return localProperty != null ? localProperty : (domainProperty != null ? domainProperty : (globalProperty != null ? globalProperty : pDefault));
    }

    public synchronized void setCustomSocketFactory(SocketFactory pFactory) {
        this.iCustomSocketFactory = pFactory;
    }

    public synchronized SocketFactory getCustomSocketFactory() {
        return this.iCustomSocketFactory;
    }

    public Level getLogConsoleLevel() {
        return Level.parse(this.getProperty("sblim.wbem.logConsoleLevel", "OFF"));
    }

    public String getLogConsoleType() {
        return this.getProperty("sblim.wbem.logConsoleType", "MESSAGE");
    }

    public Level getLogFileLevel() {
        return Level.parse(this.getProperty("sblim.wbem.logFileLevel", "OFF"));
    }

    public String getLogFileLocation() {
        return this.getProperty("sblim.wbem.logFileLocation", "%t/cimclient_log_%g.txt");
    }

    public int getLogFileCount() {
        return Integer.parseInt(this.getProperty("sblim.wbem.logFileCount", "3"));
    }

    public int getLogFileSizeLimit() {
        return Integer.parseInt(this.getProperty("sblim.wbem.logFileSizeLimit", "5242880"));
    }

    public Level getTraceFileLevel() {
        return Level.parse(this.getProperty("sblim.wbem.traceFileLevel", "OFF"));
    }

    public String getTraceFileLocation() {
        return this.getProperty("sblim.wbem.traceFileLocation", "%t/cimclient_trace_%g.txt");
    }

    public int getTraceFileCount() {
        return Integer.parseInt(this.getProperty("sblim.wbem.traceFileCount", "5"));
    }

    public int getTraceFileSizeLimit() {
        return Integer.parseInt(this.getProperty("sblim.wbem.traceFileSizeLimit", "1000000"));
    }

    public int getHttpTimeout() {
        return Integer.parseInt(this.getProperty("sblim.wbem.httpTimeout", "0"));
    }

    public int getHttpPoolSize() {
        return Integer.parseInt(this.getProperty("sblim.wbem.httpPoolSize", "16"));
    }

    public String getHttpAuthenticationModule() {
        return this.getProperty("sblim.wbem.httpAuthModule", WBEMConfigurationDefaults.HTTP_AUTHENTICATION_MODULE);
    }

    public String getHttpWwwAuthenticateInfo() {
        return this.getProperty("sblim.wbem.httpWwwAuthenticateInfo", null);
    }

    public boolean isHttpMPost() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.httpMPOST", "true"));
    }

    public boolean isHttpChunked() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.httpChunking", "true"));
    }

    public String getHttpVersion() {
        return this.getProperty("sblim.wbem.httpVersion", "1.1");
    }

    public String getSslKeyStorePath() {
        return this.getProperty("javax.net.ssl.keyStore", null);
    }

    public String getSslKeyStoreType() {
        return this.getProperty("javax.net.ssl.keyStoreType", "JKS");
    }

    public String getSslKeyStorePassword() {
        return this.getProperty("javax.net.ssl.keyStorePassword", "");
    }

    public String getSslTrustStorePath() {
        return this.getProperty("javax.net.ssl.trustStore", null);
    }

    public String getSslTrustStoreType() {
        return this.getProperty("javax.net.ssl.trustStoreType", "JKS");
    }

    public String getSslTrustStorePassword() {
        return this.getProperty("javax.net.ssl.trustStorePassword", "");
    }

    public String getSslSocketProvider() {
        Provider[] providers = Security.getProviders("SSLContext.SSL");
        return this.getProperty("sblim.wbem.sslSocketProvider", providers != null && providers.length > 0 ? providers[0].getClass().getName() : null);
    }

    public String getSslServerSocketProvider() {
        Provider[] providers = Security.getProviders("SSLContext.SSL");
        return this.getProperty("sblim.wbem.sslServerSocketProvider", providers != null && providers.length > 0 ? providers[0].getClass().getName() : null);
    }

    public String getSslProtocol() {
        return this.getSecurityProperty("ssl.Protocol", "SSL");
    }

    public String getSslClientProtocol() {
        return this.getProperty("sblim.wbem.sslClientProtocol", null);
    }

    public String getSslListenerProtocol() {
        return this.getProperty("sblim.wbem.sslListenerProtocol", null);
    }

    public String getSslKeyManagerAlgorithm() {
        return this.getSecurityProperty("ssl.KeyManagerFactory.algorithm", null);
    }

    public String getSslTrustManagerAlgorithm() {
        return this.getSecurityProperty("ssl.TrustManagerFactory.algorithm", null);
    }

    public boolean getSslClientPeerVerification() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.sslClientPeerVerification", "false"));
    }

    public String getSslListenerPeerVerification() {
        return this.getProperty("sblim.wbem.sslListenerPeerVerification", "ignore");
    }

    public String getSslClientCipherSuitesToDisable() {
        return this.getProperty("sblim.wbem.sslClientCipherSuitesToDisable", null);
    }

    public String getSslListenerCipherSuitesToDisable() {
        return this.getProperty("sblim.wbem.sslListenerCipherSuitesToDisable", null);
    }

    public int getHttpConnectRetriesCount() {
        return Integer.parseInt(this.getProperty("sblim.wbem.httpConnectionRetries", "0"));
    }

    public boolean isHttpContentLengthRetryEnabled() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.httpEnableContentLengthRetry", "false"));
    }

    public int getHttpContentLengthThreshold() {
        return Integer.parseInt(this.getProperty("sblim.wbem.httpContentLengthThreshold", "50"));
    }

    public String getCimXmlParser() {
        return this.getProperty("sblim.wbem.cimxmlParser", "SAX");
    }

    public String getCimXmlEmbObjBuilder() {
        return this.getProperty("sblim.wbem.cimxmlEmbObjBuilder", "AttribOnly");
    }

    public boolean strictEmbObjTypes() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.cimxmlParser.strictEmbObjTypes", "true"));
    }

    public boolean upperCaseEmbObjEntities() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.cimxmlBuilder.upperCaseEmbObjEntities", "true"));
    }

    public boolean performSslHandshake() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.performSslHandshake", "true"));
    }

    public boolean synchronizedSslHandshake() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.synchronizedSslHandshake", "false"));
    }

    public boolean socketConnectWithTimeout() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.socketConnectWithTimeout", "true"));
    }

    public int getSocketConnectTimeout() {
        return Integer.parseInt(this.getProperty("sblim.wbem.socketConnectTimeout", "0"));
    }

    public int getSocketIdleTimeout() {
        return Integer.parseInt(this.getProperty("sblim.wbem.socketIdleTimeout", "0"));
    }

    public boolean isDefaultAuthorizationEnabled() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.default.authorization.enabled", "false"));
    }

    public String getDefaultPrincipal() {
        return this.getProperty("sblim.wbem.default.principal", "default");
    }

    public String getDefaultCredentials() {
        return this.getProperty("sblim.wbem.default.credential", "default");
    }

    public boolean isCimXmlTracingEnabled() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.cimxmlTracing", "false"));
    }

    public String getCimXmlTraceStream() {
        return this.getProperty("sblim.wbem.cimxmlTraceStream", null);
    }

    public int getListenerBacklog() {
        return Integer.parseInt(this.getProperty("sblim.wbem.listenerBacklog", "2"));
    }

    public int getListenerHttpTimeout() {
        return Integer.parseInt(this.getProperty("sblim.wbem.listenerHttpTimeout", "10000"));
    }

    public int getListenerHttpHeaderTimeout() {
        return Integer.parseInt(this.getProperty("sblim.wbem.listenerHttpHeaderTimeout", "30000"));
    }

    public int getListenerMaxAllowedTimeouts() {
        return Integer.parseInt(this.getProperty("sblim.wbem.listenerHttpMaxAllowedTimeouts", "0"));
    }

    public int getListenerMaxPoolSize() {
        return Integer.parseInt(this.getProperty("sblim.wbem.listenerPoolMaxSize", "8"));
    }

    public int getListenerMinPoolSize() {
        return Integer.parseInt(this.getProperty("sblim.wbem.listenerPoolMinSize", "2"));
    }

    public int getListenerMaxQueueSize() {
        return Integer.parseInt(this.getProperty("sblim.wbem.listenerQueueMaxSize", "32"));
    }

    public long getListenerMaxIdle() {
        return Long.parseLong(this.getProperty("sblim.wbem.listenerHandlerMaxIdle", "30000"));
    }

    public int getListenerMaxQueuedEvents() {
        return Integer.parseInt(this.getProperty("sblim.wbem.listenerMaxQueuedEvents", "0"));
    }

    public boolean isReliableIndicationEnabled() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.listenerEnableReliableIndications", "false"));
    }

    public long getListenerDeliveryRetryAttempts() {
        return Long.parseLong(this.getProperty("sblim.wbem.listenerDeliveryRetryAttempts", "3"));
    }

    public long getListenerDeliveryRetryInterval() {
        return Long.parseLong(this.getProperty("sblim.wbem.listenerDeliveryRetryInterval", "20"));
    }

    public int getReliableIndicationHashtableCapacity() {
        return Integer.parseInt(this.getProperty("sblim.wbem.listenerReliableIndicationHashtableCapacity", "0"));
    }

    public String getListenerIndicationTraceFilter() {
        return this.getProperty("sblim.wbem.listenerIndicationTraceFilter", null);
    }

    public boolean getListenerAddSenderIPAddress() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.listenerAddSenderIPAddress", "false"));
    }

    public boolean verifyJavaLangDoubleStrings() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.verifyJavaLangDoubleStrings", "true"));
    }

    public boolean synchronizeNumericKeyDataTypes() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.synchronizeNumericKeyDataTypes", "false"));
    }

    public boolean isGzipEncodingEnabled() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.enableGzipEncoding", "false"));
    }

    public boolean allowEmptyLocalNameSpacePath() {
        return Boolean.valueOf(this.getProperty("sblim.wbem.cimxmlParser.allowEmptyLocalNameSpacePath", "false"));
    }

    static {
        cConfigURL = null;
        cConfigFullURL = null;
        cLoadSuccessful = false;
        cLoadException = null;
        WBEMConfiguration.loadGlobalConfiguration();
        cConfiguration = new WBEMConfiguration();
        WBEMConfiguration.cConfiguration.iIsGlobal = true;
    }
}

