/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.wbem;

import javax.cim.CIMInstance;
import javax.wbem.WBEMException;

public class CIMError {
    private int iStatusCode;
    private String iDescription;
    private CIMInstance[] iInstances;

    public CIMError() {
        this(1, "Failed.");
    }

    public CIMError(WBEMException pEx) {
        this(pEx.getID(), pEx.getMessage(), pEx.getCIMErrors());
    }

    public CIMError(int pStatus) {
        this(pStatus, null);
    }

    public CIMError(int pStatus, String pMsg) {
        this(pStatus, pMsg, null);
    }

    public CIMError(int pStatus, String pMsg, CIMInstance[] pInstances) {
        this.iStatusCode = pStatus;
        this.iDescription = pMsg;
        this.iInstances = pInstances;
    }

    public int getCode() {
        return this.iStatusCode;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public CIMInstance[] getCIMInstances() {
        return this.iInstances;
    }

    public void setCode(int pStatus) {
        if (pStatus > 28 || pStatus < 1) {
            throw new IllegalArgumentException("invalid error code");
        }
        this.iStatusCode = pStatus;
    }

    public void setDescription(String pDescription) {
        this.iDescription = pDescription;
    }

    public String toString() {
        return "CIMError: " + (this.iDescription != null ? "(" + this.iDescription + ")" : "");
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMError)) {
            return false;
        }
        CIMError that = (CIMError)o;
        return this.iStatusCode == that.iStatusCode && (this.iDescription == null ? that.iDescription == null : this.iDescription.equals(that.iDescription));
    }

    public int hashCode() {
        return (this.iDescription != null ? this.iDescription.hashCode() : 0) << 16 + this.iStatusCode;
    }
}

