/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.wbem.indications;

import java.util.EventListener;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.wbem.listener.IndicationListener;
import org.sblim.cimclient.IndicationListenerSBLIM;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.sblim.cimclient.internal.wbem.indications.CIMEvent;

public class CIMEventDispatcher
extends Thread {
    protected LinkedList<CIMEvent> iEventQueue = new LinkedList();
    protected EventListener iListener = null;
    private boolean iAlive = true;
    private int iMaxEvents = 0;
    private LogAndTraceBroker iLogger = LogAndTraceBroker.getBroker();

    public CIMEventDispatcher(EventListener pListener) {
        this(pListener, 0);
    }

    public CIMEventDispatcher(EventListener pListener, int pMaxEvents) {
        if (!(pListener instanceof IndicationListener) && !(pListener instanceof IndicationListenerSBLIM)) {
            throw new IllegalArgumentException("Listener must be instance of IndicationListener or IndicationListenerSBLIM");
        }
        this.iListener = pListener;
        this.iMaxEvents = pMaxEvents;
        this.setDaemon(true);
        this.setName("CIMEventDispatcher");
        this.start();
    }

    public synchronized void dispatchEvent(CIMEvent pEvent) {
        if (pEvent != null) {
            int size;
            if (this.iMaxEvents > 0 && (size = this.iEventQueue.size()) >= this.iMaxEvents) {
                for (int i = size - this.iMaxEvents + 1; i > 0; --i) {
                    CIMEvent event = this.iEventQueue.remove(0);
                    this.iLogger.trace(Level.FINE, "Deleted CIMEvent (id=" + event.getID() + ") from the queue (maximum size of " + this.iMaxEvents + " reached)");
                }
            }
            this.iEventQueue.add(pEvent);
            this.iLogger.trace(Level.FINE, "Added CIMEvent (id=" + pEvent.getID() + ") to the queue (" + this.iEventQueue.size() + " elements total)");
            this.notify();
        } else {
            this.iLogger.trace(Level.WARNING, "CIMEvent to dispatch was null");
        }
    }

    public synchronized void startup() {
        this.iAlive = true;
        this.start();
    }

    public synchronized void kill() {
        this.iAlive = false;
        this.notify();
    }

    public synchronized void close() {
        this.kill();
    }

    private synchronized CIMEvent getEvent() {
        CIMEvent event = null;
        while (event == null) {
            try {
                if (this.iEventQueue.size() == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.iAlive) break;
            if (this.iEventQueue.size() <= 0) continue;
            event = this.iEventQueue.remove(0);
            this.iLogger.trace(Level.FINER, "Removed CIMEvent (id=" + event.getID() + ") from the queue (" + this.iEventQueue.size() + " elements left)");
        }
        return event;
    }

    public void run() {
        while (this.iAlive) {
            try {
                CIMEvent event = this.getEvent();
                if (event == null) continue;
                this.iLogger.trace(Level.FINER, "Processing CIMEvent (id=" + event.getID() + ")");
                try {
                    if (this.iListener instanceof IndicationListener) {
                        ((IndicationListener)this.iListener).indicationOccured(event.getID(), event.getIndication());
                        continue;
                    }
                    ((IndicationListenerSBLIM)this.iListener).indicationOccured(event.getID(), event.getIndication(), event.getInetAddress());
                }
                catch (Throwable t) {
                    this.iLogger.trace(Level.FINE, "Exception caught in listener (" + this.iListener.getClass().getName() + ") while processing CIMEvent", t);
                }
            }
            catch (Throwable t) {
                this.iLogger.trace(Level.FINE, "Exception in event dispatcher loop", t);
            }
        }
    }
}

