/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.wbem.indications;

import java.net.InetAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.cim.CIMInstance;
import javax.cim.CIMProperty;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.sblim.cimclient.internal.wbem.indications.CIMEvent;
import org.sblim.cimclient.internal.wbem.indications.CIMEventDispatcher;

public class ReliableIndicationHandler {
    private LinkedList<ReliableIndication> iQueue = new LinkedList();
    private LinkedList<CacheEntry> iCache = new LinkedList();
    private CIMEventDispatcher iDispatcher;
    private LogAndTraceBroker iLogger = LogAndTraceBroker.getBroker();
    private long iIndentifierLifetime;
    private String iLastSequenceContext;
    private Long iLastSequenceNumber;
    private long iExpectedSequenceNumber = 0L;
    private boolean iIsFirstIndication = true;

    public ReliableIndicationHandler(CIMEventDispatcher pDispatcher, long pIdentiferLifetime) {
        this.iDispatcher = pDispatcher;
        this.iIndentifierLifetime = pIdentiferLifetime;
    }

    private void addToQueue(ReliableIndication pIndication) {
        int size = this.iQueue.size();
        if (size == 0 || this.iQueue.getLast().getSequenceNumber() < pIndication.getSequenceNumber()) {
            this.iQueue.addLast(pIndication);
        } else {
            for (int i = size - 1; i >= 0; --i) {
                ReliableIndication indication = this.iQueue.get(i);
                if (indication.getSequenceNumber() >= pIndication.getSequenceNumber()) continue;
                this.iQueue.add(i + 1, pIndication);
                this.processQueue();
                return;
            }
            this.iQueue.addFirst(pIndication);
        }
        if (size > 0) {
            this.processQueue();
        }
    }

    private void flushQueue() {
        if (this.iQueue.isEmpty()) {
            return;
        }
        for (int i = this.iQueue.size() - 1; i >= 0; --i) {
            ReliableIndication indication = this.iQueue.removeFirst();
            this.logMissingQueueEntries(indication.getSequenceNumber());
            this.iDispatcher.dispatchEvent(new CIMEvent(indication.getIndication(), indication.getId(), indication.getInetAddress()));
            this.iExpectedSequenceNumber = indication.getSequenceNumber() + 1L;
        }
    }

    private boolean isQueueEmpty() {
        return this.iQueue.isEmpty();
    }

    private void logMissingQueueEntries(long pSequenceNumber) {
        if (pSequenceNumber > this.iExpectedSequenceNumber) {
            for (long l = this.iExpectedSequenceNumber; l < pSequenceNumber; ++l) {
                this.iLogger.trace(Level.FINE, "Missing indication #" + l + " detected");
            }
        }
    }

    private void processQueue() {
        if (this.iQueue.isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        ReliableIndication indication = this.iQueue.getFirst();
        while (indication.getDiscardTime() <= currentTime) {
            indication = this.iQueue.removeFirst();
            this.logMissingQueueEntries(indication.getSequenceNumber());
            this.iDispatcher.dispatchEvent(new CIMEvent(indication.getIndication(), indication.getId(), indication.getInetAddress()));
            this.iExpectedSequenceNumber = indication.getSequenceNumber() + 1L;
            if (this.iQueue.isEmpty()) {
                return;
            }
            indication = this.iQueue.getFirst();
        }
        while (indication.getSequenceNumber() == this.iExpectedSequenceNumber) {
            indication = this.iQueue.removeFirst();
            this.iDispatcher.dispatchEvent(new CIMEvent(indication.getIndication(), indication.getId(), indication.getInetAddress()));
            ++this.iExpectedSequenceNumber;
            if (this.iQueue.isEmpty()) {
                return;
            }
            indication = this.iQueue.getFirst();
        }
    }

    private void addToCache(String pSequenceContext, long pSequenceNumber, long pDiscardTime) {
        CacheEntry newEntry = new CacheEntry(pSequenceContext, pSequenceNumber, pDiscardTime);
        int size = this.iCache.size();
        if (size == 0 || this.iCache.getLast().getDiscardTime() <= pDiscardTime) {
            this.iCache.addLast(newEntry);
        } else {
            for (int i = size - 1; i >= 0; --i) {
                CacheEntry entry = this.iCache.get(i);
                if (entry.getDiscardTime() > pDiscardTime) continue;
                this.iCache.add(i + 1, newEntry);
                return;
            }
            this.iCache.addFirst(newEntry);
        }
    }

    private boolean isCacheEmpty() {
        return this.iCache.isEmpty();
    }

    private boolean isInCache(String pSequenceContext) {
        if (this.iCache.isEmpty()) {
            return false;
        }
        Iterator iterator = this.iCache.iterator();
        while (iterator.hasNext()) {
            if (((CacheEntry)iterator.next()).getSequenceContext().compareTo(pSequenceContext) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean isInCache(String pSequenceContext, long pSequenceNumber) {
        if (this.iCache.isEmpty()) {
            return false;
        }
        for (CacheEntry entry : this.iCache) {
            if (entry.getSequenceContext().compareTo(pSequenceContext) != 0 || entry.getSequenceNumber() != pSequenceNumber) continue;
            return true;
        }
        return false;
    }

    private void processCache() {
        if (this.iCache.isEmpty()) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        for (int i = this.iCache.size() - 1; i >= 0 && this.iCache.getFirst().getDiscardTime() <= currentTime; --i) {
            this.iCache.removeFirst();
        }
    }

    protected synchronized boolean areAllEmpty() {
        return this.isCacheEmpty() && this.isQueueEmpty();
    }

    protected synchronized void processAll() {
        this.processQueue();
        this.processCache();
    }

    public synchronized void handleIndication(CIMInstance pIndication, String pId, InetAddress pInetAddress) {
        long arrivalTime = System.currentTimeMillis();
        CIMProperty<?> seqCtxProp = pIndication.getProperty("SequenceContext");
        CIMProperty<?> seqNumProp = pIndication.getProperty("SequenceNumber");
        if (seqCtxProp == null || seqNumProp == null || seqCtxProp.getValue() == null || seqNumProp.getValue() == null) {
            if (this.iLastSequenceContext != null) {
                this.flushQueue();
                this.iLastSequenceContext = null;
                this.iLastSequenceNumber = null;
            }
            this.iDispatcher.dispatchEvent(new CIMEvent(pIndication, pId, pInetAddress));
            this.iIsFirstIndication = false;
            return;
        }
        if (this.iIsFirstIndication) {
            this.iLastSequenceContext = (String)seqCtxProp.getValue();
            this.iLastSequenceNumber = (Long)seqNumProp.getValue();
            this.iExpectedSequenceNumber = this.iLastSequenceNumber + 1L;
            this.addToCache(this.iLastSequenceContext, this.iLastSequenceNumber, arrivalTime + this.iIndentifierLifetime);
            this.iDispatcher.dispatchEvent(new CIMEvent(pIndication, pId, pInetAddress));
            this.iIsFirstIndication = false;
            return;
        }
        String seqCtx = (String)seqCtxProp.getValue();
        Long seqNum = (Long)seqNumProp.getValue();
        long seqNumVal = seqNum;
        if (this.iLastSequenceContext == null || seqCtx.compareTo(this.iLastSequenceContext) != 0) {
            if (this.isInCache(seqCtx)) {
                this.iLogger.trace(Level.FINE, "Out-of-order indication #" + seqNumVal + " received from previous context; indication ignored, logged: " + pIndication.toString());
                return;
            }
            this.iLogger.trace(Level.FINE, "Discarding knowledge of previous sequence identifier because context changed");
            this.flushQueue();
            this.iLastSequenceContext = seqCtx;
            this.iLastSequenceNumber = 0L;
            this.iExpectedSequenceNumber = 1L;
            this.addToCache(seqCtx, seqNumVal, arrivalTime + this.iIndentifierLifetime);
            if (seqNumVal == 0L) {
                this.iDispatcher.dispatchEvent(new CIMEvent(pIndication, pId, pInetAddress));
                return;
            }
            this.iLastSequenceNumber = -1L;
            this.iExpectedSequenceNumber = 0L;
            this.addToQueue(new ReliableIndication(pIndication, seqNumVal, arrivalTime + this.iIndentifierLifetime, pId, pInetAddress));
            return;
        }
        if (seqNumVal == this.iExpectedSequenceNumber) {
            this.iLastSequenceNumber = seqNum;
            this.iExpectedSequenceNumber = seqNumVal + 1L;
            this.addToCache(seqCtx, seqNumVal, arrivalTime + this.iIndentifierLifetime);
            this.iDispatcher.dispatchEvent(new CIMEvent(pIndication, pId, pInetAddress));
            return;
        }
        if (this.isInCache(seqCtx, seqNumVal)) {
            this.iLogger.trace(Level.FINE, "Duplicate indication #" + seqNumVal + " received; indication ignored");
            this.addToCache(seqCtx, seqNumVal, arrivalTime + this.iIndentifierLifetime);
            return;
        }
        if (seqNumVal < this.iExpectedSequenceNumber) {
            this.iLogger.trace(Level.FINE, "Out-of-order indication #" + seqNumVal + " received (#" + this.iExpectedSequenceNumber + " expected); indication ignored, logged: " + pIndication.toString());
            this.addToCache(seqCtx, seqNumVal, arrivalTime + this.iIndentifierLifetime);
            return;
        }
        this.addToCache(seqCtx, seqNumVal, arrivalTime + this.iIndentifierLifetime);
        this.addToQueue(new ReliableIndication(pIndication, seqNumVal, arrivalTime + this.iIndentifierLifetime, pId, pInetAddress));
    }

    private class CacheEntry {
        private String iSeqContext;
        private long iSeqNumber;
        private long iDiscardTime;

        public CacheEntry(String pSequenceContext, long pSequenceNumber, long pDiscardTime) {
            this.iSeqContext = pSequenceContext;
            this.iSeqNumber = pSequenceNumber;
            this.iDiscardTime = pDiscardTime;
        }

        public long getDiscardTime() {
            return this.iDiscardTime;
        }

        public String getSequenceContext() {
            return this.iSeqContext;
        }

        public long getSequenceNumber() {
            return this.iSeqNumber;
        }
    }

    private class ReliableIndication {
        private long iDiscardTime;
        private String iId;
        private CIMInstance iIndication;
        private InetAddress iInetAddress;
        private long iSequenceNumber;

        public ReliableIndication(CIMInstance pIndication, long pSequenceNumber, long pDiscardTime, String pId, InetAddress pInetAddress) {
            this.iIndication = pIndication;
            this.iSequenceNumber = pSequenceNumber;
            this.iDiscardTime = pDiscardTime;
            this.iId = pId;
            this.iInetAddress = pInetAddress;
        }

        public long getDiscardTime() {
            return this.iDiscardTime;
        }

        public String getId() {
            return this.iId;
        }

        public CIMInstance getIndication() {
            return this.iIndication;
        }

        public InetAddress getInetAddress() {
            return this.iInetAddress;
        }

        public long getSequenceNumber() {
            return this.iSequenceNumber;
        }
    }
}

