/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import org.sblim.cimclient.GenericExts;
import org.sblim.slp.ServiceLocationException;
import org.sblim.slp.internal.AttributeHandler;
import org.sblim.slp.internal.Convert;
import org.sblim.slp.internal.SLPString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLocationAttribute
implements Serializable {
    private static final long serialVersionUID = -6753246108754657715L;
    private Vector<Object> iValues;
    private String iId;
    private int iHashCode = 0;
    private transient ValueEntry[] iSortedValueEntries;

    public ServiceLocationAttribute(String pId, Vector<Object> pValues) {
        this.iId = pId;
        if (pValues != null && pValues.size() > 0) {
            this.iValues = GenericExts.cloneVector(pValues);
        }
    }

    public ServiceLocationAttribute(String pString) throws ServiceLocationException {
        if (pString == null || pString.length() == 0) {
            throw new ServiceLocationException(2, "Empty or null String is not good for this constructor!");
        }
        if (pString.startsWith("(") && pString.endsWith(")")) {
            int equalPos = pString.indexOf(61);
            if (equalPos < 0) {
                throw new ServiceLocationException(2, "Missing '=' from attribute string: " + pString);
            }
            this.iId = Convert.unescape(pString.substring(1, equalPos));
            if (this.iId.length() == 0) {
                throw new ServiceLocationException(2, "Empty attribute ID in attribute string: " + pString);
            }
            String valueString = pString.substring(equalPos + 1, pString.length() - 1);
            this.parseValueString(valueString);
        } else {
            if (pString.indexOf(40) >= 0 || pString.indexOf(41) >= 0) {
                throw new ServiceLocationException(2);
            }
            this.iId = Convert.unescape(pString);
            this.iValues = null;
        }
    }

    public static String escapeId(String pId) {
        return Convert.escape(pId, "(),\\!<=>~");
    }

    public static String escapeValue(Object pValue) {
        return AttributeHandler.escapeValue(pValue);
    }

    public Vector<Object> getValues() {
        if (this.iValues != null) {
            return GenericExts.cloneVector(this.iValues);
        }
        return this.iValues;
    }

    public String getId() {
        return this.iId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ServiceLocationAttribute)) {
            return false;
        }
        ServiceLocationAttribute that = (ServiceLocationAttribute)obj;
        if (!that.getId().equalsIgnoreCase(this.iId)) {
            return false;
        }
        Vector<Object> thatValues = that.iValues;
        if (this.iValues == null) {
            return thatValues == null;
        }
        if (thatValues == null) {
            return false;
        }
        if (this.iValues.size() != thatValues.size()) {
            return false;
        }
        Object[] thisEntries = this.getSortedValueEntries();
        Object[] thatEntries = that.getSortedValueEntries();
        return Arrays.equals(thisEntries, thatEntries);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("(");
        stringbuffer.append(this.iId);
        if (this.iValues != null) {
            stringbuffer.append("=");
            int size = this.iValues.size();
            for (int i = 0; i < size; ++i) {
                Object obj = this.iValues.elementAt(i);
                if (i > 0) {
                    stringbuffer.append(",");
                }
                if (obj instanceof byte[]) {
                    obj = AttributeHandler.mkOpaqueStr((byte[])obj);
                }
                stringbuffer.append(obj.toString());
            }
        }
        stringbuffer.append(")");
        return stringbuffer.toString();
    }

    private void incHashCode(int pHashCode) {
        this.iHashCode *= 31;
        this.iHashCode += pHashCode;
    }

    public int hashCode() {
        if (this.iHashCode == 0) {
            this.iHashCode = this.iId.hashCode();
            if (this.iValues != null) {
                ValueEntry[] valueEntries = this.getSortedValueEntries();
                for (int i = 0; i < valueEntries.length; ++i) {
                    this.incHashCode(valueEntries[i].hashCode());
                }
            }
        }
        return this.iHashCode;
    }

    private void parseValueString(String pStr) throws ServiceLocationException {
        StringTokenizer tokenizer = new StringTokenizer(pStr, ",");
        this.iValues = new Vector();
        while (tokenizer.hasMoreElements()) {
            Object value;
            String valueStr = tokenizer.nextToken();
            try {
                int intVal = Integer.parseInt(valueStr);
                value = intVal;
            }
            catch (NumberFormatException e) {
                value = "TRUE".equalsIgnoreCase(valueStr) ? Boolean.TRUE : ("FALSE".equalsIgnoreCase(valueStr) ? Boolean.FALSE : (valueStr.startsWith("\\FF") ? (Object)ServiceLocationAttribute.parseOpaqueStr(valueStr) : Convert.unescape(valueStr)));
            }
            this.iValues.add(value);
        }
    }

    private static byte[] parseOpaqueStr(String pStr) throws ServiceLocationException {
        int left;
        if (pStr.length() == 3) {
            throw new ServiceLocationException(2, "There must be at least three characters after \\FF in opaque string! pStr=" + pStr);
        }
        ByteArrayOutputStream oStr = new ByteArrayOutputStream();
        int pos = 3;
        while ((left = pStr.length() - pos) > 0) {
            if (left < 3) {
                throw new ServiceLocationException(2, "Number of characters must be multiple of three after \\FF in opaque string! pStr=" + pStr);
            }
            if (pStr.charAt(pos) != '\\') {
                throw new ServiceLocationException(2, "Hex value must be preceded by \\ in opaque string! pStr=" + pStr);
            }
            String hexStr = pStr.substring(pos + 1, pos + 3);
            pos += 3;
            try {
                oStr.write(Integer.parseInt(hexStr, 16));
            }
            catch (NumberFormatException e) {
                throw new ServiceLocationException(2, "Failed to parse hex value: " + hexStr + " in opaque string: " + pStr + " !");
            }
        }
        return oStr.toByteArray();
    }

    private ValueEntry[] getSortedValueEntries() {
        if (this.iValues == null) {
            return null;
        }
        if (this.iSortedValueEntries != null) {
            return this.iSortedValueEntries;
        }
        this.iSortedValueEntries = new ValueEntry[this.iValues.size()];
        for (int i = 0; i < this.iValues.size(); ++i) {
            Object value;
            ValueEntry entry;
            this.iSortedValueEntries[i] = entry = new ValueEntry();
            entry.iValue = value = this.iValues.get(i);
            entry.iStr = value == null ? "" : (value instanceof String ? SLPString.unify((String)value) : (value instanceof byte[] ? AttributeHandler.mkOpaqueStr((byte[])value) : value.toString()));
        }
        Arrays.sort(this.iSortedValueEntries);
        return this.iSortedValueEntries;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ValueEntry
    implements Comparable<ValueEntry> {
        public String iStr;
        public Object iValue;

        ValueEntry() {
        }

        @Override
        public int compareTo(ValueEntry o) {
            ValueEntry that = o;
            return this.iStr.compareTo(that.iStr);
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (!(pObj instanceof ValueEntry)) {
                return false;
            }
            ValueEntry that = (ValueEntry)pObj;
            if (this.iValue == null) {
                return that.iValue == null;
            }
            if (that.iValue == null) {
                return false;
            }
            if (!this.iValue.getClass().equals(that.iValue.getClass())) {
                return false;
            }
            if (this.iValue instanceof byte[]) {
                return Arrays.equals((byte[])this.iValue, (byte[])that.iValue);
            }
            if (this.iValue instanceof String) {
                return this.iStr.equals(that.iStr);
            }
            return this.iValue.equals(that.iValue);
        }

        public int hashCode() {
            return this.iStr == null ? 1 : this.iStr.hashCode();
        }
    }
}

