/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal;

import java.io.UnsupportedEncodingException;
import org.sblim.slp.ServiceLocationException;

public class Convert {
    public static final String ATTR_RESERVED = "(),\\!<=>~";
    public static final String SCOPE_RESERVED = "(),\\!<=>~;*+";
    public static final String DEFAULT_RESERVED = "(),\\!<=>~";
    private static final byte[] EMPTY_BYTES = new byte[0];

    public static byte[] getBytes(String pStr) {
        if (pStr == null) {
            return EMPTY_BYTES;
        }
        try {
            return pStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding : UTF-8", e);
        }
    }

    public static String escape(String pStr) {
        return Convert.escape(pStr, "(),\\!<=>~");
    }

    public static String escape(String pStr, String pReservedChars) {
        if (pStr == null) {
            return "";
        }
        if (pReservedChars == null) {
            return pStr;
        }
        StringBuffer strBuf = null;
        for (int i = 0; i < pStr.length(); ++i) {
            char ch = pStr.charAt(i);
            if (ch < ' ' || pReservedChars.indexOf(ch) >= 0) {
                if (strBuf == null) {
                    strBuf = new StringBuffer();
                    if (i > 0) {
                        strBuf.append(pStr.substring(0, i));
                    }
                }
                strBuf.append(Convert.escapeChar(ch));
                continue;
            }
            if (strBuf == null) continue;
            strBuf.append(ch);
        }
        return strBuf == null ? pStr : strBuf.toString();
    }

    public static String unescape(String pStr) throws ServiceLocationException {
        int pos;
        if (pStr == null) {
            return null;
        }
        StringBuffer resBuf = null;
        int lastPos = 0;
        while ((pos = pStr.indexOf(92, lastPos)) >= 0) {
            char ch = Convert.unescapeChar(pStr.substring(pos));
            if (resBuf == null) {
                resBuf = new StringBuffer();
            }
            resBuf.append(pStr.subSequence(lastPos, pos)).append(ch);
            lastPos = pos + 3;
        }
        if (resBuf != null && lastPos < pStr.length()) {
            resBuf.append(pStr.substring(lastPos, pStr.length()));
        }
        return resBuf == null ? pStr : resBuf.toString();
    }

    private static String escapeChar(char ch) {
        char code = ch;
        String hexStr = Integer.toHexString(code).toUpperCase();
        return (hexStr.length() == 1 ? "\\0" : "\\") + hexStr;
    }

    private static char unescapeChar(String pEscSeq) throws ServiceLocationException {
        if (pEscSeq.length() < 3) {
            throw new ServiceLocationException(2, "Escaped character must contain 2 hex digits!\npEscSeq:" + pEscSeq);
        }
        String hexStr = pEscSeq.substring(1, 3);
        try {
            int code = Integer.parseInt(hexStr, 16);
            return (char)code;
        }
        catch (NumberFormatException e) {
            throw new ServiceLocationException(2, "Failed to parse hex string: " + hexStr + ", pEscSeq=" + pEscSeq + " !", e);
        }
    }
}

