/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal.msg;

import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.sblim.slp.ServiceLocationAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DADescriptor
implements Comparable<DADescriptor> {
    private String iURL;
    private TreeSet<String> iScopeSet;
    private List<ServiceLocationAttribute> iAttributes;
    private int iHashCode = 0;

    public DADescriptor(String pURL, TreeSet<String> pScopeSet, List<ServiceLocationAttribute> pAttributes) {
        this.iURL = pURL;
        this.iScopeSet = pScopeSet;
        this.iAttributes = pAttributes;
    }

    public String getURL() {
        return this.iURL;
    }

    public boolean hasScope(String pScope) {
        if (this.iScopeSet == null) {
            return false;
        }
        return this.iScopeSet.contains(pScope);
    }

    @Override
    public int compareTo(DADescriptor o) {
        DADescriptor that = o;
        return this.iURL.compareTo(that.iURL);
    }

    public boolean equals(Object pObj) {
        if (!(pObj instanceof DADescriptor)) {
            return false;
        }
        DADescriptor that = (DADescriptor)pObj;
        return this.iURL.equals(that.iURL);
    }

    private void incHashCode(int pHashCode) {
        this.iHashCode *= 31;
        this.iHashCode += pHashCode;
    }

    public int hashCode() {
        if (this.iHashCode == 0) {
            Iterator<Object> itr;
            this.iHashCode = this.iURL.hashCode();
            if (this.iScopeSet != null) {
                itr = this.iScopeSet.iterator();
                while (itr.hasNext()) {
                    this.incHashCode(itr.next().hashCode());
                }
            }
            if (this.iAttributes != null) {
                itr = this.iAttributes.iterator();
                while (itr.hasNext()) {
                    this.iHashCode += itr.next().hashCode();
                }
            }
        }
        return this.iHashCode;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer("URL : " + this.iURL + "\nScopes : ");
        if (this.iScopeSet != null) {
            Iterator<String> itr = this.iScopeSet.iterator();
            boolean more = false;
            while (itr.hasNext()) {
                if (more) {
                    strBuf.append(", ");
                } else {
                    more = true;
                }
                strBuf.append(itr.next());
            }
        }
        return strBuf.toString();
    }
}

