/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal.ua;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.sblim.slp.ServiceLocationException;
import org.sblim.slp.internal.IPv6MulticastAddressFactory;
import org.sblim.slp.internal.Net;
import org.sblim.slp.internal.SLPConfig;
import org.sblim.slp.internal.TRC;
import org.sblim.slp.internal.msg.MsgFactory;
import org.sblim.slp.internal.msg.ReplyMessage;
import org.sblim.slp.internal.msg.RequestMessage;
import org.sblim.slp.internal.ua.ResponseCache;
import org.sblim.slp.internal.ua.ResultTable;
import org.sblim.slp.internal.ua.TCPRequester;

public class DatagramRequester
implements Runnable {
    RequestMessage iReqMsg;
    private Thread iThread;
    ResultTable iResTable;
    private InetAddress iDst0;
    private InetAddress iDst1;
    private DatagramSocket iDGramSocket;
    private int iPort = SLPConfig.getGlobalCfg().getPort();
    private boolean iUseV4 = Net.hasIPv4() && SLPConfig.getGlobalCfg().useIPv4();
    private boolean iUseV6 = Net.hasIPv6() && SLPConfig.getGlobalCfg().useIPv6();
    private List<TCPRequester> iTCPRequesters;
    int iTotalTimeOut;
    int[] iTimeOuts;
    int iMaxResults = SLPConfig.getGlobalCfg().getMaximumResults();
    private static final int MAX_DATAGRAM_SIZE = 65536;
    private final byte[] iInBuf = new byte[65536];

    public DatagramRequester(RequestMessage pRqstMsg, ResultTable pResTable, InetAddress pDst) throws IOException {
        this.iReqMsg = pRqstMsg;
        this.iResTable = pResTable;
        this.iDst0 = pDst;
        this.iTimeOuts = SLPConfig.getGlobalCfg().getDatagramTimeouts();
        this.iDGramSocket = new DatagramSocket();
    }

    public DatagramRequester(RequestMessage pRqstMsg, ResultTable pResTable) throws IOException {
        this.iReqMsg = pRqstMsg;
        this.iResTable = pResTable;
        this.iTimeOuts = SLPConfig.getGlobalCfg().getMulticastTimeouts();
        this.iTotalTimeOut = SLPConfig.getGlobalCfg().getMulticastMaximumWait();
        MulticastSocket mcastSocket = new MulticastSocket();
        this.iDGramSocket = mcastSocket;
        if (this.iUseV6) {
            this.iDst0 = IPv6MulticastAddressFactory.get(5, pRqstMsg);
            try {
                mcastSocket.joinGroup(this.iDst0);
            }
            catch (IOException ioe) {
                TRC.warning("IOException caught during join, disabling IPv6: " + ioe.getMessage(), ioe);
                this.iDst0 = null;
            }
        }
        if (this.iUseV4) {
            this.iDst1 = SLPConfig.getMulticastAddress();
            mcastSocket.joinGroup(this.iDst1);
        }
    }

    public void start(boolean pAsThread) {
        this.iResTable.registerRequester(this);
        if (pAsThread) {
            this.iThread = new Thread(this);
            this.iThread.start();
        } else {
            this.iThread = null;
            this.run();
        }
    }

    public int getPort() {
        return this.iDGramSocket == null ? -1 : this.iDGramSocket.getLocalPort();
    }

    public void waitFor() {
        if (this.iThread == null) {
            return;
        }
        try {
            this.iThread.join();
        }
        catch (InterruptedException e) {
            TRC.error(e);
        }
    }

    public void run() {
        try {
            if (this.iDGramSocket instanceof MulticastSocket) {
                this.mcastNegotiate();
            } else {
                this.ucastNegotiate();
            }
        }
        catch (Exception e) {
            this.iResTable.addException(e);
            TRC.error(e.getMessage(), e);
        }
        finally {
            this.iDGramSocket.close();
            this.iResTable.unregisterRequester(this);
        }
    }

    private void mcastNegotiate() throws Exception {
        byte[] reqBytes = this.iReqMsg.serialize(true, true, false);
        DatagramPacket outPacket0 = this.iDst0 == null ? null : new DatagramPacket(reqBytes, reqBytes.length, this.iDst0, this.iPort);
        DatagramPacket outPacket1 = this.iDst1 == null ? null : new DatagramPacket(reqBytes, reqBytes.length, this.iDst1, this.iPort);
        DatagramPacket inPacket = new DatagramPacket(this.iInBuf, this.iInBuf.length);
        MCastLoopController ctrl = new MCastLoopController();
        boolean respondersUpdated = false;
        ResponseCache rspCache = new ResponseCache();
        block4: while (ctrl.hasNext()) {
            if (respondersUpdated) {
                byte[] msg = this.iReqMsg.serialize(true, true, true);
                if (outPacket0 != null) {
                    outPacket0.setData(msg);
                }
                if (outPacket1 != null) {
                    outPacket1.setData(msg);
                }
                respondersUpdated = false;
            }
            TRC.debug("sending: " + this.iReqMsg);
            try {
                if (outPacket0 != null) {
                    this.iDGramSocket.send(outPacket0);
                }
            }
            catch (IOException ioe) {
                TRC.warning("IOException caught during send, disabling IPv6: " + ioe.getMessage(), ioe);
                outPacket0 = null;
                this.iDst0 = null;
            }
            if (outPacket1 != null) {
                this.iDGramSocket.send(outPacket1);
            }
            while (ctrl.hasNext()) {
                this.iDGramSocket.setSoTimeout(ctrl.getTimeOut());
                try {
                    this.iDGramSocket.receive(inPacket);
                }
                catch (SocketTimeoutException e) {
                    TRC.debug("receive timed out");
                    ctrl.nextTimeOut();
                    continue block4;
                }
                InetAddress responderAddress = inPacket.getAddress();
                respondersUpdated = this.iReqMsg.updatePrevResponders(responderAddress.toString());
                if (rspCache.contains(inPacket)) {
                    TRC.debug("received packet is found in rspCache");
                    continue;
                }
                ReplyMessage replyMsg = this.handleResponse(inPacket);
                if (replyMsg == null) continue;
                if (replyMsg.overflows()) {
                    if (DatagramRequester.isLinkLocal(responderAddress)) continue;
                    this.addTCPRequester(responderAddress);
                    rspCache.add(inPacket);
                    continue;
                }
                rspCache.add(inPacket);
            }
            break block4;
        }
        this.waitForTCPRequesters();
    }

    private void ucastNegotiate() throws Exception {
        byte[] reqBytes = this.iReqMsg.serialize(false, true, false);
        DatagramPacket outPacket = new DatagramPacket(reqBytes, reqBytes.length, this.iDst0, this.iPort);
        DatagramPacket inPacket = new DatagramPacket(this.iInBuf, this.iInBuf.length);
        int timeOutIdx = 0;
        int timeOut = this.iTimeOuts[timeOutIdx];
        int tries = 10;
        while (timeOutIdx < this.iTimeOuts.length && tries > 0) {
            TRC.debug("sending: " + this.iReqMsg);
            this.iDGramSocket.send(outPacket);
            this.iDGramSocket.setSoTimeout(timeOut);
            try {
                this.iDGramSocket.receive(inPacket);
            }
            catch (SocketTimeoutException e) {
                TRC.debug("receive timed out");
                timeOut = this.iTimeOuts[timeOutIdx++];
                continue;
            }
            InetAddress responderAddress = inPacket.getAddress();
            ReplyMessage replyMsg = this.handleResponse(inPacket);
            if (replyMsg == null) {
                --tries;
                continue;
            }
            if (!replyMsg.overflows()) break;
            TCPRequester tcpRequester = new TCPRequester(this.iResTable, responderAddress, this.iReqMsg, true);
            tcpRequester.waitFor();
            break;
        }
    }

    private ReplyMessage handleResponse(DatagramPacket pPacket) {
        ReplyMessage replyMsg;
        try {
            replyMsg = (ReplyMessage)MsgFactory.parse(pPacket);
            TRC.debug("expected: " + this.iReqMsg.getXID() + ", received: " + replyMsg);
            if (this.iReqMsg.getXID() != replyMsg.getXID() || !this.iReqMsg.isAllowedResponseType(replyMsg)) {
                TRC.debug("expected: " + this.iReqMsg.getXID() + ", ignoring: " + replyMsg);
                return null;
            }
        }
        catch (Exception e) {
            this.iResTable.addException(e);
            return null;
        }
        TRC.debug("resTable <- " + replyMsg);
        this.iResTable.addResults(replyMsg);
        this.iResTable.addExceptions(replyMsg);
        return replyMsg;
    }

    private static boolean isLinkLocal(InetAddress pAddr) {
        if (pAddr instanceof Inet6Address) {
            Inet6Address dest6 = (Inet6Address)pAddr;
            return dest6.isLinkLocalAddress();
        }
        return false;
    }

    static long getMillis() {
        return new Date().getTime();
    }

    private void addTCPRequester(InetAddress pDest) throws ServiceLocationException {
        if (this.iTCPRequesters == null) {
            this.iTCPRequesters = new ArrayList<TCPRequester>();
        }
        this.iTCPRequesters.add(new TCPRequester(this.iResTable, pDest, this.iReqMsg, true));
    }

    private void waitForTCPRequesters() {
        if (this.iTCPRequesters == null) {
            return;
        }
        Iterator<TCPRequester> itr = this.iTCPRequesters.iterator();
        while (itr.hasNext()) {
            itr.next().waitFor();
        }
        this.iTCPRequesters.clear();
    }

    class MCastLoopController {
        private long iStartTime = DatagramRequester.getMillis();
        private int iTimeOutIdx = 0;

        MCastLoopController() {
        }

        public int getTimeOut() {
            return DatagramRequester.this.iTimeOuts[this.iTimeOutIdx];
        }

        private boolean hasNextTimeOut() {
            return this.iTimeOutIdx < DatagramRequester.this.iTimeOuts.length;
        }

        public void nextTimeOut() {
            if (this.hasNextTimeOut()) {
                ++this.iTimeOutIdx;
            }
        }

        public boolean hasNext() {
            return DatagramRequester.this.iResTable.getTotalResponses() < DatagramRequester.this.iMaxResults && DatagramRequester.getMillis() - this.iStartTime < (long)DatagramRequester.this.iTotalTimeOut && this.hasNextTimeOut();
        }
    }
}

