/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.tn5250j.Configure;
import org.tn5250j.ExternalProgramConfig;
import org.tn5250j.TN5250jConstants;
import org.tn5250j.gui.JSortTable;
import org.tn5250j.gui.SortTableModel;
import org.tn5250j.gui.TN5250jMultiSelectList;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.interfaces.OptionAccessFactory;
import org.tn5250j.tools.AlignLayout;
import org.tn5250j.tools.DESSHA1;
import org.tn5250j.tools.GUIGraphicsUtils;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class ConnectDialog
extends JDialog
implements ActionListener,
ChangeListener,
TN5250jConstants {
    private static final String USER_PREF_LAST_SESSION = "last_session";
    private static final long serialVersionUID = 1L;
    private static volatile TN5250jLogger LOG = TN5250jLogFactory.getLogger(ConnectDialog.class);
    JPanel configOptions = new JPanel();
    JPanel sessionPanel = new JPanel();
    JPanel options = new JPanel(new FlowLayout(1, 30, 10));
    JPanel interfacePanel = null;
    JPanel sessionOpts = new JPanel();
    JPanel sessionOptPanel = new JPanel(new FlowLayout(1, 30, 10));
    JPanel emulOptPanel = new JPanel();
    JPanel emptyPane = new JPanel(new FlowLayout(1, 10, 10));
    JPanel accessPanel = new JPanel();
    JPanel loggingPanel = new JPanel();
    JPanel levelPanel = new JPanel();
    JPanel appenderPanel = new JPanel();
    JPanel externalPanel = new JPanel();
    JPanel externalOpts = new JPanel();
    JPanel externalOptPanel = new JPanel(new FlowLayout(1, 30, 10));
    JPanel aboutPanel = null;
    JTable sessions = null;
    JTable externals = null;
    GridBagConstraints gbc;
    JRadioButton intOFF = null;
    JRadioButton intDEBUG = null;
    JRadioButton intINFO = null;
    JRadioButton intWARN = null;
    JRadioButton intERROR = null;
    JRadioButton intFATAL = null;
    JButton editButton = null;
    JButton removeButton = null;
    JButton connectButton = null;
    JButton applyButton = null;
    JButton cAddButton = null;
    JButton cEditButton = null;
    JButton cRemoveButton = null;
    SessionsTableModel ctm = null;
    CustomizedTableModel etm = null;
    JScrollPane scrollPane;
    JScrollPane scrollPane2;
    ListSelectionModel rowSM = null;
    ListSelectionModel rowSM2 = null;
    Properties props = null;
    Properties etnProps = null;
    JRadioButton intTABS = null;
    JCheckBox hideTabBar = null;
    JCheckBox showMe = null;
    JCheckBox lastView = null;
    Border etchedBorder = BorderFactory.createEtchedBorder();
    BorderLayout borderLayout = new BorderLayout();
    TN5250jMultiSelectList accessOptions;
    JPasswordField password;
    JButton setPassButton;
    String connectKey = null;
    private JRadioButton intConsole;
    private JRadioButton intFile;
    private JRadioButton intBoth;
    private JTextField browser;
    private JTextField mailer;

    public ConnectDialog(Frame frame, String string, Properties properties) {
        super(frame, string, true);
        this.props = ConfigureFactory.getInstance().getProperties("sessions");
        this.etnProps = ExternalProgramConfig.getInstance().getEtnPgmProps();
        try {
            this.jbInit();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getSize();
            if (dimension2.height > dimension.height) {
                dimension2.height = dimension.height;
            }
            if (dimension2.width > dimension.width) {
                dimension2.width = dimension.width;
            }
            int n = frame.getWidth();
            int n2 = frame.getHeight();
            int n3 = frame.getX();
            int n4 = frame.getY();
            this.setLocation(n3 + n / 2 - dimension2.width / 2, n4 + n2 / 2 - dimension2.height / 2);
            this.setVisible(true);
        }
        catch (Exception exception) {
            LOG.warn("Error while initializing!", exception);
        }
    }

    void jbInit() throws Exception {
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.createSessionsPanel();
        this.createEmulatorOptionsPanel();
        this.createButtonOptions();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addChangeListener(this);
        jTabbedPane.addTab(LangTool.getString("ss.labelConnections"), this.sessionPanel);
        jTabbedPane.addTab(LangTool.getString("ss.labelOptions1"), this.emulOptPanel);
        this.createLoggingPanel();
        jTabbedPane.addTab(LangTool.getString("ss.labelLogging"), this.loggingPanel);
        this.createAccessPanel();
        jTabbedPane.addTab(LangTool.getString("ss.labelOptions2"), this.accessPanel);
        this.createExternalProgramsPanel();
        jTabbedPane.addTab(LangTool.getString("ss.labelExternal"), this.externalPanel);
        this.createAboutPanel();
        jTabbedPane.addTab("About", this.aboutPanel);
        this.getContentPane().add((Component)jTabbedPane, "Center");
        this.getContentPane().add((Component)this.options, "South");
        this.pack();
        if (this.sessions.getRowCount() > 0) {
            String string;
            int n;
            int n2 = -1;
            for (n = 0; n < this.sessions.getRowCount(); ++n) {
                if (!((Boolean)this.ctm.getValueAt(n, 2)).booleanValue()) continue;
                n2 = n;
                break;
            }
            if (n2 < 0 && (string = this.loadSelectedSessionPreference()) != null) {
                for (int i = 0; i < this.sessions.getRowCount(); ++i) {
                    if (!string.equals(this.ctm.getValueAt(i, 0))) continue;
                    n2 = i;
                    break;
                }
            }
            if (n2 < 0) {
                n2 = 0;
            }
            this.sessions.getSelectionModel().setSelectionInterval(n2, n2);
            n = Math.min(this.sessions.getRowCount() - 1, n2 + 3);
            Rectangle rectangle = this.sessions.getCellRect(n, 0, true);
            this.sessions.scrollRectToVisible(rectangle);
        } else {
            this.connectButton.setEnabled(false);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConnectDialog.this.sessions.requestFocus();
                    }
                });
            }
        });
        this.setIconImages(GUIGraphicsUtils.getApplicationIcons());
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n;
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        if (!jTabbedPane.getTitleAt(n = jTabbedPane.getSelectedIndex()).equals(LangTool.getString("ss.labelConnections"))) {
            this.connectButton.setEnabled(false);
            this.setTitle(LangTool.getString("ss.title") + " - " + jTabbedPane.getTitleAt(n));
        } else {
            this.setTitle(LangTool.getString("ss.title") + " - " + LangTool.getString("ss.labelConnections"));
            this.connectButton.setEnabled(true);
        }
    }

    private void createSessionsPanel() {
        this.ctm = new SessionsTableModel();
        this.sessions = new JSortTable(this.ctm);
        this.sessions.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.sessions.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.sessions.getColumnModel().getColumn(2).setPreferredWidth(65);
        AbstractAction abstractAction = new AbstractAction("connect"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.doActionConnect();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0, false);
        this.sessions.getInputMap().put(keyStroke, "connect");
        this.sessions.getActionMap().put("connect", abstractAction);
        this.sessions.setSelectionMode(0);
        this.sessions.setPreferredScrollableViewportSize(new Dimension(500, 200));
        this.sessions.setShowGrid(false);
        this.scrollPane = new JScrollPane(this.sessions);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.sessions.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ConnectDialog.this.doActionConnect();
                }
            }
        });
        this.rowSM = this.sessions.getSelectionModel();
        this.rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    ConnectDialog.this.editButton.setEnabled(false);
                    ConnectDialog.this.removeButton.setEnabled(false);
                    ConnectDialog.this.connectButton.setEnabled(false);
                } else {
                    ConnectDialog.this.editButton.setEnabled(true);
                    ConnectDialog.this.removeButton.setEnabled(true);
                    ConnectDialog.this.connectButton.setEnabled(true);
                }
            }
        });
        this.configOptions.setLayout(this.borderLayout);
        this.sessionPanel.setLayout(this.borderLayout);
        this.configOptions.add((Component)this.sessionPanel, "Center");
        this.sessionOpts.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.sessionOpts.add((Component)this.scrollPane, "Center");
        this.sessionPanel.add((Component)this.sessionOpts, "North");
        this.sessionPanel.add((Component)this.sessionOptPanel, "South");
        this.addOptButton(LangTool.getString("ss.optAdd"), "ADD", this.sessionOptPanel);
        this.removeButton = this.addOptButton(LangTool.getString("ss.optDelete"), "REMOVE", this.sessionOptPanel, false);
        this.editButton = this.addOptButton(LangTool.getString("ss.optEdit"), "EDIT", this.sessionOptPanel, false);
    }

    private void createEmulatorOptionsPanel() {
        this.emulOptPanel.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.emulOptPanel.add((Component)jPanel, "North");
        this.interfacePanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(LangTool.getString("conf.labelPresentation"));
        titledBorder.setTitleJustification(2);
        this.interfacePanel.setBorder(titledBorder);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.hideTabBar = new JCheckBox(LangTool.getString("conf.labelHideTabBar"));
        this.hideTabBar.setSelected(false);
        if (this.props.containsKey("emul.hideTabBar") && this.props.getProperty("emul.hideTabBar").equals("yes")) {
            this.hideTabBar.setSelected(true);
        }
        this.hideTabBar.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ConnectDialog.this.hideTabBar_itemStateChanged(itemEvent);
            }
        });
        this.intTABS = new JRadioButton(LangTool.getString("conf.labelTABS"));
        this.intTABS.setSelected(true);
        this.intTABS.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
            }
        });
        buttonGroup.add(this.intTABS);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(10, 10, 5, 10);
        this.interfacePanel.add((Component)this.intTABS, this.gbc);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 27, 5, 10);
        this.interfacePanel.add((Component)this.hideTabBar, this.gbc);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new AlignLayout(1, 5, 5));
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(LangTool.getString("ss.labelStartup"));
        titledBorder2.setTitleJustification(2);
        jPanel2.setBorder(titledBorder2);
        this.showMe = new JCheckBox(LangTool.getString("ss.labelShowMe"));
        if (this.props.containsKey("emul.showConnectDialog")) {
            this.showMe.setSelected(true);
        }
        this.showMe.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ConnectDialog.this.showMe_itemStateChanged(itemEvent);
            }
        });
        this.lastView = new JCheckBox(LangTool.getString("ss.labelLastView"));
        if (this.props.containsKey("emul.startLastView")) {
            this.lastView.setSelected(true);
        }
        this.lastView.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ConnectDialog.this.lastView_itemStateChanged(itemEvent);
            }
        });
        jPanel2.add(this.showMe);
        jPanel2.add(this.lastView);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add(this.interfacePanel);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(jPanel2);
    }

    private void createLoggingPanel() {
        this.loggingPanel.setLayout(new GridBagLayout());
        this.levelPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(LangTool.getString("logscr.Level"));
        titledBorder.setTitleJustification(2);
        this.levelPanel.setBorder(titledBorder);
        int n = Integer.parseInt(this.props.getProperty("emul.logLevel", Integer.toString(2)));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.intOFF = new JRadioButton(LangTool.getString("logscr.Off"));
        this.intOFF.setSelected(true);
        this.intOFF.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ConnectDialog.this.intOFF_itemStateChanged(itemEvent);
            }
        });
        this.intDEBUG = new JRadioButton(LangTool.getString("logscr.Debug"));
        this.intDEBUG.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ConnectDialog.this.intDEBUG_itemStateChanged(itemEvent);
            }
        });
        this.intINFO = new JRadioButton(LangTool.getString("logscr.Info"));
        this.intINFO.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ConnectDialog.this.intINFO_itemStateChanged(itemEvent);
            }
        });
        this.intWARN = new JRadioButton(LangTool.getString("logscr.Warn"));
        this.intWARN.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ConnectDialog.this.intWARN_itemStateChanged(itemEvent);
            }
        });
        this.intERROR = new JRadioButton(LangTool.getString("logscr.Error"));
        this.intERROR.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ConnectDialog.this.intERROR_itemStateChanged(itemEvent);
            }
        });
        this.intFATAL = new JRadioButton(LangTool.getString("logscr.Fatal"));
        this.intFATAL.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ConnectDialog.this.intFATAL_itemStateChanged(itemEvent);
            }
        });
        buttonGroup.add(this.intOFF);
        buttonGroup.add(this.intDEBUG);
        buttonGroup.add(this.intINFO);
        buttonGroup.add(this.intWARN);
        buttonGroup.add(this.intERROR);
        buttonGroup.add(this.intFATAL);
        this.gbc = new GridBagConstraints();
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(20, 20, 5, 20);
        this.levelPanel.add((Component)this.intOFF, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 20, 5, 20);
        this.levelPanel.add((Component)this.intDEBUG, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 20, 5, 20);
        this.levelPanel.add((Component)this.intINFO, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 20, 5, 20);
        this.levelPanel.add((Component)this.intWARN, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 4;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 20, 5, 20);
        this.levelPanel.add((Component)this.intERROR, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 5;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 20, 20, 20);
        this.levelPanel.add((Component)this.intFATAL, this.gbc);
        this.appenderPanel = new JPanel(new GridBagLayout());
        titledBorder = BorderFactory.createTitledBorder(LangTool.getString("logscr.Appender"));
        titledBorder.setTitleJustification(2);
        this.appenderPanel.setBorder(titledBorder);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.intConsole = new JRadioButton(LangTool.getString("logscr.Console"));
        this.intConsole.setSelected(true);
        this.intConsole.setEnabled(false);
        this.intConsole.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ConnectDialog.this.intConsole_itemStateChanged(itemEvent);
            }
        });
        this.intFile = new JRadioButton(LangTool.getString("logscr.File"));
        this.intFile.setEnabled(false);
        this.intBoth = new JRadioButton(LangTool.getString("logscr.Both"));
        this.intBoth.setEnabled(false);
        buttonGroup2.add(this.intConsole);
        buttonGroup2.add(this.intFile);
        buttonGroup2.add(this.intBoth);
        switch (n) {
            case 32: {
                this.intOFF.setSelected(true);
                break;
            }
            case 1: {
                this.intDEBUG.setSelected(true);
                break;
            }
            case 2: {
                this.intINFO.setSelected(true);
                break;
            }
            case 4: {
                this.intWARN.setSelected(true);
                break;
            }
            case 8: {
                this.intERROR.setSelected(true);
                break;
            }
            case 16: {
                this.intFATAL.setSelected(true);
                break;
            }
            default: {
                this.intINFO.setSelected(true);
            }
        }
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(20, 20, 5, 20);
        this.appenderPanel.add((Component)this.intConsole, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 20, 5, 20);
        this.appenderPanel.add((Component)this.intFile, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(5, 20, 20, 20);
        this.appenderPanel.add((Component)this.intBoth, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(10, 10, 10, 20);
        this.loggingPanel.add((Component)this.levelPanel, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.anchor = 17;
        this.gbc.insets = new Insets(10, 20, 10, 10);
        this.loggingPanel.add((Component)this.appenderPanel, this.gbc);
    }

    private void createAccessPanel() {
        this.accessOptions = new TN5250jMultiSelectList();
        if (this.props.getProperty("emul.accessDigest") != null) {
            this.accessOptions.setEnabled(false);
        }
        Vector<String> vector = OptionAccessFactory.getInstance().getOptions();
        Hashtable hashtable = new Hashtable(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            hashtable.put(LangTool.getString("key." + (String)vector.get(i)), vector.get(i));
        }
        Vector<String> vector2 = OptionAccessFactory.getInstance().getOptionDescriptions();
        this.accessOptions.setListData(vector2.toArray());
        int n = OptionAccessFactory.getInstance().getNumberOfRestrictedOptions();
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < vector2.size(); ++i) {
            if (OptionAccessFactory.getInstance().isValidOption((String)hashtable.get(vector2.get(i)))) continue;
            nArray[n2++] = i;
        }
        this.accessOptions.setSelectedIndices(nArray);
        this.accessOptions.setSourceHeader(LangTool.getString("ss.labelActive"), 0);
        this.accessOptions.setSelectionHeader(LangTool.getString("ss.labelRestricted"), 0);
        this.accessPanel.setLayout(new BorderLayout());
        this.accessPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 5));
        this.accessPanel.add((Component)this.accessOptions, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        jPanel.setLayout(new FlowLayout(1, 10, 0));
        AbstractAction abstractAction = new AbstractAction(LangTool.getString("ss.labelSetPass")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ConnectDialog.this.password.getPassword().length > 0) {
                    try {
                        DESSHA1 dESSHA1 = new DESSHA1();
                        ConnectDialog.this.props.setProperty("emul.accessDigest", dESSHA1.digest(new String(ConnectDialog.this.password.getPassword()), "tn5205j"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        this.setPassButton = new JButton(abstractAction);
        if (this.props.getProperty("emul.accessDigest") != null) {
            this.setPassButton.setEnabled(false);
        }
        jPanel.add(this.setPassButton);
        this.password = new JPasswordField(15);
        this.password.setDocument(new CheckPasswordDocument());
        jPanel.add(this.password);
        this.accessPanel.add((Component)jPanel, "North");
    }

    private void createExternalProgramsPanel() {
        JPanel jPanel = new JPanel();
        this.externalPanel.setLayout(new BorderLayout());
        this.externalPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 5));
        jPanel.setLayout(new AlignLayout(3, 5, 5));
        jPanel.setBorder(BorderFactory.createTitledBorder(LangTool.getString("external.title")));
        jPanel.add(new JLabel(LangTool.getString("external.http")));
        this.browser = new JTextField(30);
        if (this.props.containsKey("emul.protocol.http")) {
            this.browser.setText(this.props.getProperty("emul.protocol.http"));
        }
        jPanel.add(this.browser);
        jPanel.add(new JButton("..."));
        jPanel.add(new JLabel(LangTool.getString("external.mailto")));
        this.mailer = new JTextField(30);
        if (this.props.containsKey("emul.protocol.mailto")) {
            this.mailer.setText(this.props.getProperty("emul.protocol.mailto"));
        }
        jPanel.add(this.mailer);
        jPanel.add(new JButton("..."));
        this.externalPanel.add((Component)jPanel, "North");
        this.etm = new CustomizedTableModel();
        this.externals = new JSortTable(this.etm);
        this.externals.setSelectionMode(0);
        this.externals.setPreferredScrollableViewportSize(new Dimension(500, 100));
        this.externals.setShowGrid(false);
        this.scrollPane2 = new JScrollPane(this.externals);
        this.scrollPane2.setVerticalScrollBarPolicy(20);
        this.scrollPane2.setHorizontalScrollBarPolicy(30);
        this.externals.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ConnectDialog.this.doActionConnect();
                }
            }
        });
        this.rowSM2 = this.externals.getSelectionModel();
        this.rowSM2.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    ConnectDialog.this.cEditButton.setEnabled(false);
                    ConnectDialog.this.cRemoveButton.setEnabled(false);
                    ConnectDialog.this.cAddButton.setEnabled(false);
                } else {
                    ConnectDialog.this.cEditButton.setEnabled(true);
                    ConnectDialog.this.cRemoveButton.setEnabled(true);
                    ConnectDialog.this.cAddButton.setEnabled(true);
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(LangTool.getString("customized.title")));
        this.externalOpts.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.externalOpts.add((Component)this.scrollPane2, "Center");
        jPanel2.add((Component)this.externalOpts, "North");
        jPanel2.add((Component)this.externalOptPanel, "South");
        this.cAddButton = this.addOptButton(LangTool.getString("ss.optAdd"), "cADD", this.externalOptPanel);
        this.cRemoveButton = this.addOptButton(LangTool.getString("ss.optDelete"), "cREMOVE", this.externalOptPanel, false);
        this.cEditButton = this.addOptButton(LangTool.getString("ss.optEdit"), "cEDIT", this.externalOptPanel, false);
        this.externalPanel.add((Component)jPanel2, "Center");
    }

    private void doSomethingEntered() {
        if (this.props.getProperty("emul.accessDigest") != null) {
            try {
                DESSHA1 dESSHA1 = new DESSHA1();
                if (this.props.getProperty("emul.accessDigest").equals(dESSHA1.digest(new String(this.password.getPassword()), "tn5205j"))) {
                    this.accessOptions.setEnabled(true);
                    this.setPassButton.setEnabled(true);
                }
            }
            catch (Exception exception) {
                LOG.warn(exception.getMessage(), exception);
            }
        }
    }

    private void doNothingEntered() {
    }

    private void createButtonOptions() {
        this.connectButton = this.addOptButton(LangTool.getString("ss.optConnect"), "CONNECT", this.options, false);
        this.applyButton = this.addOptButton(LangTool.getString("ss.optApply"), "APPLY", this.options, true);
        this.addOptButton(LangTool.getString("ss.optCancel"), "DONE", this.options);
    }

    private void createAboutPanel() {
        this.aboutPanel = new JPanel();
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("About");
        titledBorder.setTitleJustification(2);
        jPanel.add(new JLabel("TN5250j"));
        jPanel.add(new JLabel("Version: 0.7.7-Snapshot"));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.aboutPanel.add(jPanel);
        this.aboutPanel.setBorder(titledBorder);
    }

    private JButton addOptButton(String string, String string2, Container container) {
        return this.addOptButton(string, string2, container, true);
    }

    private JButton addOptButton(String string, String string2, Container container, boolean bl) {
        JButton jButton = new JButton(string);
        jButton.setEnabled(bl);
        jButton.setActionCommand(string2);
        jButton.setPreferredSize(new Dimension(140, 28));
        int n = string.indexOf("&");
        if (n >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.deleteCharAt(n);
            jButton.setText(stringBuffer.toString());
            jButton.setMnemonic(string.charAt(n + 1));
        }
        jButton.addActionListener(this);
        jButton.setAlignmentX(0.5f);
        container.add(jButton);
        return jButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        int n2;
        String string;
        if (actionEvent.getActionCommand().equals("DONE")) {
            this.saveProps();
            this.setVisible(false);
        }
        if (actionEvent.getActionCommand().equals("ADD")) {
            string = Configure.doEntry((JFrame)this.getParent(), null, this.props);
            this.ctm.addSession();
            if (this.ctm.getRowCount() == 1) {
                this.sessions.getSelectionModel().setSelectionInterval(0, 0);
            } else {
                n2 = 0;
                for (n = 0; n < this.sessions.getRowCount(); ++n) {
                    if (!((String)this.ctm.getValueAt(n, 0)).equals(string)) continue;
                    n2 = n;
                }
                this.sessions.getSelectionModel().setSelectionInterval(n2, n2);
            }
            this.sessions.requestFocus();
        }
        if (actionEvent.getActionCommand().equals("REMOVE")) {
            this.removeEntry();
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
        if (actionEvent.getActionCommand().equals("EDIT")) {
            int n3 = this.rowSM.getMinSelectionIndex();
            Configure.doEntry((JFrame)this.getParent(), (String)this.ctm.getValueAt(n3, 0), this.props);
            this.ctm.chgSession(n3);
            this.sessions.requestFocus();
        }
        if (actionEvent.getActionCommand().equals("cADD")) {
            string = ExternalProgramConfig.doEntry((JFrame)this.getParent(), null, this.etnProps);
            this.etm.addSession();
            if (this.etm.getRowCount() == 1) {
                this.externals.getSelectionModel().setSelectionInterval(0, 0);
            } else {
                n2 = 0;
                for (n = 0; n < this.externals.getRowCount(); ++n) {
                    if (!((String)this.etm.getValueAt(n, 0)).equals(string)) continue;
                    n2 = n;
                }
                this.externals.getSelectionModel().setSelectionInterval(n2, n2);
            }
            this.externals.requestFocus();
        }
        if (actionEvent.getActionCommand().equals("cEDIT")) {
            int n4 = this.rowSM2.getMinSelectionIndex();
            ExternalProgramConfig.doEntry((JFrame)this.getParent(), (String)this.etm.getValueAt(n4, 0), this.etnProps);
            this.etm.chgSession(n4);
            this.externals.requestFocus();
        }
        if (actionEvent.getActionCommand().equals("cREMOVE")) {
            this.removeExternalProgram();
            this.cEditButton.setEnabled(false);
            this.cRemoveButton.setEnabled(false);
        }
        if (actionEvent.getActionCommand().equals("CONNECT")) {
            this.doActionConnect();
        }
        if (actionEvent.getActionCommand().equals("APPLY")) {
            this.saveProps();
        }
    }

    private void doActionConnect() {
        if (!this.connectButton.isEnabled()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        int n = this.rowSM.getMinSelectionIndex();
        this.connectKey = (String)this.ctm.getValueAt(n, 0);
        this.saveProps();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.dispose();
    }

    public String getConnectKey() {
        return this.connectKey;
    }

    private void saveProps() {
        if (this.connectKey != null) {
            this.saveSelectedSessionPreference(this.connectKey);
        }
        this.setOptionAccess();
        this.setExternalPrograms();
        this.setLogLevel();
        ConfigureFactory.getInstance().saveSettings("sessions", "------ Session Information --------");
        ConfigureFactory.getInstance().saveSettings("etnPgmProps", "tn5250jExternalProgram.properties", "External Program Settings");
        OptionAccessFactory.getInstance().reload();
    }

    private void saveSelectedSessionPreference(String string) {
        Preferences preferences = Preferences.userNodeForPackage(SessionsDataModel.class);
        preferences.put(USER_PREF_LAST_SESSION, string);
    }

    private String loadSelectedSessionPreference() {
        Preferences preferences = Preferences.userNodeForPackage(SessionsDataModel.class);
        return preferences.get(USER_PREF_LAST_SESSION, null);
    }

    private void setExternalPrograms() {
        if (this.browser.getText().trim().length() > 0) {
            this.props.setProperty("emul.protocol.http", this.browser.getText().trim());
        } else {
            this.props.remove("emul.protocol.http");
        }
        if (this.mailer.getText().trim().length() > 0) {
            this.props.setProperty("emul.protocol.mailto", this.mailer.getText().trim());
        } else {
            this.props.remove("emul.protocol.mailto");
        }
    }

    private void setLogLevel() {
        if (this.intOFF.isSelected()) {
            this.props.setProperty("emul.logLevel", Integer.toString(32));
        }
        if (this.intDEBUG.isSelected()) {
            this.props.setProperty("emul.logLevel", Integer.toString(1));
        }
        if (this.intINFO.isSelected()) {
            this.props.setProperty("emul.logLevel", Integer.toString(2));
        }
        if (this.intWARN.isSelected()) {
            this.props.setProperty("emul.logLevel", Integer.toString(4));
        }
        if (this.intERROR.isSelected()) {
            this.props.setProperty("emul.logLevel", Integer.toString(8));
        }
        if (this.intFATAL.isSelected()) {
            this.props.setProperty("emul.logLevel", Integer.toString(16));
        }
    }

    private void setOptionAccess() {
        Vector<String> vector = OptionAccessFactory.getInstance().getOptions();
        Hashtable hashtable = new Hashtable(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            hashtable.put(LangTool.getString("key." + (String)vector.get(i)), vector.get(i));
        }
        Object[] objectArray = this.accessOptions.getSelectedValues();
        String string = "";
        for (int i = 0; i < objectArray.length; ++i) {
            string = string + (String)hashtable.get(objectArray[i]) + ";";
        }
        this.props.setProperty("emul.restricted", string);
    }

    private void removeEntry() {
        int n = this.rowSM.getMinSelectionIndex();
        this.props.remove(this.ctm.getValueAt(n, 0));
        this.ctm.removeSession(n);
    }

    private void removeExternalProgram() {
        int n;
        String string;
        int n2 = this.rowSM2.getMinSelectionIndex();
        String string2 = (String)this.etm.getValueAt(n2, 0);
        int n3 = 0;
        Object object = this.etnProps.keys();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            if (this.etnProps.getProperty(string) != string2) continue;
            String string3 = string.substring(8);
            n = string3.indexOf(".");
            n3 = Integer.parseInt(string3.substring(0, n));
            break;
        }
        object = new Properties();
        string = this.etnProps.getProperty("etn.pgm.support.total.num");
        if (string != null && string.length() > 0) {
            int n4 = Integer.parseInt(string);
            for (n = 1; n <= n4; ++n) {
                int n5 = n;
                if (n > n3) {
                    n5 = n - 1;
                }
                if (n == n3) continue;
                String string4 = this.etnProps.getProperty("etn.pgm." + n + ".command.name");
                String string5 = this.etnProps.getProperty("etn.pgm." + n + ".command.window");
                String string6 = this.etnProps.getProperty("etn.pgm." + n + ".command.unix");
                ((Properties)object).setProperty("etn.pgm." + n5 + ".command.name", string4);
                ((Properties)object).setProperty("etn.pgm." + n5 + ".command.window", string5);
                ((Properties)object).setProperty("etn.pgm." + n5 + ".command.unix", string6);
            }
            ((Properties)object).setProperty("etn.pgm.support.total.num", String.valueOf(n4 - 1));
        }
        this.etnProps.clear();
        this.etnProps.putAll((Map<?, ?>)object);
        this.etm.removeSession(n2);
    }

    void hideTabBar_itemStateChanged(ItemEvent itemEvent) {
        if (this.hideTabBar.isSelected()) {
            this.props.setProperty("emul.hideTabBar", "yes");
        } else {
            this.props.remove("emul.hideTabBar");
        }
    }

    void showMe_itemStateChanged(ItemEvent itemEvent) {
        if (this.showMe.isSelected()) {
            this.props.setProperty("emul.showConnectDialog", "");
        } else {
            this.props.remove("emul.showConnectDialog");
        }
    }

    void lastView_itemStateChanged(ItemEvent itemEvent) {
        if (this.lastView.isSelected()) {
            this.props.setProperty("emul.startLastView", "");
        } else {
            this.props.remove("emul.startLastView");
        }
    }

    private void intOFF_itemStateChanged(ItemEvent itemEvent) {
        if (!this.intOFF.isSelected() && TN5250jLogFactory.isLog4j()) {
            this.intConsole.setEnabled(true);
            this.intFile.setEnabled(true);
            this.intBoth.setEnabled(true);
        } else {
            this.intConsole.setEnabled(false);
            this.intConsole.setSelected(true);
            this.intFile.setEnabled(false);
            this.intBoth.setEnabled(false);
            TN5250jLogFactory.setLogLevels(32);
        }
    }

    private void intDEBUG_itemStateChanged(ItemEvent itemEvent) {
        if (this.intDEBUG.isSelected()) {
            TN5250jLogFactory.setLogLevels(1);
        }
    }

    private void intINFO_itemStateChanged(ItemEvent itemEvent) {
        if (this.intINFO.isSelected()) {
            TN5250jLogFactory.setLogLevels(2);
        }
    }

    private void intWARN_itemStateChanged(ItemEvent itemEvent) {
        if (this.intWARN.isSelected()) {
            TN5250jLogFactory.setLogLevels(4);
        }
    }

    private void intERROR_itemStateChanged(ItemEvent itemEvent) {
        if (this.intERROR.isSelected()) {
            TN5250jLogFactory.setLogLevels(8);
        }
    }

    private void intFATAL_itemStateChanged(ItemEvent itemEvent) {
        if (this.intFATAL.isSelected()) {
            TN5250jLogFactory.setLogLevels(16);
        }
    }

    private void intConsole_itemStateChanged(ItemEvent itemEvent) {
    }

    public class SessionComparator
    implements Comparator<Object> {
        private boolean ascending;

        public SessionComparator(boolean bl) {
            this.ascending = bl;
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof String && object2 instanceof String) {
                String string = object.toString();
                String string2 = object2.toString();
                int n = 0;
                n = this.ascending ? string.compareTo(string2) : string2.compareTo(string);
                if (n < 0) {
                    return -1;
                }
                if (n > 0) {
                    return 1;
                }
                return 0;
            }
            if (object instanceof Boolean && object2 instanceof Boolean) {
                boolean bl = (Boolean)object;
                boolean bl2 = (Boolean)object2;
                if (this.ascending) {
                    if (bl == bl2) {
                        return 0;
                    }
                    if (bl) {
                        return 1;
                    }
                    return -1;
                }
                if (bl == bl2) {
                    return 0;
                }
                if (bl2) {
                    return 1;
                }
                return -1;
            }
            if (object instanceof Comparable && object2 instanceof Comparable) {
                Comparable comparable = (Comparable)object;
                Comparable comparable2 = (Comparable)object2;
                if (this.ascending) {
                    return comparable.compareTo(object2);
                }
                return comparable2.compareTo(comparable);
            }
            return 1;
        }
    }

    private class CustomizedTableModel
    extends AbstractTableModel
    implements SortTableModel {
        private static final long serialVersionUID = 1L;
        final String[] cols = new String[]{LangTool.getString("customized.name"), LangTool.getString("customized.window"), LangTool.getString("customized.unix")};
        List<CustomizedExternalProgram> mySort = new ArrayList<CustomizedExternalProgram>();
        int sortedColumn = 0;
        boolean isAscending = true;

        public CustomizedTableModel() {
            this.resetSorted();
        }

        private void resetSorted() {
            this.mySort.clear();
            String string = ConnectDialog.this.etnProps.getProperty("etn.pgm.support.total.num");
            if (string != null && string.length() > 0) {
                int n = Integer.parseInt(string);
                for (int i = 1; i <= n; ++i) {
                    String string2 = ConnectDialog.this.etnProps.getProperty("etn.pgm." + i + ".command.name");
                    String string3 = ConnectDialog.this.etnProps.getProperty("etn.pgm." + i + ".command.window");
                    String string4 = ConnectDialog.this.etnProps.getProperty("etn.pgm." + i + ".command.unix");
                    this.mySort.add(new CustomizedExternalProgram(string2, string3, string4));
                }
            }
            this.sortColumn(this.sortedColumn, this.isAscending);
        }

        @Override
        public boolean isSortable(int n) {
            return n == 0;
        }

        @Override
        public void sortColumn(int n, boolean bl) {
            this.sortedColumn = n;
            this.isAscending = bl;
            Collections.sort(this.mySort, new SessionComparator(bl));
        }

        @Override
        public int getColumnCount() {
            return this.cols.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.cols[n];
        }

        @Override
        public int getRowCount() {
            return this.mySort.size();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CustomizedExternalProgram customizedExternalProgram = this.mySort.get(n);
            if (n2 == 0) {
                return customizedExternalProgram.getName();
            }
            if (n2 == 1) {
                return customizedExternalProgram.getWCommand();
            }
            if (n2 == 2) {
                return customizedExternalProgram.getUCommand();
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public void addSession() {
            this.resetSorted();
            this.fireTableRowsInserted(this.mySort.size() - 1, this.mySort.size() - 1);
        }

        public void chgSession(int n) {
            this.resetSorted();
            this.fireTableRowsUpdated(n, n);
        }

        public void removeSession(int n) {
            this.resetSorted();
            this.fireTableRowsDeleted(n, n);
        }
    }

    class CustomizedExternalProgram {
        private String name;
        private String wCommand;
        private String uCommand;

        CustomizedExternalProgram(String string, String string2, String string3) {
            this.name = string;
            this.wCommand = string2;
            this.uCommand = string3;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof CustomizedExternalProgram)) {
                return false;
            }
            CustomizedExternalProgram customizedExternalProgram = (CustomizedExternalProgram)object;
            return this.hashCode() == customizedExternalProgram.hashCode();
        }

        public String getName() {
            return this.name;
        }

        public String getUCommand() {
            return this.uCommand;
        }

        public String getWCommand() {
            return this.wCommand;
        }
    }

    private class SessionsTableModel
    extends AbstractTableModel
    implements SortTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] COLS = new String[]{LangTool.getString("conf.tableColA"), LangTool.getString("conf.tableColB"), LangTool.getString("conf.tableColC")};
        private List<SessionsDataModel> sortedItems = new ArrayList<SessionsDataModel>();

        public SessionsTableModel() {
            this.resetSorted();
        }

        private void resetSorted() {
            Enumeration<Object> enumeration = ConnectDialog.this.props.keys();
            this.sortedItems.clear();
            String string = null;
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (string.startsWith("emul.")) continue;
                String[] stringArray = new String[20];
                Configure.parseArgs(ConnectDialog.this.props.getProperty(string), stringArray);
                Boolean bl = new Boolean(string.equals(ConnectDialog.this.props.getProperty("emul.default", "")));
                this.sortedItems.add(new SessionsDataModel(string, stringArray[0], bl));
            }
            this.sortColumn(0, true);
        }

        @Override
        public boolean isSortable(int n) {
            if (n == 0) {
                return true;
            }
            return n == 1;
        }

        @Override
        public void sortColumn(int n, final boolean bl) {
            if (n == 0) {
                Collections.sort(this.sortedItems, new Comparator<SessionsDataModel>(){

                    @Override
                    public int compare(SessionsDataModel sessionsDataModel, SessionsDataModel sessionsDataModel2) {
                        if (bl) {
                            return sessionsDataModel.name.compareToIgnoreCase(sessionsDataModel2.name);
                        }
                        return sessionsDataModel2.name.compareToIgnoreCase(sessionsDataModel.name);
                    }
                });
            }
            if (n == 1) {
                Collections.sort(this.sortedItems, new Comparator<SessionsDataModel>(){

                    @Override
                    public int compare(SessionsDataModel sessionsDataModel, SessionsDataModel sessionsDataModel2) {
                        if (bl) {
                            return sessionsDataModel.host.compareToIgnoreCase(sessionsDataModel2.host);
                        }
                        return sessionsDataModel2.host.compareToIgnoreCase(sessionsDataModel.host);
                    }
                });
            }
        }

        @Override
        public int getColumnCount() {
            return this.COLS.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.COLS[n];
        }

        @Override
        public int getRowCount() {
            return this.sortedItems.size();
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            boolean bl = (Boolean)object;
            String string = this.sortedItems.get(n).name;
            if (bl) {
                ConnectDialog.this.props.setProperty("emul.default", string);
            } else {
                ConnectDialog.this.props.setProperty("emul.default", "");
            }
            int n3 = this.sortedItems.size();
            for (int i = 0; i < n3; ++i) {
                SessionsDataModel sessionsDataModel = this.sortedItems.get(i);
                if (string.equals(sessionsDataModel.name)) {
                    this.sortedItems.set(i, new SessionsDataModel(sessionsDataModel.name, sessionsDataModel.host, (Boolean)object));
                    continue;
                }
                if (!sessionsDataModel.deflt.booleanValue()) continue;
                this.sortedItems.set(i, new SessionsDataModel(sessionsDataModel.name, sessionsDataModel.host, Boolean.FALSE));
            }
            this.fireTableDataChanged();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.sortedItems.get(n).name;
                }
                case 1: {
                    return this.sortedItems.get(n).host;
                }
                case 2: {
                    return this.sortedItems.get(n).deflt;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 2;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public void addSession() {
            this.resetSorted();
            this.fireTableRowsInserted(ConnectDialog.this.props.size() - 1, ConnectDialog.this.props.size() - 1);
        }

        public void chgSession(int n) {
            this.resetSorted();
            this.fireTableRowsUpdated(n, n);
        }

        public void removeSession(int n) {
            this.resetSorted();
            this.fireTableRowsDeleted(n, n);
        }
    }

    private static final class SessionsDataModel {
        private final String name;
        private final String host;
        private final Boolean deflt;

        public SessionsDataModel(String string, String string2, Boolean bl) {
            this.name = string;
            this.host = string2;
            this.deflt = bl;
        }
    }

    private class CheckPasswordDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        private CheckPasswordDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(n, string, attributeSet);
            if (this.getText(0, this.getLength()).length() > 0) {
                ConnectDialog.this.doSomethingEntered();
            }
        }

        @Override
        public void remove(int n, int n2) throws BadLocationException {
            super.remove(n, n2);
            if (this.getText(0, this.getLength()).length() == 0) {
                ConnectDialog.this.doNothingEntered();
            }
        }
    }
}

