/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.tools.AlignLayout;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class ExternalProgramConfig {
    private static TN5250jLogger log = TN5250jLogFactory.getLogger("org.tn5250j.ExternalProgramConfig");
    private static ExternalProgramConfig etnConfig;
    public static final String EXTERNAL_PROGRAM_REGISTRY_KEY = "etnPgmProps";
    public static final String EXTERNAL_PROGRAM_PROPERTIES_FILE_NAME = "tn5250jExternalProgram.properties";
    public static final String EXTERNAL_PROGRAM_HEADER = "External Program Settings";
    private Properties etnPgmProps = this.loadExternalProgramSettings();
    private static Properties props;
    private static JTextField name;
    private static JTextField wCommand;
    private static JTextField uCommand;
    private static JDialog dialog;
    private static Object[] options;
    private static String num;

    public static ExternalProgramConfig getInstance() {
        if (etnConfig == null) {
            etnConfig = new ExternalProgramConfig();
        }
        return etnConfig;
    }

    private ExternalProgramConfig() {
    }

    public Properties getEtnPgmProps() {
        return this.etnPgmProps;
    }

    private final Properties loadExternalProgramSettings() {
        Properties properties = null;
        try {
            properties = ConfigureFactory.getInstance().getProperties(EXTERNAL_PROGRAM_REGISTRY_KEY, EXTERNAL_PROGRAM_PROPERTIES_FILE_NAME, false, "Default Settings");
            log.info("begin loading external program settings");
            if (properties.size() == 0) {
                Properties properties2 = new Properties();
                URL uRL = null;
                ClassLoader classLoader = this.getClass().getClassLoader();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                uRL = classLoader.getResource(EXTERNAL_PROGRAM_PROPERTIES_FILE_NAME);
                properties2.load(uRL.openStream());
                Enumeration<Object> enumeration = properties2.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    properties.setProperty(string, properties2.getProperty(string));
                }
                ConfigureFactory.getInstance().saveSettings(EXTERNAL_PROGRAM_REGISTRY_KEY, EXTERNAL_PROGRAM_PROPERTIES_FILE_NAME, EXTERNAL_PROGRAM_HEADER);
            }
        }
        catch (IOException iOException) {
            log.error(iOException.getMessage());
        }
        catch (SecurityException securityException) {
            log.error(securityException.getMessage());
        }
        return properties;
    }

    public static String doEntry(Frame frame, String string, Properties properties) {
        String string2;
        AbstractAction abstractAction;
        Object[] objectArray;
        Object object;
        Object object2;
        props = properties;
        name = new JTextField(20);
        wCommand = new JTextField(40);
        uCommand = new JTextField(40);
        if (string != null) {
            object2 = props.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                if (props.getProperty((String)object) != string) continue;
                objectArray = ((String)object).substring(8);
                int n = objectArray.indexOf(".");
                num = objectArray.substring(0, n);
                name.setText(props.getProperty("etn.pgm." + num + ".command.name"));
                wCommand.setText(props.getProperty("etn.pgm." + num + ".command.window"));
                uCommand.setText(props.getProperty("etn.pgm." + num + ".command.unix"));
            }
        }
        object2 = new JPanel();
        object = new AlignLayout(2, 5, 5);
        ((Container)object2).setLayout((LayoutManager)object);
        ((JComponent)object2).setBorder(BorderFactory.createEtchedBorder());
        ExternalProgramConfig.addLabelComponent(LangTool.getString("customized.name"), name, (Container)object2);
        ExternalProgramConfig.addLabelComponent(LangTool.getString("customized.window"), wCommand, (Container)object2);
        ExternalProgramConfig.addLabelComponent(LangTool.getString("customized.unix"), uCommand, (Container)object2);
        name.setAlignmentX(0.5f);
        objectArray = new Object[]{object2};
        options = new JButton[2];
        final String string3 = string;
        if (string3 == null) {
            abstractAction = new AbstractAction(LangTool.getString("conf.optAdd")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExternalProgramConfig.doConfigureAction(string3);
                }
            };
            ExternalProgramConfig.options[0] = new JButton(abstractAction);
            ((JButton)options[0]).setEnabled(false);
            string2 = LangTool.getString("customized.addEntryTitle");
            name.setDocument(new SomethingEnteredDocument());
        } else {
            abstractAction = new AbstractAction(LangTool.getString("conf.optEdit")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExternalProgramConfig.doConfigureAction(string3);
                }
            };
            ExternalProgramConfig.options[0] = new JButton(abstractAction);
            string2 = LangTool.getString("customized.editEntryTitle");
            name.setEditable(false);
        }
        abstractAction = new AbstractAction(LangTool.getString("conf.optCancel")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                dialog.dispose();
            }
        };
        ExternalProgramConfig.options[1] = new JButton(abstractAction);
        JOptionPane jOptionPane = new JOptionPane(objectArray, -1, -1, null, options, options[0]);
        Frame frame2 = frame;
        jOptionPane.setInitialValue(options[0]);
        jOptionPane.setComponentOrientation(frame2.getComponentOrientation());
        dialog = jOptionPane.createDialog(frame2, string2);
        dialog.setVisible(true);
        return name.getText();
    }

    private static void addLabelComponent(String string, Component component, Container container) {
        JLabel jLabel = new JLabel(string);
        jLabel.setAlignmentX(0.0f);
        jLabel.setHorizontalTextPosition(2);
        container.add(jLabel);
        container.add(component);
    }

    private static void doConfigureAction(String string) {
        if (string == null) {
            String string2 = props.getProperty("etn.pgm.support.total.num");
            int n = Integer.parseInt(string2) + 1;
            props.setProperty("etn.pgm.support.total.num", String.valueOf(n));
            props.setProperty("etn.pgm." + n + ".command.name", name.getText());
            props.setProperty("etn.pgm." + n + ".command.window", wCommand.getText());
            props.setProperty("etn.pgm." + n + ".command.unix", uCommand.getText());
        } else {
            props.setProperty("etn.pgm." + num + ".command.name", name.getText());
            props.setProperty("etn.pgm." + num + ".command.window", wCommand.getText());
            props.setProperty("etn.pgm." + num + ".command.unix", uCommand.getText());
        }
        dialog.dispose();
    }

    private static void doSomethingEntered() {
        ((JButton)options[0]).setEnabled(true);
    }

    private static void doNothingEntered() {
        ((JButton)options[0]).setEnabled(false);
    }

    static {
        props = null;
        name = null;
        wCommand = null;
        uCommand = null;
        dialog = null;
        num = "1";
    }

    private static class SomethingEnteredDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        private SomethingEnteredDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(n, string, attributeSet);
            if (this.getText(0, this.getLength()).length() > 0) {
                ExternalProgramConfig.doSomethingEntered();
            }
        }

        @Override
        public void remove(int n, int n2) throws BadLocationException {
            super.remove(n, n2);
            if (this.getText(0, this.getLength()).length() == 0) {
                ExternalProgramConfig.doNothingEntered();
            }
        }
    }
}

