/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class GlobalConfigure
extends ConfigureFactory {
    public static final String TN5250J_FOLDER = ".tn5250j";
    private static GlobalConfigure _instance;
    private static Properties settings;
    private static Hashtable registry;
    private static Hashtable headers;
    public static final File ses;
    private static final String settingsFile = "tn5250jstartup.cfg";
    private final TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public GlobalConfigure() {
        if (_instance == null) {
            this.initialize();
            _instance = this;
        }
    }

    public static GlobalConfigure instance() {
        if (_instance == null) {
            _instance = new GlobalConfigure();
        }
        return _instance;
    }

    private void initialize() {
        this.verifiySettingsFolder();
        this.loadSettings();
        this.loadSessions();
        this.loadMacros();
        this.loadKeyStrokes();
    }

    private void verifiySettingsFolder() {
        block4: {
            String string = System.getProperty("user.home") + File.separator + TN5250J_FOLDER;
            File file = new File(string);
            if (!file.exists()) {
                try {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Settings folder '" + string + "' doesn't exist. Will created now.");
                    }
                    file.mkdir();
                }
                catch (Exception exception) {
                    if (!this.log.isWarnEnabled()) break block4;
                    this.log.warn("Couldn't create settings folder '" + string + "'", exception);
                }
            }
        }
    }

    private void loadSessions() {
        this.setProperties("sessions", "sessions", "------ Sessions --------", true);
    }

    private void loadMacros() {
        this.setProperties("macros", "macros", "------ Macros --------", true);
    }

    private void loadKeyStrokes() {
        this.setProperties("keymap", "keymap", "------ Key Map key=keycode,isShiftDown,isControlDown,isAltDown,isAltGrDown --------", true);
    }

    @Override
    public void reloadSettings() {
        if (this.log.isInfoEnabled()) {
            this.log.info("reloading settings");
        }
        this.loadSettings();
        this.loadSessions();
        this.loadMacros();
        this.loadKeyStrokes();
        if (this.log.isInfoEnabled()) {
            this.log.info("Done (reloading settings).");
        }
    }

    private void loadSettings() {
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        settings = new Properties();
        if (System.getProperties().containsKey("emulator.settingsDirectory")) {
            settings.setProperty("emulator.settingsDirectory", System.getProperty("emulator.settingsDirectory") + File.separator);
            this.checkDirs();
        } else {
            settings.setProperty("emulator.settingsDirectory", System.getProperty("user.home") + File.separator + TN5250J_FOLDER + File.separator);
            try {
                fileInputStream = new FileInputStream(settingsFile);
                settings.load(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    fileInputStream2 = new FileInputStream(this.settingsDirectory() + settingsFile);
                    settings.load(fileInputStream2);
                }
                catch (FileNotFoundException fileNotFoundException2) {
                    this.log.info(" Information Message: " + fileNotFoundException2.getMessage() + ".  The file " + settingsFile + " will be created for first time use.");
                    this.checkLegacy();
                    this.saveSettings();
                }
                catch (IOException iOException) {
                    this.log.warn("IO Exception accessing File tn5250jstartup.cfg for the following reason : " + iOException.getMessage());
                }
                catch (SecurityException securityException) {
                    this.log.warn("Security Exception for file tn5250jstartup.cfg  This file can not be accessed because : " + securityException.getMessage());
                }
            }
            catch (IOException iOException) {
                this.log.warn("IO Exception accessing File tn5250jstartup.cfg for the following reason : " + iOException.getMessage());
            }
            catch (SecurityException securityException) {
                this.log.warn("Security Exception for file tn5250jstartup.cfg  This file can not be accessed because : " + securityException.getMessage());
            }
        }
    }

    private void checkDirs() {
        File file = new File(settings.getProperty("emulator.settingsDirectory"));
        if (!file.isDirectory()) {
            file.mkdirs();
        }
    }

    private void checkLegacy() {
        if (ses.exists()) {
            int n = JOptionPane.showConfirmDialog(null, "Dear User,\n\nSeems you are using an old version of tn5250j.\nIn meanwhile the application became multi-user capable,\nwhich means ALL the config- and settings-files are\nplaced in your home-dir to avoid further problems in\nthe near future.\n\nYou have the choice to choose if you want the files\nto be copied or not, please make your choice !\n\nShall we copy the files to the new location ?", "Old install detected", 2, 0);
            if (n == 0) {
                this.checkDirs();
                this.copyConfigs("sessions");
                this.copyConfigs("macros");
                this.copyConfigs("keymap");
            } else {
                JOptionPane.showMessageDialog(null, "Dear User,\n\nYou choosed not to copy the file.\nThis means the program will end here.\n\nTo use this NON-STANDARD behaviour start tn5250j\nwith -Demulator.settingsDirectory=<settings-dir> \nas a parameter to avoid this question all the time.", "Using NON-STANDARD behaviour", 2);
                System.exit(0);
            }
        }
    }

    private void copyConfigs(String string) {
        String string2 = System.getProperty("user.dir") + File.separator + string;
        String string3 = System.getProperty("user.home") + File.separator + TN5250J_FOLDER + File.separator + string;
        File file = new File(string);
        try {
            FileReader fileReader = new FileReader(string2);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            FileWriter fileWriter = new FileWriter(string3);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            String string4 = bufferedReader.readLine();
            while (string4 != null) {
                printWriter.println(string4);
                string4 = bufferedReader.readLine();
            }
            bufferedReader.close();
            printWriter.close();
            file.delete();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log.warn(string2 + " not found !");
        }
        catch (IOException iOException) {
            this.log.warn("Global io-error !");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public void saveSettings() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.settingsDirectory() + settingsFile);
            settings.store(fileOutputStream, "----------------- tn5250j Global Settings --------------");
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void saveSettings(String string) {
        this.saveSettings(string, "");
    }

    @Override
    public void saveSettings(String string, String string2) {
        this.saveSettings(string, string, string2);
    }

    @Override
    public void saveSettings(String string, String string2, String string3) {
        if (registry.containsKey(string)) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.settingsDirectory() + string2);
                Properties properties = (Properties)registry.get(string);
                properties.store(fileOutputStream, string3);
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.log.warn("File not found : writing file " + string2 + ".  Description of error is " + fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                this.log.warn("IO Exception : writing file " + string2 + ".  Description of error is " + iOException.getMessage());
            }
            catch (SecurityException securityException) {
                this.log.warn("Security Exception : writing file " + string2 + ".  Description of error is " + securityException.getMessage());
            }
        }
    }

    @Override
    public void setProperties(String string, Properties properties) {
        registry.put(string, properties);
    }

    @Override
    public void setProperties(String string, String string2, String string3) {
        this.setProperties(string, string2, string3, false);
    }

    @Override
    public void setProperties(String string, String string2, String string3, boolean bl) {
        FileInputStream fileInputStream = null;
        Properties properties = new Properties();
        headers.put(string, string3);
        try {
            fileInputStream = new FileInputStream(this.settingsDirectory() + string2);
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (bl) {
                this.log.info(" Information Message: " + fileNotFoundException.getMessage() + ".  The file " + string2 + " will" + " be created for first time use.");
                this.saveSettings(string, string3);
            } else {
                this.log.info(" Information Message: " + fileNotFoundException.getMessage() + ".");
            }
        }
        catch (IOException iOException) {
            this.log.warn("IO Exception accessing File " + string2 + " for the following reason : " + iOException.getMessage());
        }
        catch (SecurityException securityException) {
            this.log.warn("Security Exception for file " + string2 + ".  This file can not be accessed because : " + securityException.getMessage());
        }
        registry.put(string, properties);
    }

    @Override
    public Properties getProperties(String string) {
        if (registry.containsKey(string)) {
            return (Properties)registry.get(string);
        }
        return null;
    }

    public Properties getProperties() {
        return settings;
    }

    @Override
    public Properties getProperties(String string, String string2) {
        return this.getProperties(string, string2, false, "", false);
    }

    @Override
    public Properties getProperties(String string, String string2, boolean bl, String string3) {
        return this.getProperties(string, string2, false, "", false);
    }

    @Override
    public Properties getProperties(String string, String string2, boolean bl, String string3, boolean bl2) {
        if (!registry.containsKey(string) || bl2) {
            FileInputStream fileInputStream = null;
            Properties properties = new Properties();
            headers.put(string, string3);
            try {
                fileInputStream = new FileInputStream(this.settingsDirectory() + string2);
                properties.load(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (bl) {
                    this.log.info(" Information Message: " + fileNotFoundException.getMessage() + ".  The file " + string2 + " will" + " be created for first time use.");
                    registry.put(string, properties);
                    this.saveSettings(string, string3);
                    return properties;
                }
                this.log.info(" Information Message: " + fileNotFoundException.getMessage() + ".");
            }
            catch (IOException iOException) {
                this.log.warn("IO Exception accessing File " + string2 + " for the following reason : " + iOException.getMessage());
            }
            catch (SecurityException securityException) {
                this.log.warn("Security Exception for file " + string2 + ".  This file can not be accessed because : " + securityException.getMessage());
            }
            registry.put(string, properties);
            return properties;
        }
        return (Properties)registry.get(string);
    }

    @Override
    public String getProperty(String string, String string2) {
        if (settings.containsKey(string)) {
            return settings.getProperty(string);
        }
        return string2;
    }

    @Override
    public String getProperty(String string) {
        return settings.getProperty(string);
    }

    private String settingsDirectory() {
        return settings.getProperty("emulator.settingsDirectory");
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader = GlobalConfigure.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    static {
        registry = new Hashtable();
        headers = new Hashtable();
        ses = new File("sessions");
    }
}

