/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tn5250j.My5250;
import org.tn5250j.Session5250;
import org.tn5250j.SessionPanel;
import org.tn5250j.event.SessionChangeEvent;
import org.tn5250j.event.SessionJumpEvent;
import org.tn5250j.event.SessionJumpListener;
import org.tn5250j.event.SessionListener;
import org.tn5250j.event.TabClosedListener;
import org.tn5250j.gui.ButtonTabComponent;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.interfaces.GUIViewInterface;
import org.tn5250j.tools.GUIGraphicsUtils;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class Gui5250Frame
extends GUIViewInterface
implements ChangeListener,
TabClosedListener,
SessionListener,
SessionJumpListener {
    private static final long serialVersionUID = 1L;
    private JTabbedPane sessTabbedPane = new JTabbedPane();
    private boolean embedded = false;
    private boolean hideTabBar = false;
    private TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public Gui5250Frame(My5250 my5250) {
        super(my5250);
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            this.log.warn("Error during initializing!", exception);
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.frameSeq = sequence++;
        this.sessTabbedPane.setBorder(BorderFactory.createEtchedBorder());
        this.sessTabbedPane.setBounds(new Rectangle(78, 57, 5, 5));
        this.sessTabbedPane.setOpaque(true);
        this.sessTabbedPane.setRequestFocusEnabled(false);
        this.sessTabbedPane.setDoubleBuffered(false);
        this.sessTabbedPane.addChangeListener(this);
        Properties properties = ConfigureFactory.getInstance().getProperties("sessions");
        if (properties.getProperty("emul.hideTabBar", "no").equals("yes")) {
            this.hideTabBar = true;
        }
        if (!this.hideTabBar) {
            this.getContentPane().add((Component)this.sessTabbedPane, "Center");
        }
        if (this.packFrame) {
            this.pack();
        } else {
            this.validate();
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            SessionPanel sessionPanel;
            int n;
            int n2;
            int n3 = this.sessTabbedPane.getSelectedIndex();
            boolean bl = true;
            if (this.hideTabBar && this.sessTabbedPane.getTabCount() == 0) {
                n2 = this.getContentPane().getComponentCount();
                for (n = 0; n < n2; ++n) {
                    if (!(this.getContentPane().getComponent(n) instanceof SessionPanel)) continue;
                    sessionPanel = (SessionPanel)this.getContentPane().getComponent(n);
                    bl &= sessionPanel.confirmCloseSession(false);
                    break;
                }
            }
            n2 = this.sessTabbedPane.getTabCount();
            for (n = 0; n < n2 && bl; bl &= sessionPanel.confirmCloseSession(false), ++n) {
                this.sessTabbedPane.setSelectedIndex(n);
                this.updateSessionTitle();
                sessionPanel = (SessionPanel)this.sessTabbedPane.getSelectedComponent();
            }
            if (!bl) {
                this.sessTabbedPane.setSelectedIndex(n3);
                this.updateSessionTitle();
                return;
            }
            super.processWindowEvent(windowEvent);
            me.closingDown(this);
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void onSessionJump(SessionJumpEvent sessionJumpEvent) {
        switch (sessionJumpEvent.getJumpDirection()) {
            case 0: {
                this.prevSession();
                break;
            }
            case 1: {
                this.nextSession();
            }
        }
    }

    private void nextSession() {
        final int n = this.sessTabbedPane.getSelectedIndex();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n2 = n;
                if (n2 < Gui5250Frame.this.sessTabbedPane.getTabCount() - 1) {
                    Gui5250Frame.this.sessTabbedPane.setSelectedIndex(++n2);
                } else {
                    Gui5250Frame.this.sessTabbedPane.setSelectedIndex(0);
                }
                Gui5250Frame.this.updateSessionTitle();
            }
        });
    }

    private void prevSession() {
        final int n = this.sessTabbedPane.getSelectedIndex();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n2 = n;
                if (n2 == 0) {
                    Gui5250Frame.this.sessTabbedPane.setSelectedIndex(Gui5250Frame.this.sessTabbedPane.getTabCount() - 1);
                } else {
                    Gui5250Frame.this.sessTabbedPane.setSelectedIndex(--n2);
                }
                Gui5250Frame.this.updateSessionTitle();
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        this.setSessionTitle((SessionPanel)jTabbedPane.getSelectedComponent());
    }

    private void setSessionTitle(SessionPanel sessionPanel) {
        if (sessionPanel != null && sessionPanel.isConnected()) {
            String string = this.determineTabName(sessionPanel);
            if (sequence - 1 > 0) {
                this.setTitle(string + " - tn5250j <" + sequence + ">");
            } else {
                this.setTitle(string + " - tn5250j");
            }
        } else if (sequence - 1 > 0) {
            this.setTitle("tn5250j <" + sequence + ">");
        } else {
            this.setTitle("tn5250j");
        }
    }

    private String determineTabName(SessionPanel sessionPanel) {
        assert (sessionPanel != null);
        String string = sessionPanel.getSession().isUseSystemName() ? sessionPanel.getSessionName() : (sessionPanel.getAllocDeviceName() != null ? sessionPanel.getAllocDeviceName() : sessionPanel.getHostName());
        return string;
    }

    private void updateSessionTitle() {
        SessionPanel sessionPanel = (SessionPanel)this.sessTabbedPane.getSelectedComponent();
        this.setSessionTitle(sessionPanel);
    }

    @Override
    public void addSessionView(String string, SessionPanel sessionPanel) {
        if (this.hideTabBar && this.sessTabbedPane.getTabCount() == 0 && !this.embedded) {
            this.getContentPane().add((Component)sessionPanel, "Center");
            sessionPanel.addSessionListener(this);
            sessionPanel.resizeMe();
            this.repaint();
            if (this.packFrame) {
                this.pack();
            } else {
                this.validate();
            }
            this.embedded = true;
            sessionPanel.requestFocusInWindow();
            this.setSessionTitle(sessionPanel);
        } else {
            if (this.hideTabBar && this.sessTabbedPane.getTabCount() == 0) {
                SessionPanel sessionPanel2 = null;
                for (int i = 0; i < this.getContentPane().getComponentCount(); ++i) {
                    if (!(this.getContentPane().getComponent(i) instanceof SessionPanel)) continue;
                    sessionPanel2 = (SessionPanel)this.getContentPane().getComponent(i);
                    this.getContentPane().remove(i);
                    break;
                }
                this.createTabWithSessionContent(string, sessionPanel2, false);
                this.sessTabbedPane.setTitleAt(0, this.determineTabName(sessionPanel2));
                this.getContentPane().add((Component)this.sessTabbedPane, "Center");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Gui5250Frame.this.repaint();
                    }
                });
            }
            this.createTabWithSessionContent(string, sessionPanel, true);
        }
    }

    private final void createTabWithSessionContent(String string, final SessionPanel sessionPanel, final boolean bl) {
        this.sessTabbedPane.addTab(string, Gui5250Frame.determineIconForSession(sessionPanel.session), sessionPanel);
        final int n = this.sessTabbedPane.indexOfComponent(sessionPanel);
        ButtonTabComponent buttonTabComponent = new ButtonTabComponent(this.sessTabbedPane);
        buttonTabComponent.addTabCloseListener(this);
        this.sessTabbedPane.setTabComponentAt(n, buttonTabComponent);
        sessionPanel.addSessionListener(this);
        sessionPanel.addSessionJumpListener(this);
        sessionPanel.addSessionListener(buttonTabComponent);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                sessionPanel.resizeMe();
                sessionPanel.repaint();
                if (bl) {
                    Gui5250Frame.this.sessTabbedPane.setSelectedIndex(n);
                    sessionPanel.requestFocusInWindow();
                }
            }
        });
    }

    @Override
    public void onTabClosed(int n) {
        SessionPanel sessionPanel = this.getSessionAt(n);
        sessionPanel.confirmCloseSession(true);
    }

    @Override
    public void removeSessionView(SessionPanel sessionPanel) {
        if (this.hideTabBar && this.sessTabbedPane.getTabCount() == 0) {
            for (int i = 0; i < this.getContentPane().getComponentCount(); ++i) {
                if (!(this.getContentPane().getComponent(i) instanceof SessionPanel)) continue;
                this.getContentPane().remove(i);
            }
        } else {
            int n = this.sessTabbedPane.indexOfComponent(sessionPanel);
            this.log.info("session found and closing down " + n);
            sessionPanel.removeSessionListener(this);
            sessionPanel.removeSessionJumpListener(this);
            this.sessTabbedPane.remove(n);
        }
    }

    @Override
    public int getSessionViewCount() {
        if (this.hideTabBar && this.sessTabbedPane.getTabCount() == 0) {
            for (int i = 0; i < this.getContentPane().getComponentCount(); ++i) {
                if (!(this.getContentPane().getComponent(i) instanceof SessionPanel)) continue;
                return 1;
            }
            return 0;
        }
        return this.sessTabbedPane.getTabCount();
    }

    @Override
    public SessionPanel getSessionAt(int n) {
        if (this.hideTabBar && this.sessTabbedPane.getTabCount() == 0) {
            for (int i = 0; i < this.getContentPane().getComponentCount(); ++i) {
                if (!(this.getContentPane().getComponent(i) instanceof SessionPanel)) continue;
                return (SessionPanel)this.getContentPane().getComponent(i);
            }
            return null;
        }
        if (this.sessTabbedPane.getTabCount() <= 0) {
            return null;
        }
        return (SessionPanel)this.sessTabbedPane.getComponentAt(n);
    }

    @Override
    public void onSessionChanged(SessionChangeEvent sessionChangeEvent) {
        Session5250 session5250 = (Session5250)sessionChangeEvent.getSource();
        final SessionPanel sessionPanel = session5250.getGUI();
        final int n = this.sessTabbedPane.indexOfComponent(sessionPanel);
        if (n >= 0 && n < this.sessTabbedPane.getTabCount()) {
            this.sessTabbedPane.setIconAt(n, Gui5250Frame.determineIconForSession(session5250));
        }
        switch (sessionChangeEvent.getState()) {
            case 1: {
                String string = sessionPanel.getAllocDeviceName();
                if (string == null) break;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("SessionChangedEvent: " + sessionChangeEvent.getState() + " " + string);
                }
                if (n >= 0 && n < this.sessTabbedPane.getTabCount()) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Gui5250Frame.this.sessTabbedPane.setTitleAt(n, Gui5250Frame.this.determineTabName(sessionPanel));
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
                this.updateSessionTitle();
            }
        }
    }

    private static final Icon determineIconForSession(Session5250 session5250) {
        if (session5250 != null && session5250.isSslConfigured()) {
            if (session5250.isSslSocket()) {
                return GUIGraphicsUtils.getClosedLockIcon();
            }
            return GUIGraphicsUtils.getOpenLockIcon();
        }
        return null;
    }

    @Override
    public boolean containsSession(SessionPanel sessionPanel) {
        if (this.hideTabBar && this.sessTabbedPane.getTabCount() == 0) {
            for (int i = 0; i < this.getContentPane().getComponentCount(); ++i) {
                if (!(this.getContentPane().getComponent(i) instanceof SessionPanel)) continue;
                return ((SessionPanel)this.getContentPane().getComponent(i)).equals(sessionPanel);
            }
            return false;
        }
        return this.sessTabbedPane.indexOfComponent(sessionPanel) >= 0;
    }
}

