/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.tn5250j.SessionConfig;
import org.tn5250j.SessionPanel;
import org.tn5250j.event.ScreenListener;
import org.tn5250j.event.ScreenOIAListener;
import org.tn5250j.event.SessionConfigEvent;
import org.tn5250j.event.SessionConfigListener;
import org.tn5250j.framework.tn5250.Screen5250;
import org.tn5250j.framework.tn5250.ScreenOIA;
import org.tn5250j.settings.ColumnSeparator;
import org.tn5250j.tools.GUIGraphicsUtils;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class GuiGraphicBuffer
implements ScreenOIAListener,
ScreenListener,
PropertyChangeListener,
SessionConfigListener,
ActionListener {
    private static final transient char[] dupChar = new char[]{'*'};
    private BufferedImage bi;
    private final Object lock = new Object();
    private Line2D separatorLine = new Line2D.Float();
    private Rectangle2D tArea;
    private Rectangle2D aArea;
    private Rectangle2D cArea;
    private Rectangle2D sArea;
    private Rectangle2D pArea;
    private Rectangle2D mArea;
    private Rectangle2D iArea;
    private Rectangle2D kbArea;
    private Rectangle2D scriptArea;
    private Rectangle2D cursor = new Rectangle2D.Float();
    private static final String xSystem = "X - System";
    private static final String xError = "X - II";
    private int crossRow;
    private Rectangle crossRect = new Rectangle();
    private int offTop = 0;
    private int offLeft = 0;
    private boolean antialiased = true;
    private Graphics2D gg2d;
    private Screen5250 screen;
    private Data updateRect;
    protected int columnWidth;
    protected int rowHeight;
    private SessionPanel gui;
    private LineMetrics lm;
    Font font;
    private int lenScreen;
    private boolean showHex;
    private Color colorBlue;
    private Color colorWhite;
    private Color colorRed;
    private Color colorGreen;
    private Color colorPink;
    private Color colorYellow;
    Color colorBg;
    private Color colorTurq;
    private Color colorGUIField;
    private Color colorCursor;
    private Color colorSep;
    private Color colorHexAttr;
    protected int crossHair = 0;
    private boolean updateFont;
    private int cursorSize = 0;
    protected boolean hotSpots = false;
    private float sfh = 1.2f;
    private float sfw = 1.0f;
    private float ps132 = 0.0f;
    private boolean cfg_guiInterface = false;
    private boolean cfg_guiShowUnderline = true;
    private int cursorBottOffset;
    private boolean rulerFixed;
    private Timer blinker;
    private ColumnSeparator colSepLine;
    private final StringBuffer hsMore = new StringBuffer("More...");
    private final StringBuffer hsBottom = new StringBuffer("Bottom");
    private Rectangle workR = new Rectangle();
    private boolean colSep = false;
    private boolean underLine = false;
    private boolean nonDisplay = false;
    private Color fg;
    private Color bg;
    private SessionConfig config;
    protected Rectangle clipper;
    private final TN5250jLogger log = TN5250jLogFactory.getLogger("GFX");

    public GuiGraphicBuffer(Screen5250 screen5250, SessionPanel sessionPanel, SessionConfig sessionConfig) {
        this.screen = screen5250;
        this.config = sessionConfig;
        this.gui = sessionPanel;
        sessionConfig.addSessionConfigListener(this);
        this.loadProps();
        String string = null;
        if (sessionConfig.isPropertyExists("font") && !GUIGraphicsUtils.isFontNameExists(string = this.getStringProperty("font"))) {
            string = null;
        }
        if (string == null) {
            this.font = new Font(GUIGraphicsUtils.getDefaultFont(), 0, 14);
            sessionConfig.setProperty("font", this.font.getFontName());
        } else {
            this.font = new Font(string, 0, 14);
        }
        sessionPanel.setFont(this.font);
        this.getSettings();
        FontRenderContext fontRenderContext = new FontRenderContext(this.font.getTransform(), true, true);
        this.lm = this.font.getLineMetrics("Wy", fontRenderContext);
        this.columnWidth = (int)this.font.getStringBounds("W", fontRenderContext).getWidth() + 1;
        this.rowHeight = (int)(this.font.getStringBounds("g", fontRenderContext).getHeight() + (double)this.lm.getDescent() + (double)this.lm.getLeading());
        screen5250.getOIA().addOIAListener(this);
        screen5250.addScreenListener(this);
        this.tArea = new Rectangle2D.Float();
        this.cArea = new Rectangle2D.Float();
        this.aArea = new Rectangle2D.Float();
        this.sArea = new Rectangle2D.Float();
        this.pArea = new Rectangle2D.Float();
        this.mArea = new Rectangle2D.Float();
        this.iArea = new Rectangle2D.Float();
        this.kbArea = new Rectangle2D.Float();
        this.scriptArea = new Rectangle2D.Float();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof Timer) {
            if (this.screen.isCursorActive()) {
                this.screen.setCursorActive(false);
            } else {
                this.screen.setCursorActive(true);
            }
        }
    }

    public boolean isBlinkCursor() {
        return this.blinker != null;
    }

    public void resize(int n, int n2) {
        if (this.bi.getWidth() != n || this.bi.getHeight() != n2) {
            this.bi = null;
            this.bi = new BufferedImage(n, n2, 1);
            this.getSettings();
        }
    }

    private void getSettings() {
        this.lenScreen = this.screen.getScreenLength();
    }

    protected final void loadColors() {
        this.colorBlue = new Color(140, 120, 255);
        this.colorTurq = new Color(0, 240, 255);
        this.colorRed = Color.red;
        this.colorWhite = Color.white;
        this.colorYellow = Color.yellow;
        this.colorGreen = Color.green;
        this.colorPink = Color.magenta;
        this.colorGUIField = Color.white;
        this.colorSep = Color.white;
        this.colorHexAttr = Color.white;
        this.colorBg = this.cfg_guiInterface ? Color.lightGray : Color.black;
        this.colorCursor = Color.white;
        if (!this.config.isPropertyExists("colorBg")) {
            this.setProperty("colorBg", Integer.toString(this.colorBg.getRGB()));
        } else {
            this.colorBg = this.getColorProperty("colorBg");
        }
        this.gui.setBackground(this.colorBg);
        if (!this.config.isPropertyExists("colorBlue")) {
            this.setProperty("colorBlue", Integer.toString(this.colorBlue.getRGB()));
        } else {
            this.colorBlue = this.getColorProperty("colorBlue");
        }
        if (!this.config.isPropertyExists("colorTurq")) {
            this.setProperty("colorTurq", Integer.toString(this.colorTurq.getRGB()));
        } else {
            this.colorTurq = this.getColorProperty("colorTurq");
        }
        if (!this.config.isPropertyExists("colorRed")) {
            this.setProperty("colorRed", Integer.toString(this.colorRed.getRGB()));
        } else {
            this.colorRed = this.getColorProperty("colorRed");
        }
        if (!this.config.isPropertyExists("colorWhite")) {
            this.setProperty("colorWhite", Integer.toString(this.colorWhite.getRGB()));
        } else {
            this.colorWhite = this.getColorProperty("colorWhite");
        }
        if (!this.config.isPropertyExists("colorYellow")) {
            this.setProperty("colorYellow", Integer.toString(this.colorYellow.getRGB()));
        } else {
            this.colorYellow = this.getColorProperty("colorYellow");
        }
        if (!this.config.isPropertyExists("colorGreen")) {
            this.setProperty("colorGreen", Integer.toString(this.colorGreen.getRGB()));
        } else {
            this.colorGreen = this.getColorProperty("colorGreen");
        }
        if (!this.config.isPropertyExists("colorPink")) {
            this.setProperty("colorPink", Integer.toString(this.colorPink.getRGB()));
        } else {
            this.colorPink = this.getColorProperty("colorPink");
        }
        if (!this.config.isPropertyExists("colorGUIField")) {
            this.setProperty("colorGUIField", Integer.toString(this.colorGUIField.getRGB()));
        } else {
            this.colorGUIField = this.getColorProperty("colorGUIField");
        }
        if (!this.config.isPropertyExists("colorCursor")) {
            this.setProperty("colorCursor", Integer.toString(this.colorCursor.getRGB()));
        } else {
            this.colorCursor = this.getColorProperty("colorCursor");
        }
        if (!this.config.isPropertyExists("colorSep")) {
            this.colorSep = this.colorWhite;
            this.setProperty("colorSep", Integer.toString(this.colorSep.getRGB()));
        } else {
            this.colorSep = this.getColorProperty("colorSep");
        }
        if (!this.config.isPropertyExists("colorHexAttr")) {
            this.colorHexAttr = this.colorWhite;
            this.setProperty("colorHexAttr", Integer.toString(this.colorHexAttr.getRGB()));
        } else {
            this.colorHexAttr = this.getColorProperty("colorHexAttr");
        }
    }

    public void loadProps() {
        this.loadColors();
        this.colSepLine = ColumnSeparator.getFromName(this.getStringProperty("colSeparator"));
        if (this.config.isPropertyExists("showAttr") && this.getStringProperty("showAttr").equals("Hex")) {
            this.showHex = true;
        }
        if (this.config.isPropertyExists("guiInterface")) {
            if (this.getStringProperty("guiInterface").equals("Yes")) {
                this.screen.setUseGUIInterface(true);
                this.cfg_guiInterface = true;
            } else {
                this.screen.setUseGUIInterface(false);
                this.cfg_guiInterface = false;
            }
        }
        if (this.config.isPropertyExists("guiShowUnderline")) {
            this.cfg_guiShowUnderline = this.getStringProperty("guiShowUnderline").equals("Yes");
        }
        if (this.config.isPropertyExists("hotspots")) {
            this.hotSpots = this.getStringProperty("hotspots").equals("Yes");
        }
        if (this.config.isPropertyExists("hsMore") && this.getStringProperty("hsMore").length() > 0) {
            this.hsMore.setLength(0);
            this.hsMore.append(this.getStringProperty("hsMore"));
        }
        if (this.config.isPropertyExists("hsBottom") && this.getStringProperty("hsBottom").length() > 0) {
            this.hsBottom.setLength(0);
            this.hsBottom.append(this.getStringProperty("hsBottom"));
        }
        if (this.config.isPropertyExists("cursorSize")) {
            if (this.getStringProperty("cursorSize").equals("Full")) {
                this.cursorSize = 2;
            }
            if (this.getStringProperty("cursorSize").equals("Half")) {
                this.cursorSize = 1;
            }
            if (this.getStringProperty("cursorSize").equals("Line")) {
                this.cursorSize = 0;
            }
        }
        if (this.config.isPropertyExists("crossHair")) {
            if (this.getStringProperty("crossHair").equals("None")) {
                this.crossHair = 0;
            }
            if (this.getStringProperty("crossHair").equals("Horz")) {
                this.crossHair = 1;
            }
            if (this.getStringProperty("crossHair").equals("Vert")) {
                this.crossHair = 2;
            }
            if (this.getStringProperty("crossHair").equals("Both")) {
                this.crossHair = 3;
            }
        }
        if (this.config.isPropertyExists("rulerFixed")) {
            this.rulerFixed = this.getStringProperty("rulerFixed").equals("Yes");
        }
        if (this.config.isPropertyExists("fontScaleHeight")) {
            this.sfh = this.getFloatProperty("fontScaleHeight");
        }
        if (this.config.isPropertyExists("fontScaleWidth")) {
            this.sfw = this.getFloatProperty("fontScaleWidth");
        }
        if (this.config.isPropertyExists("fontPointSize")) {
            this.ps132 = this.getFloatProperty("fontPointSize");
        }
        if (this.config.isPropertyExists("cursorBottOffset")) {
            this.cursorBottOffset = this.getIntProperty("cursorBottOffset");
        }
        if (this.config.isPropertyExists("resetRequired")) {
            if (this.getStringProperty("resetRequired").equals("Yes")) {
                this.screen.setResetRequired(true);
            } else {
                this.screen.setResetRequired(false);
            }
        }
        if (this.config.isPropertyExists("useAntialias")) {
            this.antialiased = this.getStringProperty("useAntialias").equals("Yes");
        }
        if (this.config.getStringProperty("cursorBlink").equals("Yes")) {
            this.blinker = new Timer(500, this);
            this.blinker.start();
        }
        if (this.config.isPropertyExists("backspaceError")) {
            if (this.getStringProperty("backspaceError").equals("Yes")) {
                this.screen.setBackspaceError(true);
            } else {
                this.screen.setBackspaceError(false);
            }
        }
    }

    protected final String getStringProperty(String string) {
        return this.config.getStringProperty(string);
    }

    protected final Color getColorProperty(String string) {
        return this.config.getColorProperty(string);
    }

    protected final float getFloatProperty(String string) {
        return this.config.getFloatProperty(string);
    }

    protected final int getIntProperty(String string) {
        return this.config.getIntegerProperty(string);
    }

    protected final void setProperty(String string, String string2) {
        this.config.setProperty(string, string2);
    }

    @Override
    public void onConfigChanged(SessionConfigEvent sessionConfigEvent) {
        this.propertyChange(sessionConfigEvent);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        boolean bl = false;
        if (string.equals("colorBg")) {
            this.colorBg = (Color)propertyChangeEvent.getNewValue();
            bl = true;
        }
        if (string.equals("colorBlue")) {
            this.colorBlue = (Color)propertyChangeEvent.getNewValue();
            bl = true;
        }
        if (string.equals("colorTurq")) {
            this.colorTurq = (Color)propertyChangeEvent.getNewValue();
            bl = true;
        }
        if (string.equals("colorRed")) {
            this.colorRed = (Color)propertyChangeEvent.getNewValue();
            bl = true;
        }
        if (string.equals("colorWhite")) {
            this.colorWhite = (Color)propertyChangeEvent.getNewValue();
            bl = true;
        }
        if (string.equals("colorYellow")) {
            this.colorYellow = (Color)propertyChangeEvent.getNewValue();
            bl = true;
        }
        if (string.equals("colorGreen")) {
            this.colorGreen = (Color)propertyChangeEvent.getNewValue();
            bl = true;
        }
        if (string.equals("colorPink")) {
            this.colorPink = (Color)propertyChangeEvent.getNewValue();
            bl = true;
        }
        if (string.equals("colorGUIField")) {
            this.colorGUIField = (Color)propertyChangeEvent.getNewValue();
            bl = true;
        }
        if (string.equals("colorCursor")) {
            this.colorCursor = (Color)propertyChangeEvent.getNewValue();
            bl = true;
        }
        if (string.equals("colorSep")) {
            this.colorSep = (Color)propertyChangeEvent.getNewValue();
            bl = true;
        }
        if (string.equals("colorHexAttr")) {
            this.colorHexAttr = (Color)propertyChangeEvent.getNewValue();
            bl = true;
        }
        if (string.equals("cursorSize")) {
            if (propertyChangeEvent.getNewValue().equals("Full")) {
                this.cursorSize = 2;
            }
            if (propertyChangeEvent.getNewValue().equals("Half")) {
                this.cursorSize = 1;
            }
            if (propertyChangeEvent.getNewValue().equals("Line")) {
                this.cursorSize = 0;
            }
        }
        if (string.equals("crossHair")) {
            if (propertyChangeEvent.getNewValue().equals("None")) {
                this.crossHair = 0;
            }
            if (propertyChangeEvent.getNewValue().equals("Horz")) {
                this.crossHair = 1;
            }
            if (propertyChangeEvent.getNewValue().equals("Vert")) {
                this.crossHair = 2;
            }
            if (propertyChangeEvent.getNewValue().equals("Both")) {
                this.crossHair = 3;
            }
        }
        if (string.equals("rulerFixed")) {
            this.rulerFixed = propertyChangeEvent.getNewValue().equals("Yes");
        }
        this.colSepLine = ColumnSeparator.getFromName(propertyChangeEvent.getNewValue().toString());
        if (string.equals("showAttr")) {
            this.showHex = propertyChangeEvent.getNewValue().equals("Hex");
        }
        if (string.equals("guiInterface")) {
            if (propertyChangeEvent.getNewValue().equals("Yes")) {
                this.screen.setUseGUIInterface(true);
                this.cfg_guiInterface = true;
            } else {
                this.screen.setUseGUIInterface(true);
                this.cfg_guiInterface = false;
            }
        }
        if (string.equals("guiShowUnderline")) {
            this.cfg_guiShowUnderline = propertyChangeEvent.getNewValue().equals("Yes");
        }
        if (string.equals("hotspots")) {
            this.hotSpots = propertyChangeEvent.getNewValue().equals("Yes");
        }
        if (string.equals("resetRequired")) {
            if (propertyChangeEvent.getNewValue().equals("Yes")) {
                this.screen.setResetRequired(true);
            } else {
                this.screen.setResetRequired(false);
            }
        }
        if (string.equals("hsMore")) {
            this.hsMore.setLength(0);
            this.hsMore.append((String)propertyChangeEvent.getNewValue());
        }
        if (string.equals("hsBottom")) {
            this.hsBottom.setLength(0);
            this.hsBottom.append((String)propertyChangeEvent.getNewValue());
        }
        if (string.equals("font")) {
            this.font = new Font((String)propertyChangeEvent.getNewValue(), 0, 14);
            this.updateFont = true;
        }
        if (string.equals("useAntialias")) {
            if (propertyChangeEvent.getNewValue().equals("Yes")) {
                this.setUseAntialias(true);
            } else {
                this.setUseAntialias(false);
            }
            this.updateFont = true;
        }
        if (string.equals("fontScaleHeight")) {
            this.sfh = Float.parseFloat((String)propertyChangeEvent.getNewValue());
            this.updateFont = true;
        }
        if (string.equals("fontScaleWidth")) {
            this.sfw = Float.parseFloat((String)propertyChangeEvent.getNewValue());
            this.updateFont = true;
        }
        if (string.equals("fontPointSize")) {
            this.ps132 = Float.parseFloat((String)propertyChangeEvent.getNewValue());
            this.updateFont = true;
        }
        if (string.equals("cursorBottOffset")) {
            this.cursorBottOffset = this.getIntProperty("cursorBottOffset");
        }
        if (string.equals("cursorBlink")) {
            this.log.debug(this.getStringProperty("cursorBlink"));
            if (propertyChangeEvent.getNewValue().equals("Yes")) {
                if (this.blinker == null) {
                    this.blinker = new Timer(500, this);
                    this.blinker.start();
                }
            } else if (this.blinker != null) {
                this.blinker.stop();
                this.blinker = null;
            }
        }
        if (string.equals("backspaceError")) {
            if (propertyChangeEvent.getNewValue().equals("Yes")) {
                this.screen.setBackspaceError(true);
            } else {
                this.screen.setBackspaceError(false);
            }
        }
        if (this.updateFont) {
            Rectangle rectangle = this.gui.getDrawingBounds();
            this.resizeScreenArea(rectangle.width, rectangle.height);
            this.updateFont = false;
        }
        if (bl) {
            this.drawOIA();
        }
        this.gui.validate();
        this.gui.repaint();
    }

    public int getPosFromView(int n, int n2) {
        n -= this.offLeft;
        n2 -= this.offTop;
        if ((double)n > this.tArea.getMaxX()) {
            n = (int)this.tArea.getMaxX() - 1;
        }
        if ((double)n2 > this.tArea.getMaxY()) {
            n2 = (int)this.tArea.getMaxY() - 1;
        }
        if ((double)n < this.tArea.getMinX()) {
            n = 0;
        }
        if ((double)n2 < this.tArea.getMinY()) {
            n2 = 0;
        }
        int n3 = n2 / this.rowHeight;
        int n4 = n / this.columnWidth;
        return this.screen.getPos(n3, n4);
    }

    public int getRowColFromPoint(int n, int n2) {
        if ((double)n > this.tArea.getMaxX()) {
            n = (int)this.tArea.getMaxX() - 1;
        }
        if ((double)n2 > this.tArea.getMaxY()) {
            n2 = (int)this.tArea.getMaxY() - 1;
        }
        if ((double)n < this.tArea.getMinX()) {
            n = 0;
        }
        if ((double)n2 < this.tArea.getMinY()) {
            n2 = 0;
        }
        int n3 = n2 / this.rowHeight;
        int n4 = n / this.columnWidth;
        return this.screen.getPos(n3, n4);
    }

    public void getPointFromRowCol(int n, int n2, Point point) {
        point.x = this.columnWidth * n2 + this.offLeft;
        point.y = this.rowHeight * n + this.offTop;
    }

    public boolean isWithinScreenArea(int n, int n2) {
        return this.tArea.contains(n, n2);
    }

    public Point translateStart(Point point) {
        int n = this.getPosFromView(point.x, point.y);
        int n2 = this.columnWidth * this.screen.getCol(n);
        int n3 = this.rowHeight * this.screen.getRow(n);
        point.setLocation(n2, n3);
        return point;
    }

    public Point translateEnd(Point point) {
        int n = this.getPosFromView(point.x, point.y);
        if (n >= this.lenScreen) {
            n = this.lenScreen - 1;
        }
        int n2 = this.columnWidth * this.screen.getCol(n) + this.columnWidth - 1;
        int n3 = this.rowHeight * this.screen.getRow(n) + this.rowHeight - 1;
        point.setLocation(n2, n3);
        return point;
    }

    public void getBoundingArea(Rectangle rectangle) {
        if (!this.gui.rubberband.isAreaSelected()) {
            rectangle.setBounds(1, 1, this.screen.getColumns(), this.screen.getRows());
        } else {
            this.gui.rubberband.getBoundingArea(this.workR);
            int n = this.getRowColFromPoint(this.workR.x, this.workR.y);
            int n2 = this.getRowColFromPoint(this.workR.width, this.workR.height);
            int n3 = this.screen.getRow(n) + 1;
            int n4 = this.screen.getCol(n) + 1;
            rectangle.setBounds(n3, n4, this.screen.getCol(n2) + 1, this.screen.getRow(n2) + 1);
        }
    }

    protected final void resizeScreenArea(int n, int n2) {
        Font font = null;
        font = GUIGraphicsUtils.getDerivedFont(this.font, n, n2, this.screen.getRows(), this.screen.getColumns(), this.sfh, this.sfw, this.ps132);
        if (this.font.getSize() != font.getSize() || this.updateFont || this.offLeft != (n - this.bi.getWidth()) / 2 || this.offTop != (n2 - this.bi.getHeight()) / 2) {
            this.font = font;
            FontRenderContext fontRenderContext = new FontRenderContext(this.font.getTransform(), true, true);
            this.lm = this.font.getLineMetrics("Wy", fontRenderContext);
            this.columnWidth = (int)this.font.getStringBounds("W", fontRenderContext).getWidth() + 2;
            this.rowHeight = (int)(this.font.getStringBounds("g", fontRenderContext).getHeight() + (double)this.lm.getDescent() + (double)this.lm.getLeading());
            this.resize(this.columnWidth * this.screen.getColumns(), this.rowHeight * (this.screen.getRows() + 2));
            this.offLeft = (n - this.getWidth()) / 2;
            this.offTop = (n2 - this.getHeight()) / 2;
            if (this.offLeft < 0) {
                this.offLeft = 0;
            }
            if (this.offTop < 0) {
                this.offTop = 0;
            }
            this.drawOIA();
            this.updateFont = false;
        }
    }

    public final Dimension getPreferredSize() {
        return new Dimension(this.columnWidth * this.screen.getColumns(), this.rowHeight * (this.screen.getRows() + 2));
    }

    public BufferedImage getImageBuffer(int n, int n2) {
        int n3 = this.columnWidth * this.screen.getColumns();
        int n4 = this.rowHeight * (this.screen.getRows() + 2);
        if (this.bi == null || this.bi.getWidth() != n3 || this.bi.getHeight() != n4) {
            this.bi = new BufferedImage(n3, n4, 1);
        }
        this.drawOIA();
        return this.bi;
    }

    public Graphics2D drawOIA() {
        int n = this.screen.getRows();
        Graphics2D graphics2D = this.getDrawingArea();
        if (this.antialiased) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics2D.setFont(this.font);
        graphics2D.setColor(this.colorBg);
        graphics2D.fillRect(0, 0, this.bi.getWidth(null), this.bi.getHeight(null));
        this.tArea.setRect(0.0, 0.0, this.bi.getWidth(null), this.rowHeight * n);
        this.cArea.setRect(0.0, this.rowHeight * (n + 1), this.bi.getWidth(null), this.rowHeight * (n + 1));
        this.aArea.setRect(0.0, 0.0, this.bi.getWidth(null), this.bi.getHeight(null));
        this.sArea.setRect(this.columnWidth * 9, this.rowHeight * (n + 1), this.columnWidth * 20, this.rowHeight);
        this.pArea.setRect(this.bi.getWidth(null) - this.columnWidth * 6, this.rowHeight * (n + 1), this.columnWidth * 6, this.rowHeight);
        this.mArea.setRect((float)(this.sArea.getX() + this.sArea.getWidth()) + (float)this.columnWidth + (float)this.columnWidth, this.rowHeight * (n + 1), this.columnWidth + this.columnWidth, this.rowHeight);
        this.kbArea.setRect((float)(this.sArea.getX() + this.sArea.getWidth()) + (float)(20 * this.columnWidth), this.rowHeight * (n + 1), this.columnWidth + this.columnWidth, this.rowHeight);
        this.scriptArea.setRect((float)(this.sArea.getX() + this.sArea.getWidth()) + (float)(16 * this.columnWidth), this.rowHeight * (n + 1), this.columnWidth + this.columnWidth, this.rowHeight);
        this.iArea.setRect((float)(this.sArea.getX() + this.sArea.getWidth()) + (float)(25 * this.columnWidth), this.rowHeight * (n + 1), this.columnWidth, this.rowHeight);
        this.separatorLine.setLine(0.0, this.rowHeight * (n + 1) - this.rowHeight / 2, this.bi.getWidth(null), this.rowHeight * (n + 1) - this.rowHeight / 2);
        graphics2D.setColor(this.colorBlue);
        graphics2D.draw(this.separatorLine);
        this.gg2d = graphics2D;
        return graphics2D;
    }

    public void drawCursor(int n, int n2) {
        int n3 = this.cursorBottOffset;
        boolean bl = this.screen.getOIA().isInsertMode();
        Graphics2D graphics2D = this.getDrawingArea();
        switch (this.cursorSize) {
            case 0: {
                this.cursor.setRect(this.columnWidth * n2, this.rowHeight * (n + 1) - n3, this.columnWidth, 1.0);
                break;
            }
            case 1: {
                this.cursor.setRect(this.columnWidth * n2, this.rowHeight * (n + 1) - this.rowHeight / 2, this.columnWidth, this.rowHeight / 2 - n3);
                break;
            }
            case 2: {
                this.cursor.setRect(this.columnWidth * n2, this.rowHeight * n, this.columnWidth, this.rowHeight - n3);
            }
        }
        if (bl && this.cursorSize != 1) {
            this.cursor.setRect(this.columnWidth * n2, this.rowHeight * (n + 1) - this.rowHeight / 2, this.columnWidth, this.rowHeight / 2 - n3);
        }
        Rectangle rectangle = this.cursor.getBounds();
        rectangle.setSize(rectangle.width, rectangle.height);
        graphics2D.setColor(this.colorCursor);
        graphics2D.setXORMode(this.colorBg);
        graphics2D.fill(this.cursor);
        this.updateImage(rectangle);
        if (!this.rulerFixed) {
            this.crossRow = n;
            this.crossRect.setBounds(rectangle);
        } else if (this.crossHair == 0) {
            this.crossRow = n;
            this.crossRect.setBounds(rectangle);
        }
        switch (this.crossHair) {
            case 1: {
                graphics2D.drawLine(0, this.rowHeight * (this.crossRow + 1) - n3, this.bi.getWidth(null), this.rowHeight * (this.crossRow + 1) - n3);
                this.updateImage(0, this.rowHeight * (this.crossRow + 1) - n3, this.bi.getWidth(null), 1);
                break;
            }
            case 2: {
                graphics2D.drawLine(this.crossRect.x, 0, this.crossRect.x, this.bi.getHeight(null) - this.rowHeight - this.rowHeight);
                this.updateImage(this.crossRect.x, 0, 1, this.bi.getHeight(null) - this.rowHeight - this.rowHeight);
                break;
            }
            case 3: {
                graphics2D.drawLine(0, this.rowHeight * (this.crossRow + 1) - n3, this.bi.getWidth(null), this.rowHeight * (this.crossRow + 1) - n3);
                graphics2D.drawLine(this.crossRect.x, 0, this.crossRect.x, this.bi.getHeight(null) - this.rowHeight - this.rowHeight);
                this.updateImage(0, this.rowHeight * (this.crossRow + 1) - n3, this.bi.getWidth(null), 1);
                this.updateImage(this.crossRect.x, 0, 1, this.bi.getHeight(null) - this.rowHeight - this.rowHeight);
            }
        }
        graphics2D.dispose();
        graphics2D = this.getWritingArea(this.font);
        graphics2D.setPaint(this.colorBg);
        graphics2D.fill(this.pArea);
        graphics2D.setColor(this.colorWhite);
        graphics2D.drawString(n + 1 + "/" + (n2 + 1), (float)this.pArea.getX(), (float)this.pArea.getY() + (float)this.rowHeight);
        this.updateImage(this.pArea.getBounds());
        graphics2D.dispose();
    }

    private void drawScriptRunning(Color color) {
        Graphics2D graphics2D = (Graphics2D)this.bi.getGraphics();
        graphics2D.setColor(color);
        int[] nArray = new int[]{(int)this.scriptArea.getX(), (int)this.scriptArea.getX(), (int)this.scriptArea.getX() + (int)this.scriptArea.getWidth()};
        int[] nArray2 = new int[]{(int)this.scriptArea.getY(), (int)this.scriptArea.getY() + (int)this.scriptArea.getHeight(), (int)this.scriptArea.getY() + (int)(this.scriptArea.getHeight() / 2.0)};
        graphics2D.fillPolygon(nArray, nArray2, 3);
        graphics2D.setClip(this.scriptArea);
        graphics2D.dispose();
    }

    private void eraseScriptRunning(Color color) {
        Graphics2D graphics2D = (Graphics2D)this.bi.getGraphics();
        graphics2D.setColor(color);
        graphics2D.fill(this.scriptArea);
        graphics2D.dispose();
    }

    public Graphics2D getDrawingArea() {
        Graphics2D graphics2D = this.bi.createGraphics();
        return graphics2D;
    }

    public synchronized void drawImageBuffer(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        if (graphics2D == null) {
            this.log.debug(" we got a null graphic object ");
            return;
        }
        graphics2D.drawImage(this.bi.getSubimage(n, n2, n3, n4), null, n + this.offLeft, n2 + this.offTop);
    }

    protected void updateImage(int n, int n2, int n3, int n4) {
        if (this.gui.rubberband != null && this.gui.rubberband.isAreaSelected()) {
            this.gui.rubberband.erase();
        }
        this.gg2d.setClip(n, n2, n3, n4);
        if (this.gui.rubberband != null && this.gui.rubberband.isAreaSelected()) {
            this.gui.rubberband.draw();
        }
        if (n == 0) {
            n3 += this.offLeft;
        } else {
            n += this.offLeft;
        }
        if (n2 == 0) {
            n4 += this.offTop;
        } else {
            n2 += this.offTop;
        }
        final int n5 = n4;
        final int n6 = n3;
        final int n7 = n;
        final int n8 = n2;
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GuiGraphicBuffer.this.gui.repaint(n7, n8, n6, n5);
                }
            });
        }
        catch (Exception exception) {
            this.log.warn("setStatus(ON) " + exception.getMessage());
        }
    }

    protected void updateImage(Rectangle rectangle) {
        this.updateImage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public synchronized void drawImageBuffer(Graphics2D graphics2D) {
        if (graphics2D == null) {
            this.log.debug(" we got a null graphic object ");
            return;
        }
        graphics2D.drawImage(this.bi, null, this.offLeft, this.offTop);
    }

    public Graphics2D getWritingArea(Font font) {
        Graphics2D graphics2D = this.bi.createGraphics();
        if (graphics2D != null) {
            if (this.antialiased) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            graphics2D.setFont(font);
        }
        return graphics2D;
    }

    public void setUseAntialias(boolean bl) {
        this.antialiased = bl;
    }

    private void setStatus(ScreenOIA screenOIA) {
        int n = screenOIA.getLevel();
        int n2 = screenOIA.getInputInhibited();
        String string = screenOIA.getInhibitedText();
        Graphics2D graphics2D = this.getWritingArea(this.font);
        if (graphics2D == null) {
            return;
        }
        try {
            graphics2D.setColor(this.colorBg);
            graphics2D.fill(this.sArea);
            float f = (float)((int)this.sArea.getY() + this.rowHeight) - (this.lm.getLeading() + this.lm.getDescent());
            switch (n) {
                case 1: {
                    if (n2 != 1) break;
                    graphics2D.setColor(this.colorWhite);
                    if (string != null) {
                        graphics2D.drawString(string, (float)this.sArea.getX(), f);
                        break;
                    }
                    graphics2D.drawString(xSystem, (float)this.sArea.getX(), f);
                    break;
                }
                case 10: {
                    if (n2 != 1) break;
                    graphics2D.setColor(this.colorRed);
                    if (string != null) {
                        graphics2D.drawString(string, (float)this.sArea.getX(), f);
                        break;
                    }
                    graphics2D.drawString(xError, (float)this.sArea.getX(), f);
                }
            }
            this.updateImage(this.sArea.getBounds());
            graphics2D.dispose();
        }
        catch (Exception exception) {
            this.log.warn(" gui graphics setStatus " + exception.getMessage());
        }
    }

    public final void drawChar(Graphics2D graphics2D, int n, int n2, int n3) {
        Rectangle rectangle = new Rectangle();
        char[] cArray = new char[1];
        char c = this.updateRect.attr[n];
        cArray[0] = this.updateRect.text[n];
        this.setDrawAttr(n);
        boolean bl = this.updateRect.isAttr[n] != '\u0000';
        char c2 = this.updateRect.graphic[n];
        boolean bl2 = c2 != '\u0000';
        rectangle = this.modelToView(n2, n3, rectangle);
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = (int)((float)(n5 + this.rowHeight) - (this.lm.getDescent() + this.lm.getLeading()));
        if (this.showHex && bl) {
            Font font = graphics2D.getFont();
            Font font2 = font.deriveFont(font.getSize2D() / 2.0f);
            graphics2D.setFont(font2);
            graphics2D.setColor(this.colorHexAttr);
            char[] cArray2 = Integer.toHexString(c).toCharArray();
            graphics2D.drawChars(cArray2, 0, 1, n4, n5 + this.rowHeight / 2);
            graphics2D.drawChars(cArray2, 1, 1, n4 + this.columnWidth / 2, (int)((float)(n5 + this.rowHeight) - (this.lm.getDescent() + this.lm.getLeading()) - 2.0f));
            graphics2D.setFont(font);
        }
        if (!this.nonDisplay && !bl) {
            if (!bl2) {
                graphics2D.setColor(this.bg);
                graphics2D.fill(rectangle);
            } else {
                if (this.bg == this.colorBg && c2 >= '\t' && c2 <= '\f') {
                    graphics2D.setColor(this.colorGUIField);
                } else {
                    graphics2D.setColor(this.bg);
                }
                graphics2D.fill(rectangle);
            }
            if (bl2 && c2 < '\t') {
                graphics2D.setColor(this.fg);
                switch (c2) {
                    case '\u0001': {
                        if (cArray[0] != '.') break;
                        if (this.screen.isUsingGuiInterface()) {
                            GUIGraphicsUtils.drawWinUpperLeft(graphics2D, 4, this.colorBlue, n4, n5, this.columnWidth, this.rowHeight);
                            break;
                        }
                        GUIGraphicsUtils.drawWinUpperLeft(graphics2D, 3, this.fg, n4, n5, this.columnWidth, this.rowHeight);
                        break;
                    }
                    case '\u0002': {
                        if (cArray[0] != '.') break;
                        if (this.screen.isUsingGuiInterface()) {
                            GUIGraphicsUtils.drawWinUpper(graphics2D, 4, this.colorBlue, n4, n5, this.columnWidth, this.rowHeight);
                            break;
                        }
                        GUIGraphicsUtils.drawWinUpper(graphics2D, 3, this.fg, n4, n5, this.columnWidth, this.rowHeight);
                        break;
                    }
                    case '\u0003': {
                        if (cArray[0] != '.') break;
                        if (this.screen.isUsingGuiInterface()) {
                            GUIGraphicsUtils.drawWinUpperRight(graphics2D, 4, this.colorBlue, n4, n5, this.columnWidth, this.rowHeight);
                            break;
                        }
                        GUIGraphicsUtils.drawWinUpperRight(graphics2D, 3, this.fg, n4, n5, this.columnWidth, this.rowHeight);
                        break;
                    }
                    case '\u0004': {
                        if (cArray[0] != ':') break;
                        if (this.screen.isUsingGuiInterface()) {
                            GUIGraphicsUtils.drawWinLeft(graphics2D, 4, this.bg, n4, n5, this.columnWidth, this.rowHeight);
                            break;
                        }
                        GUIGraphicsUtils.drawWinLeft(graphics2D, 3, this.fg, n4, n5, this.columnWidth, this.rowHeight);
                        graphics2D.drawLine(n4 + this.columnWidth / 2, n5, n4 + this.columnWidth / 2, n5 + this.rowHeight);
                        break;
                    }
                    case '\u0005': {
                        if (cArray[0] != ':') break;
                        if (this.screen.isUsingGuiInterface()) {
                            GUIGraphicsUtils.drawWinRight(graphics2D, 4, this.bg, n4, n5, this.columnWidth, this.rowHeight);
                            break;
                        }
                        GUIGraphicsUtils.drawWinRight(graphics2D, 3, this.fg, n4, n5, this.columnWidth, this.rowHeight);
                        break;
                    }
                    case '\u0006': {
                        if (cArray[0] != ':') break;
                        if (this.screen.isUsingGuiInterface()) {
                            GUIGraphicsUtils.drawWinLowerLeft(graphics2D, 4, this.bg, n4, n5, this.columnWidth, this.rowHeight);
                            break;
                        }
                        GUIGraphicsUtils.drawWinLowerLeft(graphics2D, 3, this.fg, n4, n5, this.columnWidth, this.rowHeight);
                        break;
                    }
                    case '\u0007': {
                        if (cArray[0] != '.') break;
                        if (this.screen.isUsingGuiInterface()) {
                            GUIGraphicsUtils.drawWinBottom(graphics2D, 4, this.bg, n4, n5, this.columnWidth, this.rowHeight);
                            break;
                        }
                        GUIGraphicsUtils.drawWinBottom(graphics2D, 3, this.fg, n4, n5, this.columnWidth, this.rowHeight);
                        break;
                    }
                    case '\b': {
                        if (cArray[0] != ':') break;
                        if (this.screen.isUsingGuiInterface()) {
                            GUIGraphicsUtils.drawWinLowerRight(graphics2D, 4, this.bg, n4, n5, this.columnWidth, this.rowHeight);
                            break;
                        }
                        GUIGraphicsUtils.drawWinLowerRight(graphics2D, 3, this.fg, n4, n5, this.columnWidth, this.rowHeight);
                    }
                }
            } else {
                if (cArray[0] != '\u0000') {
                    if (bl2 && c2 < '\r' && this.fg == this.colorGUIField) {
                        graphics2D.setColor(Color.black);
                    } else {
                        graphics2D.setColor(this.fg);
                    }
                    try {
                        if (bl2) {
                            if (cArray[0] == '\u001c') {
                                graphics2D.drawChars(dupChar, 0, 1, n4 + 1, n6 - 2);
                            } else {
                                graphics2D.drawChars(cArray, 0, 1, n4 + 1, n6 - 2);
                            }
                        } else if (cArray[0] == '\u001c') {
                            graphics2D.drawChars(dupChar, 0, 1, n4, n6 - 2);
                        } else {
                            graphics2D.drawChars(cArray, 0, 1, n4, n6 - 2);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.out.println(" drawChar iae " + illegalArgumentException.getMessage());
                    }
                }
                if (this.underLine && (!bl2 || this.cfg_guiShowUnderline)) {
                    graphics2D.setColor(this.fg);
                    graphics2D.drawLine(n4, (int)((float)n5 + ((float)this.rowHeight - (this.lm.getLeading() + this.lm.getDescent()))), n4 + this.columnWidth, (int)((float)n5 + ((float)this.rowHeight - (this.lm.getLeading() + this.lm.getDescent()))));
                }
                if (this.colSep) {
                    graphics2D.setColor(this.colorSep);
                    switch (this.colSepLine) {
                        case Line: {
                            graphics2D.drawLine(n4, n5, n4, n5 + this.rowHeight - 1);
                            graphics2D.drawLine(n4 + this.columnWidth - 1, n5, n4 + this.columnWidth - 1, n5 + this.rowHeight);
                            break;
                        }
                        case ShortLine: {
                            graphics2D.drawLine(n4, n5 + this.rowHeight - (int)this.lm.getLeading() - 4, n4, n5 + this.rowHeight);
                            graphics2D.drawLine(n4 + this.columnWidth - 1, n5 + this.rowHeight - (int)this.lm.getLeading() - 4, n4 + this.columnWidth - 1, n5 + this.rowHeight);
                            break;
                        }
                        case Dot: {
                            graphics2D.drawLine(n4, n5 + this.rowHeight - (int)this.lm.getLeading() - 3, n4, n5 + this.rowHeight - (int)this.lm.getLeading() - 4);
                            graphics2D.drawLine(n4 + this.columnWidth - 1, n5 + this.rowHeight - (int)this.lm.getLeading() - 3, n4 + this.columnWidth - 1, n5 + this.rowHeight - (int)this.lm.getLeading() - 4);
                            break;
                        }
                    }
                }
            }
        }
        if (bl2 & c2 >= '\t') {
            switch (c2) {
                case '\t': {
                    GUIGraphicsUtils.draw3DLeft(graphics2D, 2, n4, n5, this.columnWidth, this.rowHeight);
                    break;
                }
                case '\u000b': {
                    GUIGraphicsUtils.draw3DMiddle(graphics2D, 2, n4, n5, this.columnWidth, this.rowHeight);
                    break;
                }
                case '\n': {
                    GUIGraphicsUtils.draw3DRight(graphics2D, 2, n4, n5, this.columnWidth, this.rowHeight);
                    break;
                }
                case '\f': {
                    GUIGraphicsUtils.draw3DOne(graphics2D, 2, n4, n5, this.columnWidth, this.rowHeight);
                    break;
                }
                case '\r': 
                case '\u0011': 
                case '\u0015': 
                case '\u0019': {
                    GUIGraphicsUtils.draw3DLeft(graphics2D, 1, n4, n5, this.columnWidth, this.rowHeight);
                    break;
                }
                case '\u000f': 
                case '\u0013': 
                case '\u0017': 
                case '\u001b': {
                    GUIGraphicsUtils.draw3DMiddle(graphics2D, 1, n4, n5, this.columnWidth, this.rowHeight);
                    break;
                }
                case '\u000e': 
                case '\u0012': 
                case '\u0016': 
                case '\u001a': {
                    GUIGraphicsUtils.draw3DRight(graphics2D, 1, n4, n5, this.columnWidth, this.rowHeight);
                    break;
                }
                case '\u001c': {
                    GUIGraphicsUtils.drawScrollBar(graphics2D, 1, 1, n4, n5, this.columnWidth, this.rowHeight, this.colorWhite, this.colorBg);
                    break;
                }
                case '\u001d': {
                    GUIGraphicsUtils.drawScrollBar(graphics2D, 1, 2, n4, n5, this.columnWidth, this.rowHeight, this.colorWhite, this.colorBg);
                    break;
                }
                case '\u001e': {
                    GUIGraphicsUtils.drawScrollBar(graphics2D, 2, 0, n4, n5, this.columnWidth, this.rowHeight, this.colorWhite, this.colorBg);
                    break;
                }
                case '\u001f': {
                    GUIGraphicsUtils.drawScrollBar(graphics2D, 2, 3, n4, n5, this.columnWidth, this.rowHeight, this.colorWhite, this.colorBg);
                }
            }
        }
    }

    @Override
    public void onScreenSizeChanged(int n, int n2) {
        this.log.info("screen size change");
        this.gui.resizeMe();
    }

    @Override
    public void onScreenChanged(int n, int n2, int n3, int n4, int n5) {
        if (n == 3 || n == 4) {
            this.drawCursor(n2, n3);
            return;
        }
        if (this.hotSpots) {
            this.screen.checkHotSpots();
        }
        int n6 = 0;
        int n7 = 0;
        this.updateRect = new Data(n2, n3, n4, n5);
        Rectangle rectangle = new Rectangle();
        int n8 = 0;
        n7 = n5;
        rectangle.x = n3 * this.columnWidth;
        rectangle.y = n2 * this.rowHeight;
        rectangle.width = (n5 - n3 + 1) * this.columnWidth;
        rectangle.height = (n4 - n2 + 1) * this.rowHeight;
        this.gg2d.setClip(rectangle.getBounds());
        this.gg2d.setColor(this.colorBg);
        this.gg2d.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        while (n2 <= n4) {
            n6 = n5 - n3;
            n7 = n3;
            while (n6-- >= 0) {
                if (n3 + n6 > n5) continue;
                this.drawChar(this.gg2d, n8++, n2, n7);
                ++n7;
            }
            ++n2;
        }
        this.updateImage(rectangle);
    }

    @Override
    public void onOIAChanged(ScreenOIA screenOIA, int n) {
        switch (screenOIA.getLevel()) {
            case 11: {
                if (screenOIA.isKeysBuffered()) {
                    Graphics2D graphics2D = this.getWritingArea(this.font);
                    float f = (float)(this.rowHeight * (this.screen.getRows() + 2)) - (this.lm.getLeading() + this.lm.getDescent());
                    graphics2D.setColor(this.colorYellow);
                    graphics2D.drawString("KB", (float)this.kbArea.getX(), f);
                    this.updateImage(this.kbArea.getBounds());
                    graphics2D.dispose();
                    break;
                }
                Graphics2D graphics2D = this.getWritingArea(this.font);
                graphics2D.setColor(this.colorBg);
                graphics2D.fill(this.kbArea);
                this.updateImage(this.kbArea.getBounds());
                graphics2D.dispose();
                break;
            }
            case 4: {
                Graphics2D graphics2D = this.getWritingArea(this.font);
                graphics2D.setColor(this.colorBg);
                graphics2D.fill(this.mArea);
                this.updateImage(this.mArea.getBounds());
                graphics2D.dispose();
                break;
            }
            case 3: {
                Graphics2D graphics2D = this.getWritingArea(this.font);
                float f = (float)(this.rowHeight * (this.screen.getRows() + 2)) - (this.lm.getLeading() + this.lm.getDescent());
                graphics2D.setColor(this.colorBlue);
                graphics2D.drawString("MW", (float)this.mArea.getX(), f);
                this.updateImage(this.mArea.getBounds());
                graphics2D.dispose();
                break;
            }
            case 12: {
                if (screenOIA.isScriptActive()) {
                    this.drawScriptRunning(this.colorGreen);
                    this.updateImage(this.scriptArea.getBounds());
                    break;
                }
                this.eraseScriptRunning(this.colorBg);
                this.updateImage(this.scriptArea.getBounds());
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                this.setStatus(screenOIA);
                break;
            }
            case 6: {
                if (screenOIA.isInsertMode()) {
                    Graphics2D graphics2D = this.getWritingArea(this.font);
                    float f = (float)(this.rowHeight * (this.screen.getRows() + 2)) - (this.lm.getLeading() + this.lm.getDescent());
                    graphics2D.setColor(this.colorBlue);
                    graphics2D.drawLine((int)this.iArea.getX(), (int)f, (int)(this.iArea.getX() + (this.iArea.getWidth() / 2.0 - 1.0)), (int)(f - (float)(this.rowHeight / 2)));
                    graphics2D.drawLine((int)(this.iArea.getX() + this.iArea.getWidth() - 1.0), (int)f, (int)(this.iArea.getX() + this.iArea.getWidth() / 2.0), (int)(f - (float)(this.rowHeight / 2)));
                    this.updateImage(this.iArea.getBounds());
                    graphics2D.dispose();
                    break;
                }
                Graphics2D graphics2D = this.getWritingArea(this.font);
                graphics2D.setColor(this.colorBg);
                graphics2D.fill(this.iArea);
                this.updateImage(this.iArea.getBounds());
                graphics2D.dispose();
            }
        }
    }

    public Rectangle2D getTextArea() {
        return this.tArea;
    }

    public Rectangle2D getScreenArea() {
        return this.aArea;
    }

    public Rectangle2D getCommandLineArea() {
        return this.cArea;
    }

    public Rectangle2D getStatusArea() {
        return this.sArea;
    }

    public Rectangle2D getPositionArea() {
        return this.pArea;
    }

    public Rectangle2D getMessageArea() {
        return this.mArea;
    }

    public Rectangle2D getInsertIndicatorArea() {
        return this.iArea;
    }

    public Rectangle2D getKBIndicatorArea() {
        return this.kbArea;
    }

    public Rectangle2D getScriptIndicatorArea() {
        return this.scriptArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidth() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
            return this.bi.getWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
            return this.bi.getHeight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidth(ImageObserver imageObserver) {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
            return this.bi.getWidth(imageObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight(ImageObserver imageObserver) {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
            return this.bi.getHeight(imageObserver);
        }
    }

    protected Data fillData(int n, int n2, int n3, int n4) {
        return new Data(n, n2, n3, n4);
    }

    public final Rectangle modelToView(int n, int n2) {
        return this.modelToView(n, n2, new Rectangle());
    }

    public final Rectangle modelToView(int n, int n2, Rectangle rectangle) {
        rectangle.x = n2 * this.columnWidth;
        rectangle.y = n * this.rowHeight;
        rectangle.width = this.columnWidth;
        rectangle.height = this.rowHeight;
        return rectangle;
    }

    protected Color getColor(char c, boolean bl) {
        int n = 0;
        n = bl ? (c & 0xFF00) >> 8 : c & 0xFF;
        switch (n) {
            case 0: {
                return this.colorBg;
            }
            case 2: {
                return this.colorGreen;
            }
            case 1: {
                return this.colorBlue;
            }
            case 4: {
                return this.colorRed;
            }
            case 6: {
                return this.colorYellow;
            }
            case 3: {
                return this.colorTurq;
            }
            case 7: {
                return this.colorWhite;
            }
            case 5: {
                return this.colorPink;
            }
        }
        return Color.orange;
    }

    private void setDrawAttr(int n) {
        this.colSep = false;
        this.underLine = false;
        this.nonDisplay = false;
        this.fg = this.getColor(this.updateRect.color[n], false);
        this.bg = this.getColor(this.updateRect.color[n], true);
        this.underLine = (this.updateRect.extended[n] & 8) != 0;
        this.colSep = (this.updateRect.extended[n] & 2) != 0;
        this.nonDisplay = (this.updateRect.extended[n] & '\u0001') != 0;
    }

    protected class Data {
        public char[] text;
        public char[] attr;
        public char[] isAttr;
        public char[] color;
        public char[] extended;
        public final char[] graphic;
        public final char[] field;

        public Data(char[] cArray, char[] cArray2, char[] cArray3, char[] cArray4, char[] cArray5) {
            this.text = cArray;
            this.color = cArray3;
            this.extended = cArray4;
            this.graphic = cArray5;
            this.attr = cArray2;
            this.field = null;
        }

        public Data(int n, int n2, int n3, int n4) {
            int n5 = (++n4 - ++n2 + 1) * (++n3 - ++n + 1);
            this.text = new char[n5];
            this.attr = new char[n5];
            this.isAttr = new char[n5];
            this.color = new char[n5];
            this.extended = new char[n5];
            this.graphic = new char[n5];
            this.field = new char[n5];
            if (n5 == GuiGraphicBuffer.this.lenScreen) {
                GuiGraphicBuffer.this.screen.GetScreen(this.text, n5, 1);
                GuiGraphicBuffer.this.screen.GetScreen(this.attr, n5, 7);
                GuiGraphicBuffer.this.screen.GetScreen(this.isAttr, n5, 8);
                GuiGraphicBuffer.this.screen.GetScreen(this.color, n5, 2);
                GuiGraphicBuffer.this.screen.GetScreen(this.extended, n5, 4);
                GuiGraphicBuffer.this.screen.GetScreen(this.graphic, n5, 5);
                GuiGraphicBuffer.this.screen.GetScreen(this.field, n5, 3);
            } else {
                GuiGraphicBuffer.this.screen.GetScreenRect(this.text, n5, n, n2, n3, n4, 1);
                GuiGraphicBuffer.this.screen.GetScreenRect(this.attr, n5, n, n2, n3, n4, 7);
                GuiGraphicBuffer.this.screen.GetScreenRect(this.isAttr, n5, n, n2, n3, n4, 8);
                GuiGraphicBuffer.this.screen.GetScreenRect(this.color, n5, n, n2, n3, n4, 2);
                GuiGraphicBuffer.this.screen.GetScreenRect(this.extended, n5, n, n2, n3, n4, 4);
                GuiGraphicBuffer.this.screen.GetScreenRect(this.graphic, n5, n, n2, n3, n4, 5);
                GuiGraphicBuffer.this.screen.GetScreenRect(this.field, n5, n, n2, n3, n4, 3);
            }
        }
    }
}

