/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.tn5250j.BootStrapper;
import org.tn5250j.ConnectDialog;
import org.tn5250j.Gui5250Frame;
import org.tn5250j.Session5250;
import org.tn5250j.SessionPanel;
import org.tn5250j.event.BootEvent;
import org.tn5250j.event.BootListener;
import org.tn5250j.event.EmulatorActionEvent;
import org.tn5250j.event.EmulatorActionListener;
import org.tn5250j.event.SessionChangeEvent;
import org.tn5250j.event.SessionListener;
import org.tn5250j.framework.Tn5250jController;
import org.tn5250j.framework.common.SessionManager;
import org.tn5250j.framework.common.Sessions;
import org.tn5250j.gui.TN5250jSplashScreen;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.interfaces.GUIViewInterface;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class My5250
implements BootListener,
SessionListener,
EmulatorActionListener {
    private static final String PARAM_START_SESSION = "-s";
    private GUIViewInterface frame1;
    private String[] sessionArgs = null;
    private static Properties sessions = new Properties();
    private static BootStrapper strapper = null;
    private SessionManager manager;
    private static List<GUIViewInterface> frames;
    private TN5250jSplashScreen splash;
    private int step;
    StringBuilder viewNamesForNextStartBuilder = null;
    private TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public My5250() {
        this.splash = new TN5250jSplashScreen("tn5250jSplash.jpg");
        this.splash.setSteps(5);
        this.splash.setVisible(true);
        this.loadLookAndFeel();
        My5250.loadSessions();
        this.splash.updateProgress(++this.step);
        this.initJarPaths();
        this.initScripting();
        frames = new ArrayList<GUIViewInterface>();
        this.newView();
        this.setDefaultLocale();
        this.manager = SessionManager.instance();
        this.splash.updateProgress(++this.step);
        Tn5250jController.getCurrent();
    }

    public SessionManager getSessionManager() {
        return this.manager;
    }

    private void loadLookAndFeel() {
        try {
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(lookAndFeelInfo.getName())) continue;
                UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    private static boolean checkBootStrapper(String[] stringArray) {
        try {
            Socket socket = new Socket("localhost", 3036);
            PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
            String string = null;
            for (int i = 0; i < stringArray.length; ++i) {
                string = string != null ? string + stringArray[i] + " " : stringArray[i] + " ";
            }
            printWriter.println(string);
            printWriter.flush();
            printWriter.close();
            socket.close();
            return true;
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void bootOptionsReceived(BootEvent bootEvent) {
        this.log.info(" boot options received " + bootEvent.getNewSessionOptions());
        ConfigureFactory.getInstance().reloadSettings();
        if (!bootEvent.getNewSessionOptions().equals("null")) {
            String[] stringArray = new String[20];
            My5250.parseArgs(bootEvent.getNewSessionOptions(), stringArray);
            if (My5250.isSpecified(PARAM_START_SESSION, stringArray)) {
                String string = My5250.getParm(PARAM_START_SESSION, stringArray);
                if (sessions.containsKey(string)) {
                    My5250.parseArgs(sessions.getProperty(string), stringArray);
                    final String[] stringArray2 = stringArray;
                    final String string2 = string;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            My5250.this.newSession(string2, stringArray2);
                        }
                    });
                }
            } else if (stringArray[0].startsWith("-")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        My5250.this.startNewSession();
                    }
                });
            } else {
                final String[] stringArray3 = stringArray;
                final String string = stringArray[0];
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        My5250.this.newSession(string, stringArray3);
                    }
                });
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    My5250.this.startNewSession();
                }
            });
        }
    }

    public static void main(String[] stringArray) {
        if (!My5250.isSpecified("-nc", stringArray)) {
            if (!My5250.checkBootStrapper(stringArray)) {
                if (My5250.isSpecified("-d", stringArray)) {
                    strapper = new BootStrapper();
                    strapper.start();
                }
            } else {
                System.exit(0);
            }
        }
        My5250 my5250 = new My5250();
        if (strapper != null) {
            strapper.addBootListener(my5250);
        }
        if (stringArray.length > 0) {
            if (My5250.isSpecified("-width", stringArray) || My5250.isSpecified("-height", stringArray)) {
                int n = my5250.frame1.getWidth();
                int n2 = my5250.frame1.getHeight();
                if (My5250.isSpecified("-width", stringArray)) {
                    n = Integer.parseInt(My5250.getParm("-width", stringArray));
                }
                if (My5250.isSpecified("-height", stringArray)) {
                    n2 = Integer.parseInt(My5250.getParm("-height", stringArray));
                }
                my5250.frame1.setSize(n, n2);
                my5250.frame1.centerFrame();
            }
            if (stringArray[0].startsWith("-")) {
                if (My5250.isSpecified(PARAM_START_SESSION, stringArray)) {
                    String string = My5250.getParm(PARAM_START_SESSION, stringArray);
                    if (sessions.containsKey(string)) {
                        sessions.setProperty("emul.default", string);
                    } else {
                        stringArray = null;
                    }
                }
                if (My5250.isSpecified("-L", stringArray)) {
                    Locale.setDefault(My5250.parseLocal(My5250.getParm("-L", stringArray)));
                }
                LangTool.init();
            } else {
                LangTool.init();
            }
        } else {
            LangTool.init();
        }
        List<String> list = new ArrayList<String>();
        list.addAll(My5250.loadLastSessionViewNames());
        list.addAll(My5250.loadLastSessionViewNamesFrom(stringArray));
        list = My5250.filterExistingViewNames(list);
        if (list.size() > 0) {
            My5250.insertDefaultSessionIfConfigured(list);
            My5250.startSessionsFromList(my5250, list);
            if (sessions.containsKey("emul.showConnectDialog")) {
                my5250.openConnectSessionDialogAndStartSelectedSession();
            }
        } else {
            my5250.startNewSession();
        }
    }

    private static void startSessionsFromList(My5250 my5250, List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (!my5250.frame1.isVisible()) {
                my5250.splash.updateProgress(++my5250.step);
                my5250.splash.setVisible(false);
                my5250.frame1.setVisible(true);
                my5250.frame1.setCursor(Cursor.getPredefinedCursor(0));
            }
            my5250.sessionArgs = new String[20];
            My5250.parseArgs(sessions.getProperty(string), my5250.sessionArgs);
            my5250.newSession(string, my5250.sessionArgs);
        }
    }

    private static void insertDefaultSessionIfConfigured(List<String> list) {
        if (My5250.getDefaultSession() != null && !list.contains(My5250.getDefaultSession())) {
            list.add(0, My5250.getDefaultSession());
        }
    }

    static List<String> loadLastSessionViewNamesFrom(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (String string : stringArray) {
            if (bl && !PARAM_START_SESSION.equals(string)) {
                arrayList.add(string);
            }
            bl = PARAM_START_SESSION.equals(string);
        }
        return arrayList;
    }

    static List<String> loadLastSessionViewNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (sessions.containsKey("emul.startLastView")) {
            String string;
            String string2 = sessions.getProperty("emul.view", "");
            int n = 0;
            int n2 = string2.indexOf(PARAM_START_SESSION, n);
            while (n2 > -1) {
                string = string2.substring(n, n2).trim();
                if (string.length() > 0) {
                    arrayList.add(string);
                }
                n = n2 + PARAM_START_SESSION.length();
                n2 = string2.indexOf(PARAM_START_SESSION, n);
            }
            if (n + PARAM_START_SESSION.length() < string2.length() && (string = string2.substring(n + PARAM_START_SESSION.length() - 1).trim()).length() > 0) {
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    static List<String> filterExistingViewNames(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (!sessions.containsKey(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private static boolean containsNotOnlyNullValues(String[] stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (string == null) continue;
                return true;
            }
        }
        return false;
    }

    private void setDefaultLocale() {
        if (sessions.containsKey("emul.locale")) {
            Locale.setDefault(My5250.parseLocal(sessions.getProperty("emul.locale")));
        }
    }

    private static String getParm(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return stringArray[i + 1];
        }
        return null;
    }

    private static boolean isSpecified(String string, String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || !stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private static String getDefaultSession() {
        String string = sessions.getProperty("emul.default");
        if (string != null && !string.trim().isEmpty()) {
            return string;
        }
        return null;
    }

    public void startNewUbluSession(String[] stringArray) {
        String string = "";
        string = My5250.containsNotOnlyNullValues(this.sessionArgs) && !this.sessionArgs[0].startsWith("-") ? this.sessionArgs[0] : My5250.getDefaultSession();
        Sessions sessions = this.manager.getSessions();
        if (string != null && sessions.getCount() == 0 && My5250.sessions.containsKey(string)) {
            this.sessionArgs = new String[20];
            My5250.parseArgs(My5250.sessions.getProperty(string), this.sessionArgs);
        }
        this.newSession("ublu", stringArray);
    }

    private void startNewSession() {
        String string = "";
        string = My5250.containsNotOnlyNullValues(this.sessionArgs) && !this.sessionArgs[0].startsWith("-") ? this.sessionArgs[0] : My5250.getDefaultSession();
        Sessions sessions = this.manager.getSessions();
        if (string != null && sessions.getCount() == 0 && My5250.sessions.containsKey(string)) {
            this.sessionArgs = new String[20];
            My5250.parseArgs(My5250.sessions.getProperty(string), this.sessionArgs);
        }
        if (this.sessionArgs == null || sessions.getCount() > 0 || My5250.sessions.containsKey("emul.showConnectDialog")) {
            this.openConnectSessionDialogAndStartSelectedSession();
        } else {
            this.newSession(string, this.sessionArgs);
        }
    }

    private void openConnectSessionDialogAndStartSelectedSession() {
        String string = this.openConnectSessionDialog();
        Sessions sessions = this.manager.getSessions();
        if (string != null) {
            String string2 = My5250.sessions.getProperty(string);
            this.sessionArgs = new String[20];
            My5250.parseArgs(string2, this.sessionArgs);
            this.newSession(string, this.sessionArgs);
        } else if (sessions.getCount() == 0) {
            System.exit(0);
        }
    }

    private void startDuplicateSession(SessionPanel sessionPanel) {
        Object object;
        My5250.loadSessions();
        if (sessionPanel == null) {
            object = this.manager.getSessions();
            for (int i = 0; i < ((Sessions)object).getCount(); ++i) {
                if (!((Sessions)object).item(i).getGUI().isVisible()) continue;
                sessionPanel = ((Sessions)object).item(i).getGUI();
                break;
            }
        }
        object = sessions.getProperty(sessionPanel.getSessionName());
        this.sessionArgs = new String[20];
        My5250.parseArgs((String)object, this.sessionArgs);
        this.newSession(sessionPanel.getSessionName(), this.sessionArgs);
    }

    private String openConnectSessionDialog() {
        this.splash.setVisible(false);
        ConnectDialog connectDialog = new ConnectDialog((Frame)this.frame1, LangTool.getString("ss.title"), sessions);
        My5250.loadSessions();
        return connectDialog.getConnectKey();
    }

    private synchronized void newSession(String string, String[] stringArray) {
        Properties properties = new Properties();
        String string2 = null;
        String string3 = stringArray[0];
        properties.put("SESSION_HOST", string3);
        if (My5250.isSpecified("-e", stringArray)) {
            properties.put("SESSION_TN_ENHANCED", "1");
        }
        if (My5250.isSpecified("-p", stringArray)) {
            properties.put("SESSION_HOST_PORT", My5250.getParm("-p", stringArray));
        }
        if (My5250.isSpecified("-f", stringArray)) {
            string2 = My5250.getParm("-f", stringArray);
        }
        if (My5250.isSpecified("-cp", stringArray)) {
            properties.put("SESSION_CODE_PAGE", My5250.getParm("-cp", stringArray));
        }
        if (My5250.isSpecified("-gui", stringArray)) {
            properties.put("SESSION_USE_GUI", "1");
        }
        if (My5250.isSpecified("-t", stringArray)) {
            properties.put("SESSION_TERM_NAME_SYSTEM", "1");
        }
        if (My5250.isSpecified("-132", stringArray)) {
            properties.put("SESSION_SCREEN_SIZE", "1");
        } else {
            properties.put("SESSION_SCREEN_SIZE", "0");
        }
        if (My5250.isSpecified("-usp", stringArray)) {
            if (My5250.isSpecified("-sph", stringArray)) {
                properties.put("SESSION_PROXY_HOST", My5250.getParm("-sph", stringArray));
            }
            if (My5250.isSpecified("-spp", stringArray)) {
                properties.put("SESSION_PROXY_PORT", My5250.getParm("-spp", stringArray));
            }
        }
        if (My5250.isSpecified("-sslType", stringArray)) {
            properties.put("-sslType", My5250.getParm("-sslType", stringArray));
        }
        if (My5250.isSpecified("-dn=hostname", stringArray)) {
            String string4;
            try {
                string4 = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                string4 = "UNKNOWN_HOST";
            }
            properties.put("SESSION_DEVICE_NAME", string4);
        } else if (My5250.isSpecified("-dn", stringArray)) {
            properties.put("SESSION_DEVICE_NAME", My5250.getParm("-dn", stringArray));
        }
        if (My5250.isSpecified("-hb", stringArray)) {
            properties.put("SESSION_KEEP_ALIVE_ENABLED", "1");
        }
        int n = this.manager.getSessions().getCount();
        Session5250 session5250 = this.manager.openSession(properties, string2, string);
        SessionPanel sessionPanel = new SessionPanel(session5250);
        if (!this.frame1.isVisible()) {
            this.splash.updateProgress(++this.step);
            if (My5250.isSpecified("-noembed", stringArray) && n > 0) {
                this.newView();
            }
            this.splash.setVisible(false);
            this.frame1.setVisible(true);
            this.frame1.setCursor(Cursor.getPredefinedCursor(0));
        } else if (My5250.isSpecified("-noembed", stringArray)) {
            this.splash.updateProgress(++this.step);
            this.newView();
            this.splash.setVisible(false);
            this.frame1.setVisible(true);
            this.frame1.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (My5250.isSpecified("-t", stringArray)) {
            this.frame1.addSessionView(string, sessionPanel);
        } else {
            this.frame1.addSessionView(string3, sessionPanel);
        }
        sessionPanel.connect();
        sessionPanel.addEmulatorActionListener(this);
    }

    private void newView() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (sessions.containsKey("emul.width")) {
            n = Integer.parseInt(sessions.getProperty("emul.width"));
        }
        if (sessions.containsKey("emul.height")) {
            n2 = Integer.parseInt(sessions.getProperty("emul.height"));
        }
        this.frame1 = new Gui5250Frame(this);
        this.frame1.setCursor(Cursor.getPredefinedCursor(3));
        if (sessions.containsKey("emul.frame" + this.frame1.getFrameSequence())) {
            String string = sessions.getProperty("emul.frame" + this.frame1.getFrameSequence());
            this.restoreFrame(this.frame1, string);
        } else {
            this.frame1.setSize(n, n2);
            this.frame1.centerFrame();
        }
        frames.add(this.frame1);
    }

    private void restoreFrame(GUIViewInterface gUIViewInterface, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        gUIViewInterface.setLocation(n, n2);
        gUIViewInterface.setSize(n3, n4);
    }

    protected void closingDown(GUIViewInterface gUIViewInterface) {
        Sessions sessions = this.manager.getSessions();
        if (this.log.isDebugEnabled()) {
            this.log.debug("number of active sessions we have " + sessions.getCount());
        }
        if (this.viewNamesForNextStartBuilder == null) {
            this.viewNamesForNextStartBuilder = new StringBuilder();
        }
        while (gUIViewInterface.getSessionViewCount() > 0) {
            SessionPanel sessionPanel = gUIViewInterface.getSessionAt(0);
            this.viewNamesForNextStartBuilder.append("-s ").append(sessionPanel.getSessionName()).append(" ");
            this.closeSessionInternal(sessionPanel);
        }
        My5250.sessions.setProperty("emul.frame" + gUIViewInterface.getFrameSequence(), gUIViewInterface.getX() + "," + gUIViewInterface.getY() + "," + gUIViewInterface.getWidth() + "," + gUIViewInterface.getHeight());
        frames.remove(gUIViewInterface);
        gUIViewInterface.dispose();
        if (this.log.isDebugEnabled()) {
            this.log.debug("number of active sessions we have after shutting down " + sessions.getCount());
        }
        this.log.info("view settings " + this.viewNamesForNextStartBuilder);
        if (sessions.getCount() == 0) {
            My5250.sessions.setProperty("emul.width", Integer.toString(gUIViewInterface.getWidth()));
            My5250.sessions.setProperty("emul.height", Integer.toString(gUIViewInterface.getHeight()));
            My5250.sessions.setProperty("emul.view", this.viewNamesForNextStartBuilder.toString());
            ConfigureFactory.getInstance().saveSettings("sessions", "sessions", "------ Defaults --------");
            if (strapper != null) {
                strapper.interrupt();
            }
            System.exit(0);
        }
    }

    protected void closeSessionInternal(SessionPanel sessionPanel) {
        GUIViewInterface gUIViewInterface = this.getParentView(sessionPanel);
        if (gUIViewInterface == null) {
            return;
        }
        Sessions sessions = this.manager.getSessions();
        if (sessions.item(sessionPanel.getSession()) != null) {
            gUIViewInterface.removeSessionView(sessionPanel);
            this.manager.closeSession(sessionPanel);
        }
        if (this.manager.getSessions().getCount() < 1) {
            this.closingDown(gUIViewInterface);
        }
    }

    private static void parseArgs(String string, String[] stringArray) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
    }

    private static Locale parseLocal(String string) {
        int n = 0;
        String[] stringArray = new String[]{"", "", ""};
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return new Locale(stringArray[0], stringArray[1], stringArray[2]);
    }

    private static void loadSessions() {
        sessions = ConfigureFactory.getInstance().getProperties("sessions");
    }

    @Override
    public void onSessionChanged(SessionChangeEvent sessionChangeEvent) {
        Session5250 session5250 = (Session5250)sessionChangeEvent.getSource();
        SessionPanel sessionPanel = session5250.getGUI();
        switch (sessionChangeEvent.getState()) {
            case 2: {
                this.closeSessionInternal(sessionPanel);
            }
        }
    }

    @Override
    public void onEmulatorAction(EmulatorActionEvent emulatorActionEvent) {
        SessionPanel sessionPanel = (SessionPanel)emulatorActionEvent.getSource();
        switch (emulatorActionEvent.getAction()) {
            case 1: {
                this.closeSessionInternal(sessionPanel);
                break;
            }
            case 3: {
                throw new UnsupportedOperationException("Not yet implemented!");
            }
            case 2: {
                this.startNewSession();
                break;
            }
            case 4: {
                this.startDuplicateSession(sessionPanel);
            }
        }
    }

    private GUIViewInterface getParentView(SessionPanel sessionPanel) {
        GUIViewInterface gUIViewInterface = null;
        for (int i = 0; i < frames.size(); ++i) {
            gUIViewInterface = frames.get(i);
            if (!gUIViewInterface.containsSession(sessionPanel)) continue;
            return gUIViewInterface;
        }
        return null;
    }

    private void initScripting() {
        try {
            Class.forName("org.tn5250j.scripting.JPythonInterpreterDriver");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.log.warn("Information Message: Can not find scripting support files, scripting will not be available: Failed to load interpreter drivers " + noClassDefFoundError);
        }
        catch (Exception exception) {
            this.log.warn("Information Message: Can not find scripting support files, scripting will not be available: Failed to load interpreter drivers " + exception);
        }
        this.splash.updateProgress(++this.step);
    }

    private void initJarPaths() {
        String string = System.getProperty("python.path") + File.pathSeparator + "jython.jar" + File.pathSeparator + "jythonlib.jar" + File.pathSeparator + "jt400.jar" + File.pathSeparator + "itext.jar";
        if (sessions.containsKey("emul.scriptClassPath")) {
            string = string + File.pathSeparator + sessions.getProperty("emul.scriptClassPath");
        }
        System.setProperty("python.path", string);
        this.splash.updateProgress(++this.step);
    }

    static Properties getSessions() {
        return sessions;
    }
}

