/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.tn5250j.TN5250jConstants;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.interfaces.OptionAccessFactory;
import org.tn5250j.tools.LangTool;

public class OptionAccess
extends OptionAccessFactory {
    private static OptionAccess _instance;
    private static List<String> restricted;

    public OptionAccess() {
        if (_instance == null) {
            this.initialize();
            _instance = this;
        }
    }

    public static OptionAccess instance() {
        if (_instance == null) {
            _instance = new OptionAccess();
        }
        return _instance;
    }

    private void initialize() {
        this.loadOptions();
    }

    private void loadOptions() {
        restricted.clear();
        String string = ConfigureFactory.getInstance().getProperties("sessions").getProperty("emul.restricted");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                restricted.add(stringTokenizer.nextToken());
            }
        }
    }

    @Override
    public Vector<String> getOptions() {
        Vector<String> vector = new Vector<String>(TN5250jConstants.mnemonicData.length);
        for (int i = 0; i < TN5250jConstants.mnemonicData.length; ++i) {
            vector.add(TN5250jConstants.mnemonicData[i]);
        }
        Collections.sort(vector);
        return vector;
    }

    @Override
    public Vector<String> getOptionDescriptions() {
        Vector<String> vector = new Vector<String>(TN5250jConstants.mnemonicData.length);
        for (int i = 0; i < TN5250jConstants.mnemonicData.length; ++i) {
            vector.add(LangTool.getString("key." + TN5250jConstants.mnemonicData[i]));
        }
        Collections.sort(vector);
        return vector;
    }

    @Override
    public boolean isValidOption(String string) {
        return !restricted.contains(string);
    }

    @Override
    public boolean isRestrictedOption(String string) {
        return restricted.contains(string);
    }

    @Override
    public int getNumberOfRestrictedOptions() {
        return restricted.size();
    }

    @Override
    public void reload() {
        this.loadOptions();
    }

    static {
        restricted = new ArrayList<String>();
    }
}

