/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import org.tn5250j.SessionConfig;
import org.tn5250j.SessionPanel;
import org.tn5250j.framework.tn5250.Screen5250;

public class PrinterThread
extends Thread
implements Printable {
    char[] screen;
    char[] screenExtendedAttr;
    char[] screenAttrPlace;
    Screen5250 scr;
    int numCols;
    int numRows;
    Color colorBg;
    Font font;
    SessionPanel session;
    boolean toDefault;
    SessionConfig config;

    public PrinterThread(Screen5250 screen5250, Font font, int n, int n2, Color color, boolean bl, SessionPanel sessionPanel) {
        this.setPriority(1);
        this.session = sessionPanel;
        this.session.setCursor(Cursor.getPredefinedCursor(3));
        this.config = sessionPanel.getSession().getConfiguration();
        int n3 = screen5250.getScreenLength();
        this.screen = new char[n3];
        this.screenExtendedAttr = new char[n3];
        this.screenAttrPlace = new char[n3];
        int n4 = screen5250.GetScreen(this.screen, n3, 1);
        n4 = screen5250.GetScreen(this.screenExtendedAttr, n3, 4);
        n4 = screen5250.GetScreen(this.screenAttrPlace, n3, 8);
        this.toDefault = bl;
        this.numCols = n;
        this.numRows = n2;
        this.colorBg = color;
        this.font = font;
    }

    @Override
    public void run() {
        Paper paper;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setJobName("tn5250j");
        PageFormat pageFormat = printerJob.defaultPage();
        if (this.numCols == 132) {
            pageFormat.setOrientation(0);
        } else {
            pageFormat.setOrientation(1);
        }
        if (this.numCols != 132) {
            if (this.config.getStringProperty("print.portWidth").length() != 0 && this.config.getStringProperty("print.portHeight").length() != 0 && this.config.getStringProperty("print.portImageWidth").length() != 0 && this.config.getStringProperty("print.portImageHeight").length() != 0 && this.config.getStringProperty("print.portImage.X").length() != 0 && this.config.getStringProperty("print.portImage.Y").length() != 0) {
                paper = pageFormat.getPaper();
                paper.setSize(Double.parseDouble(this.config.getStringProperty("print.portWidth")), Double.parseDouble(this.config.getStringProperty("print.portHeight")));
                paper.setImageableArea(Double.parseDouble(this.config.getStringProperty("print.portImage.X")), Double.parseDouble(this.config.getStringProperty("print.portImage.Y")), Double.parseDouble(this.config.getStringProperty("print.portImageWidth")), Double.parseDouble(this.config.getStringProperty("print.portImageHeight")));
                pageFormat.setPaper(paper);
            }
        } else if (this.config.getStringProperty("print.landWidth").length() != 0 && this.config.getStringProperty("print.landHeight").length() != 0 && this.config.getStringProperty("print.landImageWidth").length() != 0 && this.config.getStringProperty("print.landImageHeight").length() != 0 && this.config.getStringProperty("print.landImage.X").length() != 0 && this.config.getStringProperty("print.landImage.Y").length() != 0) {
            paper = pageFormat.getPaper();
            paper.setSize(Double.parseDouble(this.config.getStringProperty("print.landWidth")), Double.parseDouble(this.config.getStringProperty("print.landHeight")));
            paper.setImageableArea(Double.parseDouble(this.config.getStringProperty("print.landImage.X")), Double.parseDouble(this.config.getStringProperty("print.landImage.Y")), Double.parseDouble(this.config.getStringProperty("print.landImageWidth")), Double.parseDouble(this.config.getStringProperty("print.landImageHeight")));
        }
        if (this.config.getStringProperty("print.font").length() > 0) {
            this.font = new Font(this.config.getStringProperty("print.font"), 0, 8);
        }
        printerJob.setPrintable(this, pageFormat);
        this.session.setCursor(Cursor.getPredefinedCursor(0));
        if (printerJob.printDialog()) {
            try {
                this.session.requestFocus();
                printerJob.print();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.session.requestFocus();
        }
        this.session = null;
        this.screen = null;
        this.screenExtendedAttr = null;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n == 0) {
            LineMetrics lineMetrics;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(Color.black);
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            int n2 = (int)pageFormat.getImageableWidth() / this.numCols;
            int n3 = (int)pageFormat.getImageableHeight() / this.numRows;
            Font font = this.font;
            FontRenderContext fontRenderContext = null;
            for (float f = 1.0f; f < 50.0f; f += 1.0f) {
                font = this.font.deriveFont(f);
                fontRenderContext = new FontRenderContext(font.getTransform(), true, true);
                lineMetrics = font.getLineMetrics("Wy", fontRenderContext);
                if (n2 < (int)font.getStringBounds("W", fontRenderContext).getWidth() || n3 < (int)(font.getStringBounds("y", fontRenderContext).getHeight() + (double)lineMetrics.getDescent() + (double)lineMetrics.getLeading())) break;
            }
            font = this.font.deriveFont(f -= 1.0f);
            fontRenderContext = new FontRenderContext(font.getTransform(), true, true);
            lineMetrics = font.getLineMetrics("Wy", fontRenderContext);
            graphics2D.setFont(font);
            int n4 = (int)font.getStringBounds("W", fontRenderContext).getWidth();
            int n5 = (int)(font.getStringBounds("y", fontRenderContext).getHeight() + (double)lineMetrics.getDescent() + (double)lineMetrics.getLeading());
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    int n6 = n4 * j;
                    int n7 = n5 * (i + 1);
                    if (this.screen[this.getPos(i, j)] >= ' ' && (this.screenExtendedAttr[this.getPos(i, j)] & '\u0001') == 0) {
                        graphics2D.drawChars(this.screen, this.getPos(i, j), 1, n6, (int)((float)(n7 + n5) - (lineMetrics.getDescent() + lineMetrics.getLeading()) - 2.0f));
                    }
                    if ((this.screenExtendedAttr[this.getPos(i, j)] & 8) == 0 || this.screenAttrPlace[this.getPos(i, j)] == '\u0001') continue;
                    graphics.drawLine(n6, (int)((float)n7 + ((float)n5 - lineMetrics.getLeading() - 3.0f)), n6 + n4, (int)((float)n7 + ((float)n5 - lineMetrics.getLeading()) - 3.0f));
                }
            }
            return 0;
        }
        return 1;
    }

    private int getPos(int n, int n2) {
        return n * this.numCols + n2;
    }
}

