/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.SwingUtilities;
import org.tn5250j.RubberBandCanvasIF;

public abstract class RubberBand {
    private volatile RubberBandCanvasIF canvas;
    protected volatile Point startPoint;
    protected volatile Point endPoint;
    private volatile boolean eraseSomething = false;
    private volatile boolean isSomethingBounded = false;
    private volatile boolean isDragging = false;

    public boolean isDragging() {
        return this.isDragging;
    }

    public RubberBand(RubberBandCanvasIF rubberBandCanvasIF) {
        this.setCanvas(rubberBandCanvasIF);
        this.getCanvas().addMouseListener(new MouseHandler());
        this.getCanvas().addMouseMotionListener(new MouseMotionHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void draw() {
        Graphics graphics = this.getCanvas().getDrawingGraphics();
        if (graphics != null) {
            try {
                if (this.getCanvas().canDrawRubberBand(this)) {
                    graphics.setXORMode(this.canvas.getBackground());
                    this.drawRubberBand(graphics);
                    this.setEraseSomething(true);
                }
            }
            finally {
                graphics.dispose();
            }
        }
    }

    protected abstract void drawBoundingShape(Graphics var1, int var2, int var3, int var4, int var5);

    protected void drawRubberBand(Graphics graphics) {
        if (this.getEndPoint().x > this.getStartPoint().x && this.getEndPoint().y > this.getStartPoint().y) {
            this.drawBoundingShape(graphics, this.getStartPoint().x, this.getStartPoint().y, this.getEndPoint().x - this.getStartPoint().x, this.getEndPoint().y - this.getStartPoint().y);
        } else if (this.getEndPoint().x < this.getStartPoint().x && this.getEndPoint().y < this.getStartPoint().y) {
            this.drawBoundingShape(graphics, this.getEndPoint().x, this.getEndPoint().y, this.getStartPoint().x - this.getEndPoint().x, this.getStartPoint().y - this.getEndPoint().y);
        } else if (this.getEndPoint().x > this.getStartPoint().x && this.getEndPoint().y < this.getStartPoint().y) {
            this.drawBoundingShape(graphics, this.getStartPoint().x, this.getEndPoint().y, this.getEndPoint().x - this.getStartPoint().x, this.getStartPoint().y - this.getEndPoint().y);
        } else if (this.getEndPoint().x < this.getStartPoint().x && this.getEndPoint().y > this.getStartPoint().y) {
            this.drawBoundingShape(graphics, this.getEndPoint().x, this.getStartPoint().y, this.getStartPoint().x - this.getEndPoint().x, this.getEndPoint().y - this.getStartPoint().y);
        }
        this.isSomethingBounded = true;
    }

    protected void erase() {
        if (this.getEraseSomething()) {
            this.draw();
            this.setEraseSomething(false);
        }
    }

    public final RubberBandCanvasIF getCanvas() {
        return this.canvas;
    }

    protected Point getEndPoint() {
        if (this.endPoint == null) {
            this.setEndPoint(new Point(0, 0));
        }
        return this.endPoint;
    }

    protected Point getStartPoint() {
        if (this.startPoint == null) {
            this.setStartPoint(new Point(0, 0));
        }
        return this.startPoint;
    }

    protected final boolean getEraseSomething() {
        return this.eraseSomething;
    }

    protected void notifyRubberBandCanvas() {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.getStartPoint().x < this.getEndPoint().x) {
            n4 = this.getStartPoint().x;
            n3 = this.getEndPoint().x;
        } else {
            n4 = this.getEndPoint().x;
            n3 = this.getStartPoint().x;
        }
        if (this.getStartPoint().y < this.getEndPoint().y) {
            n2 = this.getStartPoint().y;
            n = this.getEndPoint().y;
        } else {
            n2 = this.getEndPoint().y;
            n = this.getStartPoint().y;
        }
        this.getCanvas().areaBounded(this, n4, n2, n3, n);
    }

    public final void setCanvas(RubberBandCanvasIF rubberBandCanvasIF) {
        this.canvas = rubberBandCanvasIF;
    }

    protected final void setEndPoint(Point point) {
        this.endPoint = point;
    }

    protected final void setEraseSomething(boolean bl) {
        this.eraseSomething = bl;
    }

    protected final void setStartPoint(Point point) {
        this.startPoint = point;
        if (this.startPoint == null) {
            this.endPoint = null;
        }
    }

    protected void start(Point point) {
        this.setEndPoint(point);
        this.setStartPoint(point);
    }

    protected void stop(Point point) {
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        this.setEndPoint(point);
    }

    protected void reset() {
        this.setStartPoint(null);
        this.setEndPoint(null);
        this.isSomethingBounded = false;
    }

    protected final boolean isAreaSelected() {
        return this.isSomethingBounded;
    }

    private class MouseMotionHandler
    extends MouseMotionAdapter {
        private MouseMotionHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!SwingUtilities.isRightMouseButton(mouseEvent) && RubberBand.this.getCanvas().canDrawRubberBand(RubberBand.this)) {
                RubberBand.this.erase();
                if (!RubberBand.this.isDragging) {
                    RubberBand.this.reset();
                    RubberBand.this.start(RubberBand.this.canvas.translateStart(mouseEvent.getPoint()));
                }
                RubberBand.this.isDragging = true;
                RubberBand.this.stop(RubberBand.this.canvas.translateEnd(mouseEvent.getPoint()));
                RubberBand.this.notifyRubberBandCanvas();
                RubberBand.this.draw();
                RubberBand.this.notifyRubberBandCanvas();
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!SwingUtilities.isRightMouseButton(mouseEvent) && !RubberBand.this.isSomethingBounded) {
                RubberBand.this.start(RubberBand.this.canvas.translateStart(mouseEvent.getPoint()));
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            RubberBand.this.isDragging = false;
        }
    }
}

