/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.tn5250j.SessionConfig;
import org.tn5250j.SessionPanel;
import org.tn5250j.event.SessionChangeEvent;
import org.tn5250j.event.SessionListener;
import org.tn5250j.framework.common.SessionManager;
import org.tn5250j.framework.tn5250.Screen5250;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.gui.SystemRequestDialog;
import org.tn5250j.interfaces.ScanListener;
import org.tn5250j.interfaces.SessionInterface;

public class Session5250
implements SessionInterface {
    private String configurationResource;
    private String sessionName;
    private int sessionType;
    protected Properties sesProps;
    private boolean heartBeat;
    private final String propFileName;
    private final SessionConfig sesConfig;
    private tnvt vt;
    private final Screen5250 screen;
    private SessionPanel guiComponent;
    private List<SessionListener> sessionListeners = null;
    private final ReadWriteLock sessionListenerLock = new ReentrantReadWriteLock();
    private boolean scan;
    private List<ScanListener> scanListeners = null;
    private final ReadWriteLock scanListenerLock = new ReentrantReadWriteLock();

    public Session5250(Properties properties, String string, String string2, SessionConfig sessionConfig) {
        this.propFileName = sessionConfig.getConfigurationResource();
        this.sesConfig = sessionConfig;
        this.configurationResource = string;
        this.sessionName = string2;
        this.sesProps = properties;
        if (this.sesProps.containsKey("SESSION_KEEP_ALIVE_ENABLED")) {
            this.heartBeat = true;
        }
        this.screen = new Screen5250();
    }

    @Override
    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public SessionConfig getConfiguration() {
        return this.sesConfig;
    }

    public SessionManager getSessionManager() {
        return SessionManager.instance();
    }

    @Override
    public boolean isConnected() {
        if (this.vt == null) {
            return false;
        }
        return this.vt.isConnected();
    }

    public boolean isSslSocket() {
        if (this.vt != null) {
            return this.vt.isSslSocket();
        }
        return false;
    }

    public boolean isSslConfigured() {
        String string;
        return this.sesProps.get("-sslType") != null && !"NONE".equals(string = (String)this.sesProps.get("-sslType"));
    }

    public boolean isSendKeepAlive() {
        return this.heartBeat;
    }

    public boolean isUseSystemName() {
        return this.sesProps.getProperty("SESSION_TERM_NAME_SYSTEM") != null;
    }

    public Properties getConnectionProperties() {
        return this.sesProps;
    }

    public void setGUI(SessionPanel sessionPanel) {
        this.guiComponent = sessionPanel;
    }

    public SessionPanel getGUI() {
        return this.guiComponent;
    }

    @Override
    public String getSessionName() {
        return this.sessionName;
    }

    public String getAllocDeviceName() {
        if (this.vt != null) {
            return this.vt.getAllocatedDeviceName();
        }
        return null;
    }

    @Override
    public int getSessionType() {
        return this.sessionType;
    }

    public String getHostName() {
        return this.vt.getHostName();
    }

    public Screen5250 getScreen() {
        return this.screen;
    }

    @Override
    public void signalBell() {
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public String showSystemRequest() {
        SystemRequestDialog systemRequestDialog = new SystemRequestDialog(this.guiComponent);
        return systemRequestDialog.show();
    }

    @Override
    public void connect() {
        String string = "1080";
        boolean bl = false;
        boolean bl2 = false;
        int n = 23;
        bl = this.sesProps.containsKey("SESSION_TN_ENHANCED");
        if (this.sesProps.containsKey("SESSION_SCREEN_SIZE") && this.sesProps.getProperty("SESSION_SCREEN_SIZE").equals("1")) {
            bl2 = true;
        }
        final tnvt tnvt2 = new tnvt(this, this.screen, bl, bl2);
        this.setVT(tnvt2);
        if (this.sesProps.containsKey("SESSION_PROXY_PORT")) {
            string = this.sesProps.getProperty("SESSION_PROXY_PORT");
        }
        if (this.sesProps.containsKey("SESSION_PROXY_HOST")) {
            tnvt2.setProxy(this.sesProps.getProperty("SESSION_PROXY_HOST"), string);
        }
        String string2 = this.sesProps.containsKey("-sslType") ? this.sesProps.getProperty("-sslType") : "NONE";
        tnvt2.setSSLType(string2);
        if (this.sesProps.containsKey("SESSION_CODE_PAGE")) {
            tnvt2.setCodePage(this.sesProps.getProperty("SESSION_CODE_PAGE"));
        }
        if (this.sesProps.containsKey("SESSION_DEVICE_NAME")) {
            tnvt2.setDeviceName(this.sesProps.getProperty("SESSION_DEVICE_NAME"));
        }
        n = this.sesProps.containsKey("SESSION_HOST_PORT") ? Integer.parseInt(this.sesProps.getProperty("SESSION_HOST_PORT")) : 23;
        final String string3 = this.sesProps.getProperty("SESSION_HOST");
        final int n2 = n;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                tnvt2.connect(string3, n2);
            }
        };
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void disconnect() {
        this.vt.disconnect();
    }

    protected void setVT(tnvt tnvt2) {
        this.vt = tnvt2;
        this.screen.setVT(this.vt);
        if (this.vt != null) {
            this.vt.setScanningEnabled(this.scan);
        }
    }

    public tnvt getVT() {
        return this.vt;
    }

    public void setScanningEnabled(boolean bl) {
        this.scan = bl;
        if (this.vt != null) {
            this.vt.setScanningEnabled(bl);
        }
    }

    public boolean isScanningEnabled() {
        if (this.vt != null) {
            return this.vt.isScanningEnabled();
        }
        return this.scan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fireScanned(String string, String string2) {
        this.scanListenerLock.readLock().lock();
        try {
            if (this.scanListeners != null) {
                for (ScanListener scanListener : this.scanListeners) {
                    scanListener.scanned(string, string2);
                }
            }
        }
        finally {
            this.scanListenerLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addScanListener(ScanListener scanListener) {
        this.scanListenerLock.writeLock().lock();
        try {
            if (this.scanListeners == null) {
                this.scanListeners = new ArrayList<ScanListener>(3);
            }
            this.scanListeners.add(scanListener);
        }
        finally {
            this.scanListenerLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeScanListener(ScanListener scanListener) {
        this.scanListenerLock.writeLock().lock();
        try {
            if (this.scanListeners != null) {
                this.scanListeners.remove(scanListener);
            }
        }
        finally {
            this.scanListenerLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fireSessionChanged(int n) {
        this.sessionListenerLock.readLock().lock();
        try {
            if (this.sessionListeners != null) {
                for (SessionListener sessionListener : this.sessionListeners) {
                    SessionChangeEvent sessionChangeEvent = new SessionChangeEvent(this);
                    sessionChangeEvent.setState(n);
                    sessionListener.onSessionChanged(sessionChangeEvent);
                }
            }
        }
        finally {
            this.sessionListenerLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addSessionListener(SessionListener sessionListener) {
        this.sessionListenerLock.writeLock().lock();
        try {
            if (this.sessionListeners == null) {
                this.sessionListeners = new ArrayList<SessionListener>(3);
            }
            this.sessionListeners.add(sessionListener);
        }
        finally {
            this.sessionListenerLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeSessionListener(SessionListener sessionListener) {
        this.sessionListenerLock.writeLock().lock();
        try {
            if (this.sessionListeners != null) {
                this.sessionListeners.remove(sessionListener);
            }
        }
        finally {
            this.sessionListenerLock.writeLock().unlock();
        }
    }
}

