/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.tn5250j.SessionConfig;
import org.tn5250j.settings.AttributesPanel;
import org.tn5250j.settings.ColorAttributesPanel;
import org.tn5250j.settings.CursorAttributesPanel;
import org.tn5250j.settings.DisplayAttributesPanel;
import org.tn5250j.settings.ErrorResetAttributesPanel;
import org.tn5250j.settings.FontAttributesPanel;
import org.tn5250j.settings.HotspotAttributesPanel;
import org.tn5250j.settings.KeypadAttributesPanel;
import org.tn5250j.settings.MouseAttributesPanel;
import org.tn5250j.settings.OnConnectAttributesPanel;
import org.tn5250j.settings.PrinterAttributesPanel;
import org.tn5250j.settings.SignoffAttributesPanel;
import org.tn5250j.settings.TabAttributesPanel;
import org.tn5250j.tools.LangTool;

public class SessionAttributes
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final String fileName;
    private final Properties props;
    private JPanel jpm = new JPanel(new BorderLayout());
    private final SessionConfig changes;
    private JTree tree = new JTree();
    private CardLayout cardLayout;
    private JPanel jp;

    public SessionAttributes(Frame frame, SessionConfig sessionConfig) {
        super(frame);
        frame.setCursor(Cursor.getPredefinedCursor(3));
        this.fileName = sessionConfig.getConfigurationResource();
        this.props = sessionConfig.getProperties();
        this.changes = sessionConfig;
        try {
            this.jbInit();
            frame.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        Object object;
        this.jp = new JPanel();
        this.cardLayout = new CardLayout();
        this.jp.setLayout(this.cardLayout);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode = enumeration.nextElement();
            object = ((DefaultMutableTreeNode)treeNode).getUserObject();
            if (!(object instanceof AttributesPanel)) continue;
            this.jp.add((Component)((AttributesPanel)object), ((AttributesPanel)object).toString());
        }
        object = new DefaultMutableTreeNode(this.fileName);
        this.createNodes((DefaultMutableTreeNode)object);
        this.tree = new JTree((TreeNode)object);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)SessionAttributes.this.tree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                Object object = defaultMutableTreeNode.getUserObject();
                SessionAttributes.this.showPanel(object);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.white);
        jPanel.add(this.tree);
        this.jpm.add((Component)this.jp, "East");
        this.jpm.add((Component)jPanel, "West");
        this.cardLayout.first(this.jp);
    }

    private void showPanel(Object object) {
        this.cardLayout.show(this.jp, object.toString());
    }

    private void createNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.createNode(defaultMutableTreeNode, new ColorAttributesPanel(this.changes));
        this.createNode(defaultMutableTreeNode, new DisplayAttributesPanel(this.changes));
        this.createNode(defaultMutableTreeNode, new CursorAttributesPanel(this.changes));
        this.createNode(defaultMutableTreeNode, new FontAttributesPanel(this.changes));
        this.createNode(defaultMutableTreeNode, new TabAttributesPanel(this.changes));
        this.createNode(defaultMutableTreeNode, new SignoffAttributesPanel(this.changes));
        this.createNode(defaultMutableTreeNode, new OnConnectAttributesPanel(this.changes));
        this.createNode(defaultMutableTreeNode, new MouseAttributesPanel(this.changes));
        this.createNode(defaultMutableTreeNode, new HotspotAttributesPanel(this.changes));
        this.createNode(defaultMutableTreeNode, new KeypadAttributesPanel(this.changes));
        this.createNode(defaultMutableTreeNode, new PrinterAttributesPanel(this.changes));
        this.createNode(defaultMutableTreeNode, new ErrorResetAttributesPanel(this.changes));
    }

    private void createNode(DefaultMutableTreeNode defaultMutableTreeNode, AttributesPanel attributesPanel) {
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(attributesPanel));
        this.jp.add((Component)attributesPanel, attributesPanel.toString());
    }

    protected final String getStringProperty(String string) {
        if (this.props.containsKey(string)) {
            return (String)this.props.get(string);
        }
        return "";
    }

    protected final String getStringProperty(String string, String string2) {
        if (this.props.containsKey(string)) {
            String string3 = (String)this.props.get(string);
            if (string3.length() > 0) {
                return string3;
            }
            return string2;
        }
        return string2;
    }

    protected final int getIntProperty(String string) {
        return Integer.parseInt((String)this.props.get(string));
    }

    protected final void setProperty(String string, String string2) {
        this.props.setProperty(string, string2);
    }

    public Properties getProperties() {
        return this.props;
    }

    public void showIt() {
        Object[] objectArray = new Object[]{this.jpm};
        Object[] objectArray2 = new String[]{LangTool.getString("sa.optApply"), LangTool.getString("sa.optCancel"), LangTool.getString("sa.optSave")};
        final JOptionPane jOptionPane = new JOptionPane(objectArray, -1, 1, null, objectArray2, objectArray2[1]);
        this.setTitle(LangTool.getString("sa.title"));
        this.setModal(true);
        this.setContentPane(jOptionPane);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }
        });
        jOptionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (SessionAttributes.this.isVisible() && propertyChangeEvent.getSource() == jOptionPane && (string.equals("value") || string.equals("inputValue"))) {
                    jOptionPane.setCursor(Cursor.getPredefinedCursor(3));
                    SessionAttributes.this.doOptionStuff(jOptionPane);
                    jOptionPane.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setVisible(true);
    }

    private void doOptionStuff(JOptionPane jOptionPane) {
        Object object = jOptionPane.getValue();
        if (LangTool.getString("sa.optApply").equals(object)) {
            this.applyAttributes();
            jOptionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
        }
        if (LangTool.getString("sa.optCancel").equals(object)) {
            this.setVisible(false);
            this.dispose();
        }
        if (LangTool.getString("sa.optSave").equals(object)) {
            if (this.props.containsKey("saveme")) {
                this.props.remove("saveme");
            }
            this.saveProps();
            this.setVisible(false);
            this.dispose();
        }
    }

    private void applyAttributes() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode = enumeration.nextElement();
            Object object = ((DefaultMutableTreeNode)treeNode).getUserObject();
            if (!(object instanceof AttributesPanel)) continue;
            ((AttributesPanel)object).applyAttributes();
        }
        this.setProperty("saveme", "yes");
    }

    private void saveProps() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode = enumeration.nextElement();
            Object object = ((DefaultMutableTreeNode)treeNode).getUserObject();
            if (!(object instanceof AttributesPanel)) continue;
            ((AttributesPanel)object).save();
        }
        this.changes.saveSessionProps();
    }
}

