/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.Color;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JOptionPane;
import org.tn5250j.event.SessionConfigEvent;
import org.tn5250j.event.SessionConfigListener;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.tools.GUIGraphicsUtils;
import org.tn5250j.tools.LangTool;

public class SessionConfig {
    private String configurationResource;
    private String sessionName;
    private Properties sesProps;
    private boolean usingDefaults;
    private List<SessionConfigListener> sessionCfglisteners = null;
    private final ReadWriteLock sessionCfglistenersLock = new ReentrantReadWriteLock();

    public SessionConfig(String string, String string2) {
        this.configurationResource = string;
        this.sessionName = string2;
        this.loadConfigurationResource();
    }

    public String getConfigurationResource() {
        if (this.configurationResource == null || this.configurationResource == "") {
            this.configurationResource = "TN5250JDefaults.props";
            this.usingDefaults = true;
        }
        return this.configurationResource;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void firePropertyChange(Object object, String string, Object object2, Object object3) {
        if (object2 != null && object3 != null && object2.equals(object3)) {
            return;
        }
        this.sessionCfglistenersLock.readLock().lock();
        try {
            if (this.sessionCfglisteners != null) {
                SessionConfigEvent sessionConfigEvent = new SessionConfigEvent(object, string, object2, object3);
                for (SessionConfigListener sessionConfigListener : this.sessionCfglisteners) {
                    sessionConfigListener.onConfigChanged(sessionConfigEvent);
                }
            }
        }
        finally {
            this.sessionCfglistenersLock.readLock().unlock();
        }
    }

    public Properties getProperties() {
        return this.sesProps;
    }

    public void setSessionProps(Properties properties) {
        this.sesProps.putAll((Map<?, ?>)properties);
    }

    public void setModified() {
        this.sesProps.setProperty("saveme", "");
    }

    public void saveSessionProps(Container container) {
        if (this.sesProps.containsKey("saveme")) {
            this.sesProps.remove("saveme");
            Object[] objectArray = new Object[]{this.getConfigurationResource()};
            String string = MessageFormat.format(LangTool.getString("messages.saveSettings"), objectArray);
            int n = JOptionPane.showConfirmDialog(container, string);
            if (n == 0) {
                this.saveSessionProps();
            }
        }
    }

    public void saveSessionProps() {
        if (this.usingDefaults) {
            ConfigureFactory.getInstance().saveSettings("dfltSessionProps", this.getConfigurationResource(), "");
        } else {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.settingsDirectory() + this.getConfigurationResource());
                this.sesProps.store(fileOutputStream, "------ Defaults --------");
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void loadConfigurationResource() {
        this.sesProps = new Properties();
        if (this.configurationResource == null || this.configurationResource == "") {
            this.configurationResource = "TN5250JDefaults.props";
            this.usingDefaults = true;
            this.loadDefaults();
        } else {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.settingsDirectory() + this.getConfigurationResource());
                this.sesProps.load(fileInputStream);
                if (this.sesProps.size() == 0) {
                    this.loadDefaults();
                }
            }
            catch (IOException iOException) {
                System.out.println("Information Message: Properties file is being created for first time use:  File name " + this.getConfigurationResource());
                this.loadDefaults();
            }
            catch (SecurityException securityException) {
                System.out.println(securityException.getMessage());
            }
        }
    }

    private String settingsDirectory() {
        return ConfigureFactory.getInstance().getProperty("emulator.settingsDirectory");
    }

    private void loadDefaults() {
        try {
            this.sesProps = ConfigureFactory.getInstance().getProperties("dfltSessionProps", this.getConfigurationResource(), true, "Default Settings");
            if (this.sesProps.size() == 0) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                URL uRL = classLoader.getResource(this.getConfigurationResource());
                Properties properties = new Properties();
                properties.load(uRL.openStream());
                this.sesProps.putAll((Map<?, ?>)properties);
                uRL = classLoader.getResource("tn5250jSchemas.properties");
                Properties properties2 = new Properties();
                properties2.load(uRL.openStream());
                String string = properties2.getProperty("schemaDefault");
                this.sesProps.setProperty("colorBg", properties2.getProperty(string + ".colorBg"));
                this.sesProps.setProperty("colorRed", properties2.getProperty(string + ".colorRed"));
                this.sesProps.setProperty("colorTurq", properties2.getProperty(string + ".colorTurq"));
                this.sesProps.setProperty("colorCursor", properties2.getProperty(string + ".colorCursor"));
                this.sesProps.setProperty("colorGUIField", properties2.getProperty(string + ".colorGUIField"));
                this.sesProps.setProperty("colorWhite", properties2.getProperty(string + ".colorWhite"));
                this.sesProps.setProperty("colorYellow", properties2.getProperty(string + ".colorYellow"));
                this.sesProps.setProperty("colorGreen", properties2.getProperty(string + ".colorGreen"));
                this.sesProps.setProperty("colorPink", properties2.getProperty(string + ".colorPink"));
                this.sesProps.setProperty("colorBlue", properties2.getProperty(string + ".colorBlue"));
                this.sesProps.setProperty("colorSep", properties2.getProperty(string + ".colorSep"));
                this.sesProps.setProperty("colorHexAttr", properties2.getProperty(string + ".colorHexAttr"));
                this.sesProps.setProperty("font", GUIGraphicsUtils.getDefaultFont());
                ConfigureFactory.getInstance().saveSettings("dfltSessionProps", this.getConfigurationResource(), "");
            }
        }
        catch (IOException iOException) {
            System.out.println("Information Message: Properties file is being created for first time use:  File name " + this.getConfigurationResource());
        }
        catch (SecurityException securityException) {
            System.out.println(securityException.getMessage());
        }
    }

    public boolean isPropertyExists(String string) {
        return this.sesProps.containsKey(string);
    }

    public String getStringProperty(String string) {
        if (this.sesProps.containsKey(string)) {
            return (String)this.sesProps.get(string);
        }
        return "";
    }

    public int getIntegerProperty(String string) {
        if (this.sesProps.containsKey(string)) {
            try {
                int n = Integer.parseInt((String)this.sesProps.get(string));
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return 0;
    }

    public Color getColorProperty(String string) {
        if (this.sesProps.containsKey(string)) {
            Color color = new Color(this.getIntegerProperty(string));
            return color;
        }
        return null;
    }

    public Rectangle getRectangleProperty(String string) {
        Rectangle rectangle = new Rectangle();
        if (this.sesProps.containsKey(string)) {
            String string2 = this.sesProps.getProperty(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            if (stringTokenizer.hasMoreTokens()) {
                rectangle.x = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                rectangle.y = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                rectangle.width = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                rectangle.height = Integer.parseInt(stringTokenizer.nextToken());
            }
        }
        return rectangle;
    }

    public void setRectangleProperty(String string, Rectangle rectangle) {
        String string2 = rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height;
        this.sesProps.setProperty(string, string2);
    }

    public float getFloatProperty(String string) {
        if (this.sesProps.containsKey(string)) {
            float f = Float.parseFloat((String)this.sesProps.get(string));
            return f;
        }
        return 0.0f;
    }

    public Object setProperty(String string, String string2) {
        return this.sesProps.setProperty(string, string2);
    }

    public Object removeProperty(String string) {
        return this.sesProps.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addSessionConfigListener(SessionConfigListener sessionConfigListener) {
        this.sessionCfglistenersLock.writeLock().lock();
        try {
            if (this.sessionCfglisteners == null) {
                this.sessionCfglisteners = new ArrayList<SessionConfigListener>(3);
            }
            this.sessionCfglisteners.add(sessionConfigListener);
        }
        finally {
            this.sessionCfglistenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeSessionConfigListener(SessionConfigListener sessionConfigListener) {
        this.sessionCfglistenersLock.writeLock().lock();
        try {
            if (this.sessionCfglisteners != null) {
                this.sessionCfglisteners.remove(sessionConfigListener);
            }
        }
        finally {
            this.sessionCfglistenersLock.writeLock().unlock();
        }
    }
}

