/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.tn5250j.GuiGraphicBuffer;
import org.tn5250j.KeyPad;
import org.tn5250j.PrinterThread;
import org.tn5250j.RubberBand;
import org.tn5250j.RubberBandCanvasIF;
import org.tn5250j.Session5250;
import org.tn5250j.SessionAttributes;
import org.tn5250j.SessionConfig;
import org.tn5250j.SessionPopup;
import org.tn5250j.SessionScroller;
import org.tn5250j.event.EmulatorActionEvent;
import org.tn5250j.event.EmulatorActionListener;
import org.tn5250j.event.SessionChangeEvent;
import org.tn5250j.event.SessionConfigEvent;
import org.tn5250j.event.SessionConfigListener;
import org.tn5250j.event.SessionJumpEvent;
import org.tn5250j.event.SessionJumpListener;
import org.tn5250j.event.SessionListener;
import org.tn5250j.framework.tn5250.Rect;
import org.tn5250j.framework.tn5250.Screen5250;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.gui.ConfirmTabCloseDialog;
import org.tn5250j.keyboard.KeyboardHandler;
import org.tn5250j.mailtools.SendEMailDialog;
import org.tn5250j.spoolfile.SpoolExporter;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.Macronizer;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class SessionPanel
extends JPanel
implements ComponentListener,
ActionListener,
RubberBandCanvasIF,
SessionConfigListener,
SessionListener {
    private static final long serialVersionUID = 1L;
    private boolean firstScreen;
    private char[] signonSave;
    private BorderLayout borderLayout1 = new BorderLayout();
    private Screen5250 screen;
    protected Session5250 session;
    private GuiGraphicBuffer guiGraBuf;
    protected TNRubberBand rubberband;
    private JPanel s = new JPanel();
    private KeyPad keyPad = new KeyPad();
    private String newMacName;
    private Vector<SessionJumpListener> listeners = null;
    private Vector<EmulatorActionListener> actionListeners = null;
    private SessionJumpEvent jumpEvent;
    private boolean macroRunning;
    private boolean stopMacro;
    private boolean doubleClick;
    protected SessionConfig sesConfig;
    protected KeyboardHandler keyHandler;
    protected final SessionScroller scroller = new SessionScroller();
    private final TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public SessionPanel(Session5250 session5250) {
        this.session = session5250;
        this.sesConfig = session5250.getConfiguration();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            this.log.warn("Error in constructor: " + exception.getMessage());
        }
        session5250.getConfiguration().addSessionConfigListener(this);
        session5250.addSessionListener(this);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.s.setOpaque(false);
        this.s.setDoubleBuffered(false);
        this.session.setGUI(this);
        this.screen = this.session.getScreen();
        this.addComponentListener(this);
        if (this.guiGraBuf == null) {
            this.checkOffScreenImage();
        }
        this.setRubberBand(new TNRubberBand(this));
        this.keyHandler = KeyboardHandler.getKeyboardHandlerInstance(this.session);
        if (!this.sesConfig.isPropertyExists("width") || !this.sesConfig.isPropertyExists("height")) {
            this.setSize(this.guiGraBuf.getPreferredSize());
        } else {
            this.setSize(this.sesConfig.getIntegerProperty("width"), this.sesConfig.getIntegerProperty("height"));
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    SessionPanel.this.actionPopup(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                if (mouseEvent.getClickCount() == 2 & SessionPanel.this.doubleClick) {
                    SessionPanel.this.screen.sendKeys("[enter]");
                } else {
                    boolean bl;
                    int n = SessionPanel.this.guiGraBuf.getPosFromView(mouseEvent.getX(), mouseEvent.getY());
                    if (SessionPanel.this.log.isDebugEnabled()) {
                        SessionPanel.this.log.debug(SessionPanel.this.screen.getRow(n) + "," + SessionPanel.this.screen.getCol(n));
                        SessionPanel.this.log.debug(mouseEvent.getX() + "," + mouseEvent.getY() + "," + ((SessionPanel)SessionPanel.this).guiGraBuf.columnWidth + "," + ((SessionPanel)SessionPanel.this).guiGraBuf.rowHeight);
                    }
                    if (bl = SessionPanel.this.screen.moveCursor(n)) {
                        if (SessionPanel.this.rubberband.isAreaSelected()) {
                            SessionPanel.this.rubberband.reset();
                        }
                        SessionPanel.this.screen.repaintScreen();
                    }
                    SessionPanel.this.getFocusForMe();
                }
            }
        });
        if (this.sesConfig.getStringProperty("mouseWheel").equals("Yes")) {
            this.scroller.addMouseWheelListener(this);
        }
        this.log.debug("Initializing macros");
        Macronizer.init();
        this.keyPad.addActionListener(this);
        if (this.sesConfig.getStringProperty("keypad").equals("Yes")) {
            this.keyPad.setVisible(true);
        } else {
            this.keyPad.setVisible(false);
        }
        this.add((Component)this.keyPad, "South");
        this.add((Component)this.s, "Center");
        this.requestFocus();
        this.jumpEvent = new SessionJumpEvent(this);
        this.doubleClick = this.sesConfig.getStringProperty("doubleClick").equals("Yes");
    }

    public void setRunningHeadless(boolean bl) {
        if (bl) {
            this.screen.getOIA().removeOIAListener(this.guiGraBuf);
            this.screen.removeScreenListener(this.guiGraBuf);
        } else {
            this.screen.getOIA().addOIAListener(this.guiGraBuf);
            this.screen.addScreenListener(this.guiGraBuf);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        this.keyHandler.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed()) {
            super.processKeyEvent(keyEvent);
        }
    }

    public void sendScreenEMail() {
        new SendEMailDialog((JFrame)SwingUtilities.getRoot(this), this);
    }

    public void doKeyBoundArea(KeyEvent keyEvent, String string) {
        MouseEvent mouseEvent;
        Point point = new Point();
        if (!this.rubberband.isAreaSelected()) {
            if (string.equals("[markleft]")) {
                this.guiGraBuf.getPointFromRowCol(this.screen.getCurrentRow() - 1, this.screen.getCurrentCol() + 1, point);
            }
            if (string.equals("[markright]")) {
                this.guiGraBuf.getPointFromRowCol(this.screen.getCurrentRow() - 1, this.screen.getCurrentCol() - 2, point);
            }
            if (string.equals("[markup]")) {
                this.guiGraBuf.getPointFromRowCol(this.screen.getCurrentRow() + 1, this.screen.getCurrentCol() - 1, point);
            }
            if (string.equals("[markdown]")) {
                this.guiGraBuf.getPointFromRowCol(this.screen.getCurrentRow() - 2, this.screen.getCurrentCol() - 1, point);
            }
            mouseEvent = new MouseEvent(this, 501, System.currentTimeMillis(), 16, point.x, point.y, 1, false);
            this.dispatchEvent(mouseEvent);
        }
        this.guiGraBuf.getPointFromRowCol(this.screen.getCurrentRow() - 1, this.screen.getCurrentCol() - 1, point);
        mouseEvent = new MouseEvent(this, 506, System.currentTimeMillis(), 16, point.x, point.y, 1, false);
        this.dispatchEvent(mouseEvent);
    }

    public boolean confirmCloseSession(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !this.isConnected() || this.confirmTabClose();
        if (bl2) {
            boolean bl4 = bl2 = this.isOnSignOnScreen() || this.confirmSignOffClose();
        }
        if (bl2 && bl) {
            this.fireEmulatorAction(1);
        }
        return bl2;
    }

    private boolean confirmTabClose() {
        boolean bl = true;
        if (this.session.getConfiguration().isPropertyExists("confirmTabClose")) {
            this.requestFocus();
            ConfirmTabCloseDialog confirmTabCloseDialog = new ConfirmTabCloseDialog(this);
            if (this.session.getConfiguration().getStringProperty("confirmTabClose").equals("Yes") && !confirmTabCloseDialog.show()) {
                bl = false;
            }
        }
        return bl;
    }

    private boolean confirmSignOffClose() {
        if (this.sesConfig.isPropertyExists("confirmSignoff") && this.sesConfig.getStringProperty("confirmSignoff").equals("Yes")) {
            this.requestFocus();
            int n = JOptionPane.showConfirmDialog(this.getParent(), LangTool.getString("messages.signOff"), LangTool.getString("cs.title"), 2);
            return n == 0;
        }
        return true;
    }

    public void getFocusForMe() {
        this.grabFocus();
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    public JPanel getDrawingCanvas() {
        return this.s;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = ((JButton)object).getActionCommand();
        if (string.equals("NXTPAD")) {
            this.keyPad.nextPad();
        } else {
            this.screen.sendKeys(string);
        }
        this.getFocusForMe();
    }

    @Override
    public void onConfigChanged(SessionConfigEvent sessionConfigEvent) {
        String string = sessionConfigEvent.getPropertyName();
        if (string.equals("keypad")) {
            if (((String)sessionConfigEvent.getNewValue()).equals("Yes")) {
                this.keyPad.setVisible(true);
            } else {
                this.keyPad.setVisible(false);
            }
            this.validate();
        }
        if (string.equals("doubleClick")) {
            this.doubleClick = ((String)sessionConfigEvent.getNewValue()).equals("Yes");
        }
        if (string.equals("mouseWheel")) {
            if (((String)sessionConfigEvent.getNewValue()).equals("Yes")) {
                this.scroller.addMouseWheelListener(this);
            } else {
                this.scroller.removeMouseWheelListener(this);
            }
        }
        this.resizeMe();
        this.repaint();
    }

    public tnvt getVT() {
        return this.session.getVT();
    }

    public void toggleDebug() {
        this.session.getVT().toggleDebug();
    }

    public void startNewSession() {
        this.fireEmulatorAction(2);
    }

    public void startDuplicateSession() {
        this.fireEmulatorAction(4);
    }

    public void sendAidKey(int n) {
        this.session.getVT().sendAidKey(n);
    }

    public void toggleConnection() {
        if (this.isConnected()) {
            boolean bl;
            boolean bl2 = bl = this.confirmTabClose() && (this.isOnSignOnScreen() || this.confirmSignOffClose());
            if (bl) {
                this.session.getVT().disconnect();
            }
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SessionPanel.this.session.getVT().connect();
                }
            };
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.start();
        }
    }

    public void nextSession() {
        this.fireSessionJump(1);
    }

    public void prevSession() {
        this.fireSessionJump(0);
    }

    protected void fireSessionJump(int n) {
        if (this.listeners != null) {
            int n2 = this.listeners.size();
            for (int i = 0; i < n2; ++i) {
                SessionJumpListener sessionJumpListener = this.listeners.elementAt(i);
                this.jumpEvent.setJumpDirection(n);
                sessionJumpListener.onSessionJump(this.jumpEvent);
            }
        }
    }

    protected void fireEmulatorAction(int n) {
        if (this.actionListeners != null) {
            int n2 = this.actionListeners.size();
            for (int i = 0; i < n2; ++i) {
                EmulatorActionListener emulatorActionListener = this.actionListeners.elementAt(i);
                EmulatorActionEvent emulatorActionEvent = new EmulatorActionEvent(this);
                emulatorActionEvent.setAction(n);
                emulatorActionListener.onEmulatorAction(emulatorActionEvent);
            }
        }
    }

    public boolean isMacroRunning() {
        return this.macroRunning;
    }

    public boolean isStopMacroRequested() {
        return this.stopMacro;
    }

    public boolean isSessionRecording() {
        return this.keyHandler.isRecording();
    }

    public void setMacroRunning(boolean bl) {
        this.macroRunning = bl;
        if (this.macroRunning) {
            this.screen.getOIA().setScriptActive(true);
        } else {
            this.screen.getOIA().setScriptActive(false);
        }
        this.stopMacro = !this.macroRunning;
    }

    public void setStopMacroRequested() {
        this.setMacroRunning(false);
    }

    public void closeDown() {
        this.sesConfig.saveSessionProps(this.getParent());
        if (this.session.getVT() != null) {
            this.session.getVT().disconnect();
        }
        this.keyHandler.sessionClosed(this);
        this.keyHandler = null;
    }

    public void actionAttributes() {
        SessionAttributes sessionAttributes = new SessionAttributes((Frame)SwingUtilities.getRoot(this), this.sesConfig);
        sessionAttributes.showIt();
        this.getFocusForMe();
        sessionAttributes = null;
    }

    private void actionPopup(MouseEvent mouseEvent) {
        new SessionPopup(this, mouseEvent);
    }

    public void actionSpool() {
        try {
            SpoolExporter spoolExporter = new SpoolExporter(this.session.getVT(), this);
            spoolExporter.setVisible(true);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            JOptionPane.showMessageDialog(this, LangTool.getString("messages.noAS400Toolbox"), "Error", 0, null);
        }
    }

    public void executeMacro(ActionEvent actionEvent) {
        this.executeMacro(actionEvent.getActionCommand());
    }

    public void executeMacro(String string) {
        Macronizer.invoke(string, this);
    }

    protected void stopRecordingMe() {
        if (this.keyHandler.getRecordBuffer().length() > 0) {
            Macronizer.setMacro(this.newMacName, this.keyHandler.getRecordBuffer());
            this.log.debug(this.keyHandler.getRecordBuffer());
        }
        this.keyHandler.stopRecording();
    }

    protected void startRecordingMe() {
        String string = JOptionPane.showInputDialog(null, LangTool.getString("macro.message"), LangTool.getString("macro.title"), -1);
        if (string != null && (string = string.trim()).length() > 0) {
            this.log.info(string);
            this.newMacName = string;
            this.keyHandler.startRecording();
        }
    }

    void resizeMe() {
        Rectangle rectangle = this.getDrawingBounds();
        if (this.guiGraBuf != null) {
            this.guiGraBuf.resizeScreenArea(rectangle.width, rectangle.height);
        }
        this.screen.repaintScreen();
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            graphics.setClip(0, 0, this.getWidth(), this.getHeight());
        }
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }

    public Rectangle getDrawingBounds() {
        Rectangle rectangle = this.getBounds();
        if (this.keyPad != null && this.keyPad.isVisible()) {
            rectangle.height -= this.keyPad.getHeight();
        }
        rectangle.setSize(rectangle.width, rectangle.height);
        return rectangle;
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.resizeMe();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        this.log.debug("paint from screen");
        if (this.guiGraBuf == null) {
            this.checkOffScreenImage();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.rubberband.isAreaSelected() && !this.rubberband.isDragging()) {
            this.rubberband.erase();
        }
        graphics2D.setColor(this.guiGraBuf.colorBg);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.guiGraBuf.drawImageBuffer(graphics2D);
        if (this.rubberband.isAreaSelected() && !this.rubberband.isDragging()) {
            this.rubberband.draw();
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.log.info("update paint from gui");
        this.paint(graphics);
    }

    public boolean isHotSpots() {
        return this.guiGraBuf.hotSpots;
    }

    public void toggleHotSpots() {
        this.guiGraBuf.hotSpots = !this.guiGraBuf.hotSpots;
    }

    public void crossHair() {
        this.screen.setCursorActive(false);
        ++this.guiGraBuf.crossHair;
        if (this.guiGraBuf.crossHair > 3) {
            this.guiGraBuf.crossHair = 0;
        }
        this.screen.setCursorActive(true);
    }

    private void checkOffScreenImage() {
        if (this.guiGraBuf == null) {
            this.guiGraBuf = new GuiGraphicBuffer(this.screen, this, this.sesConfig);
            this.guiGraBuf.getImageBuffer(0, 0);
        }
    }

    public final void actionCopy() {
        Rect rect = this.getBoundingArea();
        this.rubberband.reset();
        this.screen.repaintScreen();
        String string = this.screen.copyText(rect);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, null);
    }

    protected final Vector<Double> sumThem(boolean bl) {
        this.log.debug("Summing");
        return this.screen.sumThem(bl, this.getBoundingArea());
    }

    public final void printMe() {
        PrinterThread printerThread = new PrinterThread(this.screen, this.guiGraBuf.font, this.screen.getColumns(), this.screen.getRows(), Color.black, true, this);
        printerThread.start();
    }

    public synchronized void addSessionJumpListener(SessionJumpListener sessionJumpListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(3);
        }
        this.listeners.addElement(sessionJumpListener);
    }

    public synchronized void removeSessionJumpListener(SessionJumpListener sessionJumpListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(sessionJumpListener);
    }

    public synchronized void addEmulatorActionListener(EmulatorActionListener emulatorActionListener) {
        if (this.actionListeners == null) {
            this.actionListeners = new Vector(3);
        }
        this.actionListeners.addElement(emulatorActionListener);
    }

    public synchronized void removeEmulatorActionListener(EmulatorActionListener emulatorActionListener) {
        if (this.actionListeners == null) {
            return;
        }
        this.actionListeners.removeElement(emulatorActionListener);
    }

    @Override
    public Graphics getDrawingGraphics() {
        return this.guiGraBuf.getDrawingArea();
    }

    protected final void setRubberBand(TNRubberBand tNRubberBand) {
        this.rubberband = tNRubberBand;
    }

    public Rect getBoundingArea() {
        Rectangle rectangle = new Rectangle();
        this.guiGraBuf.getBoundingArea(rectangle);
        Rect rect = new Rect();
        rect.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return rect;
    }

    @Override
    public Point translateStart(Point point) {
        return this.guiGraBuf.translateStart(point);
    }

    @Override
    public Point translateEnd(Point point) {
        return this.guiGraBuf.translateEnd(point);
    }

    public int getPosFromView(int n, int n2) {
        return this.guiGraBuf.getPosFromView(n, n2);
    }

    public void getBoundingArea(Rectangle rectangle) {
        this.guiGraBuf.getBoundingArea(rectangle);
    }

    @Override
    public void areaBounded(RubberBand rubberBand, int n, int n2, int n3, int n4) {
        this.repaint();
        if (this.log.isDebugEnabled()) {
            this.log.debug(" bound " + rubberBand.getEndPoint());
        }
    }

    @Override
    public boolean canDrawRubberBand(RubberBand rubberBand) {
        return this.guiGraBuf.isWithinScreenArea(rubberBand.getStartPoint().x, rubberBand.getStartPoint().y);
    }

    public Session5250 getSession() {
        return this.session;
    }

    public void setSession(Session5250 session5250) {
        this.session = session5250;
    }

    public boolean isConnected() {
        return this.session.getVT() != null && this.session.getVT().isConnected();
    }

    public boolean isOnSignOnScreen() {
        if (this.firstScreen) {
            char[] cArray = this.screen.getScreenAsChars();
            Rectangle rectangle = this.sesConfig.getRectangleProperty("signOnRegion");
            int n = rectangle.x;
            int n2 = rectangle.y;
            int n3 = rectangle.width;
            int n4 = rectangle.height;
            if (n == 0) {
                n = 1;
            }
            if (n2 == 0) {
                n2 = 1;
            }
            if (n3 == 0) {
                n3 = 24;
            }
            if (n4 == 0) {
                n4 = 80;
            }
            int n5 = 0;
            for (int i = n; i <= n3; ++i) {
                for (int j = n2; j <= n4; ++j) {
                    n5 = this.screen.getPos(i - 1, j - 1);
                    if (this.signonSave[n5] == cArray[n5]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public String getSessionName() {
        return this.session.getSessionName();
    }

    public String getAllocDeviceName() {
        if (this.session.getVT() != null) {
            return this.session.getVT().getAllocatedDeviceName();
        }
        return null;
    }

    public String getHostName() {
        if (this.session.getVT() != null) {
            return this.session.getVT().getHostName();
        }
        return this.session.getConnectionProperties().getProperty("SESSION_HOST");
    }

    public Screen5250 getScreen() {
        return this.screen;
    }

    public void connect() {
        this.session.connect();
    }

    public void disconnect() {
        this.session.disconnect();
    }

    @Override
    public void onSessionChanged(SessionChangeEvent sessionChangeEvent) {
        switch (sessionChangeEvent.getState()) {
            case 1: {
                String string;
                if (!this.firstScreen) {
                    this.firstScreen = true;
                    this.signonSave = this.screen.getScreenAsChars();
                }
                if ((string = this.sesConfig.getStringProperty("connectMacro")).length() <= 0) break;
                this.executeMacro(string);
                break;
            }
            default: {
                this.firstScreen = false;
                this.signonSave = null;
            }
        }
    }

    public synchronized void addSessionListener(SessionListener sessionListener) {
        this.session.addSessionListener(sessionListener);
    }

    public synchronized void removeSessionListener(SessionListener sessionListener) {
        this.session.removeSessionListener(sessionListener);
    }

    public class TNRubberBand
    extends RubberBand {
        public TNRubberBand(RubberBandCanvasIF rubberBandCanvasIF) {
            super(rubberBandCanvasIF);
        }

        @Override
        protected void drawBoundingShape(Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.drawRect(n, n2, n3, n4);
        }

        protected Rectangle getBoundingArea() {
            Rectangle rectangle = new Rectangle();
            this.getBoundingArea(rectangle);
            return rectangle;
        }

        protected void getBoundingArea(Rectangle rectangle) {
            if (this.getEndPoint().x > this.getStartPoint().x && this.getEndPoint().y > this.getStartPoint().y) {
                rectangle.setBounds(this.getStartPoint().x, this.getStartPoint().y, this.getEndPoint().x - this.getStartPoint().x, this.getEndPoint().y - this.getStartPoint().y);
            } else if (this.getEndPoint().x < this.getStartPoint().x && this.getEndPoint().y < this.getStartPoint().y) {
                rectangle.setBounds(this.getEndPoint().x, this.getEndPoint().y, this.getStartPoint().x - this.getEndPoint().x, this.getStartPoint().y - this.getEndPoint().y);
            } else if (this.getEndPoint().x > this.getStartPoint().x && this.getEndPoint().y < this.getStartPoint().y) {
                rectangle.setBounds(this.getStartPoint().x, this.getEndPoint().y, this.getEndPoint().x - this.getStartPoint().x, this.getStartPoint().y - this.getEndPoint().y);
            } else if (this.getEndPoint().x < this.getStartPoint().x && this.getEndPoint().y > this.getStartPoint().y) {
                rectangle.setBounds(this.getEndPoint().x, this.getStartPoint().y, this.getStartPoint().x - this.getEndPoint().x, this.getEndPoint().y - this.getStartPoint().y);
            }
        }

        @Override
        protected Point getEndPoint() {
            if (this.endPoint == null) {
                Point point = new Point(0, 0);
                SessionPanel.this.guiGraBuf.getPointFromRowCol(0, 0, point);
                this.setEndPoint(point);
            }
            return this.endPoint;
        }

        @Override
        protected Point getStartPoint() {
            if (this.startPoint == null) {
                Point point = new Point(0, 0);
                SessionPanel.this.guiGraBuf.getPointFromRowCol(0, 0, point);
                this.setStartPoint(point);
            }
            return this.startPoint;
        }
    }
}

