/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j;

import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.tn5250j.SessionPanel;
import org.tn5250j.framework.tn5250.Screen5250;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.gui.HexCharMapDialog;
import org.tn5250j.interfaces.OptionAccessFactory;
import org.tn5250j.keyboard.configure.KeyConfigure;
import org.tn5250j.mailtools.SendEMailDialog;
import org.tn5250j.spoolfile.SpoolExporter;
import org.tn5250j.tools.GUIGraphicsUtils;
import org.tn5250j.tools.LangTool;
import org.tn5250j.tools.LoadMacroMenu;
import org.tn5250j.tools.Macronizer;
import org.tn5250j.tools.SendScreenImageToFile;
import org.tn5250j.tools.SendScreenToFile;
import org.tn5250j.tools.XTFRFile;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class SessionPopup {
    private final Screen5250 screen;
    private final SessionPanel sessiongui;
    private final tnvt vt;
    private final TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public SessionPopup(SessionPanel sessionPanel, MouseEvent mouseEvent) {
        AbstractAction abstractAction;
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.sessiongui = sessionPanel;
        this.vt = this.sessiongui.getSession().getVT();
        this.screen = this.sessiongui.getScreen();
        final int n = this.sessiongui.getPosFromView(mouseEvent.getX(), mouseEvent.getY());
        if (!this.sessiongui.rubberband.isAreaSelected() && this.screen.isInField(n, false)) {
            abstractAction = new AbstractAction(LangTool.getString("popup.copy")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = SessionPopup.this.screen.copyTextField(n);
                    StringSelection stringSelection = new StringSelection(string);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, null);
                    SessionPopup.this.sessiongui.getFocusForMe();
                }
            };
            jPopupMenu.add(this.createMenuItem(abstractAction, "[copy]"));
            abstractAction = new AbstractAction(LangTool.getString("popup.paste")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SessionPopup.this.paste(false);
                }
            };
            jPopupMenu.add(this.createMenuItem(abstractAction, "[paste]"));
            abstractAction = new AbstractAction(LangTool.getString("popup.pasteSpecial")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SessionPopup.this.paste(true);
                }
            };
            jPopupMenu.add(abstractAction);
            jPopupMenu.addSeparator();
            abstractAction = new AbstractAction(LangTool.getString("popup.hexMap")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SessionPopup.this.showHexMap();
                    SessionPopup.this.sessiongui.getFocusForMe();
                }
            };
            jPopupMenu.add(this.createMenuItem(abstractAction, ""));
            jPopupMenu.addSeparator();
        } else {
            JMenu jMenu;
            JMenu jMenu2;
            abstractAction = new AbstractAction(LangTool.getString("popup.copy")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SessionPopup.this.sessiongui.actionCopy();
                    SessionPopup.this.sessiongui.getFocusForMe();
                }
            };
            jPopupMenu.add(this.createMenuItem(abstractAction, "[copy]"));
            abstractAction = new AbstractAction(LangTool.getString("popup.paste")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SessionPopup.this.paste(false);
                }
            };
            jPopupMenu.add(this.createMenuItem(abstractAction, "[paste]"));
            abstractAction = new AbstractAction(LangTool.getString("popup.pasteSpecial")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SessionPopup.this.paste(true);
                }
            };
            jPopupMenu.add(abstractAction);
            Rectangle rectangle = new Rectangle();
            if (this.sessiongui.rubberband.isAreaSelected()) {
                this.sessiongui.getBoundingArea(rectangle);
                jPopupMenu.addSeparator();
                JMenuItem jMenuItem = new JMenuItem(LangTool.getString("popup.selectedColumns") + " " + rectangle.width);
                jMenuItem.setArmed(false);
                jPopupMenu.add(jMenuItem);
                jMenuItem = new JMenuItem(LangTool.getString("popup.selectedRows") + " " + rectangle.height);
                jMenuItem.setArmed(false);
                jPopupMenu.add(jMenuItem);
                jMenu2 = new JMenu(LangTool.getString("popup.calc"));
                jPopupMenu.add(jMenu2);
                abstractAction = new AbstractAction(LangTool.getString("popup.calcGroupCD")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SessionPopup.this.sumArea(true);
                    }
                };
                jMenu2.add(abstractAction);
                abstractAction = new AbstractAction(LangTool.getString("popup.calcGroupDC")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SessionPopup.this.sumArea(false);
                    }
                };
                jMenu2.add(abstractAction);
            }
            jPopupMenu.addSeparator();
            abstractAction = new AbstractAction(LangTool.getString("popup.printScreen")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SessionPopup.this.sessiongui.printMe();
                    SessionPopup.this.sessiongui.getFocusForMe();
                }
            };
            jPopupMenu.add(this.createMenuItem(abstractAction, "[print]"));
            jPopupMenu.addSeparator();
            jMenu2 = new JMenu(LangTool.getString("popup.keyboard"));
            jPopupMenu.add(jMenu2);
            abstractAction = new AbstractAction(LangTool.getString("popup.mapKeys")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SessionPopup.this.mapMeKeys();
                }
            };
            jMenu2.add(abstractAction);
            jMenu2.addSeparator();
            this.createKeyboardItem(jMenu2, "[attn]");
            this.createKeyboardItem(jMenu2, "[reset]");
            this.createKeyboardItem(jMenu2, "[sysreq]");
            if (this.screen.getOIA().isMessageWait() && OptionAccessFactory.getInstance().isValidOption("[dspmsgs]")) {
                abstractAction = new AbstractAction(LangTool.getString("popup.displayMessages")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SessionPopup.this.vt.systemRequest('4');
                    }
                };
                jMenu2.add(this.createMenuItem(abstractAction, "[dspmsgs]"));
            }
            jMenu2.addSeparator();
            this.createKeyboardItem(jMenu2, "[dupfield]");
            this.createKeyboardItem(jMenu2, "[help]");
            this.createKeyboardItem(jMenu2, "[eraseeof]");
            this.createKeyboardItem(jMenu2, "[field+]");
            this.createKeyboardItem(jMenu2, "[field-]");
            this.createKeyboardItem(jMenu2, "[newline]");
            if (OptionAccessFactory.getInstance().isValidOption("[hostprint]")) {
                abstractAction = new AbstractAction(LangTool.getString("popup.hostPrint")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SessionPopup.this.vt.hostPrint(1);
                    }
                };
                jMenu2.add(this.createMenuItem(abstractAction, "[hostprint]"));
            }
            this.createShortCutItems(jMenu2);
            if (this.screen.getOIA().isMessageWait() && OptionAccessFactory.getInstance().isValidOption("[dspmsgs]")) {
                abstractAction = new AbstractAction(LangTool.getString("popup.displayMessages")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SessionPopup.this.vt.systemRequest('4');
                    }
                };
                jPopupMenu.add(this.createMenuItem(abstractAction, "[dspmsgs]"));
            }
            jPopupMenu.addSeparator();
            abstractAction = new AbstractAction(LangTool.getString("popup.hexMap")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SessionPopup.this.showHexMap();
                    SessionPopup.this.sessiongui.getFocusForMe();
                }
            };
            jPopupMenu.add(this.createMenuItem(abstractAction, ""));
            abstractAction = new AbstractAction(LangTool.getString("popup.mapKeys")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SessionPopup.this.mapMeKeys();
                    SessionPopup.this.sessiongui.getFocusForMe();
                }
            };
            jPopupMenu.add(this.createMenuItem(abstractAction, ""));
            if (OptionAccessFactory.getInstance().isValidOption("[dspattr]")) {
                abstractAction = new AbstractAction(LangTool.getString("popup.settings")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SessionPopup.this.sessiongui.actionAttributes();
                        SessionPopup.this.sessiongui.getFocusForMe();
                    }
                };
                jPopupMenu.add(this.createMenuItem(abstractAction, "[dspattr]"));
            }
            jPopupMenu.addSeparator();
            if (this.sessiongui.isMacroRunning()) {
                abstractAction = new AbstractAction(LangTool.getString("popup.stopScript")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SessionPopup.this.sessiongui.setStopMacroRequested();
                    }
                };
                jPopupMenu.add(abstractAction);
            } else {
                jMenu = new JMenu(LangTool.getString("popup.macros"));
                abstractAction = this.sessiongui.isSessionRecording() ? new AbstractAction(LangTool.getString("popup.stop")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SessionPopup.this.sessiongui.stopRecordingMe();
                        SessionPopup.this.sessiongui.getFocusForMe();
                    }
                } : new AbstractAction(LangTool.getString("popup.record")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SessionPopup.this.sessiongui.startRecordingMe();
                        SessionPopup.this.sessiongui.getFocusForMe();
                    }
                };
                jMenu.add(abstractAction);
                if (Macronizer.isMacrosExist()) {
                    this.addMacros(jMenu);
                }
                jPopupMenu.add(jMenu);
            }
            jPopupMenu.addSeparator();
            jMenu = new JMenu(LangTool.getString("popup.export"));
            if (OptionAccessFactory.getInstance().isValidOption("[transfer]")) {
                abstractAction = new AbstractAction(LangTool.getString("popup.xtfrFile")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SessionPopup.this.doMeTransfer();
                        SessionPopup.this.sessiongui.getFocusForMe();
                    }
                };
                jMenu.add(this.createMenuItem(abstractAction, "[transfer]"));
            }
            if (OptionAccessFactory.getInstance().isValidOption("[spoolfile]")) {
                abstractAction = new AbstractAction(LangTool.getString("popup.xtfrSpool")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SessionPopup.this.doMeSpool();
                        SessionPopup.this.sessiongui.getFocusForMe();
                    }
                };
                jMenu.add(abstractAction);
            }
            jPopupMenu.add(jMenu);
            JMenu jMenu3 = new JMenu(LangTool.getString("popup.send"));
            jPopupMenu.add(jMenu3);
            if (OptionAccessFactory.getInstance().isValidOption("[quick-mail]")) {
                abstractAction = new AbstractAction(LangTool.getString("popup.quickmail")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SessionPopup.this.sendQuickEMail();
                        SessionPopup.this.sessiongui.getFocusForMe();
                    }
                };
                jMenu3.add(this.createMenuItem(abstractAction, "[quick-mail]"));
            }
            if (OptionAccessFactory.getInstance().isValidOption("[e-mail]")) {
                abstractAction = new AbstractAction(LangTool.getString("popup.email")){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SessionPopup.this.sendScreenEMail();
                        SessionPopup.this.sessiongui.getFocusForMe();
                    }
                };
                jMenu3.add(this.createMenuItem(abstractAction, "[e-mail]"));
            }
            abstractAction = new AbstractAction(LangTool.getString("popup.file")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SessionPopup.this.sendMeToFile();
                }
            };
            jMenu3.add(abstractAction);
            abstractAction = new AbstractAction(LangTool.getString("popup.toImage")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SessionPopup.this.sendMeToImageFile();
                }
            };
            jMenu3.add(abstractAction);
            jPopupMenu.addSeparator();
        }
        if (OptionAccessFactory.getInstance().isValidOption("[opennew]")) {
            abstractAction = new AbstractAction(LangTool.getString("popup.connections")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SessionPopup.this.sessiongui.startNewSession();
                }
            };
            jPopupMenu.add(this.createMenuItem(abstractAction, "[opennew]"));
        }
        jPopupMenu.addSeparator();
        if (OptionAccessFactory.getInstance().isValidOption("[togcon]")) {
            abstractAction = this.vt.isConnected() ? new AbstractAction(LangTool.getString("popup.disconnect")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SessionPopup.this.sessiongui.toggleConnection();
                    SessionPopup.this.sessiongui.getFocusForMe();
                }
            } : new AbstractAction(LangTool.getString("popup.connect")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SessionPopup.this.sessiongui.toggleConnection();
                    SessionPopup.this.sessiongui.getFocusForMe();
                }
            };
            jPopupMenu.add(this.createMenuItem(abstractAction, "[togcon]"));
        }
        if (OptionAccessFactory.getInstance().isValidOption("[close]")) {
            abstractAction = new AbstractAction(LangTool.getString("popup.close")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SessionPopup.this.sessiongui.confirmCloseSession(true);
                }
            };
            jPopupMenu.add(this.createMenuItem(abstractAction, "[close]"));
        }
        GUIGraphicsUtils.positionPopup(mouseEvent.getComponent(), jPopupMenu, mouseEvent.getX(), mouseEvent.getY());
    }

    private void createKeyboardItem(JMenu jMenu, String string) {
        if (OptionAccessFactory.getInstance().isValidOption(string)) {
            final String string2 = string;
            AbstractAction abstractAction = new AbstractAction(LangTool.getString("key." + string)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SessionPopup.this.screen.sendKeys(string2);
                }
            };
            jMenu.add(this.createMenuItem(abstractAction, string));
        }
    }

    private void addMacros(JMenu jMenu) {
        LoadMacroMenu.loadMacros(this.sessiongui, jMenu);
    }

    private JMenuItem createMenuItem(Action action, String string) {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setAction(action);
        if (this.sessiongui.keyHandler.isKeyStrokeDefined(string)) {
            jMenuItem.setAccelerator(this.sessiongui.keyHandler.getKeyStroke(string));
        } else {
            InputMap inputMap = this.sessiongui.getInputMap();
            KeyStroke[] keyStrokeArray = inputMap.allKeys();
            for (int i = 0; i < keyStrokeArray.length; ++i) {
                if (!((String)inputMap.get(keyStrokeArray[i])).equals(string)) continue;
                jMenuItem.setAccelerator(keyStrokeArray[i]);
                break;
            }
        }
        return jMenuItem;
    }

    private void createShortCutItems(JMenu jMenu) {
        JMenu jMenu2 = new JMenu(LangTool.getString("popup.shortCuts"));
        jMenu.addSeparator();
        jMenu.add(jMenu2);
        InputMap inputMap = this.sessiongui.getInputMap();
        KeyStroke[] keyStrokeArray = inputMap.allKeys();
        ActionMap actionMap = this.sessiongui.getActionMap();
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            JMenuItem jMenuItem = new JMenuItem();
            Action action = actionMap.get(inputMap.get(keyStrokeArray[i]));
            jMenuItem.setAction(action);
            jMenuItem.setText(LangTool.getString("key." + (String)inputMap.get(keyStrokeArray[i])));
            jMenuItem.setAccelerator(keyStrokeArray[i]);
            jMenu2.add(jMenuItem);
        }
    }

    private void sumArea(boolean bl) {
        Vector<Double> vector = this.sessiongui.sumThem(bl);
        Iterator iterator = vector.iterator();
        double d = 0.0;
        double d2 = 0.0;
        while (iterator.hasNext()) {
            d2 = 0.0;
            try {
                d2 = (Double)iterator.next();
            }
            catch (Exception exception) {
                this.log.warn(exception);
            }
            d += d2;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Vector sum " + d);
        }
        vector = null;
        iterator = null;
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        if (bl) {
            decimalFormatSymbols.setDecimalSeparator('.');
            decimalFormatSymbols.setGroupingSeparator(',');
        } else {
            decimalFormatSymbols.setDecimalSeparator(',');
            decimalFormatSymbols.setGroupingSeparator('.');
        }
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        decimalFormat.setMinimumFractionDigits(6);
        JOptionPane.showMessageDialog(null, decimalFormat.format(d), LangTool.getString("popup.calc"), 1);
    }

    private void showHexMap() {
        HexCharMapDialog hexCharMapDialog = new HexCharMapDialog(this.sessiongui, this.vt.getCodePage());
        String string = hexCharMapDialog.showModal();
        if (string != null) {
            this.screen.sendKeys(string);
        }
    }

    private void mapMeKeys() {
        Frame frame = (Frame)SwingUtilities.getRoot(this.sessiongui);
        if (Macronizer.isMacrosExist()) {
            String[] stringArray = Macronizer.getMacroList();
            new KeyConfigure(frame, stringArray, this.vt.getCodePage());
        } else {
            new KeyConfigure(frame, null, this.vt.getCodePage());
        }
    }

    private void doMeTransfer() {
        new XTFRFile((Frame)SwingUtilities.getRoot(this.sessiongui), this.vt, this.sessiongui);
    }

    private void doMeSpool() {
        try {
            SpoolExporter spoolExporter = new SpoolExporter(this.vt, this.sessiongui);
            spoolExporter.setVisible(true);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            JOptionPane.showMessageDialog(this.sessiongui, LangTool.getString("messages.noAS400Toolbox"), "Error", 0, null);
        }
    }

    private void sendScreenEMail() {
        new SendEMailDialog((Frame)SwingUtilities.getRoot(this.sessiongui), this.sessiongui);
    }

    private void sendQuickEMail() {
        new SendEMailDialog((Frame)SwingUtilities.getRoot(this.sessiongui), this.sessiongui, false);
    }

    private void sendMeToFile() {
        SendScreenToFile.showDialog(SwingUtilities.getRoot(this.sessiongui), this.screen);
    }

    private void sendMeToImageFile() {
        new SendScreenImageToFile((Frame)SwingUtilities.getRoot(this.sessiongui), this.sessiongui);
    }

    private void paste(boolean bl) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(this);
            if (transferable != null) {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.screen.pasteText(string, bl);
                this.sessiongui.getFocusForMe();
            }
        }
        catch (HeadlessException headlessException) {
            this.log.debug("HeadlessException", headlessException);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            this.log.debug("the requested data flavor is not supported", unsupportedFlavorException);
        }
        catch (IOException iOException) {
            this.log.debug("data is no longer available in the requested flavor", iOException);
        }
    }
}

