/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.encoding;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.tn5250j.encoding.BuiltInCodePageFactory;
import org.tn5250j.encoding.ICodePage;
import org.tn5250j.encoding.JavaCodePageFactory;
import org.tn5250j.encoding.ToolboxCodePageFactory;

public class CharMappings {
    public static final String DFT_ENC = "37";
    public static final int NATIVE_CP = 0;
    public static final int TOOLBOX_CP = 1;
    private static final HashMap<String, ICodePage> map = new HashMap();

    public static String[] getAvailableCodePages() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : BuiltInCodePageFactory.getInstance().getAvailableCodePages()) {
            hashSet.add(string);
        }
        for (String string : ToolboxCodePageFactory.getInstance().getAvailableCodePages()) {
            hashSet.add(string);
        }
        Object[] objectArray = hashSet.toArray(new String[hashSet.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public static ICodePage getCodePage(String string) {
        if (map.containsKey(string)) {
            return map.get(string);
        }
        ICodePage iCodePage = BuiltInCodePageFactory.getInstance().getCodePage(string);
        if (iCodePage != null) {
            map.put(string, iCodePage);
            return iCodePage;
        }
        iCodePage = ToolboxCodePageFactory.getInstance().getCodePage(string);
        if (iCodePage != null) {
            map.put(string, iCodePage);
            return iCodePage;
        }
        iCodePage = JavaCodePageFactory.getCodePage(string);
        if (iCodePage != null) {
            map.put(string, iCodePage);
            return iCodePage;
        }
        return BuiltInCodePageFactory.getInstance().getCodePage(DFT_ENC);
    }
}

