/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.encoding;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.tn5250j.encoding.AbstractCodePage;
import org.tn5250j.encoding.ICodePage;

class JavaCodePageFactory
extends AbstractCodePage {
    private final CharsetEncoder encoder;
    private final CharsetDecoder decoder;

    JavaCodePageFactory(String string, CharsetEncoder charsetEncoder, CharsetDecoder charsetDecoder) {
        super(string);
        this.encoder = charsetEncoder;
        this.decoder = charsetDecoder;
    }

    @Override
    public char ebcdic2uni(int n) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[]{(byte)n});
            CharBuffer charBuffer = this.decoder.decode(byteBuffer);
            return charBuffer.get(0);
        }
        catch (Exception exception) {
            return ' ';
        }
    }

    @Override
    public byte uni2ebcdic(char c) {
        try {
            CharBuffer charBuffer = CharBuffer.wrap(new char[]{c});
            ByteBuffer byteBuffer = this.encoder.encode(charBuffer);
            return byteBuffer.get(0);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    static ICodePage getCodePage(String string) {
        CharsetDecoder charsetDecoder = null;
        CharsetEncoder charsetEncoder = null;
        try {
            Charset charset = Charset.forName(string);
            charsetDecoder = charset.newDecoder();
            charsetEncoder = charset.newEncoder();
        }
        catch (Exception exception) {
            charsetEncoder = null;
            charsetDecoder = null;
        }
        if (charsetEncoder != null && charsetDecoder != null) {
            return new JavaCodePageFactory(string, charsetEncoder, charsetDecoder);
        }
        return null;
    }
}

