/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.encoding.builtin;

import java.util.Arrays;
import org.tn5250j.encoding.builtin.ICodepageConverter;

public abstract class CodepageConverterAdapter
implements ICodepageConverter {
    private char[] codepage = null;
    private int[] reverse_codepage = null;

    @Override
    public ICodepageConverter init() {
        int n;
        this.codepage = this.getCodePage();
        int n2 = 0;
        for (n = 0; n < this.codepage.length; ++n) {
            n2 = Math.max(n2, this.codepage[n]);
        }
        assert (n2 + 1 < 0x100000);
        this.reverse_codepage = new int[n2 + 1];
        Arrays.fill(this.reverse_codepage, 63);
        for (n = 0; n < this.codepage.length; ++n) {
            this.reverse_codepage[this.codepage[n]] = n;
        }
        return this;
    }

    @Override
    public byte uni2ebcdic(char c) {
        assert (c < this.reverse_codepage.length);
        return (byte)this.reverse_codepage[c];
    }

    @Override
    public char ebcdic2uni(int n) {
        assert ((n &= 0xFF) < 256);
        return this.codepage[n];
    }

    protected abstract char[] getCodePage();
}

