/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JFrame;
import org.tn5250j.GlobalConfigure;
import org.tn5250j.Session5250;
import org.tn5250j.SessionPanel;
import org.tn5250j.framework.Tn5250jEvent;
import org.tn5250j.framework.Tn5250jKeyEvents;
import org.tn5250j.framework.Tn5250jListener;
import org.tn5250j.framework.Tn5250jSession;
import org.tn5250j.framework.common.SessionManager;
import org.tn5250j.framework.common.Sessions;
import org.tn5250j.framework.tn5250.Screen5250;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.interfaces.ConfigureFactory;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class Tn5250jController
extends Thread {
    private File extensionDir;
    private TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());
    private List<Tn5250jEvent> eventList;
    private List<Tn5250jListener> listeners;
    private SessionManager manager;
    Properties sesprops;
    private static Tn5250jController current;

    private Tn5250jController() {
        String string = System.getProperty("user.dir");
        this.extensionDir = new File(string + File.separatorChar + "ext");
        this.log.info("plugin directory is: " + this.extensionDir.getAbsolutePath());
        if (!this.extensionDir.exists()) {
            this.log.warn("Plugin path '" + this.extensionDir.getAbsolutePath() + "' does not exist. No plugins will be loaded.");
        }
        this.setDaemon(true);
        this.eventList = new ArrayList<Tn5250jEvent>();
        this.listeners = new ArrayList<Tn5250jListener>();
        current = this;
        this.log.info("Tn5250j plugin manager created");
        this.manager = SessionManager.instance();
        Sessions sessions = this.manager.getSessions();
        this.log.debug("Sessions:" + sessions.getCount());
        this.sesprops = ((GlobalConfigure)ConfigureFactory.getInstance()).getProperties("sessions");
        this.log.debug("Session configuration: " + this.sesprops.toString());
        this.start();
    }

    private void loadExt() {
        if (this.extensionDir.exists()) {
            File[] fileArray = this.extensionDir.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                String string = fileArray[i].getAbsolutePath() + File.separatorChar + fileArray[i].getName() + ".jar";
                File file = new File(string);
                if (file.exists()) {
                    Properties properties = this.loadConfig(file);
                    this.load(file, properties.getProperty("mainentry"), properties);
                    continue;
                }
                this.log.warn("extension could not be loaded as the jar was not found: " + string);
            }
        }
    }

    private void load(File file, String string, Properties properties) {
        URL[] uRLArray = new URL[1];
        try {
            uRLArray[0] = file.toURI().toURL();
            this.log.info("Loading jar: " + file.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            this.log.warn("The URL was malformed");
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
        try {
            Class<?> clazz = uRLClassLoader.loadClass(string);
            try {
                Tn5250jListener tn5250jListener = (Tn5250jListener)clazz.newInstance();
                this.listeners.add(tn5250jListener);
                ModuleThread moduleThread = new ModuleThread(file.getParentFile(), tn5250jListener, properties);
                moduleThread.start();
            }
            catch (InstantiationException instantiationException) {
                this.log.warn("Error instantiating class " + string);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.log.warn("The class " + string + " gives no access to the constructor");
            }
            catch (ClassCastException classCastException) {
                this.log.warn("Main module class does not derive from Tn5250jListener");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.warn("Extension could not be loaded, class: " + string + " not found");
        }
    }

    private Properties loadConfig(File file) {
        JarFile jarFile = null;
        Properties properties = null;
        try {
            jarFile = new JarFile(file);
            JarEntry jarEntry = jarFile.getJarEntry("config.properties");
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            properties = new Properties();
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            this.log.warn("Failure trying to load configuration");
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.info("Tn5250j plugin manager started");
        this.loadExt();
        while (true) {
            List<Tn5250jEvent> list = this.eventList;
            synchronized (list) {
                while (!this.eventList.isEmpty()) {
                    Tn5250jEvent tn5250jEvent = this.eventList.remove(0);
                    this.broadcastEvent(tn5250jEvent);
                }
                try {
                    this.eventList.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.log.debug("Intertupted exception");
                }
            }
        }
    }

    private void broadcastEvent(Tn5250jEvent tn5250jEvent) {
        for (Tn5250jListener tn5250jListener : this.listeners) {
            tn5250jListener.actionPerformed(tn5250jEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Tn5250jEvent tn5250jEvent) {
        this.log.debug("Received event: " + tn5250jEvent.getClass().toString());
        if (tn5250jEvent instanceof Tn5250jKeyEvents) {
            this.log.debug("Keys: " + ((Tn5250jKeyEvents)tn5250jEvent).getKeystrokes());
        }
        this.eventList.add(tn5250jEvent);
        List<Tn5250jEvent> list = this.eventList;
        synchronized (list) {
            this.eventList.notify();
        }
    }

    public static Tn5250jController getCurrent() {
        if (current == null) {
            current = new Tn5250jController();
        }
        return current;
    }

    public void createSession(Screen5250 screen5250, tnvt tnvt2, SessionPanel sessionPanel) {
        Tn5250jSession tn5250jSession = new Tn5250jSession(screen5250, tnvt2, sessionPanel);
        Iterator<Tn5250jListener> iterator = this.listeners.iterator();
        this.log.info("New session created and received");
        while (iterator.hasNext()) {
            Tn5250jListener tn5250jListener = iterator.next();
            tn5250jListener.sessionCreated(tn5250jSession);
        }
    }

    protected Properties getPropertiesForSession(String string) {
        return null;
    }

    public Screen5250 startSession(String string) {
        JFrame jFrame = new JFrame();
        String[] stringArray = new String[15];
        this.parseArgs((String)this.sesprops.get(string), stringArray);
        Properties properties = this.convertToProps(stringArray);
        Session5250 session5250 = this.manager.openSession(properties, null, string);
        SessionPanel sessionPanel = new SessionPanel(session5250);
        jFrame.getContentPane().add(sessionPanel);
        jFrame.setBounds(50, 50, 960, 700);
        jFrame.setVisible(true);
        session5250.connect();
        return session5250.getScreen();
    }

    public List<String> getSessions() {
        Enumeration<Object> enumeration = this.sesprops.keys();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.startsWith("emul.")) continue;
            arrayList.add(string);
        }
        this.log.error(arrayList.toString());
        return arrayList;
    }

    protected void parseArgs(String string, String[] stringArray) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
    }

    protected Properties convertToProps(String[] stringArray) {
        Properties properties = new Properties();
        String string = stringArray[0];
        properties.put("SESSION_HOST", string);
        if (this.isSpecified("-e", stringArray)) {
            properties.put("SESSION_TN_ENHANCED", "1");
        }
        if (this.isSpecified("-p", stringArray)) {
            properties.put("SESSION_HOST_PORT", this.getParm("-p", stringArray));
        }
        if (this.isSpecified("-cp", stringArray)) {
            properties.put("SESSION_CODE_PAGE", this.getParm("-cp", stringArray));
        }
        if (this.isSpecified("-gui", stringArray)) {
            properties.put("SESSION_USE_GUI", "1");
        }
        if (this.isSpecified("-t", stringArray)) {
            properties.put("SESSION_TERM_NAME_SYSTEM", "1");
        }
        if (this.isSpecified("-132", stringArray)) {
            properties.put("SESSION_SCREEN_SIZE", "1");
        } else {
            properties.put("SESSION_SCREEN_SIZE", "0");
        }
        if (this.isSpecified("-usp", stringArray)) {
            if (this.isSpecified("-sph", stringArray)) {
                properties.put("SESSION_PROXY_HOST", this.getParm("-sph", stringArray));
            }
            if (this.isSpecified("-spp", stringArray)) {
                properties.put("SESSION_PROXY_PORT", this.getParm("-spp", stringArray));
            }
        }
        if (this.isSpecified("-sslType", stringArray)) {
            properties.put("-sslType", this.getParm("-sslType", stringArray));
        }
        if (this.isSpecified("-dn=hostname", stringArray)) {
            String string2;
            try {
                string2 = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                string2 = "UNKNOWN_HOST";
            }
            properties.put("SESSION_DEVICE_NAME", string2);
        } else if (this.isSpecified("-dn", stringArray)) {
            properties.put("SESSION_DEVICE_NAME", this.getParm("-dn", stringArray));
        }
        if (this.isSpecified("-hb", stringArray)) {
            properties.put("SESSION_KEEP_ALIVE_ENABLED", "1");
        }
        return properties;
    }

    boolean isSpecified(String string, String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || !stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private String getParm(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return stringArray[i + 1];
        }
        return null;
    }

    private class ModuleThread
    extends Thread {
        File dir;
        Tn5250jListener mod;
        Properties config;

        public ModuleThread(File file, Tn5250jListener tn5250jListener, Properties properties) {
            this.dir = file;
            this.mod = tn5250jListener;
            this.config = properties;
            this.setDaemon(true);
            this.setName(tn5250jListener.getName());
        }

        @Override
        public void run() {
            this.mod.init(this.dir, this.config);
            this.mod.setController(Tn5250jController.getCurrent());
            Tn5250jController.this.log.info("module initialized");
            this.mod.run();
            Tn5250jController.this.log.info("module stopped");
            this.mod.destroy();
            Tn5250jController.this.log.info("module destroyed");
        }
    }
}

