/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.tn5250j.Session5250;
import org.tn5250j.SessionConfig;
import org.tn5250j.SessionPanel;
import org.tn5250j.framework.common.Sessions;
import org.tn5250j.interfaces.SessionManagerInterface;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class SessionManager
implements SessionManagerInterface {
    private static Sessions sessions;
    private static List<SessionConfig> configs;
    private TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());
    private static SessionManager _instance;

    protected SessionManager() {
        if (_instance == null) {
            this.initialize();
            _instance = this;
        }
    }

    public static SessionManager instance() {
        if (_instance == null) {
            _instance = new SessionManager();
        }
        return _instance;
    }

    private void initialize() {
        this.log.info("New session Manager initialized");
        sessions = new Sessions();
        configs = new ArrayList<SessionConfig>();
    }

    @Override
    public Sessions getSessions() {
        return sessions;
    }

    @Override
    public void closeSession(SessionPanel sessionPanel) {
        sessionPanel.closeDown();
        sessions.removeSession(sessionPanel.getSession());
    }

    @Override
    public synchronized Session5250 openSession(Properties properties, String string, String string2) {
        if (string2 == null) {
            properties.put("SESSION_TERM_NAME", properties.getProperty("SESSION_HOST"));
        } else {
            properties.put("SESSION_TERM_NAME", string2);
        }
        if (string == null) {
            string = "";
        }
        properties.put("SESSION_CONFIG_RESOURCE", string);
        SessionConfig sessionConfig = null;
        for (SessionConfig sessionConfig2 : configs) {
            if (!sessionConfig2.getSessionName().equals(string2)) continue;
            sessionConfig = sessionConfig2;
        }
        if (sessionConfig == null) {
            sessionConfig = new SessionConfig(string, string2);
            configs.add(sessionConfig);
        }
        Session5250 session5250 = new Session5250(properties, string, string2, sessionConfig);
        sessions.addSession(session5250);
        return session5250;
    }
}

