/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;
import org.tn5250j.Session5250;
import org.tn5250j.interfaces.SessionsInterface;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class Sessions
implements SessionsInterface,
ActionListener {
    private List<Session5250> sessions = null;
    private int count = 0;
    private Timer heartBeater;
    private TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public Sessions() {
        this.sessions = new ArrayList<Session5250>();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.sessions.size(); ++i) {
            try {
                Session5250 session5250 = this.sessions.get(i);
                if (!session5250.isConnected() || !session5250.isSendKeepAlive()) continue;
                session5250.getVT().sendHeartBeat();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug(" sent heartbeat to " + session5250.getSessionName());
                continue;
            }
            catch (Exception exception) {
                this.log.warn(exception.getMessage());
            }
        }
    }

    protected void addSession(Session5250 session5250) {
        this.sessions.add(session5250);
        this.log.debug("adding Session: " + session5250.getSessionName());
        if (session5250.isSendKeepAlive() && this.heartBeater == null) {
            this.heartBeater = new Timer(15000, this);
            this.heartBeater.start();
        }
        ++this.count;
    }

    protected void removeSession(Session5250 session5250) {
        if (session5250 != null) {
            this.log.debug("Removing session: " + session5250.getSessionName());
            if (session5250.isConnected()) {
                session5250.disconnect();
            }
            this.sessions.remove(session5250);
            --this.count;
        }
    }

    protected void removeSession(String string) {
        this.log.debug("Remove session by name: " + string);
        this.removeSession(this.item(string));
    }

    protected void removeSession(int n) {
        this.log.debug("Remove session by index: " + n);
        this.removeSession(this.item(n));
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public Session5250 item(int n) {
        return this.sessions.get(n);
    }

    @Override
    public Session5250 item(String string) {
        Session5250 session5250 = null;
        for (int i = 0; i < this.sessions.size(); ++i) {
            session5250 = this.sessions.get(i);
            if (!session5250.getSessionName().equals(string)) continue;
            return session5250;
        }
        return null;
    }

    public Session5250 item(Session5250 session5250) {
        Session5250 session52502 = null;
        for (int i = 0; i < this.sessions.size(); ++i) {
            session52502 = this.sessions.get(i);
            if (!session52502.equals(session5250)) continue;
            return session52502;
        }
        return null;
    }

    public ArrayList<Session5250> getSessionsList() {
        ArrayList<Session5250> arrayList = new ArrayList<Session5250>(this.sessions.size());
        for (int i = 0; i < this.sessions.size(); ++i) {
            arrayList.add(this.sessions.get(i));
        }
        return arrayList;
    }

    @Override
    public void refresh() {
    }
}

