/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.tn5250;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.tn5250j.encoding.ICodePage;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class DataStreamDumper {
    private AtomicInteger counter = new AtomicInteger(0);
    private FileOutputStream fw;
    private BufferedOutputStream dw;
    private boolean dumpActive = false;
    private ICodePage codePage;
    private TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public void toggleDebug(ICodePage iCodePage) {
        if (this.codePage == null) {
            this.codePage = iCodePage;
        }
        boolean bl = this.dumpActive = !this.dumpActive;
        if (this.dumpActive) {
            try {
                if (this.fw == null) {
                    this.fw = new FileOutputStream("log.txt");
                    this.dw = new BufferedOutputStream(this.fw);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.log.warn(fileNotFoundException.getMessage());
            }
        } else {
            try {
                if (this.dw != null) {
                    this.dw.close();
                }
                if (this.fw != null) {
                    this.fw.close();
                }
                this.dw = null;
                this.fw = null;
                this.codePage = null;
            }
            catch (IOException iOException) {
                this.log.warn(iOException.getMessage());
            }
        }
        this.log.info("Data Stream output is now " + this.dumpActive);
    }

    public void dump(byte[] byArray) {
        if (!this.dumpActive) {
            return;
        }
        try {
            this.log.info("\n Buffer Dump of data from AS400: ");
            this.dw.write("\r\n Buffer Dump of data from AS400: ".getBytes());
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < byArray.length; ++i) {
                char c;
                if (i % 16 == 0) {
                    System.out.println("  " + stringBuilder.toString());
                    this.dw.write(("  " + stringBuilder.toString() + "\r\n").getBytes());
                    stringBuilder.setLength(0);
                    stringBuilder.append("+0000");
                    stringBuilder.setLength(5 - Integer.toHexString(i).length());
                    stringBuilder.append(Integer.toHexString(i).toUpperCase());
                    System.out.print(stringBuilder.toString());
                    this.dw.write(stringBuilder.toString().getBytes());
                    stringBuilder.setLength(0);
                }
                if ((c = this.codePage.ebcdic2uni(byArray[i])) < ' ') {
                    stringBuilder.append('.');
                } else {
                    stringBuilder.append(c);
                }
                if (i % 4 == 0) {
                    System.out.print(" ");
                    this.dw.write(" ".getBytes());
                }
                if (Integer.toHexString(byArray[i] & 0xFF).length() == 1) {
                    System.out.print("0" + Integer.toHexString(byArray[i] & 0xFF).toUpperCase());
                    this.dw.write(("0" + Integer.toHexString(byArray[i] & 0xFF).toUpperCase()).getBytes());
                    continue;
                }
                System.out.print(Integer.toHexString(byArray[i] & 0xFF).toUpperCase());
                this.dw.write(Integer.toHexString(byArray[i] & 0xFF).toUpperCase().getBytes());
            }
            System.out.println();
            this.dw.write("\r\n".getBytes());
            this.dw.flush();
        }
        catch (IOException iOException) {
            this.log.warn("Cannot dump from host! Message=" + iOException.getMessage());
        }
    }

    void dumpRaw(byte[] byArray) {
        try {
            String string = "dump_" + this.counter.get() + ".data";
            this.log.debug("Dumping file: " + string);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

