/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.tn5250;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.SocketException;
import java.util.concurrent.BlockingQueue;
import org.tn5250j.encoding.ICodePage;
import org.tn5250j.framework.tn5250.DataStreamDumper;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class DataStreamProducer
implements Runnable {
    private static final int MINIMAL_PARTIAL_STREAM_LEN = 2;
    private BufferedInputStream bin;
    private ByteArrayOutputStream baosin;
    private byte[] saveStream;
    private final BlockingQueue<Object> dsq;
    private tnvt vt;
    private byte[] dataStream;
    private DataStreamDumper dataStreamDumper = new DataStreamDumper();
    private TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public DataStreamProducer(tnvt tnvt2, BufferedInputStream bufferedInputStream, BlockingQueue<Object> blockingQueue, byte[] byArray) {
        this.bin = bufferedInputStream;
        this.vt = tnvt2;
        this.baosin = new ByteArrayOutputStream();
        this.dsq = blockingQueue;
        this.dataStream = byArray;
    }

    @Override
    public final void run() {
        boolean bl = false;
        Thread thread = Thread.currentThread();
        this.loadStream(this.dataStream, 0);
        while (!bl) {
            try {
                byte[] byArray = this.readIncoming();
                if (byArray == null) continue;
                if (byArray.length > 0) {
                    this.loadStream(byArray, 0);
                    continue;
                }
                bl = true;
                this.vt.disconnect();
            }
            catch (SocketException socketException) {
                this.log.warn("   DataStreamProducer thread interrupted and stopping " + socketException.getMessage());
                bl = true;
            }
            catch (IOException iOException) {
                this.log.warn(iOException.getMessage());
                if (!thread.isInterrupted()) continue;
                bl = true;
            }
            catch (Exception exception) {
                this.log.warn(exception.getMessage());
                if (!thread.isInterrupted()) continue;
                bl = true;
            }
        }
    }

    private void loadStream(byte[] byArray, int n) {
        int n2 = (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
        int n3 = byArray.length;
        if (this.log.isDebugEnabled()) {
            this.log.debug("loadStream() offset=" + n + " partialLen=" + n2 + " bufferLen=" + n3);
        }
        if (this.saveStream != null) {
            this.log.debug("partial stream found");
            n3 = this.saveStream.length + byArray.length;
            byte[] byArray2 = new byte[n3];
            System.arraycopy(this.saveStream, 0, byArray2, 0, this.saveStream.length);
            System.arraycopy(byArray, 0, byArray2, this.saveStream.length, byArray.length);
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
            this.saveStream = null;
        }
        if (n2 > n3) {
            this.saveStream = new byte[byArray.length];
            this.log.debug("partial stream saved");
            System.arraycopy(byArray, 0, this.saveStream, 0, byArray.length);
        } else {
            int n4 = n2 + 2;
            byte[] byArray3 = new byte[n4];
            if (this.isBufferShifted(n2, n3) && this.isOpcodeShifted(byArray, n)) {
                this.log.debug("Invalid stream buffer detected. Ignoring the inserted byte.");
                System.arraycopy(byArray, n, byArray3, 0, 2);
                System.arraycopy(byArray, n + 2 + 1, byArray3, 2, n2);
            } else {
                System.arraycopy(byArray, n, byArray3, 0, n4);
            }
            try {
                this.dsq.put(byArray3);
                if (byArray.length > byArray3.length + n + 2) {
                    this.loadStream(byArray, n + n4);
                }
            }
            catch (InterruptedException interruptedException) {
                this.log.warn("load stream error.", interruptedException);
            }
        }
    }

    private boolean isOpcodeShifted(byte[] byArray, int n) {
        byte by = byArray[n + 1 + 9];
        return 0 <= by && by <= 12;
    }

    private boolean isBufferShifted(int n, int n2) {
        return n + 2 + 1 == n2;
    }

    public final byte[] readIncoming() throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        this.baosin.reset();
        int n = -1;
        while (!bl) {
            int n2 = this.bin.read();
            if (n2 == -1) {
                bl = true;
                this.vt.disconnect();
                continue;
            }
            if (n == 255 && n2 == 255) {
                n = -1;
                continue;
            }
            this.baosin.write(n2);
            if (n == 255 && n2 == 239) {
                bl = true;
            }
            if (n2 == 253 && n == 255) {
                bl = true;
                bl2 = true;
            }
            n = n2;
        }
        byte[] byArray = this.baosin.toByteArray();
        this.dataStreamDumper.dump(byArray);
        if (bl2) {
            this.baosin.write(this.bin.read());
            this.vt.negotiate(byArray);
            return null;
        }
        return byArray;
    }

    protected void toggleDebug(ICodePage iCodePage) {
        this.dataStreamDumper.toggleDebug(iCodePage);
    }
}

