/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.tn5250;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Vector;
import org.tn5250j.TN5250jConstants;
import org.tn5250j.event.ScreenListener;
import org.tn5250j.framework.tn5250.KeyStrokenizer;
import org.tn5250j.framework.tn5250.Rect;
import org.tn5250j.framework.tn5250.ScreenField;
import org.tn5250j.framework.tn5250.ScreenFields;
import org.tn5250j.framework.tn5250.ScreenOIA;
import org.tn5250j.framework.tn5250.ScreenPlanes;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;
import org.tn5250j.tools.system.OperatingSystem;

public class Screen5250 {
    private ScreenFields screenFields;
    private int lastAttr;
    private int lastPos;
    private int lenScreen;
    private KeyStrokenizer strokenizer;
    private tnvt sessionVT;
    private int numRows = 0;
    private int numCols = 0;
    protected static final int initAttr = 32;
    protected static final char initChar = '\u0000';
    public boolean cursorActive = false;
    public boolean cursorShown = false;
    protected boolean insertMode = false;
    private boolean keyProcessed = false;
    private Rect dirtyScreen = new Rect();
    public int homePos = 0;
    public int saveHomePos = 0;
    private String bufferedKeys;
    public boolean pendingInsert = false;
    public static final byte STATUS_SYSTEM = 1;
    public static final byte STATUS_ERROR_CODE = 2;
    public static final byte STATUS_VALUE_ON = 1;
    public static final byte STATUS_VALUE_OFF = 2;
    private StringBuffer hsMore = new StringBuffer("More...");
    private StringBuffer hsBottom = new StringBuffer("Bottom");
    private static final int ERR_CURSOR_PROTECTED = 5;
    private static final int ERR_INVALID_SIGN = 17;
    private static final int ERR_NO_ROOM_INSERT = 18;
    private static final int ERR_NUMERIC_ONLY = 9;
    private static final int ERR_DUP_KEY_NOT_ALLOWED = 25;
    private static final int ERR_NUMERIC_09 = 16;
    private static final int ERR_FIELD_MINUS = 22;
    private static final int ERR_FIELD_EXIT_INVALID = 24;
    private static final int ERR_ENTER_NO_ALLOWED = 32;
    private static final int ERR_MANDITORY_ENTER = 33;
    private boolean guiInterface = false;
    private boolean resetRequired = true;
    private boolean backspaceError = true;
    private boolean feError;
    Vector<ScreenListener> listeners = null;
    private ScreenOIA oia;
    protected ScreenPlanes planes;
    private StringBuffer keybuf;
    private TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public Screen5250() {
        this.keybuf = new StringBuffer();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            this.log.warn("In constructor: ", exception);
        }
    }

    void jbInit() throws Exception {
        this.lastAttr = 32;
        this.numRows = 24;
        this.numCols = 80;
        this.setCursor(1, 1);
        this.oia = new ScreenOIA(this);
        this.oia.setKeyBoardLocked(true);
        this.lenScreen = this.numRows * this.numCols;
        this.planes = new ScreenPlanes(this, this.numRows);
        this.screenFields = new ScreenFields(this);
        this.strokenizer = new KeyStrokenizer();
    }

    protected ScreenPlanes getPlanes() {
        return this.planes;
    }

    public final ScreenOIA getOIA() {
        return this.oia;
    }

    protected final void setRowsCols(int n, int n2) {
        int n3 = this.numRows;
        int n4 = this.numCols;
        this.numRows = n;
        this.numCols = n2;
        this.lenScreen = this.numRows * this.numCols;
        this.planes.setSize(n);
        if (n3 != this.numRows || n4 != this.numCols) {
            this.fireScreenSizeChanged();
        }
    }

    public boolean isCursorActive() {
        return this.cursorActive;
    }

    public boolean isCursorShown() {
        return this.cursorShown;
    }

    public void setUseGUIInterface(boolean bl) {
        this.guiInterface = bl;
    }

    public void toggleGUIInterface() {
        this.guiInterface = !this.guiInterface;
    }

    public void setResetRequired(boolean bl) {
        this.resetRequired = bl;
    }

    public void setBackspaceError(boolean bl) {
        this.backspaceError = bl;
    }

    public final String copyText(Rect rect) {
        StringBuilder stringBuilder = new StringBuilder();
        Rect rect2 = new Rect();
        rect2.setBounds(rect);
        this.log.debug("Copying " + rect2);
        int n = rect2.x;
        int n2 = 0;
        int n3 = 0;
        while (rect2.height-- > 0) {
            n3 = rect2.width;
            n2 = rect2.y;
            while (n3-- > 0) {
                char c = this.planes.getChar(this.getPos(n - 1, n2 - 1));
                if (c >= ' ' && (this.planes.screenExtended[this.getPos(n - 1, n2 - 1)] & '\u0001') == 0) {
                    stringBuilder.append(c);
                } else {
                    stringBuilder.append(' ');
                }
                ++n2;
            }
            stringBuilder.append('\n');
            ++n;
        }
        return stringBuilder.toString();
    }

    public final void pasteText(String string, boolean bl) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Pasting, special:" + bl);
        }
        this.setCursorActive(false);
        StringBuilder stringBuilder = new StringBuilder(string);
        StringBuilder stringBuilder2 = new StringBuilder();
        int n = 0;
        int n2 = stringBuilder.length();
        int n3 = this.getRow(this.lastPos);
        int n4 = this.getCol(this.lastPos);
        this.resetDirty(this.lastPos);
        int n5 = this.lastPos;
        int n6 = this.getScreenLength();
        char c = '\u0000';
        this.screenFields.saveCurrentField();
        for (int i = n; i < n2; ++i) {
            c = stringBuilder.charAt(i);
            if (c == '\n' || c == '\r') {
                this.log.info("pasted cr-lf>" + stringBuilder2 + "<");
                stringBuilder2.setLength(0);
                n5 = this.getPos(this.getRow(n5) + 1, n4);
                if (n5 <= n6) continue;
                n5 = 0;
                continue;
            }
            boolean bl2 = true;
            if (bl && !Character.isLetter(c) && !Character.isDigit(c)) {
                bl2 = false;
            }
            if (this.isInField(n5) && bl2) {
                this.planes.setChar(n5, c);
                this.setDirty(n5);
                this.screenFields.setCurrentFieldMDT();
            }
            if (bl2) {
                ++n5;
            }
            stringBuilder2.append(c);
        }
        if (stringBuilder2.length() > 0) {
            this.log.info("pasted >" + stringBuilder2 + "<");
        }
        this.screenFields.restoreCurrentField();
        this.updateDirty();
        this.setCursor(n3 + 1, n4 + 1);
        this.setCursorActive(true);
    }

    public final String copyTextField(int n) {
        this.screenFields.saveCurrentField();
        this.isInField(n);
        String string = this.screenFields.getCurrentFieldText();
        this.screenFields.restoreCurrentField();
        return string;
    }

    public final Vector<Double> sumThem(boolean bl, Rect rect) {
        StringBuilder stringBuilder = new StringBuilder();
        Rect rect2 = new Rect();
        rect2.setBounds(rect);
        this.log.debug("Summing");
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        if (bl) {
            decimalFormatSymbols.setDecimalSeparator('.');
            decimalFormatSymbols.setGroupingSeparator(',');
        } else {
            decimalFormatSymbols.setDecimalSeparator(',');
            decimalFormatSymbols.setGroupingSeparator('.');
        }
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        Vector<Double> vector = new Vector<Double>();
        int n = rect2.x;
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        while (rect2.height-- > 0) {
            n3 = rect2.width;
            n2 = rect2.y;
            while (n3-- > 0) {
                char c = this.planes.getChar(this.getPos(n - 1, n2 - 1));
                if (c >= '0' && c <= '9' || c == '.' || c == ',' || c == '-') {
                    stringBuilder.append(c);
                }
                ++n2;
            }
            if (stringBuilder.length() > 0) {
                if (stringBuilder.charAt(stringBuilder.length() - 1) == '-') {
                    stringBuilder.insert(0, '-');
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
                try {
                    Number number = decimalFormat.parse(stringBuilder.toString());
                    vector.add(new Double(number.doubleValue()));
                    d += number.doubleValue();
                }
                catch (ParseException parseException) {
                    this.log.warn(parseException.getMessage() + " at " + parseException.getErrorOffset());
                }
            }
            stringBuilder.setLength(0);
            ++n;
        }
        this.log.debug("" + d);
        return vector;
    }

    public boolean moveCursor(int n) {
        if (!this.oia.isKeyBoardLocked()) {
            if (n < 0) {
                return false;
            }
            int n2 = this.planes.getWhichGUI(n);
            if (n2 >= 13 && n2 <= 31) {
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = true;
                switch (n2) {
                    case 14: 
                    case 15: {
                        while (this.planes.getWhichGUI(--n) != 13) {
                        }
                    }
                    case 13: {
                        if (this.planes.getChar(n) == 'F') {
                            ++n;
                        } else {
                            bl = false;
                        }
                        if (this.planes.getChar(n + 1) != '=' && this.planes.getChar(n + 1) != '.' && this.planes.getChar(n + 1) != '/') {
                            stringBuffer.append(this.planes.getChar(n));
                            stringBuffer.append(this.planes.getChar(n + 1));
                            break;
                        }
                        this.log.debug(" Hotspot clicked!!! we will send character " + this.planes.getChar(n));
                        stringBuffer.append(this.planes.getChar(n));
                    }
                }
                if (bl) {
                    switch (n2) {
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 28: 
                        case 30: {
                            this.sessionVT.sendAidKey(244);
                            break;
                        }
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 29: 
                        case 31: {
                            this.sessionVT.sendAidKey(245);
                            break;
                        }
                        case 25: 
                        case 26: 
                        case 27: {
                            StringBuffer stringBuffer2 = new StringBuffer();
                            while (this.planes.getWhichGUI(n--) != 25) {
                            }
                            while (this.planes.getWhichGUI(n++) != 26) {
                                stringBuffer2.append(this.planes.getChar(n));
                            }
                            OperatingSystem.displayURL(stringBuffer2.toString());
                            this.log.info("Send to external Browser: " + stringBuffer2.toString());
                            break;
                        }
                        default: {
                            int n3 = Integer.parseInt(stringBuffer.toString());
                            if (n3 >= 1 && n3 <= 12) {
                                this.sessionVT.sendAidKey(48 + n3);
                            }
                            if (n3 >= 13 && n3 <= 24) {
                                this.sessionVT.sendAidKey(176 + (n3 - 12));
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                } else if (this.screenFields.getCurrentField() != null) {
                    int n4 = this.screenFields.getCurrentField().startPos();
                    for (int i = 0; i < stringBuffer.length(); ++i) {
                        this.planes.setChar(n4 + i, stringBuffer.charAt(i));
                    }
                    this.screenFields.setCurrentFieldMDT();
                    this.sessionVT.sendAidKey(241);
                }
                return false;
            }
            this.goto_XY(n);
            this.isInField(this.lastPos);
            return true;
        }
        return false;
    }

    public void setVT(tnvt tnvt2) {
        this.sessionVT = tnvt2;
    }

    private int getMnemonicValue(String string) {
        for (int i = 0; i < TN5250jConstants.mnemonicData.length; ++i) {
            if (!TN5250jConstants.mnemonicData[i].equals(string)) continue;
            return TN5250jConstants.mnemonicValue[i];
        }
        return 0;
    }

    protected void setPrehelpState(boolean bl, boolean bl2, boolean bl3) {
        if (this.oia.isKeyBoardLocked() && bl3) {
            this.oia.setKeyBoardLocked(false);
        } else {
            this.oia.setKeyBoardLocked(bl2);
        }
        this.bufferedKeys = null;
        this.oia.setKeysBuffered(false);
    }

    public void setCursorActive(boolean bl) {
        if (this.cursorActive && !bl) {
            this.setCursorOff();
            this.cursorActive = bl;
        } else if (!this.cursorActive && bl) {
            this.cursorActive = bl;
            this.setCursorOn();
        }
    }

    public void setCursorOn() {
        this.cursorShown = true;
        this.updateCursorLoc();
    }

    public void setCursorOff() {
        this.cursorShown = false;
        this.updateCursorLoc();
    }

    private void updateCursorLoc() {
        if (this.cursorActive) {
            this.fireCursorChanged(3);
        }
    }

    public String getKeys() {
        String string = this.keybuf.toString();
        this.keybuf = new StringBuffer();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized void sendKeys(String string) {
        this.keybuf.append(string);
        if (this.isStatusErrorCode() && !this.resetRequired) {
            this.setCursorActive(false);
            this.simulateMnemonic(this.getMnemonicValue("[reset]"));
            this.setCursorActive(true);
        }
        if (this.oia.isKeyBoardLocked()) {
            if (string.equals("[reset]") || string.equals("[sysreq]") || string.equals("[attn]")) {
                this.setCursorActive(false);
                this.simulateMnemonic(this.getMnemonicValue(string));
                this.setCursorActive(true);
                return;
            }
            if (this.isStatusErrorCode()) {
                this.sessionVT.signalBell();
                return;
            }
            this.oia.setKeysBuffered(true);
            if (this.bufferedKeys == null) {
                this.bufferedKeys = string;
                return;
            }
            this.bufferedKeys = this.bufferedKeys + string;
            return;
        }
        if (this.oia.isKeysBuffered()) {
            if (this.bufferedKeys != null) {
                string = this.bufferedKeys + string;
            }
            this.oia.setKeysBuffered(false);
            this.bufferedKeys = null;
        }
        this.isInField(this.lastPos, true);
        if (string.length() == 1 && !string.equals("[") && !string.equals("]")) {
            this.setCursorActive(false);
            this.simulateKeyStroke(string.charAt(0));
            this.setCursorActive(true);
            return;
        }
        this.strokenizer.setKeyStrokes(string);
        boolean bl = false;
        this.setCursorActive(false);
        while (true) {
            if (bl) {
                this.setCursorActive(true);
                return;
            }
            if (this.strokenizer.hasMoreKeyStrokes()) {
                this.isInField(this.lastPos, true);
                String string2 = this.strokenizer.nextKeyStroke();
                if (string2.length() == 1) {
                    this.simulateKeyStroke(string2.charAt(0));
                } else {
                    this.simulateMnemonic(this.getMnemonicValue(string2));
                }
                if (!this.oia.isKeyBoardLocked()) continue;
                this.bufferedKeys = this.strokenizer.getUnprocessedKeyStroked();
                if (this.bufferedKeys != null) {
                    this.oia.setKeysBuffered(true);
                }
                bl = true;
                continue;
            }
            bl = true;
        }
    }

    public void sendAid(int n) {
        this.sessionVT.sendAidKey(n);
    }

    protected void resetError() {
        this.restoreErrorLine();
        this.setStatus((byte)2, (byte)2, "");
    }

    protected boolean simulateMnemonic(int n) {
        boolean bl = false;
        switch (n) {
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 217: 
            case 218: 
            case 241: 
            case 244: 
            case 245: {
                if (!this.screenFields.isCanSendAid()) {
                    this.displayError(32);
                } else {
                    this.sendAid(n);
                }
                bl = true;
                break;
            }
            case 243: {
                this.sessionVT.sendHelpRequest();
                bl = true;
                break;
            }
            case 246: {
                this.sessionVT.hostPrint(1);
                bl = true;
                break;
            }
            case 1001: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    if (this.screenFields.getCurrentField().startPos() == this.lastPos) {
                        if (this.backspaceError) {
                            this.displayError(5);
                            break;
                        }
                        this.gotoFieldPrev();
                        this.goto_XY(this.screenFields.getCurrentField().endPos());
                        this.updateDirty();
                        break;
                    }
                    this.screenFields.getCurrentField().getKeyPos(this.lastPos);
                    this.screenFields.getCurrentField().changePos(-1);
                    this.resetDirty(this.screenFields.getCurrentField().getCurrentPos());
                    this.shiftLeft(this.screenFields.getCurrentField().getCurrentPos());
                    this.updateDirty();
                    this.screenFields.setCurrentFieldMDT();
                    bl = true;
                    break;
                }
                this.displayError(5);
                break;
            }
            case 1002: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.isCurrentFieldHighlightedEntry()) {
                    this.resetDirty(this.screenFields.getCurrentField().startPos);
                    this.gotoFieldPrev();
                    this.updateDirty();
                } else {
                    this.gotoFieldPrev();
                }
                if (this.screenFields.isCurrentFieldContinued()) {
                    do {
                        this.gotoFieldPrev();
                    } while (this.screenFields.isCurrentFieldContinuedMiddle() || this.screenFields.isCurrentFieldContinuedLast());
                }
                this.isInField(this.lastPos);
                bl = true;
                break;
            }
            case 1003: 
            case 1038: {
                this.process_XY(this.lastPos - this.numCols);
                bl = true;
                break;
            }
            case 1004: 
            case 1039: {
                this.process_XY(this.lastPos + this.numCols);
                bl = true;
                break;
            }
            case 1005: 
            case 1040: {
                this.process_XY(this.lastPos - 1);
                bl = true;
                break;
            }
            case 1006: 
            case 1041: {
                this.process_XY(this.lastPos + 1);
                bl = true;
                break;
            }
            case 1033: {
                this.gotoNextWord();
                bl = true;
                break;
            }
            case 1034: {
                this.gotoPrevWord();
                bl = true;
                break;
            }
            case 1007: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    this.resetDirty(this.lastPos);
                    this.screenFields.getCurrentField().getKeyPos(this.lastPos);
                    this.shiftLeft(this.screenFields.getCurrentFieldPos());
                    this.screenFields.setCurrentFieldMDT();
                    this.updateDirty();
                    bl = true;
                    break;
                }
                this.displayError(5);
                break;
            }
            case 1008: {
                if (this.screenFields.getCurrentField() != null && !this.screenFields.isCurrentFieldContinued()) {
                    if (this.screenFields.isCurrentFieldHighlightedEntry()) {
                        this.resetDirty(this.screenFields.getCurrentField().startPos);
                        this.gotoFieldNext();
                        this.updateDirty();
                    } else {
                        this.gotoFieldNext();
                    }
                } else {
                    do {
                        this.gotoFieldNext();
                    } while (this.screenFields.getCurrentField() != null && (this.screenFields.isCurrentFieldContinuedMiddle() || this.screenFields.isCurrentFieldContinuedLast()));
                }
                this.isInField(this.lastPos);
                bl = true;
                break;
            }
            case 1009: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    int n2 = this.endOfField(this.screenFields.getCurrentField().startPos(), true);
                    if (n2 > 0) {
                        this.setCursor(n2 / this.numCols + 1, n2 % this.numCols + 1);
                    }
                    bl = true;
                } else {
                    this.displayError(5);
                }
                this.resetDirty(this.lastPos);
                break;
            }
            case 1010: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    int n3 = this.lastPos;
                    this.resetDirty(this.lastPos);
                    if (this.fieldExit()) {
                        this.screenFields.setCurrentFieldMDT();
                        if (!this.screenFields.isCurrentFieldContinued()) {
                            this.gotoFieldNext();
                        } else {
                            do {
                                this.gotoFieldNext();
                                if (!this.screenFields.isCurrentFieldContinued()) continue;
                                this.fieldExit();
                            } while (this.screenFields.isCurrentFieldContinuedMiddle() || this.screenFields.isCurrentFieldContinuedLast());
                        }
                    }
                    this.updateDirty();
                    this.goto_XY(n3);
                    bl = true;
                    break;
                }
                this.displayError(5);
                break;
            }
            case 1011: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    int n4 = this.lastPos;
                    this.lastPos = this.screenFields.getCurrentField().startPos();
                    this.resetDirty(this.lastPos);
                    if (this.fieldExit()) {
                        this.screenFields.setCurrentFieldMDT();
                        if (!this.screenFields.isCurrentFieldContinued()) {
                            this.gotoFieldNext();
                        } else {
                            do {
                                this.gotoFieldNext();
                                if (!this.screenFields.isCurrentFieldContinued()) continue;
                                this.fieldExit();
                            } while (this.screenFields.isCurrentFieldContinuedMiddle() || this.screenFields.isCurrentFieldContinuedLast());
                        }
                    }
                    this.updateDirty();
                    this.goto_XY(n4);
                    bl = true;
                    break;
                }
                this.displayError(5);
                break;
            }
            case 1012: {
                this.oia.setInsertMode(!this.oia.isInsertMode());
                break;
            }
            case 1013: {
                if (this.lastPos + this.numCols + 1 != this.homePos) {
                    this.goto_XY(this.homePos - this.numCols - 1);
                    this.isInField(this.lastPos);
                    break;
                }
                this.gotoField(1);
                break;
            }
            case 1014: {
                bl = this.simulateKeyStroke('0');
                break;
            }
            case 1015: {
                bl = this.simulateKeyStroke('1');
                break;
            }
            case 1016: {
                bl = this.simulateKeyStroke('2');
                break;
            }
            case 1017: {
                bl = this.simulateKeyStroke('3');
                break;
            }
            case 1018: {
                bl = this.simulateKeyStroke('4');
                break;
            }
            case 1019: {
                bl = this.simulateKeyStroke('5');
                break;
            }
            case 1020: {
                bl = this.simulateKeyStroke('6');
                break;
            }
            case 1021: {
                bl = this.simulateKeyStroke('7');
                break;
            }
            case 1022: {
                bl = this.simulateKeyStroke('8');
                break;
            }
            case 1023: {
                bl = this.simulateKeyStroke('9');
                break;
            }
            case 1024: {
                bl = this.simulateKeyStroke('.');
                break;
            }
            case 1025: {
                bl = this.simulateKeyStroke(',');
                break;
            }
            case 1026: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    int n5 = this.screenFields.getCurrentField().getFieldShift();
                    if (n5 == 3 || n5 == 5 || n5 == 7) {
                        this.planes.setChar(this.lastPos, '-');
                        this.resetDirty(this.lastPos);
                        this.advancePos();
                        if (!this.fieldExit()) break;
                        this.screenFields.setCurrentFieldMDT();
                        if (!this.screenFields.isCurrentFieldContinued()) {
                            this.gotoFieldNext();
                        } else {
                            do {
                                this.gotoFieldNext();
                            } while (this.screenFields.isCurrentFieldContinuedMiddle() || this.screenFields.isCurrentFieldContinuedLast());
                        }
                        bl = true;
                        this.updateDirty();
                        if (!this.screenFields.isCurrentFieldAutoEnter()) break;
                        this.sendAid(241);
                        break;
                    }
                    this.displayError(22);
                    break;
                }
                this.displayError(5);
                break;
            }
            case 1027: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    this.resetDirty(this.lastPos);
                    boolean bl2 = this.screenFields.isCurrentFieldAutoEnter();
                    if (this.fieldExit()) {
                        this.screenFields.setCurrentFieldMDT();
                        if (!this.screenFields.isCurrentFieldContinued() && !this.screenFields.isCurrentFieldAutoEnter()) {
                            this.gotoFieldNext();
                        } else {
                            do {
                                this.gotoFieldNext();
                                if (!this.screenFields.isCurrentFieldContinued()) continue;
                                this.fieldExit();
                            } while (this.screenFields.isCurrentFieldContinuedMiddle() || this.screenFields.isCurrentFieldContinuedLast());
                        }
                    }
                    this.updateDirty();
                    bl = true;
                    if (!bl2) break;
                    this.sendAid(241);
                    break;
                }
                this.displayError(5);
                break;
            }
            case 1028: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    this.resetDirty(this.lastPos);
                    boolean bl3 = this.screenFields.isCurrentFieldAutoEnter();
                    if (this.fieldExit()) {
                        this.screenFields.setCurrentFieldMDT();
                        if (!this.screenFields.isCurrentFieldContinued() && !this.screenFields.isCurrentFieldAutoEnter()) {
                            this.gotoFieldNext();
                        } else {
                            do {
                                this.gotoFieldNext();
                            } while (this.screenFields.isCurrentFieldContinuedMiddle() || this.screenFields.isCurrentFieldContinuedLast());
                        }
                    }
                    this.updateDirty();
                    bl = true;
                    if (!bl3) break;
                    this.sendAid(241);
                    break;
                }
                this.displayError(5);
                break;
            }
            case 1029: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    int n6 = this.screenFields.getCurrentField().getFieldShift();
                    if (n6 == 3 || n6 == 5 || n6 == 7) {
                        this.planes.setChar(this.lastPos, '-');
                        this.resetDirty(this.lastPos);
                        this.advancePos();
                        boolean bl4 = this.screenFields.isCurrentFieldAutoEnter();
                        if (this.fieldExit()) {
                            this.screenFields.setCurrentFieldMDT();
                            if (!this.screenFields.isCurrentFieldContinued() && !this.screenFields.isCurrentFieldAutoEnter()) {
                                this.gotoFieldNext();
                            } else {
                                do {
                                    this.gotoFieldNext();
                                } while (this.screenFields.isCurrentFieldContinuedMiddle() || this.screenFields.isCurrentFieldContinuedLast());
                            }
                        }
                        this.updateDirty();
                        bl = true;
                        if (!bl4) break;
                        this.sendAid(241);
                        break;
                    }
                    this.displayError(22);
                    break;
                }
                this.displayError(5);
                break;
            }
            case 1030: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    int n7 = this.screenFields.getCurrentField().startPos();
                    if (n7 > 0) {
                        this.goto_XY(n7);
                    }
                    bl = true;
                } else {
                    this.displayError(5);
                }
                this.resetDirty(this.lastPos);
                break;
            }
            case 1031: {
                this.sessionVT.systemRequest();
                bl = true;
                break;
            }
            case 1032: {
                if (this.isStatusErrorCode()) {
                    this.resetError();
                    this.isInField(this.lastPos);
                    this.updateDirty();
                } else {
                    this.setPrehelpState(false, this.oia.isKeyBoardLocked(), false);
                }
                bl = true;
                break;
            }
            case 1037: {
                this.sessionVT.sendAttentionKey();
                bl = true;
                break;
            }
            case 1042: {
                if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                    if (this.screenFields.isCurrentFieldDupEnabled()) {
                        this.resetDirty(this.lastPos);
                        this.screenFields.getCurrentField().setFieldChar(this.lastPos, '\u001c');
                        this.screenFields.setCurrentFieldMDT();
                        this.gotoFieldNext();
                        this.updateDirty();
                        bl = true;
                        break;
                    }
                    this.displayError(25);
                    break;
                }
                this.displayError(5);
                break;
            }
            case 1043: {
                if (this.screenFields.getSize() > 0) {
                    int n8 = this.getRow(this.lastPos) + 1;
                    int n9 = this.lastPos;
                    if (n8 == this.getRows()) {
                        n8 = 0;
                    }
                    this.setCursor(++n8, 1);
                    if (!this.isInField() && this.screenFields.getCurrentField() != null && !this.screenFields.isCurrentFieldBypassField()) {
                        while (!this.isInField() && this.screenFields.getCurrentField() != null && !this.screenFields.isCurrentFieldBypassField()) {
                            this.advancePos();
                            if (this.lastPos != n9) continue;
                            this.goto_XY(n9);
                            break;
                        }
                    }
                }
                bl = true;
                break;
            }
            case 5018: {
                int n10 = this.getCurrentRow() - 1 + 3;
                if (n10 > this.getRows() - 1) {
                    n10 -= this.getRows();
                }
                this.goto_XY(this.getPos(n10, this.getCurrentCol() - 1));
                bl = true;
                break;
            }
            case 5019: {
                int n11 = this.getCurrentRow() - 1 - 3;
                if (n11 < 0) {
                    n11 = this.getRows() + n11;
                }
                this.goto_XY(this.getPos(n11, this.getCurrentCol() - 1));
                bl = true;
                break;
            }
            case 5021: {
                int n12 = this.getCurrentCol() - 1 - 3;
                int n13 = this.getCurrentRow() - 1;
                if (n12 <= 0) {
                    n12 = this.getColumns() + n12;
                    --n13;
                }
                if (n13 < 0) {
                    n13 = this.getRows() - 1;
                }
                this.process_XY(this.getPos(n13, n12));
                bl = true;
                break;
            }
            case 5020: {
                int n14 = this.getCurrentCol() - 1 + 3;
                int n15 = this.getCurrentRow() - 1;
                if (n14 >= this.getColumns()) {
                    n14 -= this.getColumns();
                    ++n15;
                }
                if (n15 > this.getRows() - 1) {
                    n15 = this.getRows() - n15;
                }
                this.process_XY(this.getPos(n15, n14));
                bl = true;
                break;
            }
            default: {
                this.log.info(" Mnemonic not supported " + n);
            }
        }
        return bl;
    }

    protected boolean simulateKeyStroke(char c) {
        if (this.isStatusErrorCode() && !Character.isISOControl(c) && !this.keyProcessed) {
            if (this.resetRequired) {
                return false;
            }
            this.resetError();
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!Character.isISOControl(c)) {
            if (this.screenFields.getCurrentField() != null && this.screenFields.withinCurrentField(this.lastPos) && !this.screenFields.isCurrentFieldBypassField()) {
                if (this.screenFields.isCurrentFieldFER() && !this.screenFields.withinCurrentField(this.screenFields.getCurrentFieldPos()) && this.lastPos == this.screenFields.getCurrentField().endPos() && this.screenFields.getCurrentFieldPos() > this.screenFields.getCurrentField().endPos()) {
                    this.displayError(24);
                    this.feError = true;
                    return false;
                }
                switch (this.screenFields.getCurrentFieldShift()) {
                    case 0: 
                    case 2: 
                    case 4: {
                        bl = true;
                        break;
                    }
                    case 1: {
                        if (!Character.isLetter(c) && c != ',' && c != '-' && c != '.' && c != ' ') break;
                        bl = true;
                        break;
                    }
                    case 3: {
                        if (Character.isDigit(c) || c == '+' || c == ',' || c == '-' || c == '.' || c == ' ') {
                            bl = true;
                            break;
                        }
                        bl2 = true;
                        break;
                    }
                    case 5: {
                        if (Character.isDigit(c)) {
                            bl = true;
                            break;
                        }
                        this.displayError(16);
                        break;
                    }
                    case 7: {
                        if (Character.isDigit(c) || c == '+' || c == '-') {
                            if (this.lastPos == this.screenFields.getCurrentField().endPos() && c != '+' && c != '-') {
                                this.displayError(17);
                                break;
                            }
                            bl = true;
                            break;
                        }
                        this.displayError(16);
                    }
                }
                if (bl) {
                    if (this.screenFields.isCurrentFieldToUpper()) {
                        c = Character.toUpperCase(c);
                    }
                    bl3 = true;
                    this.resetDirty(this.lastPos);
                    if (this.oia.isInsertMode()) {
                        if (this.endOfField(false) != this.screenFields.getCurrentField().endPos()) {
                            this.shiftRight(this.lastPos);
                        } else {
                            this.displayError(18);
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        this.screenFields.getCurrentField().getKeyPos(this.getRow(this.lastPos), this.getCol(this.lastPos));
                        this.screenFields.getCurrentField().changePos(1);
                        this.planes.setChar(this.lastPos, c);
                        this.screenFields.setCurrentFieldMDT();
                        if (!this.screenFields.withinCurrentField(this.screenFields.getCurrentFieldPos())) {
                            if (this.screenFields.isCurrentFieldAutoEnter()) {
                                bl4 = true;
                            } else if (!this.screenFields.isCurrentFieldFER()) {
                                this.gotoFieldNext();
                            }
                        } else {
                            this.setCursor(this.screenFields.getCurrentField().getCursorRow() + 1, this.screenFields.getCurrentField().getCursorCol() + 1);
                        }
                    }
                    this.fireScreenChanged(1);
                    if (bl4) {
                        this.sendAid(241);
                    }
                } else if (bl2) {
                    this.displayError(9);
                }
            } else {
                this.displayError(5);
            }
        }
        return bl3;
    }

    private int endOfField(boolean bl) {
        return this.endOfField(this.lastPos, bl);
    }

    private int endOfField(int n, boolean bl) {
        int n2;
        int n3 = n2 = this.screenFields.getCurrentField().endPos();
        int n4 = n2 - n;
        while (this.planes.getChar(n2) <= ' ' && n4-- > 0) {
            --n2;
        }
        if (n2 == n3) {
            return n2;
        }
        this.screenFields.getCurrentField().getKeyPos(n2);
        if (bl) {
            this.screenFields.getCurrentField().changePos(1);
        }
        return this.screenFields.getCurrentFieldPos();
    }

    private boolean fieldExit() {
        int n;
        int n2 = this.lastPos;
        boolean bl = false;
        int n3 = this.endOfField(false);
        ScreenField screenField = this.screenFields.getCurrentField();
        if (screenField.isMandatoryEnter() && n3 == screenField.startPos()) {
            this.displayError(33);
            return false;
        }
        int n4 = screenField.getCurrentPos();
        int n5 = n3 - screenField.startPos() - screenField.getKeyPos(n2);
        if (n5 == 0 && screenField.isFER() && n4 > screenField.endPos()) {
            bl = true;
            return bl;
        }
        while (n5 >= 0) {
            this.planes.setChar(n2, '\u0000');
            this.setDirty(n2);
            ++n2;
            bl = true;
            --n5;
        }
        if (n5 == -1 && ((n = screenField.getFieldShift()) == 3 || n == 5 || n == 7)) {
            bl = true;
        }
        if ((n = screenField.getAdjustment()) != 0) {
            switch (n) {
                case 5: {
                    this.rightAdjustField('0');
                    screenField.setRightAdjusted();
                    break;
                }
                case 6: {
                    this.rightAdjustField(' ');
                    screenField.setRightAdjusted();
                    break;
                }
                case 7: {
                    screenField.setManditoryEntered();
                }
            }
        } else if (screenField.isSignedNumeric()) {
            this.rightAdjustField(' ');
        }
        return bl;
    }

    private void rightAdjustField(char c) {
        int n = this.endOfField(false);
        int n2 = this.screenFields.getCurrentField().endPos() - n;
        if (!this.screenFields.getCurrentField().isSignedNumeric() || this.planes.getChar(n - 1) != '-') {
            // empty if block
        }
        int n3 = this.screenFields.getCurrentField().startPos();
        while (true) {
            int n4 = --n2;
            --n2;
            if (n4 < 0) break;
            this.shiftRight(n3);
            this.planes.setChar(n3, c);
            this.setDirty(n3);
        }
    }

    private void shiftLeft(int n) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = n;
        int n6 = n;
        ScreenField screenField = this.screenFields.getCurrentField();
        do {
            n3 = this.endOfField(n6, false);
            n2 = n3 - this.screenFields.getCurrentField().startPos() - this.screenFields.getCurrentField().getKeyPos(n6);
            while (n2-- > 0) {
                this.planes.setChar(n6, this.planes.getChar(++n5));
                this.setDirty(n6);
                n6 = n5;
            }
            if (!this.screenFields.isCurrentFieldContinued()) continue;
            this.gotoFieldNext();
            if (this.screenFields.getCurrentField().isContinuedFirst()) break;
            n5 = this.screenFields.getCurrentField().startPos();
            this.planes.setChar(n6, this.planes.getChar(n5));
            this.setDirty(n6);
            n6 = n5;
        } while (this.screenFields.isCurrentFieldContinued() && !this.screenFields.getCurrentField().isContinuedFirst());
        n4 = n3 >= 0 && n2 >= -1 ? n3 : n;
        this.screenFields.setCurrentField(screenField);
        this.planes.setChar(n4, '\u0000');
        this.setDirty(n4);
        this.goto_XY(this.screenFields.getCurrentFieldPos());
        screenField = null;
    }

    private void shiftRight(int n) {
        int n2;
        int n3 = n2 = this.endOfField(true);
        int n4 = n2;
        int n5 = n2 - n;
        while (n5-- > 0) {
            this.planes.setChar(n4, this.planes.getChar(--n3));
            this.setDirty(n4);
            n4 = n3;
        }
    }

    public int getRow(int n) {
        int n2 = n / this.numCols;
        if (n2 < 0) {
            n2 = this.lastPos / this.numCols;
        }
        if (n2 > this.lenScreen / this.numCols - 1) {
            n2 = this.lenScreen / this.numCols - 1;
        }
        return n2;
    }

    public int getCol(int n) {
        int n2 = n % this.getColumns();
        if (n2 > 0) {
            return n2;
        }
        return 0;
    }

    public int getPos(int n, int n2) {
        return n * this.numCols + n2;
    }

    public int getCurrentPos() {
        return this.lastPos + 1;
    }

    private void displayError(int n) {
        this.saveHomePos = this.homePos;
        this.homePos = this.lastPos + this.numCols + 1;
        this.pendingInsert = true;
        this.sessionVT.sendNegResponse2(n);
    }

    private void process_XY(int n) {
        if (n < 0) {
            n = this.lenScreen + n;
        }
        if (n > this.lenScreen - 1) {
            n -= this.lenScreen;
        }
        ScreenField screenField = this.screenFields.getCurrentField();
        if (this.feError) {
            this.feError = false;
            screenField.changePos(-1);
        } else {
            if (screenField != null && screenField.isFER() && screenField.getCurrentPos() > screenField.endPos()) {
                if (screenField.withinField(n)) {
                    screenField.getKeyPos(n);
                    return;
                }
                screenField.getKeyPos(screenField.endPos());
            }
            this.goto_XY(n);
        }
    }

    public boolean isUsingGuiInterface() {
        return this.guiInterface;
    }

    protected boolean isInField() {
        return this.isInField(this.lastPos, true);
    }

    public boolean isInField(int n, boolean bl) {
        return this.screenFields.isInField(n, bl);
    }

    public boolean isInField(int n) {
        return this.screenFields.isInField(n, true);
    }

    public boolean isInField(int n, int n2) {
        return this.isInField(n, n2, true);
    }

    public boolean isInField(int n, int n2, boolean bl) {
        return this.screenFields.isInField(n * this.numCols + n2, bl);
    }

    public int getScreenLength() {
        return this.lenScreen;
    }

    public int getRows() {
        return this.numRows;
    }

    public int getColumns() {
        return this.numCols;
    }

    public int getCurrentRow() {
        return this.lastPos / this.numCols + 1;
    }

    public int getCurrentCol() {
        return this.lastPos % this.numCols + 1;
    }

    protected int getLastPos() {
        return this.lastPos;
    }

    public StringBuffer getHSMore() {
        return this.hsMore;
    }

    public StringBuffer getHSBottom() {
        return this.hsBottom;
    }

    public char[] getScreenAsAllChars() {
        char[] cArray = new char[this.lenScreen];
        for (int i = 0; i < this.lenScreen; ++i) {
            int n = this.planes.getChar(i);
            cArray[i] = n >= 32 && !this.planes.isAttributePlace(i) ? n : 32;
        }
        return cArray;
    }

    public char[] getScreenAsChars() {
        char[] cArray = new char[this.lenScreen];
        for (int i = 0; i < this.lenScreen; ++i) {
            int n = this.planes.getChar(i);
            cArray[i] = n >= 32 && !this.planes.isAttributePlace(i) ? n : 32;
        }
        return cArray;
    }

    public char[] getData(int n, int n2, int n3, int n4, int n5) {
        try {
            int n6 = this.getPos(n, n2);
            int n7 = this.getPos(n3, n4);
            if (n6 > n7) {
                int n8;
                n7 = n8 = n6;
                n6 = n8;
            }
            return this.planes.getPlaneData(n6, n7, n5);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public synchronized int GetScreen(char[] cArray, int n, int n2) {
        return this.GetScreen(cArray, n, 0, this.lenScreen, n2);
    }

    public synchronized int GetScreen(char[] cArray, int n, int n2, int n3, int n4) {
        return this.planes.GetScreen(cArray, n, n2, n3, n4);
    }

    public synchronized int GetScreen(char[] cArray, int n, int n2, int n3, int n4, int n5) {
        return this.planes.GetScreen(cArray, n, n2, n3, n4, n5);
    }

    public synchronized int GetScreenRect(char[] cArray, int n, int n2, int n3, int n4) {
        return this.planes.GetScreenRect(cArray, n, n2, n3, n4);
    }

    public synchronized int GetScreenRect(char[] cArray, int n, int n2, int n3, int n4, int n5, int n6) {
        return this.planes.GetScreenRect(cArray, n, n2, n3, n4, n5, n6);
    }

    public synchronized boolean[] getActiveAidKeys() {
        return this.sessionVT.getActiveAidKeys();
    }

    protected synchronized void setScreenData(String string, int n) {
        int n2;
        if (n < 0 || n > this.lenScreen) {
            return;
        }
        int n3 = n;
        int n4 = string.length();
        boolean bl = false;
        boolean bl2 = false;
        for (n2 = 0; n2 < n4; ++n2) {
            if (!this.isInField(n3 + n2, true) || this.screenFields.getCurrentField().isBypassField()) continue;
            if (!bl2) {
                this.screenFields.getCurrentField().setMDT();
                bl = true;
                this.resetDirty(n3 + n2);
                this.screenFields.setMasterMDT();
                bl2 = true;
            }
            this.planes.screen[n3 + n2] = string.charAt(n2);
            this.setDirty(n3 + n2);
        }
        this.lastPos = n3 + n2;
        if (bl) {
            this.fireScreenChanged(1);
        }
    }

    public void setCursor(int n, int n2) {
        this.goto_XY((n - 1) * this.numCols + (n2 - 1));
    }

    protected void goto_XY(int n) {
        this.updateCursorLoc();
        this.lastPos = n;
        this.updateCursorLoc();
    }

    public boolean gotoField(int n) {
        int n2 = this.screenFields.getSize();
        if (n > n2 || n <= 0) {
            return false;
        }
        this.screenFields.setCurrentField(this.screenFields.getField(n - 1));
        while (this.screenFields.isCurrentFieldBypassField() && n < n2) {
            this.screenFields.setCurrentField(this.screenFields.getField(n++));
        }
        return this.gotoField(this.screenFields.getCurrentField());
    }

    protected boolean gotoField(ScreenField screenField) {
        if (screenField != null) {
            this.goto_XY(screenField.startPos());
            return true;
        }
        return false;
    }

    private void gotoNextWord() {
        int n = this.lastPos;
        if (this.planes.getChar(this.lastPos) > ' ') {
            this.advancePos();
            while (this.planes.getChar(this.lastPos) > ' ' && n != this.lastPos) {
                this.advancePos();
            }
        } else {
            this.advancePos();
        }
        while (this.planes.getChar(this.lastPos) <= ' ' && n != this.lastPos) {
            this.advancePos();
        }
    }

    private void gotoPrevWord() {
        int n = this.lastPos;
        this.changePos(-1);
        while (this.planes.getChar(this.lastPos) <= ' ') {
            this.changePos(-1);
            if (n != this.lastPos) continue;
        }
        this.changePos(-1);
        while (this.planes.getChar(this.lastPos) > ' ' && n != this.lastPos) {
            this.changePos(-1);
        }
        this.advancePos();
    }

    private void gotoFieldNext() {
        if (this.screenFields.isCurrentFieldHighlightedEntry()) {
            this.unsetFieldHighlighted(this.screenFields.getCurrentField());
        }
        this.screenFields.gotoFieldNext();
        if (this.screenFields.isCurrentFieldHighlightedEntry()) {
            this.setFieldHighlighted(this.screenFields.getCurrentField());
        }
    }

    private void gotoFieldPrev() {
        if (this.screenFields.isCurrentFieldHighlightedEntry()) {
            this.unsetFieldHighlighted(this.screenFields.getCurrentField());
        }
        this.screenFields.gotoFieldPrev();
        if (this.screenFields.isCurrentFieldHighlightedEntry()) {
            this.setFieldHighlighted(this.screenFields.getCurrentField());
        }
    }

    protected void createWindow(int n, int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        int n14 = this.getCol(this.lastPos);
        int n15 = 0;
        n15 = ++n2;
        this.planes.setScreenCharAndAttr(this.lastPos, '\u0000', 32, true);
        this.setDirty(this.lastPos);
        this.advancePos();
        this.planes.setScreenCharAndAttr(this.lastPos, (char)n6, n5, false);
        if (bl) {
            this.planes.setUseGUI(this.lastPos, 1);
        }
        this.setDirty(this.lastPos);
        this.advancePos();
        while (n15-- >= 0) {
            this.planes.setScreenCharAndAttr(this.lastPos, (char)n7, n5, false);
            if (bl) {
                this.planes.setUseGUI(this.lastPos, 2);
            }
            this.setDirty(this.lastPos);
            this.advancePos();
        }
        this.planes.setScreenCharAndAttr(this.lastPos, (char)n8, n5, false);
        if (bl) {
            this.planes.setUseGUI(this.lastPos, 3);
        }
        this.setDirty(this.lastPos);
        this.advancePos();
        this.planes.setScreenCharAndAttr(this.lastPos, '\u0000', 32, true);
        this.setDirty(this.lastPos);
        this.lastPos = (this.getRow(this.lastPos) + 1) * this.numCols + n14;
        while (n-- > 0) {
            this.planes.setScreenCharAndAttr(this.lastPos, '\u0000', 32, true);
            this.setDirty(this.lastPos);
            this.advancePos();
            this.planes.setScreenCharAndAttr(this.lastPos, (char)n9, n5, false);
            if (bl) {
                this.planes.setUseGUI(this.lastPos, 4);
            }
            this.setDirty(this.lastPos);
            this.advancePos();
            n15 = n2;
            while (n15-- >= 0) {
                this.planes.setScreenCharAndAttr(this.lastPos, '\u0000', 32, true);
                this.planes.setUseGUI(this.lastPos, 0);
                this.setDirty(this.lastPos);
                this.advancePos();
            }
            this.planes.setScreenCharAndAttr(this.lastPos, (char)n10, n5, false);
            if (bl) {
                this.planes.setUseGUI(this.lastPos, 5);
            }
            this.setDirty(this.lastPos);
            this.advancePos();
            this.planes.setScreenCharAndAttr(this.lastPos, '\u0000', 32, true);
            this.setDirty(this.lastPos);
            this.lastPos = (this.getRow(this.lastPos) + 1) * this.numCols + n14;
        }
        this.planes.setScreenCharAndAttr(this.lastPos, '\u0000', 32, true);
        this.setDirty(this.lastPos);
        this.advancePos();
        this.planes.setScreenCharAndAttr(this.lastPos, (char)n11, n5, false);
        if (bl) {
            this.planes.setUseGUI(this.lastPos, 6);
        }
        this.setDirty(this.lastPos);
        this.advancePos();
        n15 = n2;
        while (n15-- >= 0) {
            this.planes.setScreenCharAndAttr(this.lastPos, (char)n12, n5, false);
            if (bl) {
                this.planes.setUseGUI(this.lastPos, 7);
            }
            this.setDirty(this.lastPos);
            this.advancePos();
        }
        this.planes.setScreenCharAndAttr(this.lastPos, (char)n13, n5, false);
        if (bl) {
            this.planes.setUseGUI(this.lastPos, 8);
        }
        this.setDirty(this.lastPos);
        this.advancePos();
        this.planes.setScreenCharAndAttr(this.lastPos, '\u0000', 32, true);
        this.setDirty(this.lastPos);
    }

    protected void createScrollBar(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.lastPos;
        int n8 = n6 - 2;
        int n9 = (int)((float)n8 * ((float)n5 / (float)n3));
        this.planes.setScreenCharAndAttr(n7, ' ', 32, false);
        this.planes.setUseGUI(n7, 28);
        for (int i = 0; i < n8; ++i) {
            this.planes.setScreenCharAndAttr(n7 += this.numCols, ' ', 32, false);
            if (i == n9) {
                this.planes.setUseGUI(n7, 31);
                continue;
            }
            this.planes.setUseGUI(n7, 30);
        }
        this.planes.setScreenCharAndAttr(n7 += this.numCols, ' ', 32, false);
        this.planes.setUseGUI(n7, 29);
    }

    protected void writeWindowTitle(int n, int n2, int n3, byte by, int n4, int n5, StringBuffer stringBuffer) {
        int n6 = stringBuffer.length();
        switch (by & 0xC0) {
            case 64: {
                n += 4 + n3 - n6;
                break;
            }
            case 128: {
                n += 2;
                break;
            }
            default: {
                n += 3 + (n3 / 2 - n6 / 2);
            }
        }
        if ((by & 0x20) == 32) {
            n += (n2 + 1) * this.numCols;
        }
        for (int i = 0; i < n6; ++i) {
            this.planes.setChar(n, stringBuffer.charAt(i));
            this.planes.setUseGUI(n++, 0);
        }
    }

    protected void rollScreen(int n, int n2, int n3) {
        int n4 = n & 0x80;
        int n5 = n & 0x7F;
        int n6 = this.getPos(n2 - 1, 0);
        int n7 = this.getPos(n3 - 1, this.numCols - 1);
        int n8 = n7 - n6;
        switch (n4) {
            case 0: {
                for (int i = n6; i < n7 + this.numCols; ++i) {
                    if (i + n5 * this.numCols >= this.lenScreen) {
                        this.planes.setChar(i, ' ');
                        continue;
                    }
                    this.planes.setChar(i, this.planes.getChar(i + n5 * this.numCols));
                }
                break;
            }
            case 1: {
                for (int i = n7 + this.numCols; i > 0; --i) {
                    if (i - n5 * this.numCols < 0) continue;
                    this.planes.setChar(i - n5 * this.numCols, this.planes.getChar(i));
                    this.planes.setChar(i, ' ');
                }
                break;
            }
            default: {
                this.log.warn(" Invalid roll parameter - please report this");
            }
        }
    }

    public void dumpScreen() {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = this.getScreenAsChars();
        int n = this.getColumns();
        int n2 = this.getRows() * n;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            stringBuffer.append(cArray[n4]);
            if (n3 == n) {
                stringBuffer.append('\n');
                n3 = 0;
            }
            ++n4;
            ++n3;
        }
        this.log.info(stringBuffer.toString());
    }

    protected void addField(int n, int n2, int n3, int n4, int n5, int n6) {
        this.lastAttr = n;
        this.planes.setScreenCharAndAttr(this.lastPos, '\u0000', this.lastAttr, true);
        this.setDirty(this.lastPos);
        this.advancePos();
        ScreenField screenField = null;
        if (this.screenFields.existsAtPos(this.lastPos)) {
            this.screenFields.setCurrentFieldFFWs(n3, n4);
        } else {
            screenField = this.screenFields.setField(n, this.getRow(this.lastPos), this.getCol(this.lastPos), n2, n3, n4, n5, n6);
            this.lastPos = screenField.startPos();
            int n7 = n2;
            boolean bl = this.guiInterface;
            if (screenField.isBypassField()) {
                bl = false;
            }
            while (n7-- > 0) {
                if (this.planes.getChar(this.lastPos) == '\u0000') {
                    this.planes.setScreenCharAndAttr(this.lastPos, ' ', this.lastAttr, false);
                } else {
                    this.planes.setScreenAttr(this.lastPos, this.lastAttr);
                }
                if (bl) {
                    this.planes.setUseGUI(this.lastPos, 11);
                }
                this.planes.setScreenFieldAttr(this.lastPos, n3);
                this.advancePos();
            }
            if (bl) {
                if (n2 > 1) {
                    this.planes.setUseGUI(screenField.startPos(), 9);
                    if (this.lastPos > 0) {
                        this.planes.setUseGUI(this.lastPos - 1, 10);
                    } else {
                        this.planes.setUseGUI(this.lastPos, 10);
                    }
                } else {
                    this.planes.setUseGUI(this.lastPos - 1, 12);
                }
            }
            this.setEndingAttr(32);
            this.lastPos = screenField.startPos();
        }
        screenField = null;
    }

    public ScreenFields getScreenFields() {
        return this.screenFields;
    }

    protected void drawFields() {
        int n = this.screenFields.getSize();
        for (int i = 0; i < n; ++i) {
            ScreenField screenField = this.screenFields.getField(i);
            if (screenField.isBypassField()) continue;
            int n2 = screenField.startPos();
            int n3 = screenField.length;
            boolean bl = true;
            if (n3 >= this.lenScreen) {
                n3 = this.lenScreen - 1;
            }
            if (n3 > 1) {
                while (n3-- > 0) {
                    if (this.guiInterface && bl) {
                        this.planes.setUseGUI(n2, 9);
                        bl = false;
                    } else {
                        this.planes.setUseGUI(n2, 11);
                    }
                    if (this.guiInterface && n3 == 0) {
                        this.planes.setUseGUI(n2, 10);
                    }
                    this.setDirty(n2++);
                }
                continue;
            }
            this.planes.setUseGUI(n2, 12);
        }
    }

    protected void drawField(ScreenField screenField) {
        int n = screenField.startPos();
        int n2 = screenField.length;
        while (n2-- > 0) {
            this.setDirty(n++);
        }
        this.updateDirty();
    }

    protected void setFieldHighlighted(ScreenField screenField) {
        int n = screenField.startPos();
        int n2 = screenField.length;
        int n3 = screenField.getHighlightedAttr();
        while (n2-- > 0) {
            this.planes.setScreenAttr(n, n3);
            this.setDirty(n++);
        }
        this.fireScreenChanged(1);
    }

    protected void unsetFieldHighlighted(ScreenField screenField) {
        int n = screenField.startPos();
        int n2 = screenField.length;
        int n3 = screenField.getAttr();
        while (n2-- > 0) {
            this.planes.setScreenAttr(n, n3);
            this.setDirty(n++);
        }
        this.fireScreenChanged(1);
    }

    public boolean checkHotSpots() {
        return this.planes.checkHotSpots();
    }

    protected void setChar(int n) {
        if (this.lastPos > 0) {
            this.lastAttr = this.planes.getCharAttr(this.lastPos - 1);
        }
        if (n > 0 && (char)n < ' ') {
            this.planes.setScreenCharAndAttr(this.lastPos, '\u0000', 33, false);
            this.setDirty(this.lastPos);
            this.advancePos();
        } else {
            this.planes.setScreenCharAndAttr(this.lastPos, (char)n, this.lastAttr, false);
            this.setDirty(this.lastPos);
            if (this.guiInterface && !this.isInField(this.lastPos, false)) {
                this.planes.setUseGUI(this.lastPos, 0);
            }
            this.advancePos();
        }
    }

    protected void setEndingAttr(int n) {
        int n2 = this.lastAttr;
        this.setAttr(n);
        this.lastAttr = n2;
    }

    protected void setAttr(int n) {
        this.lastAttr = n;
        this.planes.setScreenCharAndAttr(this.lastPos, '\u0000', this.lastAttr, true);
        this.setDirty(this.lastPos);
        this.advancePos();
        int n2 = this.lastPos;
        int n3 = 0;
        while (this.planes.getCharAttr(this.lastPos) != this.lastAttr && !this.planes.isAttributePlace(this.lastPos)) {
            int n4;
            this.planes.setScreenAttr(this.lastPos, this.lastAttr);
            if (this.guiInterface && !this.isInField(this.lastPos, false) && (n4 = this.planes.getWhichGUI(this.lastPos)) >= 9 && n4 <= 12) {
                this.planes.setUseGUI(this.lastPos, 0);
            }
            this.setDirty(this.lastPos);
            ++n3;
            this.advancePos();
        }
        this.lastPos = n2;
    }

    protected void setScreenCharAndAttr(char c, int n, boolean bl) {
        this.planes.setScreenCharAndAttr(this.lastPos, c, n, bl);
        this.setDirty(this.lastPos);
        this.advancePos();
    }

    protected void setScreenCharAndAttr(char c, int n, int n2, boolean bl) {
        this.planes.setScreenCharAndAttr(this.lastPos, c, n, bl);
        this.planes.setUseGUI(this.lastPos, n2);
        this.setDirty(this.lastPos);
        this.advancePos();
    }

    protected void updateDirty() {
        this.fireScreenChanged(1);
    }

    protected void setDirty(int n) {
        int n2 = Math.min(this.getRow(n), this.getRow(this.dirtyScreen.x));
        int n3 = Math.min(this.getCol(n), this.getCol(this.dirtyScreen.x));
        int n4 = Math.max(this.getRow(n), this.getRow(this.dirtyScreen.y));
        int n5 = Math.max(this.getCol(n), this.getCol(this.dirtyScreen.y));
        int n6 = this.getPos(n2, n3);
        int n7 = this.getPos(n4, n5);
        this.dirtyScreen.setBounds(n6, n7, 0, 0);
    }

    private void resetDirty(int n) {
        this.dirtyScreen.setBounds(n, n, 0, 0);
    }

    protected void advancePos() {
        this.changePos(1);
    }

    protected void changePos(int n) {
        this.lastPos += n;
        if (this.lastPos < 0) {
            this.lastPos = this.lenScreen + this.lastPos;
        }
        if (this.lastPos > this.lenScreen - 1) {
            this.lastPos -= this.lenScreen;
        }
    }

    protected void goHome() {
        if (this.pendingInsert && this.homePos > 0) {
            this.setCursor(this.getRow(this.homePos), this.getCol(this.homePos));
            this.isInField();
        } else if (!this.gotoField(1)) {
            this.homePos = this.getPos(1, 1);
            this.setCursor(1, 1);
            this.isInField(0, 0);
        } else {
            this.homePos = this.getPos(this.getCurrentRow(), this.getCurrentCol());
        }
    }

    protected void setPendingInsert(boolean bl, int n, int n2) {
        this.pendingInsert = bl;
        if (this.pendingInsert) {
            this.homePos = this.getPos(n, n2);
        }
        if (!this.isStatusErrorCode()) {
            this.setCursor(n, n2);
        }
    }

    protected void setPendingInsert(boolean bl) {
        if (this.homePos != -1) {
            this.pendingInsert = bl;
        }
    }

    protected void setErrorLine(int n) {
        this.planes.setErrorLine(n);
    }

    protected int getErrorLine() {
        return this.planes.getErrorLine();
    }

    protected void saveErrorLine() {
        this.planes.saveErrorLine();
    }

    protected void restoreErrorLine() {
        if (this.planes.isErrorLineSaved()) {
            this.planes.restoreErrorLine();
            this.fireScreenChanged(1, this.planes.getErrorLine() - 1, 0, this.planes.getErrorLine() - 1, this.numCols - 1);
        }
    }

    protected void setStatus(byte by, byte by2, String string) {
        switch (by) {
            case 1: {
                if (by2 == 1) {
                    this.oia.setInputInhibited(1, 1, string);
                    break;
                }
                this.oia.setInputInhibited(0, 2, string);
                break;
            }
            case 2: {
                if (by2 == 1) {
                    this.setPrehelpState(true, true, false);
                    this.oia.setInputInhibited(1, 10, string);
                    this.sessionVT.signalBell();
                    break;
                }
                this.oia.setInputInhibited(0, 2);
                this.setPrehelpState(false, true, true);
                this.homePos = this.saveHomePos;
                this.saveHomePos = 0;
                this.pendingInsert = false;
            }
        }
    }

    protected boolean isStatusErrorCode() {
        return this.oia.getLevel() == 10;
    }

    protected void clearAll() {
        this.lastAttr = 32;
        this.lastPos = 0;
        this.clearTable();
        this.clearScreen();
        this.planes.setScreenAttr(0, 32);
        this.oia.setInsertMode(false);
    }

    protected void clearTable() {
        this.oia.setKeyBoardLocked(true);
        this.screenFields.clearFFT();
        this.planes.initalizeFieldPlanes();
        this.pendingInsert = false;
        this.homePos = -1;
    }

    protected void clearGuiStuff() {
        for (int i = 0; i < this.lenScreen; ++i) {
            this.planes.setUseGUI(i, 0);
        }
        this.dirtyScreen.setBounds(0, this.lenScreen - 1, 0, 0);
    }

    protected void clearScreen() {
        this.planes.initalizePlanes();
        this.dirtyScreen.setBounds(0, this.lenScreen - 1, 0, 0);
        this.oia.clearScreen();
    }

    protected void restoreScreen() {
        this.lastAttr = 32;
        this.dirtyScreen.setBounds(0, this.lenScreen - 1, 0, 0);
        this.updateDirty();
    }

    private void fireScreenChanged(int n, int n2, int n3, int n4, int n5) {
        if (this.listeners != null) {
            Vector<ScreenListener> vector = new Vector<ScreenListener>(this.listeners);
            int n6 = vector.size();
            for (int i = 0; i < n6; ++i) {
                ScreenListener screenListener = vector.elementAt(i);
                screenListener.onScreenChanged(1, n2, n3, n4, n5);
            }
        }
        this.dirtyScreen.setBounds(this.lenScreen, 0, 0, 0);
    }

    private synchronized void fireScreenChanged(int n) {
        if (this.dirtyScreen.x > this.dirtyScreen.y) {
            return;
        }
        this.fireScreenChanged(n, this.getRow(this.dirtyScreen.x), this.getCol(this.dirtyScreen.x), this.getRow(this.dirtyScreen.y), this.getCol(this.dirtyScreen.y));
    }

    private synchronized void fireCursorChanged(int n) {
        int n2 = this.getRow(this.lastPos);
        int n3 = this.getCol(this.lastPos);
        if (this.listeners != null) {
            Vector<ScreenListener> vector = new Vector<ScreenListener>(this.listeners);
            int n4 = vector.size();
            for (int i = 0; i < n4; ++i) {
                ScreenListener screenListener = vector.elementAt(i);
                screenListener.onScreenChanged(n, n2, n3, n2, n3);
            }
        }
    }

    private void fireScreenSizeChanged() {
        if (this.listeners != null) {
            Vector<ScreenListener> vector = new Vector<ScreenListener>(this.listeners);
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ScreenListener screenListener = vector.elementAt(i);
                screenListener.onScreenSizeChanged(this.numRows, this.numCols);
            }
        }
    }

    public final void updateScreen() {
        this.repaintScreen();
        this.setCursorActive(false);
        this.setCursorActive(true);
    }

    public void addScreenListener(ScreenListener screenListener) {
        if (this.listeners == null) {
            this.listeners = new Vector(3);
        }
        this.listeners.addElement(screenListener);
    }

    public void removeScreenListener(ScreenListener screenListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(screenListener);
    }

    public void repaintScreen() {
        this.setCursorOff();
        this.dirtyScreen.setBounds(0, this.lenScreen - 1, 0, 0);
        this.updateDirty();
        if (this.oia.getLevel() == 10) {
            this.oia.setInputInhibited(1, 10);
        }
        if (this.oia.getLevel() == 1) {
            this.oia.setInputInhibited(1, 1);
        }
        if (this.oia.isMessageWait()) {
            this.oia.setMessageLightOn();
        }
        this.setCursorOn();
    }

    public char[] getCharacters() {
        return this.planes.screen;
    }
}

