/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.tn5250;

import org.tn5250j.framework.tn5250.Screen5250;

public class ScreenField {
    int startPos = 0;
    int endPos = 0;
    boolean mdt = false;
    protected boolean checkCanSend;
    protected boolean rightAdjd;
    protected boolean manditoried;
    boolean canSend = true;
    int attr = 0;
    int length = 0;
    int ffw1 = 0;
    int ffw2 = 0;
    int fcw1 = 0;
    int fcw2 = 0;
    int cursorPos = 0;
    Screen5250 s;
    int cursorProg = 0;
    int fieldId = 0;
    ScreenField next = null;
    ScreenField prev = null;
    boolean isSelectionField;
    int selectionFieldType;
    int selectionIndex;
    int selectionPos;

    protected ScreenField(Screen5250 screen5250) {
        this.s = screen5250;
    }

    protected ScreenField setField(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.setField(n, this.s.getCurrentRow() - 1, this.s.getCurrentCol() - 1, n2, n3, n4, n5, n6);
    }

    protected ScreenField setField(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.startPos = n2 * this.s.getColumns() + n3;
        this.endPos = this.startPos + this.length - 1;
        this.cursorProg = 0;
        this.fieldId = 0;
        this.length = n4;
        this.endPos = this.startPos + this.length - 1;
        this.attr = n;
        this.setFFWs(n5, n6);
        this.setFCWs(n7, n8);
        this.next = null;
        this.prev = null;
        return this;
    }

    public int getAttr() {
        return this.attr;
    }

    public int getHighlightedAttr() {
        return this.fcw2 & 0xF | 0x20;
    }

    public int getLength() {
        return this.length;
    }

    protected boolean setFFWs(int n, int n2) {
        this.ffw1 = n;
        this.ffw2 = n2;
        int n3 = this.getAdjustment();
        if (n3 > 0) {
            this.checkCanSend = true;
            switch (n3) {
                case 5: 
                case 6: {
                    this.rightAdjd = false;
                    break;
                }
                case 7: {
                    this.manditoried = false;
                }
            }
        }
        this.mdt = (n & 8) == 8;
        return this.mdt;
    }

    public int getFFW1() {
        return this.ffw1;
    }

    public int getFFW2() {
        return this.ffw2;
    }

    protected void setFCWs(int n, int n2) {
        this.fcw1 = n;
        this.fcw2 = n2;
        if (n == 136) {
            this.cursorProg = n2;
        }
    }

    public int getFCW1() {
        return this.fcw1;
    }

    public int getFCW2() {
        return this.fcw2;
    }

    public int getFieldLength() {
        return this.length;
    }

    public int getCursorProgression() {
        return this.cursorProg;
    }

    public int getFieldId() {
        return this.fieldId;
    }

    protected void setFieldId(int n) {
        this.fieldId = n;
    }

    public int getCursorRow() {
        return this.cursorPos / this.s.getColumns();
    }

    public int getCursorCol() {
        return this.cursorPos % this.s.getColumns();
    }

    protected void changePos(int n) {
        this.cursorPos += n;
    }

    protected String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getKeyPos(this.endPos);
        int n = this.length;
        stringBuffer.setLength(n);
        while (n-- > 0) {
            if (this.s.planes.isAttributePlace(this.cursorPos)) {
                stringBuffer.setCharAt(n, (char)(65280 + this.s.planes.getCharAttr(this.cursorPos)));
            } else {
                stringBuffer.setCharAt(n, this.s.planes.getChar(this.cursorPos));
            }
            this.changePos(-1);
        }
        if (this.isContinued() && this.isContinuedFirst()) {
            ScreenField screenField = this;
            do {
                screenField = screenField.next;
                stringBuffer.append(screenField.getText());
            } while (!screenField.isContinuedLast());
            screenField = null;
        }
        return stringBuffer.toString();
    }

    public String getString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getKeyPos(this.endPos);
        int n = this.length;
        stringBuffer.setLength(n);
        while (n-- > 0) {
            if (this.s.planes.isAttributePlace(this.cursorPos)) {
                stringBuffer.setCharAt(n, (char)(65280 + this.s.planes.getCharAttr(this.cursorPos)));
            } else if (this.s.planes.getChar(this.cursorPos) < ' ') {
                stringBuffer.setCharAt(n, ' ');
            } else {
                stringBuffer.setCharAt(n, this.s.planes.getChar(this.cursorPos));
            }
            this.changePos(-1);
        }
        if (this.isContinued() && this.isContinuedFirst()) {
            ScreenField screenField = this;
            do {
                screenField = screenField.next;
                stringBuffer.append(screenField.getString());
            } while (!screenField.isContinuedLast());
            screenField = null;
        }
        return stringBuffer.toString();
    }

    public void setFieldChar(char c) {
        int n = this.length;
        this.cursorPos = this.startPos;
        while (n-- > 0) {
            this.s.planes.setChar(this.cursorPos, c);
            this.changePos(1);
        }
    }

    public void setFieldChar(int n, char c) {
        int n2 = this.endPos - n + 1;
        this.cursorPos = n;
        while (n2-- > 0) {
            this.s.planes.setChar(this.cursorPos, c);
            this.s.setDirty(this.cursorPos);
            this.changePos(1);
        }
    }

    protected void setRightAdjusted() {
        this.rightAdjd = true;
    }

    protected void setManditoryEntered() {
        this.manditoried = true;
    }

    protected void resetMDT() {
        this.mdt = false;
    }

    protected void setMDT() {
        if (this.isContinued() && !this.isContinuedFirst()) {
            ScreenField screenField = this.prev;
            while (screenField.isContinued() && !screenField.isContinuedFirst()) {
                screenField = screenField.prev;
            }
            screenField.setMDT();
            screenField = null;
        } else {
            this.mdt = true;
        }
    }

    public boolean isBypassField() {
        return (this.ffw1 & 0x20) == 32;
    }

    public int getAdjustment() {
        return this.ffw2 & 7;
    }

    public boolean isFER() {
        return (this.ffw2 & 0x40) == 64;
    }

    public boolean isMandatoryEnter() {
        return (this.ffw2 & 8) == 8;
    }

    public boolean isToUpper() {
        return (this.ffw2 & 0x20) == 32;
    }

    public int getFieldShift() {
        return this.ffw1 & 7;
    }

    public boolean isHiglightedEntry() {
        return this.fcw1 == 137;
    }

    public boolean isAutoEnter() {
        return (this.ffw2 & 0x80) == 128;
    }

    public boolean isSignedNumeric() {
        return this.getFieldShift() == 7;
    }

    public boolean isRightToLeft() {
        return this.getFieldShift() == 4;
    }

    public boolean isNumeric() {
        return this.getFieldShift() == 3;
    }

    public boolean isDupEnabled() {
        return (this.ffw1 & 0x10) == 16;
    }

    public boolean isContinued() {
        return (this.fcw1 & 0x86) == 134 && this.fcw2 >= 1 && this.fcw2 <= 3;
    }

    public boolean isContinuedFirst() {
        return (this.fcw1 & 0x86) == 134 && this.fcw2 == 1;
    }

    public boolean isContinuedMiddle() {
        return (this.fcw1 & 0x86) == 134 && this.fcw2 == 3;
    }

    public boolean isContinuedLast() {
        return (this.fcw1 & 0x86) == 134 && this.fcw2 == 2;
    }

    protected boolean isCanSend() {
        int n = this.getAdjustment();
        if (this.isFER() && this.cursorPos > this.endPos) {
            return true;
        }
        if (this.isSignedNumeric() && this.cursorPos < this.endPos - 1) {
            return false;
        }
        if (n > 0) {
            switch (n) {
                case 5: 
                case 6: {
                    return this.rightAdjd;
                }
                case 7: {
                    return this.manditoried;
                }
            }
            return true;
        }
        return true;
    }

    public boolean isSelectionField() {
        return this.isSelectionField;
    }

    public void setSelectionFieldInfo(int n, int n2, int n3) {
        this.selectionFieldType = n;
        this.selectionIndex = n2;
        this.selectionPos = n3;
        this.isSelectionField = true;
    }

    protected int getKeyPos(int n, int n2) {
        int n3 = n * this.s.getColumns() + n2;
        int n4 = n3 - this.startPos();
        this.cursorPos = n3;
        return n4;
    }

    protected int getKeyPos(int n) {
        int n2 = n - this.startPos();
        this.cursorPos = n;
        return n2;
    }

    public int getCurrentPos() {
        return this.cursorPos;
    }

    public boolean withinField(int n) {
        return n >= this.startPos && n <= this.endPos;
    }

    public int startPos() {
        return this.startPos;
    }

    public int startRow() {
        return this.startPos / this.s.getColumns();
    }

    public int startCol() {
        return this.startPos % this.s.getColumns();
    }

    public int endPos() {
        return this.endPos;
    }

    public void setString(String string) {
        int n = this.cursorPos = this.isRightToLeft() ? this.endPos - string.length() + 1 : this.startPos;
        if (this.isRightToLeft()) {
            string = new StringBuilder(string).reverse().toString();
        }
        int n2 = string.length();
        for (int i = 0; i < this.length; ++i) {
            char c = i < n2 ? (char)string.charAt(i) : (char)' ';
            this.s.getPlanes().setChar(this.cursorPos, c);
            this.changePos(1);
        }
        this.setMDT();
        this.s.getScreenFields().setMasterMDT();
    }

    public String toString() {
        int n = (this.fcw1 & 0xFF) << 8 | this.fcw2 & 0xFF;
        return "startRow = " + this.startRow() + " startCol = " + this.startCol() + " length = " + this.length + " ffw1 = (0x" + Integer.toHexString(this.ffw1) + ") ffw2 = (0x" + Integer.toHexString(this.ffw2) + ") fcw1 = (0x" + Integer.toHexString(this.fcw1) + ") fcw2 = (0x" + Integer.toHexString(this.fcw2) + ") fcw = (" + Integer.toBinaryString(n) + ") fcw hex = (0x" + Integer.toHexString(n) + ") is bypass field = " + this.isBypassField() + ") is autoenter = " + this.isAutoEnter() + ") is manditoryenter = " + this.isMandatoryEnter() + ") is field exit required = " + this.isFER() + ") is Numeric = " + this.isNumeric() + ") is Signed Numeric = " + this.isSignedNumeric() + ") is cursor progression = " + (this.fcw1 == 136) + ") next progression field = " + this.fcw2 + ") field id " + this.fieldId + " continued edit field = " + this.isContinued() + " first continued edit field = " + this.isContinuedFirst() + " middle continued edit field = " + this.isContinuedMiddle() + " last continued edit field = " + this.isContinuedLast() + " mdt = " + this.mdt;
    }
}

