/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.tn5250;

import java.io.ByteArrayOutputStream;
import org.tn5250j.encoding.ICodePage;
import org.tn5250j.framework.tn5250.Screen5250;
import org.tn5250j.framework.tn5250.ScreenField;

public class ScreenFields {
    private ScreenField[] screenFields;
    private ScreenField currentField;
    private ScreenField saveCurrent;
    private int sizeFields;
    private boolean cpfExists;
    private int nextField;
    private int fieldIds;
    private Screen5250 screen;
    private boolean masterMDT;
    protected boolean currentModified;

    public ScreenFields(Screen5250 screen5250) {
        this.screen = screen5250;
        this.screenFields = new ScreenField[256];
    }

    protected void clearFFT() {
        this.fieldIds = 0;
        this.nextField = 0;
        this.sizeFields = 0;
        this.cpfExists = false;
        this.currentField = null;
        this.masterMDT = false;
    }

    protected boolean existsAtPos(int n) {
        ScreenField screenField = null;
        for (int i = 0; i < this.sizeFields; ++i) {
            screenField = this.screenFields[i];
            if (n != screenField.startPos()) continue;
            this.currentField = screenField;
            this.currentModified = false;
            return true;
        }
        return false;
    }

    public boolean isMasterMDT() {
        return this.masterMDT;
    }

    protected void setMasterMDT() {
        this.masterMDT = true;
    }

    public boolean isCurrentField() {
        return this.currentField == null;
    }

    public boolean isCurrentFieldFER() {
        return this.currentField.isFER();
    }

    public boolean isCurrentFieldDupEnabled() {
        return this.currentField.isDupEnabled();
    }

    public boolean isCurrentFieldToUpper() {
        return this.currentField.isToUpper();
    }

    public boolean isCurrentFieldBypassField() {
        return this.currentField.isBypassField();
    }

    public boolean isCurrentFieldHighlightedEntry() {
        if (this.currentField != null) {
            return this.currentField.isHiglightedEntry();
        }
        return false;
    }

    public boolean isCurrentFieldAutoEnter() {
        return this.currentField.isAutoEnter();
    }

    public boolean withinCurrentField(int n) {
        return this.currentField.withinField(n);
    }

    public boolean isCurrentFieldContinued() {
        return this.currentField.isContinued();
    }

    public boolean isCurrentFieldContinuedFirst() {
        return this.currentField.isContinuedFirst();
    }

    public boolean isCurrentFieldContinuedMiddle() {
        return this.currentField.isContinuedMiddle();
    }

    public boolean isCurrentFieldContinuedLast() {
        return this.currentField.isContinuedLast();
    }

    public boolean isCurrentFieldModified() {
        return this.currentModified;
    }

    public boolean isCanSendAid() {
        return this.currentField == null || this.currentField.getAdjustment() <= 0 && !this.currentField.isSignedNumeric() || !this.currentModified || !this.isInField() || this.currentField.isCanSend();
    }

    protected void saveCurrentField() {
        this.saveCurrent = this.currentField;
    }

    protected void restoreCurrentField() {
        this.currentField = this.saveCurrent;
    }

    protected void setCurrentField(ScreenField screenField) {
        this.currentField = screenField;
    }

    protected void setCurrentFieldMDT() {
        this.currentField.setMDT();
        this.currentModified = true;
        this.masterMDT = true;
    }

    protected void setCurrentFieldFFWs(int n, int n2) {
        this.masterMDT = this.currentField.setFFWs(n, n2);
    }

    protected ScreenField setField(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        ScreenField screenField = null;
        this.screenFields[this.nextField] = new ScreenField(this.screen);
        this.screenFields[this.nextField].setField(n, n2, n3, n4, n5, n6, n7, n8);
        screenField = this.screenFields[this.nextField++];
        ++this.sizeFields;
        screenField.setFieldId(++this.fieldIds);
        if (n7 == 136) {
            this.cpfExists = true;
        }
        if (this.currentField != null) {
            this.currentField.next = screenField;
            screenField.prev = this.currentField;
        }
        this.currentField = screenField;
        if (!this.masterMDT) {
            this.masterMDT = this.currentField.mdt;
        }
        this.currentModified = false;
        return this.currentField;
    }

    public ScreenField getField(int n) {
        return this.screenFields[n];
    }

    public ScreenField getCurrentField() {
        return this.currentField;
    }

    public int getCurrentFieldPos() {
        return this.currentField.getCurrentPos();
    }

    protected int getCurrentFieldShift() {
        return this.currentField.getFieldShift();
    }

    public String getCurrentFieldText() {
        return this.currentField.getText();
    }

    public int getCurrentFieldHighlightedAttr() {
        return this.currentField.getHighlightedAttr();
    }

    public int getSize() {
        return this.sizeFields;
    }

    public int getFieldCount() {
        return this.sizeFields;
    }

    protected boolean isInField(int n) {
        return this.isInField(n, true);
    }

    protected boolean isInField() {
        return this.isInField(this.screen.getLastPos(), true);
    }

    protected boolean isInField(int n, boolean bl) {
        for (int i = 0; i < this.sizeFields; ++i) {
            ScreenField screenField = this.screenFields[i];
            if (!screenField.withinField(n)) continue;
            if (bl) {
                if (!this.currentField.equals(screenField)) {
                    this.currentModified = false;
                }
                this.currentField = screenField;
            }
            return true;
        }
        return false;
    }

    public ScreenField findByString(String string, int n, int n2, int n3, boolean bl) {
        return this.findByPosition(n);
    }

    public ScreenField findByPosition(int n) {
        ScreenField screenField = null;
        for (int i = 0; i < this.sizeFields; ++i) {
            screenField = this.screenFields[i];
            if (!screenField.withinField(n)) continue;
            return screenField;
        }
        return null;
    }

    public ScreenField findByPosition(int n, int n2) {
        return this.findByPosition(this.screen.getPos(n, n2));
    }

    public ScreenField[] getFields() {
        ScreenField[] screenFieldArray = new ScreenField[this.sizeFields];
        for (int i = 0; i < this.sizeFields; ++i) {
            screenFieldArray[i] = this.screenFields[i];
        }
        return screenFieldArray;
    }

    public ScreenField getFirstInputField() {
        if (this.sizeFields <= 0) {
            return null;
        }
        int n = 0;
        ScreenField screenField = this.screenFields[n];
        while (screenField.isBypassField() && n++ < this.sizeFields) {
            screenField = this.screenFields[n];
        }
        if (screenField.isBypassField()) {
            return null;
        }
        return screenField;
    }

    public void gotoFieldNext() {
        int n = this.screen.getLastPos();
        if (this.currentField == null && this.sizeFields != 0 && !this.isInField(n, true)) {
            int n2 = n;
            this.screen.setCursorOff();
            this.screen.advancePos();
            n = this.screen.getLastPos();
            while (!this.isInField() && n2 != n) {
                this.screen.advancePos();
            }
            this.screen.setCursorOn();
        }
        if (this.currentField == null) {
            return;
        }
        ScreenField screenField = this.currentField;
        if (!screenField.withinField(n)) {
            this.screen.setCursorOff();
            if (this.sizeFields > 0) {
                int n3 = n;
                int n4 = n;
                boolean bl = false;
                do {
                    this.screen.advancePos();
                    n = this.screen.getLastPos();
                    if (!this.isInField(n) && n3 != n || this.currentField.isBypassField()) continue;
                    this.screen.gotoField(this.currentField);
                    bl = true;
                } while (!bl && n != n4);
            }
            this.currentModified = false;
            this.screen.setCursorOn();
        } else {
            if (!this.cpfExists) {
                while ((screenField = screenField.next) != null && screenField.isBypassField()) {
                }
            } else {
                int n5 = 0;
                int n6 = screenField.getCursorProgression();
                if (n6 == 0) {
                    while ((screenField = screenField.next) != null && screenField.isBypassField()) {
                    }
                } else {
                    ScreenField screenField2 = null;
                    boolean bl = false;
                    while (!bl && n5 < this.sizeFields) {
                        if ((screenField2 = this.screenFields[n5++]).getFieldId() != n6) continue;
                        bl = true;
                    }
                    if (bl) {
                        screenField = screenField2;
                    } else {
                        while ((screenField = screenField.next) != null && screenField.isBypassField()) {
                        }
                    }
                    screenField2 = null;
                }
            }
            if (screenField == null) {
                this.screen.gotoField(1);
            } else {
                this.currentField = screenField;
                this.screen.gotoField(this.currentField);
            }
            this.currentModified = false;
        }
    }

    public void gotoFieldPrev() {
        ScreenField screenField = this.currentField;
        int n = this.screen.getLastPos();
        if (!screenField.withinField(n)) {
            this.screen.setCursorOff();
            if (this.sizeFields > 0) {
                int n2 = n;
                int n3 = n;
                boolean bl = false;
                do {
                    this.screen.changePos(-1);
                    n = this.screen.getLastPos();
                    if (!this.isInField(n) && n2 != n || this.currentField.isBypassField()) continue;
                    this.screen.gotoField(this.currentField);
                    bl = true;
                } while (!bl && n != n3);
            }
            this.screen.setCursorOn();
        } else {
            int n4;
            if (screenField.startPos() == n) {
                if (!this.cpfExists) {
                    while ((screenField = screenField.prev) != null && screenField.isBypassField()) {
                    }
                } else {
                    n4 = 0;
                    int n5 = screenField.getFieldId();
                    ScreenField screenField2 = null;
                    boolean bl = false;
                    while (!bl && n4 < this.sizeFields) {
                        if ((screenField2 = this.screenFields[n4++]).getCursorProgression() != n5) continue;
                        bl = true;
                    }
                    if (bl) {
                        screenField = screenField2;
                    } else {
                        while ((screenField = screenField.prev) != null && screenField.isBypassField()) {
                        }
                    }
                    screenField2 = null;
                }
            }
            if (screenField == null) {
                n4 = this.sizeFields;
                screenField = this.screenFields[n4 - 1];
                while (screenField.isBypassField() && n4-- > 0) {
                    screenField = this.screenFields[n4];
                }
            }
            this.currentField = screenField;
            this.currentModified = false;
            this.screen.gotoField(this.currentField);
        }
    }

    protected void readFormatTable(ByteArrayOutputStream byteArrayOutputStream, int n, ICodePage iCodePage) {
        boolean bl = false;
        if (this.masterMDT) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.sizeFields; ++i) {
                int n2;
                bl = false;
                ScreenField screenField = this.screenFields[i];
                if (!screenField.mdt && n != 66) continue;
                stringBuffer.setLength(0);
                stringBuffer.append(screenField.getText());
                if (n == 82 || n == -125) {
                    n2 = stringBuffer.length() - 1;
                    while (!(n2 < 0 || stringBuffer.charAt(n2) >= ' ' && stringBuffer.charAt(n2) < '\uff20' || stringBuffer.charAt(n2) == '\u001c' && screenField.isDupEnabled())) {
                        stringBuffer.deleteCharAt(n2--);
                    }
                }
                if (screenField.isSignedNumeric() && stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == '-') {
                    bl = true;
                    stringBuffer.setLength(stringBuffer.length() - 1);
                }
                if ((n2 = stringBuffer.length()) <= 0 && n != 82 && n != -125) continue;
                if (n == 82 || n == -125) {
                    byteArrayOutputStream.write(17);
                    if (screenField.isSelectionField()) {
                        byteArrayOutputStream.write(this.screen.getRow(screenField.selectionPos) + 1);
                        byteArrayOutputStream.write(this.screen.getCol(screenField.selectionPos) + 1);
                    } else {
                        byteArrayOutputStream.write(screenField.startRow() + 1);
                        byteArrayOutputStream.write(screenField.startCol() + 1);
                    }
                }
                if (screenField.isSelectionField()) {
                    byteArrayOutputStream.write(0);
                    byteArrayOutputStream.write(screenField.selectionIndex + 31);
                    continue;
                }
                for (int j = 0; j < n2; ++j) {
                    char c = stringBuffer.charAt(j);
                    if (c < ' ' || c >= '\uff20') {
                        if (c >= '\uff20' && c <= '\uff3f') {
                            byteArrayOutputStream.write(c - 65280);
                            continue;
                        }
                        if (c == '\u001c') {
                            byteArrayOutputStream.write(c);
                            continue;
                        }
                        byteArrayOutputStream.write(iCodePage.uni2ebcdic(' '));
                        continue;
                    }
                    if (bl && j == n2 - 1) {
                        byteArrayOutputStream.write(0xD0 | 0xF & c);
                        continue;
                    }
                    byteArrayOutputStream.write(iCodePage.uni2ebcdic(c));
                }
            }
        }
    }
}

