/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.tn5250;

import java.util.Properties;
import org.tn5250j.ExternalProgramConfig;
import org.tn5250j.framework.tn5250.Screen5250;

public class ScreenPlanes {
    private final Screen5250 scr;
    private int screenSize;
    private int numRows;
    private int numCols;
    private int errorLineNum;
    private static final int initAttr = 32;
    private static final char initChar = '\u0000';
    protected char[] screen;
    private char[] screenAttr;
    private char[] screenGUI;
    private char[] screenIsAttr;
    private char[] fieldExtended;
    private char[] screenField;
    private char[] screenColor;
    protected char[] screenExtended;
    private char[] screenIsChanged;
    private char[] initArray;
    private char[] errorLine;
    private char[] errorLineAttr;
    private char[] errorLineIsAttr;
    private char[] errorLineGui;

    public ScreenPlanes(Screen5250 screen5250, int n) {
        this.scr = screen5250;
        this.setSize(n);
    }

    protected void setSize(int n) {
        this.screenSize = n;
        this.numCols = 80;
        switch (n) {
            case 24: {
                this.numRows = 24;
                break;
            }
            case 27: {
                this.numRows = 27;
                this.numCols = 132;
            }
        }
        this.setErrorLine(this.numRows);
        this.screenSize = this.numRows * this.numCols;
        this.screen = new char[this.screenSize];
        this.screenAttr = new char[this.screenSize];
        this.screenIsAttr = new char[this.screenSize];
        this.screenGUI = new char[this.screenSize];
        this.screenColor = new char[this.screenSize];
        this.screenExtended = new char[this.screenSize];
        this.fieldExtended = new char[this.screenSize];
        this.screenIsChanged = new char[this.screenSize];
        this.screenField = new char[this.screenSize];
        this.initArray = new char[this.screenSize];
        this.initalizePlanes();
    }

    protected void setErrorLine(int n) {
        this.errorLineNum = n == 0 || n > this.numRows ? this.numRows : n;
    }

    protected int getErrorLine() {
        return this.errorLineNum;
    }

    protected void saveErrorLine() {
        if (this.errorLine == null) {
            this.errorLine = new char[this.numCols];
            this.errorLineAttr = new char[this.numCols];
            this.errorLineIsAttr = new char[this.numCols];
            this.errorLineGui = new char[this.numCols];
            int n = this.scr.getPos(this.errorLineNum - 1, 0);
            for (int i = 0; i < this.numCols; ++i) {
                this.errorLine[i] = this.screen[n + i];
                this.errorLineAttr[i] = this.screenAttr[n + i];
                this.errorLineIsAttr[i] = this.screenIsAttr[n + i];
                this.errorLineGui[i] = this.screenGUI[n + i];
            }
        }
    }

    protected void restoreErrorLine() {
        if (this.errorLine != null) {
            int n = this.scr.getPos(this.errorLineNum - 1, 0);
            for (int i = 0; i < this.numCols - 1; ++i) {
                this.setScreenCharAndAttr(n + i, this.errorLine[i], this.errorLineAttr[i], this.errorLineIsAttr[i] == '1');
                this.screenGUI[i] = this.errorLineGui[i];
            }
            this.errorLine = null;
            this.errorLineAttr = null;
            this.errorLineIsAttr = null;
            this.errorLineGui = null;
        }
    }

    protected boolean isErrorLineSaved() {
        return this.errorLine != null;
    }

    protected void setScreenCharAndAttr(int n, char c, int n2, boolean bl) {
        this.screen[n] = c;
        this.screenAttr[n] = (char)n2;
        this.disperseAttribute(n, n2);
        this.screenIsAttr[n] = bl ? (char)'\u0001' : '\u0000';
        this.screenGUI[n] = '\u0000';
    }

    protected void setScreenAttr(int n, int n2, boolean bl) {
        this.screenAttr[n] = (char)n2;
        this.screenIsAttr[n] = bl ? (char)'\u0001' : '\u0000';
        this.disperseAttribute(n, n2);
        this.screenGUI[n] = '\u0000';
    }

    protected void setScreenAttr(int n, int n2) {
        this.screenAttr[n] = (char)n2;
        this.disperseAttribute(n, n2);
    }

    protected void setScreenFieldAttr(int n, int n2) {
        this.screenField[n] = (char)n2;
    }

    protected final void setChar(int n, char c) {
        this.screenIsChanged[n] = this.screen[n] == c ? 48 : 49;
        this.screen[n] = c;
        if (this.screenIsAttr[n] == '\u0001') {
            this.setScreenCharAndAttr(n, c, 32, false);
        }
    }

    protected final char getChar(int n) {
        return this.screen[n];
    }

    protected final int getCharAttr(int n) {
        return this.screenAttr[n];
    }

    protected final boolean isAttributePlace(int n) {
        return this.screenIsAttr[n] == '\u0001';
    }

    public final void setUseGUI(int n, int n2) {
        this.screenIsChanged[n] = this.screenGUI[n] == n2 ? 48 : 49;
        this.screenGUI[n] = (char)n2;
    }

    private void disperseAttribute(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (n2 == 0) {
            return;
        }
        switch (n2) {
            case 32: {
                n3 = 2;
                break;
            }
            case 33: {
                n3 = 512;
                break;
            }
            case 34: {
                n3 = 7;
                break;
            }
            case 35: {
                n3 = 1792;
                break;
            }
            case 36: {
                n3 = 2;
                n5 = 8;
                break;
            }
            case 37: {
                n3 = 512;
                n5 = 8;
                break;
            }
            case 38: {
                n3 = 7;
                n5 = 8;
                break;
            }
            case 39: {
                n6 = 1;
                break;
            }
            case 40: 
            case 42: {
                n3 = 4;
                break;
            }
            case 41: 
            case 43: {
                n3 = 1024;
                break;
            }
            case 44: 
            case 46: {
                n3 = 4;
                n5 = 8;
                break;
            }
            case 45: {
                n3 = 1024;
                n5 = 8;
                break;
            }
            case 47: {
                n6 = 1;
                break;
            }
            case 48: {
                n3 = 3;
                n4 = 2;
                break;
            }
            case 49: {
                n3 = 768;
                n4 = 2;
                break;
            }
            case 50: {
                n3 = 6;
                n4 = 2;
                break;
            }
            case 51: {
                n3 = 1536;
                n4 = 2;
                break;
            }
            case 52: {
                n3 = 3;
                n5 = 8;
                break;
            }
            case 53: {
                n3 = 768;
                n5 = 8;
                break;
            }
            case 54: {
                n3 = 6;
                n5 = 8;
                break;
            }
            case 55: {
                n6 = 1;
                break;
            }
            case 56: {
                n3 = 5;
                break;
            }
            case 57: {
                n3 = 1280;
                break;
            }
            case 58: {
                n3 = 1;
                break;
            }
            case 59: {
                n3 = 256;
                break;
            }
            case 60: {
                n3 = 5;
                n5 = 8;
                break;
            }
            case 61: {
                n3 = 1280;
                n5 = 8;
                break;
            }
            case 62: {
                n3 = 1;
                n5 = 8;
                break;
            }
            case 63: {
                n6 = 1;
                n4 = 2;
                break;
            }
            default: {
                n3 = 6;
            }
        }
        this.screenColor[n] = n3;
        this.screenExtended[n] = (char)(n5 | n4 | n6);
    }

    protected void initalizePlanes() {
        int n = 2;
        for (int i = 0; i < this.screenSize; ++i) {
            this.screenAttr[i] = 32;
            this.screenColor[i] = n;
        }
        System.arraycopy(this.initArray, 0, this.screen, 0, this.screenSize);
        System.arraycopy(this.initArray, 0, this.screenGUI, 0, this.screenSize);
        System.arraycopy(this.initArray, 0, this.screenIsAttr, 0, this.screenSize);
        System.arraycopy(this.initArray, 0, this.screenExtended, 0, this.screenSize);
        System.arraycopy(this.initArray, 0, this.fieldExtended, 0, this.screenSize);
        System.arraycopy(this.initArray, 0, this.screenField, 0, this.screenSize);
    }

    protected void initalizeFieldPlanes() {
        System.arraycopy(this.initArray, 0, this.fieldExtended, 0, this.screenSize);
        System.arraycopy(this.initArray, 0, this.screenField, 0, this.screenSize);
    }

    protected final int getWhichGUI(int n) {
        return this.screenGUI[n];
    }

    protected final boolean isChanged(int n) {
        return this.screenIsChanged[n] != '\u0000';
    }

    protected final boolean isUseGui(int n) {
        return this.screenGUI[n] != '\u0000';
    }

    protected synchronized char[] getPlaneData(int n, int n2, int n3) {
        int n4 = n2 - n;
        char[] cArray = new char[n4 + 1];
        switch (n3) {
            case 1: {
                System.arraycopy(this.screen, n, cArray, 0, n4);
                break;
            }
            case 7: {
                System.arraycopy(this.screenAttr, n, cArray, 0, n4);
                break;
            }
            case 2: {
                System.arraycopy(this.screenColor, n, cArray, 0, n4);
                break;
            }
            case 4: {
                System.arraycopy(this.screenExtended, n, cArray, 0, n4);
                break;
            }
            case 5: {
                System.arraycopy(this.screenGUI, n, cArray, 0, n4);
                break;
            }
            case 3: {
                System.arraycopy(this.screenField, n, cArray, 0, n4);
                break;
            }
            case 8: {
                System.arraycopy(this.screenIsAttr, n, cArray, 0, n4);
                break;
            }
            default: {
                System.arraycopy(this.screen, n, cArray, 0, n4);
            }
        }
        return cArray;
    }

    private int convertPosToRow(int n) {
        return n / this.numCols + 1;
    }

    private int convertPosToColumn(int n) {
        return n % this.numCols + 1;
    }

    private int convertRowColToPos(int n, int n2) {
        return (n - 1) * this.numCols + n2 - 1;
    }

    public synchronized int GetScreen(char[] cArray, int n, int n2) {
        return this.GetScreen(cArray, n, 0, this.screenSize, n2);
    }

    public synchronized int GetScreen(char[] cArray, int n, int n2, int n3, int n4) {
        char[] cArray2;
        if (cArray == null) {
            return 0;
        }
        int n5 = Math.min(Math.min(cArray.length, n), this.screenSize);
        if (n2 + n5 > this.screenSize) {
            n5 = this.screenSize - n2;
        }
        if ((cArray2 = this.getPlaneData(n2, n2 + n5, n4)) != null) {
            System.arraycopy(cArray2, 0, cArray, 0, n5);
            return cArray2.length;
        }
        return 0;
    }

    public synchronized int GetScreen(char[] cArray, int n, int n2, int n3, int n4, int n5) {
        return this.GetScreen(cArray, n, this.convertRowColToPos(n2, n3), n4, n5);
    }

    protected int GetScreenRect(char[] cArray, int n, int n2, int n3, int n4) {
        int n5 = this.convertPosToRow(n2);
        int n6 = this.convertPosToColumn(n2);
        int n7 = this.convertPosToRow(n3);
        int n8 = this.convertPosToColumn(n3);
        return this.GetScreenRect(cArray, n, n5, n6, n7, n8, n4);
    }

    protected int GetScreenRect(char[] cArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9 = 0;
        if (n2 > n4) {
            n8 = n2;
            n2 = n4;
            n4 = n8;
        }
        if (n3 > n5) {
            n8 = n3;
            n3 = n5;
            n5 = n8;
        }
        if ((n8 = n5 - n3 + 1) * (n7 = n4 - n2 + 1) <= n) {
            char[] cArray2 = new char[n8 + 1];
            int n10 = 0;
            int n11 = 0;
            int n12 = n2;
            while (n12 <= n4) {
                n11 = this.GetScreen(cArray2, cArray2.length, n12, n3, n8, n6);
                if (n11 != 0) {
                    System.arraycopy(cArray2, 0, cArray, n10, n8);
                }
                ++n12;
                n10 += n8;
                n9 += n11;
            }
        }
        return n9;
    }

    protected boolean checkHotSpots() {
        Screen5250 screen5250 = this.scr;
        int n = this.scr.getScreenLength();
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = screen5250.getHSMore();
        StringBuffer stringBuffer2 = screen5250.getHSBottom();
        for (int i = 0; i < n; ++i) {
            block39: {
                Properties properties;
                String string;
                int n2;
                int n3;
                block40: {
                    block37: {
                        block38: {
                            int n4;
                            int n5;
                            int n6;
                            bl = false;
                            if (screen5250.isInField(i, false)) continue;
                            if (i > 0 && this.screen[i] == 'F' && this.screen[i + 1] >= '0' && this.screen[i + 1] <= '9' && this.screen[i - 1] <= ' ' && (this.screenExtended[i] & '\u0001') == 0) {
                                if (this.screen[i + 2] >= '0' && this.screen[i + 2] <= '9' && (this.screen[i + 3] == '=' || this.screen[i + 3] == '-' || this.screen[i + 3] == '/')) {
                                    bl = true;
                                } else if (this.screen[i + 2] == '=' || this.screen[i + 3] == '-' || this.screen[i + 3] == '/') {
                                    bl = true;
                                }
                                if (bl) {
                                    this.screenGUI[i] = 13;
                                    n6 = 0;
                                    n5 = i / this.numCols;
                                    while (n6 < 2 && ++i / this.numCols == n5) {
                                        n6 = this.screen[i] <= ' ' ? ++n6 : 0;
                                        if (n6 >= 2) continue;
                                        this.screenGUI[i] = 15;
                                    }
                                    while (this.screen[--i] <= ' ') {
                                        this.screenGUI[i] = '\u0000';
                                    }
                                    this.screenGUI[i] = 14;
                                }
                            }
                            if (!bl && i > 0 && i < n - 2 && this.screen[i] == '.' && this.screenGUI[i] == '\u0000' && (this.screenExtended[i] & 8) == 0 && (this.screenExtended[i] & '\u0001') == 0) {
                                n6 = 0;
                                n6 = this.isOption(this.screen, i, n, 2, 3, '.');
                                if (n6 > 0) {
                                    bl = true;
                                    n5 = i;
                                    n3 = 0;
                                    n2 = n5 / this.numCols;
                                    while (++n5 / this.numCols == n2 && (this.screen[n5] >= ' ' || this.screen[n5] == '\u0000')) {
                                        n3 = this.screen[n5] <= ' ' ? ++n3 : 0;
                                        if (this.screen[n5] == '.') {
                                            n4 = 0;
                                            n4 = this.isOption(this.screen, n5, n, 2, 3, '.');
                                            if (n4 > 0) {
                                                n5 = n4;
                                                break;
                                            }
                                        }
                                        if (n3 <= 3) continue;
                                    }
                                    this.screenGUI[++n6] = 13;
                                    screen5250.setDirty(n6);
                                    while (++n6 < n5) {
                                        this.screenGUI[n6] = 15;
                                        screen5250.setDirty(n6);
                                    }
                                    while (this.screen[--n5] <= ' ') {
                                        this.screenGUI[n5] = '\u0000';
                                        screen5250.setDirty(n5);
                                    }
                                    this.screenGUI[n5] = 14;
                                    screen5250.setDirty(n5);
                                }
                            }
                            if (!bl && i > 0 && i < n - 2 && this.screen[i] == '=' && this.screenGUI[i] == '\u0000' && (this.screenExtended[i] & 8) == 0 && (this.screenExtended[i] & '\u0001') == 0) {
                                n6 = 0;
                                n6 = this.isOption(this.screen, i, n, 2, 2, '=');
                                if (n6 > 0) {
                                    bl = true;
                                    n5 = i;
                                    n3 = 0;
                                    n2 = n5 / this.numCols;
                                    while (++n5 / this.numCols == n2 && this.screen[n5] >= ' ') {
                                        n3 = this.screen[n5] == ' ' ? ++n3 : 0;
                                        if (this.screen[n5] == '=') {
                                            n4 = 0;
                                            n4 = this.isOption(this.screen, n5, n, 2, 2, '=');
                                            if (n4 > 0) {
                                                n5 = n4;
                                                break;
                                            }
                                        }
                                        if (n3 <= 2) continue;
                                    }
                                    this.screenGUI[++n6] = 13;
                                    screen5250.setDirty(n6);
                                    while (++n6 < n5) {
                                        this.screenGUI[n6] = 15;
                                        screen5250.setDirty(n6);
                                    }
                                    while (this.screen[--n5] <= ' ') {
                                        this.screenGUI[n5] = '\u0000';
                                        screen5250.setDirty(n5);
                                    }
                                    this.screenGUI[n5] = 14;
                                    screen5250.setDirty(n5);
                                }
                            }
                            if (!bl && i > 2 && i < n - stringBuffer.length() && this.screen[i] == stringBuffer.charAt(0) && this.screen[i - 1] <= ' ' && this.screen[i - 2] <= ' ' && this.screenGUI[i] == '\u0000' && (this.screenExtended[i] & '\u0001') == 0) {
                                n6 = 1;
                                n5 = stringBuffer.length();
                                n3 = 0;
                                while (++n3 < n5) {
                                    if (this.screen[i + n3] == stringBuffer.charAt(n3)) continue;
                                    n6 = 0;
                                    break;
                                }
                                if (n6 != 0) {
                                    bl = true;
                                    this.screenGUI[i] = 21;
                                    while (--n5 > 0) {
                                        this.screenGUI[++i] = 23;
                                    }
                                    this.screenGUI[i] = 22;
                                }
                            }
                            if (!bl && i > 2 && i < n - stringBuffer2.length() && this.screen[i] == stringBuffer2.charAt(0) && this.screen[i - 1] <= ' ' && this.screen[i - 2] <= ' ' && this.screenGUI[i] == '\u0000' && (this.screenExtended[i] & '\u0001') == 0) {
                                n6 = 1;
                                n5 = stringBuffer2.length();
                                n3 = 0;
                                while (++n3 < n5) {
                                    if (this.screen[i + n3] == stringBuffer2.charAt(n3)) continue;
                                    n6 = 0;
                                    break;
                                }
                                if (n6 != 0) {
                                    bl = true;
                                    this.screenGUI[i] = 17;
                                    while (--n5 > 0) {
                                        this.screenGUI[++i] = 19;
                                    }
                                    this.screenGUI[i] = 18;
                                }
                            }
                            if (bl || i <= 0 || i >= n - 7 || Character.toLowerCase(this.screen[i]) != 'h' || this.screen[i - 1] > ' ' || this.screenGUI[i] != '\u0000' || (this.screenExtended[i] & '\u0001') != 0) break block37;
                            if (Character.toLowerCase(this.screen[i + 1]) != 't' || Character.toLowerCase(this.screen[i + 2]) != 't' || Character.toLowerCase(this.screen[i + 3]) != 'p' || this.screen[i + 4] != ':' || this.screen[i + 5] != '/' || this.screen[i + 6] != '/') break block38;
                            bl = true;
                            this.screenGUI[i] = 25;
                            while (this.screen[++i] > ' ') {
                                this.screenGUI[i] = 27;
                            }
                            this.screenGUI[--i] = 26;
                            break block39;
                        }
                        if (Character.toLowerCase(this.screen[i + 1]) != 't' || Character.toLowerCase(this.screen[i + 2]) != 't' || Character.toLowerCase(this.screen[i + 3]) != 'p' || Character.toLowerCase(this.screen[i + 4]) != 's' || this.screen[i + 5] != ':' || this.screen[i + 6] != '/' || this.screen[i + 7] != '/') break block39;
                        bl = true;
                        this.screenGUI[i] = 25;
                        while (this.screen[++i] > ' ') {
                            this.screenGUI[i] = 27;
                        }
                        this.screenGUI[--i] = 26;
                        break block39;
                    }
                    if (bl || i <= 0 || i >= n - 7 || Character.toLowerCase(this.screen[i]) != 'm' || this.screen[i - 1] > ' ' || this.screenGUI[i] != '\u0000' || (this.screenExtended[i] & '\u0001') != 0) break block40;
                    if (Character.toLowerCase(this.screen[i + 1]) != 'a' || Character.toLowerCase(this.screen[i + 2]) != 'i' || Character.toLowerCase(this.screen[i + 3]) != 'l' || Character.toLowerCase(this.screen[i + 4]) != 't' || Character.toLowerCase(this.screen[i + 5]) != 'o' || this.screen[i + 6] != ':') break block39;
                    bl = true;
                    this.screenGUI[i] = 25;
                    while (this.screen[++i] > ' ') {
                        this.screenGUI[i] = 27;
                    }
                    this.screenGUI[--i] = 26;
                    break block39;
                }
                if (!bl && i > 0 && i < n - 7 && this.screen[i - 1] <= ' ' && this.screenGUI[i] == '\u0000' && (this.screenExtended[i] & '\u0001') == 0 && (string = (properties = ExternalProgramConfig.getInstance().getEtnPgmProps()).getProperty("etn.pgm.support.total.num")) != null && string.length() > 0) {
                    n3 = Integer.parseInt(string);
                    for (n2 = 1; n2 <= n3; ++n2) {
                        String string2 = properties.getProperty("etn.pgm." + n2 + ".command.name");
                        String string3 = "";
                        if (i + string2.length() >= this.screen.length) break;
                        for (int j = 0; j <= string2.length(); ++j) {
                            string3 = string3 + this.screen[i + j];
                        }
                        if (!string3.toLowerCase().equals(string2.toLowerCase() + ":")) continue;
                        bl = true;
                        this.screenGUI[i] = 25;
                        while (this.screen[++i] > ' ') {
                            this.screenGUI[i] = 27;
                        }
                        this.screenGUI[--i] = 26;
                        break;
                    }
                }
            }
            if (bl2 || !bl) continue;
            bl2 = true;
        }
        return bl2;
    }

    private int isOption(char[] cArray, int n, int n2, int n3, int n4, char c) {
        boolean bl = true;
        int n5 = n;
        int n6 = 0;
        while (--n5 >= 0 && cArray[n5] <= ' ') {
            if (n - n5 <= n3 && cArray[n5] != c && cArray[n5] != '.' && cArray[n5] != '*') continue;
            bl = false;
            break;
        }
        n6 = n5;
        while (bl && --n6 > 0 && cArray[n6] > ' ') {
            if (n5 - n6 < n3 && cArray[n6] != c && cArray[n6] != '.' && cArray[n6] != '*') continue;
            bl = false;
            break;
        }
        if (n5 - n6 > 1 && !Character.isDigit(cArray[n6 + 1])) {
            bl = false;
        }
        if (Character.isDigit(cArray[(n5 = n) + 1])) {
            bl = false;
        }
        while (bl && (++n5 < n2 && cArray[n5] <= ' ' || cArray[n5] == c)) {
            if (n5 - n < n4 && cArray[n5] != c && cArray[n5] != '.' && cArray[n5] != '*') continue;
            bl = false;
            break;
        }
        if (bl && !Character.isLetterOrDigit(cArray[n5])) {
            bl = false;
        }
        if (bl) {
            return n6;
        }
        return -1;
    }
}

