/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.tn5250;

public class Stream5250 {
    public static final int OPCODE_OFFSET = 9;
    public int streamSize;
    public int opCode;
    public int dataStart;
    public int pos;
    public byte[] buffer;

    public Stream5250(byte[] byArray) {
        this.buffer = byArray;
        this.streamSize = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
        this.opCode = byArray[9];
        this.pos = this.dataStart = 6 + byArray[6];
    }

    public Stream5250() {
        this.buffer = null;
        this.streamSize = 0;
        this.opCode = 0;
        this.pos = this.dataStart = 0;
    }

    public void initialize(byte[] byArray) {
        this.buffer = byArray;
        this.streamSize = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
        this.opCode = byArray[9];
        this.pos = this.dataStart = 6 + byArray[6];
    }

    public final int getOpCode() {
        return this.opCode;
    }

    public final byte getNextByte() throws Exception {
        if (this.buffer == null || this.pos > this.buffer.length) {
            throw new Exception("Buffer length exceeded: " + this.pos);
        }
        return this.buffer[this.pos++];
    }

    public final void setPrevByte() throws Exception {
        if (this.pos == 0) {
            throw new Exception("Index equals zero.");
        }
        --this.pos;
    }

    public final int getCurrentPos() {
        return this.pos;
    }

    public final byte getByteOffset(int n) throws Exception {
        if (this.buffer == null || this.pos + n > this.buffer.length) {
            throw new Exception("Buffer length exceeded: " + this.pos);
        }
        return this.buffer[this.pos + n];
    }

    public final boolean size() {
        return this.pos >= this.streamSize;
    }

    public final boolean hasNext() {
        return this.pos < this.streamSize;
    }

    public final byte[] getSegment() throws Exception {
        int n = (this.buffer[this.pos] & 0xFF) << 8 | this.buffer[this.pos + 1] & 0xFF;
        byte[] byArray = new byte[n];
        this.getSegment(byArray, n, true);
        return byArray;
    }

    public final void getSegment(byte[] byArray, int n, boolean bl) throws Exception {
        if (this.pos + n > this.buffer.length) {
            throw new Exception("Buffer length exceeded: start " + this.pos + " length " + n);
        }
        System.arraycopy(this.buffer, this.pos, byArray, 0, n);
        if (bl) {
            this.pos += n;
        }
    }
}

