/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.tn5250;

import java.util.ArrayList;
import java.util.List;
import org.tn5250j.encoding.ICodePage;
import org.tn5250j.framework.tn5250.Screen5250;
import org.tn5250j.framework.tn5250.tnvt;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class WTDSFParser {
    private Screen5250 screen52;
    private tnvt vt;
    private ICodePage codePage;
    int pos;
    byte[] segment;
    int length;
    boolean error;
    boolean guiStructsExist;
    private TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());
    private final List<Window> guiStructs = new ArrayList<Window>(3);
    private final List<ChoiceField> choices = new ArrayList<ChoiceField>(3);

    WTDSFParser(tnvt tnvt2) {
        this.vt = tnvt2;
        this.screen52 = tnvt2.screen52;
        this.codePage = tnvt2.codePage;
    }

    protected void addChoiceField(int n, int n2, int n3, int n4, String string) {
        ChoiceField choiceField = new ChoiceField(n, n2, n3, n4);
        choiceField.fieldId = this.screen52.getScreenFields().getCurrentField().getFieldId();
        this.choices.add(choiceField);
    }

    protected boolean isGuisExists() {
        return this.guiStructsExist;
    }

    protected byte[] getSegmentAtPos(int n) {
        int n2 = this.guiStructs.size();
        for (int i = 0; i < n2; ++i) {
            Window window = this.guiStructs.get(i);
            if (window.pos != n) continue;
            return window.window;
        }
        return null;
    }

    protected void clearGuiStructs() {
        this.guiStructs.clear();
    }

    protected boolean parseWriteToDisplayStructuredField(byte[] byArray) {
        this.error = false;
        boolean bl = false;
        boolean bl2 = false;
        this.pos = 0;
        this.segment = byArray;
        this.length = (this.segment[this.pos++] & 0xFF) << 8 | this.segment[this.pos++] & 0xFF;
        while (!bl) {
            int n = this.segment[this.pos++] & 0xFF;
            block0 : switch (n) {
                case 217: {
                    switch (this.segment[this.pos++]) {
                        case 80: {
                            this.defineSelectionField(this.length);
                            bl = true;
                            break block0;
                        }
                        case 81: {
                            int n2;
                            int n3;
                            int n4;
                            int n5;
                            int n6;
                            int n7;
                            int n8;
                            int n9;
                            boolean bl3;
                            this.guiStructs.add(new Window(this.segment, this.screen52.getLastPos()));
                            boolean bl4 = false;
                            byte by = 0;
                            byte by2 = 0;
                            if ((this.segment[this.pos++] & 0x80) == 128) {
                                bl4 = true;
                            }
                            ++this.pos;
                            ++this.pos;
                            by = this.segment[this.pos++];
                            by2 = this.segment[this.pos++];
                            this.length -= 9;
                            if (this.length == 0) {
                                bl = true;
                                this.createWindow(by, by2, 1, true, 32, 58, 46, 46, 46, 58, 58, 58, 46, 58);
                                bl2 = true;
                                break block0;
                            }
                            int n10 = 0;
                            byte by3 = 0;
                            int n11 = this.screen52.getLastPos();
                            byte by4 = 0;
                            byte by5 = 0;
                            block17: while (this.length > 0) {
                                n10 = this.segment[this.pos++] & 0xFF;
                                this.length -= n10;
                                by3 = this.segment[this.pos++];
                                switch (by3) {
                                    case 1: {
                                        bl3 = false;
                                        if ((this.segment[this.pos++] & 0x80) == 128) {
                                            bl3 = true;
                                        }
                                        by4 = this.segment[this.pos++];
                                        by5 = this.segment[this.pos++];
                                        n9 = 46;
                                        n8 = 46;
                                        n7 = 46;
                                        n6 = 58;
                                        n5 = 58;
                                        n4 = 58;
                                        n3 = 46;
                                        n2 = 58;
                                        if (n10 > 5) {
                                            if ((n9 = (int)this.codePage.ebcdic2uni(this.segment[this.pos++])) == 0) {
                                                n9 = 46;
                                            }
                                            if ((n8 = (int)this.codePage.ebcdic2uni(this.segment[this.pos++])) == 0) {
                                                n8 = 46;
                                            }
                                            if ((n7 = (int)this.codePage.ebcdic2uni(this.segment[this.pos++])) == 0) {
                                                n7 = 46;
                                            }
                                            if ((n6 = (int)this.codePage.ebcdic2uni(this.segment[this.pos++])) == 0) {
                                                n6 = 58;
                                            }
                                            if ((n5 = (int)this.codePage.ebcdic2uni(this.segment[this.pos++])) == 0) {
                                                n5 = 58;
                                            }
                                            if ((n4 = (int)this.codePage.ebcdic2uni(this.segment[this.pos++])) == 0) {
                                                n4 = 58;
                                            }
                                            if ((n3 = (int)this.codePage.ebcdic2uni(this.segment[this.pos++])) == 0) {
                                                n3 = 46;
                                            }
                                            if ((n2 = (int)this.codePage.ebcdic2uni(this.segment[this.pos++])) == 0) {
                                                n2 = 58;
                                            }
                                        }
                                        this.createWindow(by, by2, by3, bl3, by4, by5, n9, n8, n7, n6, n5, n4, n3, n2);
                                        bl2 = true;
                                        continue block17;
                                    }
                                    case 16: {
                                        if (!bl2) {
                                            this.guiStructs.add(new Window(this.segment, this.screen52.getLastPos()));
                                            this.createWindow(by, by2, 1, true, 32, 58, 46, 46, 46, 58, 58, 58, 46, 58);
                                            bl2 = true;
                                        }
                                        byte by6 = this.segment[this.pos++];
                                        by4 = this.segment[this.pos++];
                                        by5 = this.segment[this.pos++];
                                        ++this.pos;
                                        StringBuffer stringBuffer = new StringBuffer(n10 -= 6);
                                        while (n10-- > 0) {
                                            stringBuffer.append(this.codePage.ebcdic2uni(this.segment[this.pos++]));
                                        }
                                        this.log.debug(" orientation " + Integer.toBinaryString(by6) + " mAttr " + by4 + " cAttr " + by5 + " Header/Footer " + stringBuffer);
                                        this.screen52.writeWindowTitle(n11, by, by2, by6, by4, by5, stringBuffer);
                                        continue block17;
                                    }
                                }
                                this.log.warn("Invalid Window minor structure");
                                this.length = 0;
                                bl = true;
                            }
                            bl = true;
                            break block0;
                        }
                        case 83: {
                            boolean bl3 = 15 != 0;
                            int n9 = this.segment[this.pos++];
                            ++this.pos;
                            int n8 = (this.segment[this.pos++] & 0xFF) << 8 | this.segment[this.pos++] & 0xFF;
                            int n7 = (this.segment[this.pos++] & 0xFF) << 8 | this.segment[this.pos++] & 0xFF;
                            int n6 = (this.segment[this.pos++] & 0xFF) << 8 | this.segment[this.pos++] & 0xFF;
                            int n5 = (this.segment[this.pos++] & 0xFF) << 8 | this.segment[this.pos++] & 0xFF;
                            int n4 = this.segment[this.pos++];
                            this.screen52.createScrollBar(n9, n8, n7, n6, n5, n4);
                            this.length -= 15;
                            bl = true;
                            break block0;
                        }
                        case 91: {
                            ++this.pos;
                            ++this.pos;
                            bl = true;
                            break block0;
                        }
                        case 95: {
                            this.log.info("remove all gui contructs");
                            this.clearGuiStructs();
                            this.guiStructsExist = false;
                            int n3 = 4;
                            int n2 = 0;
                            this.length -= n;
                            while (--n3 > 0) {
                                n2 = this.segment[this.pos++];
                            }
                            this.screen52.clearGuiStuff();
                            this.screen52.clearTable();
                            bl = true;
                            break block0;
                        }
                        case 89: {
                            this.log.info(" remove window at " + this.screen52.getCurrentPos());
                            bl = true;
                            break block0;
                        }
                        case 96: {
                            int n3 = 6;
                            int n2 = 0;
                            this.length -= 9;
                            while (--n3 > 0) {
                                n2 = this.segment[this.pos++];
                            }
                            if (this.length > 0) {
                                n3 = (this.segment[this.pos++] & 0xFF) << 8;
                                while (--n3 > 0) {
                                    n2 = this.segment[this.pos++];
                                }
                            }
                            bl = true;
                            break block0;
                        }
                    }
                    this.vt.sendNegResponse(16, 3, 1, 1, "invalid wtd structured field sub command " + (this.pos - 1));
                    this.error = true;
                    break;
                }
                default: {
                    this.vt.sendNegResponse(16, 3, 1, 1, "invalid wtd structured field command " + (this.pos - 1));
                    this.error = true;
                }
            }
            if (!this.error) continue;
            bl = true;
        }
        return this.error;
    }

    protected void createWindow(int n, int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        int n14 = this.screen52.getLastPos();
        int n15 = this.screen52.getColumns();
        int n16 = this.screen52.getCol(n14);
        int n17 = 0;
        n17 = ++n2;
        char c = '\u0000';
        int n18 = 32;
        this.screen52.setScreenCharAndAttr(c, n18, true);
        if (bl) {
            this.screen52.setScreenCharAndAttr((char)n6, n5, 1, false);
        } else {
            this.screen52.setScreenCharAndAttr((char)n6, n5, false);
        }
        while (n17-- >= 0) {
            if (bl) {
                this.screen52.setScreenCharAndAttr((char)n7, n5, 2, false);
                continue;
            }
            this.screen52.setScreenCharAndAttr((char)n7, n5, false);
        }
        if (bl) {
            this.screen52.setScreenCharAndAttr((char)n8, n5, 3, false);
        } else {
            this.screen52.setScreenCharAndAttr((char)n8, n5, false);
        }
        this.screen52.setScreenCharAndAttr(c, n18, true);
        n14 = (this.screen52.getRow(n14) + 1) * n15 + n16;
        this.screen52.goto_XY(n14);
        while (n-- > 0) {
            this.screen52.setScreenCharAndAttr(c, n18, true);
            if (bl) {
                this.screen52.setScreenCharAndAttr((char)n9, n5, 4, false);
            } else {
                this.screen52.setScreenCharAndAttr((char)n9, n5, false);
            }
            n17 = n2 - 2;
            this.screen52.setScreenCharAndAttr(c, n18, 0, true);
            while (n17-- >= 0) {
                this.screen52.setScreenCharAndAttr(c, n18, 0, false);
            }
            this.screen52.setScreenCharAndAttr(c, n18, 0, true);
            if (bl) {
                this.screen52.setScreenCharAndAttr((char)n10, n5, 5, false);
            } else {
                this.screen52.setScreenCharAndAttr((char)n10, n5, false);
            }
            this.screen52.setScreenCharAndAttr(c, n18, true);
            n14 = (this.screen52.getRow(n14) + 1) * n15 + n16;
            this.screen52.goto_XY(n14);
        }
        this.screen52.setScreenCharAndAttr(c, n18, true);
        if (bl) {
            this.screen52.setScreenCharAndAttr((char)n11, n5, 6, false);
        } else {
            this.screen52.setScreenCharAndAttr((char)n11, n5, false);
        }
        n17 = n2;
        while (n17-- >= 0) {
            if (bl) {
                this.screen52.setScreenCharAndAttr((char)n12, n5, 7, false);
                continue;
            }
            this.screen52.setScreenCharAndAttr((char)n12, n5, false);
        }
        if (bl) {
            this.screen52.setScreenCharAndAttr((char)n13, n5, 8, false);
        } else {
            this.screen52.setScreenCharAndAttr((char)n13, n5, false);
        }
        this.screen52.setScreenCharAndAttr(c, n18, true);
    }

    private void defineSelectionField(int n) {
        try {
            byte by = this.segment[this.pos++];
            byte by2 = this.segment[this.pos++];
            byte by3 = this.segment[this.pos++];
            byte by4 = this.segment[this.pos++];
            byte by5 = this.segment[this.pos++];
            byte by6 = this.segment[this.pos++];
            byte by7 = this.segment[this.pos++];
            ++this.pos;
            ++this.pos;
            byte by8 = this.segment[this.pos++];
            byte by9 = this.segment[this.pos++];
            byte by10 = this.segment[this.pos++];
            byte by11 = this.segment[this.pos++];
            byte by12 = this.segment[this.pos++];
            byte by13 = this.segment[this.pos++];
            byte by14 = this.segment[this.pos++];
            int n2 = 0;
            int n3 = 0;
            n -= 21;
            this.log.debug(" row: " + this.screen52.getCurrentRow() + " col: " + this.screen52.getCurrentCol() + " type " + by4 + " gui " + by5 + " withMnemonic " + Integer.toHexString(by6 & 0xF0) + " noMnemonic " + Integer.toHexString(by7 & 0xF0) + " noMnemonic " + Integer.toBinaryString(by7) + " noMnemonicType " + Integer.toBinaryString(by7 & 0xF0) + " noMnemonicSel " + Integer.toBinaryString(by7 & 0xF) + " maxcols " + by10 + " cols " + by8 + " rows " + by9);
            byte by15 = 0;
            byte by16 = 0;
            int n4 = this.screen52.getCurrentRow();
            int n5 = this.screen52.getCurrentCol();
            int n6 = n4;
            int n7 = n5;
            int n8 = this.screen52.getPos(n6 - 1, n7);
            int n9 = 32;
            int n10 = 32;
            int n11 = 0;
            block6: do {
                n3 = this.segment[this.pos++];
                byte by17 = this.segment[this.pos++];
                switch (by17) {
                    case 1: {
                        byte by18 = this.segment[this.pos++];
                        ++this.pos;
                        n10 = this.segment[this.pos++];
                        ++this.pos;
                        byte by19 = this.segment[this.pos++];
                        ++this.pos;
                        byte by20 = this.segment[this.pos++];
                        ++this.pos;
                        n9 = this.segment[this.pos++];
                        ++this.pos;
                        byte by21 = this.segment[this.pos++];
                        ++this.pos;
                        byte by22 = this.segment[this.pos++];
                        ++this.pos;
                        byte by23 = this.segment[this.pos++];
                        ++this.pos;
                        byte by24 = this.segment[this.pos++];
                        break;
                    }
                    case 16: {
                        n2 = 5;
                        byte by25 = this.segment[this.pos++];
                        byte by26 = this.segment[this.pos++];
                        byte by27 = this.segment[this.pos++];
                        int n12 = 0;
                        boolean bl = false;
                        boolean bl2 = false;
                        if ((by25 & 0x40) == 64) {
                            this.log.debug(" selected ");
                            bl2 = true;
                        }
                        if ((by25 & 8) == 8) {
                            this.log.debug(" mnemOffset " + n12);
                            n12 = this.segment[this.pos++];
                            ++n2;
                        }
                        if ((by25 & 4) == 4) {
                            bl = true;
                            this.log.debug(" aidKey " + bl);
                        }
                        if ((by25 & 1) == 1) {
                            this.log.debug(" single digit ");
                            ++this.pos;
                            ++n2;
                        }
                        if ((by25 & 2) == 2) {
                            this.log.debug(" double digit ");
                            ++this.pos;
                            ++n2;
                        }
                        String string = "";
                        byte by28 = 0;
                        ++n11;
                        this.screen52.setCursor(n4, n5);
                        if ((by25 & 0x80) != 128) {
                            this.screen52.addField(38, 1, 0, 0, 0, 0);
                            this.screen52.getScreenFields().getCurrentField().setFieldChar('.');
                            this.screen52.getScreenFields().getCurrentField().setSelectionFieldInfo(17, n11, n8);
                            this.screen52.setCursor(n4, n5 + 3);
                            while (n2 < n3) {
                                by28 = this.segment[this.pos++];
                                string = string + this.vt.codePage.ebcdic2uni(by28);
                                this.screen52.setChar(this.vt.codePage.ebcdic2uni(by28));
                                ++n2;
                            }
                            this.addChoiceField(n4, n5, n6, n7, string);
                        }
                        this.log.debug(string + " selected " + bl2);
                        if (++by16 >= by10) {
                            by16 = 0;
                            n5 = n7;
                            n4 = n6 + ++by15;
                            if (by15 <= by9) continue block6;
                            n4 = n6;
                            by15 = 0;
                            n5 = n5 + 3 + by8 + by11;
                            break;
                        }
                        n5 = n5 + by11 + by8 + 3;
                        break;
                    }
                    default: {
                        for (n2 = 2; n2 < n3; ++n2) {
                            ++this.pos;
                        }
                    }
                }
            } while ((n -= n3) > 0);
        }
        catch (Exception exception) {
            this.log.warn(" defineSelectionField :", exception);
            exception.printStackTrace();
        }
    }

    protected class Window {
        byte[] window;
        int pos;

        Window(byte[] byArray, int n) {
            this.window = byArray;
            this.pos = n;
            WTDSFParser.this.guiStructsExist = true;
        }
    }

    protected class ChoiceField {
        int x;
        int y;
        int row;
        int col;
        int width;
        int height;
        char mnemonic;
        int fieldId;
        int selectIndex;

        ChoiceField(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            n = n3;
            n2 = n4;
        }
    }
}

