/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.tn5250;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.net.ssl.SSLSocket;
import javax.swing.SwingUtilities;
import org.tn5250j.Session5250;
import org.tn5250j.encoding.CharMappings;
import org.tn5250j.encoding.ICodePage;
import org.tn5250j.framework.tn5250.DataStreamProducer;
import org.tn5250j.framework.tn5250.KbdTypesCodePages;
import org.tn5250j.framework.tn5250.Screen5250;
import org.tn5250j.framework.tn5250.ScreenField;
import org.tn5250j.framework.tn5250.ScreenPlanes;
import org.tn5250j.framework.tn5250.Stream5250;
import org.tn5250j.framework.tn5250.WTDSFParser;
import org.tn5250j.framework.transport.SocketConnector;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public final class tnvt
implements Runnable {
    private static final byte IAC = -1;
    private static final byte DONT = -2;
    private static final byte DO = -3;
    private static final byte WONT = -4;
    private static final byte WILL = -5;
    private static final byte SB = -6;
    private static final byte SE = -16;
    private static final byte EOR = -17;
    private static final byte TERMINAL_TYPE = 24;
    private static final byte OPT_END_OF_RECORD = 25;
    private static final byte TRANSMIT_BINARY = 0;
    private static final byte QUAL_IS = 0;
    private static final byte TIMING_MARK = 6;
    private static final byte NEW_ENVIRONMENT = 39;
    private static final byte IS = 0;
    private static final byte SEND = 1;
    private static final byte INFO = 2;
    private static final byte VAR = 0;
    private static final byte VALUE = 1;
    private static final byte NEGOTIATE_ESC = 2;
    private static final byte USERVAR = 3;
    private static final byte ESC = 4;
    private Socket sock;
    private BufferedInputStream bin;
    private BufferedOutputStream bout;
    private final BlockingQueue<Object> dsq = new ArrayBlockingQueue<Object>(25);
    private Stream5250 bk;
    private DataStreamProducer producer;
    protected Screen5250 screen52;
    private boolean waitingForInput;
    private boolean invited;
    private boolean negotiated = false;
    private Thread me;
    private Thread pthread;
    private int readType;
    private boolean enhanced = true;
    private Session5250 controller;
    private boolean cursorOn = false;
    private String session = "";
    private int port = 23;
    private boolean connected = false;
    private boolean support132 = true;
    private ByteArrayOutputStream baosp = null;
    private ByteArrayOutputStream baosrsp = null;
    private int devSeq = -1;
    private String devName;
    private String devNameUsed;
    private KbdTypesCodePages kbdTypesCodePage;
    private boolean scan;
    private static int STRSCAN = 1;
    private boolean strpccmd;
    private String user;
    private String password;
    private String library;
    private String initialMenu;
    private String program;
    private boolean keepTrucking = true;
    private boolean pendingUnlock = false;
    private boolean[] dataIncluded;
    protected ICodePage codePage;
    private boolean firstScreen;
    private String sslType;
    private WTDSFParser sfParser;
    private final TN5250jLogger log = TN5250jLogFactory.getLogger(this.getClass());

    public tnvt(Session5250 session5250, Screen5250 screen5250, boolean bl, boolean bl2) {
        this.controller = session5250;
        if (this.log.isInfoEnabled()) {
            this.log.info(" new session -> " + this.controller.getSessionName());
        }
        this.enhanced = bl;
        this.support132 = bl2;
        this.setCodePage("37");
        this.screen52 = screen5250;
        this.dataIncluded = new boolean[24];
        if (System.getProperties().containsKey("SESSION_CONNECT_USER")) {
            this.user = System.getProperties().getProperty("SESSION_CONNECT_USER");
            if (System.getProperties().containsKey("SESSION_CONNECT_PASSWORD")) {
                this.password = System.getProperties().getProperty("SESSION_CONNECT_PASSWORD");
            }
            if (System.getProperties().containsKey("SESSION_CONNECT_LIBRARY")) {
                this.library = System.getProperties().getProperty("SESSION_CONNECT_LIBRARY");
            }
            if (System.getProperties().containsKey("SESSION_CONNECT_MENU")) {
                this.initialMenu = System.getProperties().getProperty("SESSION_CONNECT_MENU");
            }
            if (System.getProperties().containsKey("SESSION_CONNECT_PROGRAM")) {
                this.program = System.getProperties().getProperty("SESSION_CONNECT_PROGRAM");
            }
        }
        this.baosp = new ByteArrayOutputStream();
        this.baosrsp = new ByteArrayOutputStream();
    }

    public String getHostName() {
        return this.session;
    }

    public void setSSLType(String string) {
        this.sslType = string;
    }

    public void setDeviceName(String string) {
        this.devName = string;
    }

    public String getDeviceName() {
        return this.devName;
    }

    public String getAllocatedDeviceName() {
        return this.devNameUsed;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isSslSocket() {
        return this.connected && this.sock != null && this.sock instanceof SSLSocket;
    }

    public final void setProxy(String string, String string2) {
        Properties properties = System.getProperties();
        properties.put("socksProxySet", "true");
        properties.put("socksProxyHost", string);
        properties.put("socksProxyPort", string2);
        System.setProperties(properties);
        this.log.info(" socks set ");
    }

    public final boolean connect() {
        return this.connect(this.session, this.port);
    }

    public final boolean connect(String string, int n) {
        Properties properties = this.controller.getConnectionProperties();
        if (this.user == null && properties.containsKey("SESSION_CONNECT_USER")) {
            this.user = properties.getProperty("SESSION_CONNECT_USER");
            this.log.info(" user -> " + this.user + " " + this.controller.getSessionName());
            if (properties.containsKey("SESSION_CONNECT_PASSWORD")) {
                this.password = properties.getProperty("SESSION_CONNECT_PASSWORD");
            }
            if (properties.containsKey("SESSION_CONNECT_LIBRARY")) {
                this.library = properties.getProperty("SESSION_CONNECT_LIBRARY");
            }
            if (properties.containsKey("SESSION_CONNECT_MENU")) {
                this.initialMenu = properties.getProperty("SESSION_CONNECT_MENU");
            }
            if (properties.containsKey("SESSION_CONNECT_PROGRAM")) {
                this.program = properties.getProperty("SESSION_CONNECT_PROGRAM");
            }
        }
        try {
            byte[] byArray;
            this.session = string;
            this.port = n;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        tnvt.this.screen52.getOIA().setInputInhibited(1, 1, "X - Connecting");
                    }
                });
            }
            catch (Exception exception) {
                this.log.warn("setStatus(ON) " + exception.getMessage());
            }
            SocketConnector socketConnector = new SocketConnector();
            if (this.sslType != null) {
                socketConnector.setSSLType(this.sslType);
            }
            this.sock = socketConnector.createSocket(string, n);
            if (this.sock == null) {
                this.log.warn("I did not get a socket");
                this.disconnect();
                return false;
            }
            this.connected = true;
            this.sock.setKeepAlive(true);
            this.sock.setTcpNoDelay(true);
            this.sock.setSoLinger(false, 0);
            InputStream inputStream = this.sock.getInputStream();
            OutputStream outputStream = this.sock.getOutputStream();
            this.bin = new BufferedInputStream(inputStream, 8192);
            this.bout = new BufferedOutputStream(outputStream);
            while (this.negotiate(byArray = this.readNegotiations())) {
            }
            this.negotiated = true;
            try {
                this.screen52.setCursorActive(false);
            }
            catch (Exception exception) {
                this.log.warn("setCursorOff " + exception.getMessage());
            }
            this.producer = new DataStreamProducer(this, this.bin, this.dsq, byArray);
            this.pthread = new Thread(this.producer);
            this.pthread.setPriority(5);
            this.pthread.start();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        tnvt.this.screen52.getOIA().setInputInhibited(0, 1);
                    }
                });
            }
            catch (Exception exception) {
                this.log.warn("setStatus(OFF) " + exception.getMessage());
            }
            this.keepTrucking = true;
            this.me = new Thread(this);
            this.me.start();
        }
        catch (Exception exception) {
            if (exception.getMessage() == null) {
                exception.printStackTrace();
            }
            this.log.warn("connect() " + exception.getMessage());
            if (this.sock == null) {
                this.log.warn("I did not get a socket");
            }
            this.disconnect();
            return false;
        }
        return true;
    }

    public final boolean disconnect() {
        if (!this.connected) {
            this.screen52.getOIA().setInputInhibited(1, 1, "X - Disconnected");
            return false;
        }
        if (this.me != null && this.me.isAlive()) {
            this.me.interrupt();
            this.keepTrucking = false;
            this.pthread.interrupt();
        }
        this.screen52.getOIA().setInputInhibited(1, 1, "X - Disconnected");
        this.screen52.getOIA().setKeyBoardLocked(false);
        this.pendingUnlock = false;
        try {
            if (this.sock != null) {
                this.log.info("Closing socket");
                this.sock.close();
            }
            if (this.bin != null) {
                this.bin.close();
            }
            if (this.bout != null) {
                this.bout.close();
            }
            this.connected = false;
            this.firstScreen = false;
            this.screen52.goto_XY(0);
            this.screen52.setCursorActive(false);
            this.screen52.clearAll();
            this.screen52.restoreScreen();
            this.controller.fireSessionChanged(0);
        }
        catch (Exception exception) {
            this.log.warn(exception.getMessage());
            this.connected = false;
            this.devSeq = -1;
            return false;
        }
        this.devSeq = -1;
        return true;
    }

    private final ByteArrayOutputStream appendByteStream(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < byArray.length; ++i) {
            byteArrayOutputStream.write(byArray[i]);
            if (byArray[i] != -1) continue;
            byteArrayOutputStream.write(-1);
        }
        return byteArrayOutputStream;
    }

    private final byte[] readNegotiations() throws IOException {
        int n = this.bin.read();
        if (n < 0) {
            throw new IOException("Connection closed.");
        }
        int n2 = this.bin.available();
        byte[] byArray = new byte[n2 + 1];
        byArray[0] = (byte)n;
        this.bin.read(byArray, 1, n2);
        return byArray;
    }

    private final void writeByte(byte[] byArray) throws IOException {
        this.bout.write(byArray);
        this.bout.flush();
    }

    public final void sendHeartBeat() throws IOException {
        byte[] byArray = new byte[]{-1, -15};
        this.bout.write(byArray);
        this.bout.flush();
    }

    private final void readImmediate(int n) {
        if (this.screen52.isStatusErrorCode()) {
            this.screen52.restoreErrorLine();
            this.screen52.setStatus((byte)2, (byte)2, null);
        }
        if (!this.enhanced) {
            this.screen52.setCursorActive(false);
        }
        this.screen52.getOIA().setInputInhibited(1, 1);
        this.screen52.getOIA().setKeyBoardLocked(true);
        this.pendingUnlock = false;
        this.invited = false;
        this.screen52.getScreenFields().readFormatTable(this.baosp, n, this.codePage);
        try {
            this.writeGDS(0, 3, this.baosp.toByteArray());
        }
        catch (IOException iOException) {
            this.log.warn(iOException.getMessage());
            this.baosp.reset();
        }
        this.baosp.reset();
    }

    public final boolean sendAidKey(int n) {
        if (this.screen52.isStatusErrorCode()) {
            this.screen52.restoreErrorLine();
            this.screen52.setStatus((byte)2, (byte)2, null);
        }
        if (!this.enhanced) {
            this.screen52.setCursorActive(false);
        }
        this.screen52.getOIA().setInputInhibited(1, 1);
        this.screen52.getOIA().setKeyBoardLocked(true);
        this.pendingUnlock = false;
        this.invited = false;
        this.baosp.write(this.screen52.getCurrentRow());
        this.baosp.write(this.screen52.getCurrentCol());
        this.baosp.write(n);
        if (this.dataIncluded(n)) {
            this.screen52.getScreenFields().readFormatTable(this.baosp, this.readType, this.codePage);
        }
        try {
            this.writeGDS(0, 3, this.baosp.toByteArray());
        }
        catch (IOException iOException) {
            this.log.warn(iOException.getMessage());
            this.baosp.reset();
            return false;
        }
        this.baosp.reset();
        return true;
    }

    private boolean dataIncluded(int n) {
        switch (n) {
            case 49: {
                return !this.dataIncluded[0];
            }
            case 50: {
                return !this.dataIncluded[1];
            }
            case 51: {
                return !this.dataIncluded[2];
            }
            case 52: {
                return !this.dataIncluded[3];
            }
            case 53: {
                return !this.dataIncluded[4];
            }
            case 54: {
                return !this.dataIncluded[5];
            }
            case 55: {
                return !this.dataIncluded[6];
            }
            case 56: {
                return !this.dataIncluded[7];
            }
            case 57: {
                return !this.dataIncluded[8];
            }
            case 58: {
                return !this.dataIncluded[9];
            }
            case 59: {
                return !this.dataIncluded[10];
            }
            case 60: {
                return !this.dataIncluded[11];
            }
            case 177: {
                return !this.dataIncluded[12];
            }
            case 178: {
                return !this.dataIncluded[13];
            }
            case 179: {
                return !this.dataIncluded[14];
            }
            case 180: {
                return !this.dataIncluded[15];
            }
            case 181: {
                return !this.dataIncluded[16];
            }
            case 182: {
                return !this.dataIncluded[17];
            }
            case 183: {
                return !this.dataIncluded[18];
            }
            case 184: {
                return !this.dataIncluded[19];
            }
            case 185: {
                return !this.dataIncluded[20];
            }
            case 186: {
                return !this.dataIncluded[21];
            }
            case 187: {
                return !this.dataIncluded[22];
            }
            case 188: {
                return !this.dataIncluded[23];
            }
        }
        return true;
    }

    public final void sendHelpRequest() {
        this.baosp.write(this.screen52.getCurrentRow());
        this.baosp.write(this.screen52.getCurrentCol());
        this.baosp.write(243);
        try {
            this.writeGDS(0, 3, this.baosp.toByteArray());
        }
        catch (IOException iOException) {
            this.log.warn(iOException.getMessage());
        }
        this.baosp.reset();
    }

    public final void sendAttentionKey() {
        try {
            this.writeGDS(64, 0, null);
        }
        catch (IOException iOException) {
            this.log.warn(iOException.getMessage());
        }
    }

    public final void systemRequest() {
        String string = this.controller.showSystemRequest();
        this.systemRequest(string);
    }

    public final void systemRequest(char c) {
        this.systemRequest(Character.toString(c));
    }

    public final void systemRequest(String string) {
        byte[] byArray = null;
        if (string != null && string.length() > 0) {
            if (string.charAt(0) == '2') {
                this.dsq.clear();
            }
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                this.baosp.write(this.codePage.uni2ebcdic(string.charAt(i)));
            }
            byArray = this.baosp.toByteArray();
        }
        try {
            this.writeGDS(4, 0, byArray);
        }
        catch (IOException iOException) {
            this.log.info(iOException.getMessage());
        }
        this.baosp.reset();
    }

    public final void cancelInvite() {
        this.screen52.getOIA().setInputInhibited(1, 1);
        try {
            this.writeGDS(0, 10, null);
        }
        catch (IOException iOException) {
            this.log.warn(iOException.getMessage());
        }
    }

    public final void hostPrint(int n) {
        if (this.screen52.isStatusErrorCode()) {
            this.screen52.restoreErrorLine();
            this.screen52.setStatus((byte)2, (byte)2, null);
        }
        this.screen52.setCursorActive(false);
        this.screen52.getOIA().setInputInhibited(1, 1);
        this.baosp.write(this.screen52.getCurrentRow());
        this.baosp.write(this.screen52.getCurrentCol());
        this.baosp.write(246);
        try {
            this.writeGDS(0, 3, this.baosp.toByteArray());
        }
        catch (IOException iOException) {
            this.log.warn(iOException.getMessage());
        }
        this.baosp.reset();
    }

    public final void toggleDebug() {
        this.producer.toggleDebug(this.codePage);
    }

    private final void writeGDS(int n, int n2, byte[] byArray) throws IOException {
        if (this.bout == null) {
            return;
        }
        int n3 = byArray != null ? byArray.length + 10 : 10;
        this.baosrsp.write(n3 >> 8);
        this.baosrsp.write(n3 & 0xFF);
        this.baosrsp.write(18);
        this.baosrsp.write(160);
        this.baosrsp.write(0);
        this.baosrsp.write(0);
        this.baosrsp.write(4);
        this.baosrsp.write(n);
        this.baosrsp.write(0);
        this.baosrsp.write(n2);
        if (byArray != null) {
            this.baosrsp.write(byArray, 0, byArray.length);
        }
        this.baosrsp = this.appendByteStream(this.baosrsp.toByteArray());
        this.baosrsp.write(-1);
        this.baosrsp.write(-17);
        this.baosrsp.writeTo(this.bout);
        this.bout.flush();
        this.baosrsp.reset();
    }

    protected final int getOpCode() {
        return this.bk.getOpCode();
    }

    protected boolean[] getActiveAidKeys() {
        boolean[] blArray = new boolean[this.dataIncluded.length];
        System.arraycopy(this.dataIncluded, 0, blArray, 0, this.dataIncluded.length);
        return blArray;
    }

    private final void setInvited() {
        this.log.debug("invited");
        if (!this.screen52.isStatusErrorCode()) {
            this.screen52.getOIA().setInputInhibited(0, 1);
        }
        this.invited = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void strpccmd() {
        try {
            int n = 11;
            ScreenPlanes screenPlanes = this.screen52.getPlanes();
            char c = screenPlanes.getChar(n);
            boolean bl = c != 'a';
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = n + 1; i < 132; ++i) {
                c = screenPlanes.getChar(i);
                if (Character.isISOControl(c)) {
                    c = ' ';
                }
                stringBuilder.append(c);
            }
            String string = stringBuilder.toString().trim();
            this.run(string, bl);
        }
        finally {
            this.strpccmd = false;
            this.screen52.sendKeys("[enter]");
        }
    }

    private void run(String string, boolean bl) {
        try {
            this.log.debug("RUN cmd = " + string);
            this.log.debug("RUN wait = " + bl);
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(string);
            if (bl) {
                int n = process.waitFor();
                this.log.debug("RUN result = " + n);
            }
        }
        catch (Throwable throwable) {
            this.log.error(throwable);
        }
    }

    public void setScanningEnabled(boolean bl) {
        this.scan = bl;
    }

    public boolean isScanningEnabled() {
        return this.scan;
    }

    private void scan() {
        ScreenPlanes screenPlanes = this.screen52.getPlanes();
        if (screenPlanes.getChar(STRSCAN) == '#' && screenPlanes.getChar(STRSCAN + 1) == '!' && screenPlanes.getChar(STRSCAN + 2) != ' ') {
            try {
                this.parseCommand();
            }
            catch (Throwable throwable) {
                this.log.info("Exec cmd: " + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
    }

    private void parseCommand() {
        int n;
        char[] cArray = this.screen52.getScreenAsAllChars();
        for (int i = n = STRSCAN + 2; i < cArray.length; ++i) {
            if (cArray[i] != ' ') continue;
            String string = new String(cArray, n, i - n);
            String string2 = new String(cArray, i + 1, cArray.length - (i + 1));
            this.controller.fireScanned(string, string2);
            break;
        }
    }

    @Override
    public void run() {
        if (this.enhanced) {
            this.sfParser = new WTDSFParser(this);
        }
        this.bk = new Stream5250();
        while (this.keepTrucking) {
            try {
                this.bk.initialize((byte[])this.dsq.take());
            }
            catch (InterruptedException interruptedException) {
                this.log.warn("   vt thread interrupted and stopping ");
                this.keepTrucking = false;
                continue;
            }
            Thread.yield();
            this.invited = false;
            this.screen52.setCursorActive(false);
            if (this.bk == null) continue;
            switch (this.bk.getOpCode()) {
                case 0: {
                    this.log.debug("No operation");
                    break;
                }
                case 1: {
                    this.log.debug("Invite Operation");
                    this.parseIncoming();
                    this.pendingUnlock = true;
                    this.cursorOn = true;
                    this.setInvited();
                    break;
                }
                case 2: {
                    this.log.debug("Output Only");
                    this.parseIncoming();
                    this.screen52.updateDirty();
                    break;
                }
                case 3: {
                    this.log.debug("Put/Get Operation");
                    this.parseIncoming();
                    this.setInvited();
                    if (this.firstScreen) break;
                    this.firstScreen = true;
                    this.controller.fireSessionChanged(1);
                    break;
                }
                case 4: {
                    this.log.debug("Save Screen Operation");
                    this.parseIncoming();
                    break;
                }
                case 5: {
                    this.log.debug("Restore Screen Operation");
                    this.parseIncoming();
                    break;
                }
                case 6: {
                    this.log.debug("Read Immediate");
                    this.sendAidKey(0);
                    break;
                }
                case 7: {
                    this.log.debug("Reserved");
                    break;
                }
                case 8: {
                    this.log.debug("Read Screen Operation");
                    try {
                        this.readScreen();
                    }
                    catch (IOException iOException) {
                        this.log.warn(iOException.getMessage());
                    }
                    break;
                }
                case 9: {
                    this.log.debug("Reserved");
                    break;
                }
                case 10: {
                    this.log.debug("Cancel Invite Operation");
                    this.cancelInvite();
                    break;
                }
                case 11: {
                    this.log.debug("Turn on message light");
                    this.screen52.getOIA().setMessageLightOn();
                    this.screen52.setCursorActive(true);
                    break;
                }
                case 12: {
                    this.log.debug("Turn off Message light");
                    this.screen52.getOIA().setMessageLightOff();
                    this.screen52.setCursorActive(true);
                    break;
                }
            }
            if (this.screen52.isUsingGuiInterface()) {
                this.screen52.drawFields();
            }
            try {
                if (!this.strpccmd) {
                    this.screen52.updateDirty();
                } else {
                    this.strpccmd();
                }
            }
            catch (RuntimeException runtimeException) {
                this.log.warn("tnvt.run: ", runtimeException);
            }
            if (this.pendingUnlock && !this.screen52.isStatusErrorCode()) {
                this.screen52.getOIA().setKeyBoardLocked(false);
                this.pendingUnlock = false;
            }
            if (this.cursorOn && !this.screen52.getOIA().isKeyBoardLocked()) {
                this.screen52.setCursorActive(true);
                this.cursorOn = false;
            }
            Thread.yield();
        }
    }

    private final void readScreen() throws IOException {
        int n = this.screen52.getRows();
        int n2 = this.screen52.getColumns();
        byte[] byArray = new byte[n * n2];
        this.fillScreenArray(byArray);
        this.writeGDS(0, 0, byArray);
    }

    private final void fillScreenArray(byte[] byArray) {
        int n = 32;
        int n2 = 0;
        ScreenPlanes screenPlanes = this.screen52.planes;
        for (int i = 0; i < byArray.length; ++i) {
            if (screenPlanes.isAttributePlace(i)) {
                n = screenPlanes.getCharAttr(i);
                byArray[n2++] = (byte)n;
                continue;
            }
            if (screenPlanes.getCharAttr(i) != n) {
                n = screenPlanes.getCharAttr(i);
                --n2;
                n2 = Math.max(n2, 0);
                byArray[n2++] = (byte)n;
            }
            char c = screenPlanes.getChar(i);
            byte by = (byte)c;
            if (this.isDataUnicode(c)) {
                by = this.codePage.uni2ebcdic(c);
            }
            byArray[Math.min((int)n2++, (int)(byArray.length - 1))] = by;
        }
    }

    private byte[] createRegenerationBuffer(int n) throws IOException {
        int n2 = 32;
        int n3 = 0;
        ScreenPlanes screenPlanes = this.screen52.planes;
        byte[] byArray = new byte[n];
        try {
            boolean bl = this.sfParser != null && this.sfParser.isGuisExists();
            for (int i = 0; i < n; ++i) {
                byte[] byArray2;
                if (bl && (byArray2 = this.sfParser.getSegmentAtPos(i)) != null) {
                    byte[] byArray3 = new byte[byArray.length + byArray2.length + 2];
                    System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                    System.arraycopy(byArray2, 0, byArray3, n3 + 2, byArray2.length);
                    byArray = new byte[byArray3.length];
                    System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
                    byArray[n3++] = 4;
                    byArray[n3++] = 17;
                    n3 += byArray2.length;
                }
                if (screenPlanes.isAttributePlace(i)) {
                    n2 = screenPlanes.getCharAttr(i);
                    byArray[n3++] = (byte)n2;
                    continue;
                }
                if (screenPlanes.getCharAttr(i) != n2) {
                    n2 = screenPlanes.getCharAttr(i);
                    --n3;
                    n3 = Math.max(n3, 0);
                    byArray[n3++] = (byte)n2;
                }
                char c = screenPlanes.getChar(i);
                byte by = (byte)c;
                if (this.isDataUnicode(c)) {
                    by = this.codePage.uni2ebcdic(c);
                }
                byArray[Math.min((int)n3++, (int)(n - 1))] = by;
            }
        }
        catch (Exception exception) {
            this.log.warn("Error, while filling the screen array. TN5250j will continue to operate, but screen may be displayed wrong.", exception);
        }
        return byArray;
    }

    public final void saveScreen() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(new byte[]{4, 18, 0, 0});
        byteArrayOutputStream.write((byte)this.screen52.getRows());
        byteArrayOutputStream.write((byte)this.screen52.getColumns());
        int n = this.screen52.getCurrentPos();
        byteArrayOutputStream.write((byte)(n >> 8 & 0xFF));
        byteArrayOutputStream.write((byte)(n & 0xFF));
        byteArrayOutputStream.write((byte)(this.screen52.homePos >> 8 & 0xFF));
        byteArrayOutputStream.write((byte)(this.screen52.homePos & 0xFF));
        byteArrayOutputStream.write(this.createRegenerationBuffer(this.screen52.getRows() * this.screen52.getColumns()));
        int n2 = this.screen52.getScreenFields().getSize();
        byteArrayOutputStream.write((byte)(n2 >> 8 & 0xFF));
        byteArrayOutputStream.write((byte)(n2 & 0xFF));
        if (n2 > 0) {
            int n3 = this.screen52.getScreenFields().getSize();
            for (int i = 0; i < n3; ++i) {
                ScreenField screenField = this.screen52.getScreenFields().getField(i);
                byteArrayOutputStream.write((byte)screenField.getAttr());
                int n4 = screenField.startPos();
                byteArrayOutputStream.write((byte)(n4 >> 8 & 0xFF));
                byteArrayOutputStream.write((byte)(n4 & 0xFF));
                if (screenField.mdt) {
                    byteArrayOutputStream.write(1);
                } else {
                    byteArrayOutputStream.write(0);
                }
                byteArrayOutputStream.write((byte)(screenField.getLength() >> 8 & 0xFF));
                byteArrayOutputStream.write((byte)(screenField.getLength() & 0xFF));
                byteArrayOutputStream.write((byte)screenField.getFFW1() & 0xFF);
                byteArrayOutputStream.write((byte)screenField.getFFW2() & 0xFF);
                byteArrayOutputStream.write((byte)screenField.getFCW1() & 0xFF);
                byteArrayOutputStream.write((byte)screenField.getFCW2() & 0xFF);
                this.log.debug("Saved ");
                this.log.debug(screenField.toString());
            }
        }
        try {
            this.writeGDS(0, 3, byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            this.log.warn(iOException.getMessage());
        }
        this.log.debug("Save Screen end ");
    }

    public final void restoreScreen() throws IOException {
        int n = 0;
        ScreenPlanes screenPlanes = this.screen52.planes;
        try {
            int n2;
            int n3;
            this.log.debug("Restore ");
            this.bk.getNextByte();
            this.bk.getNextByte();
            int n4 = this.bk.getNextByte() & 0xFF;
            int n5 = this.bk.getNextByte() & 0xFF;
            int n6 = this.bk.getNextByte() << 8 & 0xFF00;
            n6 |= this.bk.getNextByte() & 0xFF;
            int n7 = this.bk.getNextByte() << 8 & 0xFF00;
            n7 |= this.bk.getNextByte() & 0xFF;
            if (n4 != this.screen52.getRows()) {
                this.screen52.setRowsCols(n4, n5);
            }
            this.screen52.clearAll();
            if (this.sfParser != null && this.sfParser.isGuisExists()) {
                this.sfParser.clearGuiStructs();
            }
            int n8 = 32;
            int n9 = 32;
            int n10 = n4 * n5;
            for (n3 = 0; n3 < n10; ++n3) {
                n8 = this.bk.getNextByte();
                if (n8 == 4) {
                    this.log.info(" gui restored at " + n3 + " - " + this.screen52.getRow(n3) + "," + this.screen52.getCol(n3));
                    n2 = this.bk.getNextByte();
                    byte[] byArray = this.bk.getSegment();
                    if (byArray.length > 0) {
                        this.screen52.goto_XY(n3);
                        this.sfParser.parseWriteToDisplayStructuredField(byArray);
                    }
                    --n3;
                    continue;
                }
                if (screenPlanes.isUseGui(n3)) continue;
                if (this.isAttribute(n8)) {
                    screenPlanes.setScreenCharAndAttr(n3, screenPlanes.getChar(n3), n8, true);
                    n9 = n8;
                    continue;
                }
                n2 = n8;
                if (this.isDataEBCDIC(n8)) {
                    n2 = this.codePage.ebcdic2uni(n8);
                }
                screenPlanes.setScreenCharAndAttr(n3, (char)n2, n9, false);
            }
            n3 = this.bk.getNextByte() << 8 & 0xFF00;
            this.log.debug("number of fields " + (n3 |= this.bk.getNextByte() & 0xFF));
            if (n3 > 0) {
                byte by = 0;
                int n11 = 0;
                int n12 = 0;
                byte by2 = 0;
                byte by3 = 0;
                byte by4 = 0;
                byte by5 = 0;
                boolean bl = false;
                ScreenField screenField = null;
                for (n2 = 0; n2 < n3; ++n2) {
                    by = this.bk.getNextByte();
                    n11 = this.bk.getNextByte() << 8 & 0xFF00;
                    n11 |= this.bk.getNextByte() & 0xFF;
                    bl = this.bk.getNextByte() == 1;
                    n12 = this.bk.getNextByte() << 8 & 0xFF00;
                    by2 = this.bk.getNextByte();
                    by3 = this.bk.getNextByte();
                    by4 = this.bk.getNextByte();
                    by5 = this.bk.getNextByte();
                    screenField = this.screen52.getScreenFields().setField(by, this.screen52.getRow(n11), this.screen52.getCol(n11), n12 |= this.bk.getNextByte() & 0xFF, by2, by3, by4, by5);
                    while (n12-- > 0) {
                        screenPlanes.setScreenFieldAttr(n11++, by2);
                    }
                    if (bl) {
                        screenField.setMDT();
                        this.screen52.getScreenFields().setMasterMDT();
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("/nRestored ");
                    this.log.debug(screenField.toString());
                }
            }
            if (this.screen52.isUsingGuiInterface()) {
                this.screen52.drawFields();
            }
            this.screen52.restoreScreen();
            this.screen52.setPendingInsert(true, this.screen52.getRow(n6 + n5), this.screen52.getCol(n6 + n5));
            this.screen52.goto_XY(n6 - 1);
            this.screen52.isInField();
        }
        catch (Exception exception) {
            this.log.warn("error restoring screen " + n + " with " + exception.getMessage());
        }
    }

    public final boolean waitingForInput() {
        return this.waitingForInput;
    }

    private void parseIncoming() {
        boolean bl = false;
        boolean bl2 = false;
        try {
            while (this.bk.hasNext() && !bl) {
                byte by = this.bk.getNextByte();
                switch (by) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.log.debug("save screen partial");
                        this.saveScreen();
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 7: {
                        this.controller.signalBell();
                        this.bk.getNextByte();
                        this.bk.getNextByte();
                        break;
                    }
                    case 17: {
                        bl2 = this.writeToDisplay(true);
                        if (!this.scan) break;
                        this.scan();
                        break;
                    }
                    case 13: 
                    case 18: {
                        this.log.debug("restore screen partial");
                        this.restoreScreen();
                        break;
                    }
                    case 32: {
                        byte by2 = this.bk.getNextByte();
                        if (by2 != 0) {
                            this.log.debug(" clear unit alternate error " + Integer.toHexString(by2));
                            this.sendNegResponse(16, 3, 1, 5, " clear unit alternate not supported");
                            bl = true;
                            break;
                        }
                        if (this.screen52.getRows() != 27) {
                            this.screen52.setRowsCols(27, 132);
                        }
                        this.screen52.clearAll();
                        if (this.sfParser == null || !this.sfParser.isGuisExists()) break;
                        this.sfParser.clearGuiStructs();
                        break;
                    }
                    case 33: {
                        this.writeErrorCode();
                        bl2 = this.writeToDisplay(false);
                        break;
                    }
                    case 34: {
                        this.writeErrorCodeToWindow();
                        bl2 = this.writeToDisplay(false);
                        break;
                    }
                    case 98: 
                    case 102: {
                        this.readScreen();
                        break;
                    }
                    case 64: {
                        if (this.screen52.getRows() != 24) {
                            this.screen52.setRowsCols(24, 80);
                        }
                        this.screen52.clearAll();
                        if (this.sfParser == null || !this.sfParser.isGuisExists()) break;
                        this.sfParser.clearGuiStructs();
                        break;
                    }
                    case 80: {
                        this.screen52.clearTable();
                        break;
                    }
                    case 66: 
                    case 82: {
                        this.bk.getNextByte();
                        this.bk.getNextByte();
                        this.readType = by;
                        this.screen52.goHome();
                        this.waitingForInput = true;
                        this.pendingUnlock = true;
                        break;
                    }
                    case -125: {
                        this.readType = by;
                        this.readImmediate(this.readType);
                        break;
                    }
                    case -13: {
                        this.writeStructuredField();
                        break;
                    }
                    case 35: {
                        byte by3 = this.bk.getNextByte();
                        byte by4 = this.bk.getNextByte();
                        byte by5 = this.bk.getNextByte();
                        this.screen52.rollScreen(by3, by4, by5);
                        break;
                    }
                    default: {
                        bl = true;
                        this.sendNegResponse(16, 3, 1, 1, "parseIncoming");
                    }
                }
                if (!bl2) continue;
                bl = true;
            }
        }
        catch (Exception exception) {
            this.log.warn("incoming " + exception.getMessage());
        }
    }

    protected void sendNegResponse(int n, int n2, int n3, int n4, String string) {
        try {
            int n5 = this.bk.getByteOffset(-1) & 0xF0;
            int n6 = this.bk.getCurrentPos() - 1;
            this.log.info("invalid " + string + " command " + n5 + " at pos " + n6);
        }
        catch (Exception exception) {
            this.log.warn("Send Negative Response error " + exception.getMessage());
        }
        this.baosp.write(n);
        this.baosp.write(n2);
        this.baosp.write(n3);
        this.baosp.write(n4);
        try {
            this.writeGDS(128, 0, this.baosp.toByteArray());
        }
        catch (IOException iOException) {
            this.log.warn(iOException.getMessage());
        }
        this.baosp.reset();
    }

    public void sendNegResponse2(int n) {
        this.screen52.setPrehelpState(true, true, false);
        this.baosp.write(0);
        this.baosp.write(n);
        try {
            this.writeGDS(1, 0, this.baosp.toByteArray());
        }
        catch (IOException iOException) {
            this.log.warn(iOException.getMessage());
        }
        this.baosp.reset();
    }

    private boolean writeToDisplay(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        byte by = 0;
        byte by2 = 0;
        int n = this.screen52.getRows();
        int n2 = this.screen52.getColumns();
        try {
            if (bl) {
                by = this.bk.getNextByte();
                by2 = this.bk.getNextByte();
                this.processCC0(by);
            }
            while (this.bk.hasNext() && !bl3) {
                byte by3 = this.bk.getNextByte();
                switch (by3) {
                    case 1: {
                        this.log.debug("SOH - Start of Header Order");
                        bl2 = this.processSOH();
                        break;
                    }
                    case 2: {
                        int n3;
                        int n4;
                        this.log.debug("RA - Repeat to address");
                        int n5 = this.screen52.getCurrentRow();
                        int n6 = this.screen52.getCurrentCol();
                        byte by4 = this.bk.getNextByte();
                        int n7 = this.bk.getNextByte() & 0xFF;
                        if (by4 >= n5) {
                            n4 = this.bk.getNextByte();
                            if (n5 == 1 && n6 == 2 && by4 == this.screen52.getRows() && n7 == this.screen52.getColumns()) {
                                this.screen52.clearScreen();
                                break;
                            }
                            if (n4 != 0) {
                                n4 = this.codePage.ebcdic2uni(n4);
                            }
                            n3 = by4 * this.screen52.getColumns() + n7 - (n5 * this.screen52.getColumns() + n6);
                            while (n3-- >= 0) {
                                this.screen52.setChar(n4);
                            }
                            break;
                        }
                        this.sendNegResponse(16, 5, 1, 35, " RA invalid");
                        bl2 = true;
                        break;
                    }
                    case 3: {
                        this.log.debug("EA - Erase to address");
                        int n4 = this.screen52.getCurrentRow();
                        int n3 = this.screen52.getCurrentCol();
                        byte by5 = this.bk.getNextByte();
                        int n8 = this.bk.getNextByte() & 0xFF;
                        int n9 = this.bk.getNextByte() & 0xFF;
                        while (--n9 > 0) {
                            this.bk.getNextByte();
                        }
                        int n10 = 0;
                        if (n4 == 1 && n3 == 2 && by5 == this.screen52.getRows() && n8 == this.screen52.getColumns()) {
                            this.screen52.clearScreen();
                            break;
                        }
                        int n11 = by5 * this.screen52.getColumns() + n8 - (n4 * this.screen52.getColumns() + n3);
                        while (n11-- >= 0) {
                            this.screen52.setChar(n10);
                        }
                        break;
                    }
                    case 4: {
                        this.log.debug("Command - Escape");
                        bl3 = true;
                        break;
                    }
                    case 16: {
                        this.log.debug("TD - Transparent Data");
                        int n11 = (this.bk.getNextByte() & 0xFF) << 8 | this.bk.getNextByte() & 0xFF;
                        break;
                    }
                    case 17: {
                        this.log.debug("SBA - set buffer address order (row column)");
                        byte by6 = this.bk.getNextByte();
                        int n12 = this.bk.getNextByte() & 0xFF;
                        if (by6 >= 0 && by6 <= this.screen52.getRows() && n12 >= 0 && n12 <= this.screen52.getColumns()) {
                            this.screen52.setCursor(by6, n12);
                            break;
                        }
                        this.sendNegResponse(16, 5, 1, 34, "invalid row/col order saRow = " + by6 + " saRows = " + this.screen52.getRows() + " saCol = " + n12);
                        bl2 = true;
                        break;
                    }
                    case 18: {
                        this.log.debug("WEA - Extended Attribute");
                        this.bk.getNextByte();
                        this.bk.getNextByte();
                        break;
                    }
                    case 19: {
                        this.log.debug("IC - Insert Cursor");
                        byte by7 = this.bk.getNextByte();
                        int n13 = this.bk.getNextByte() & 0xFF;
                        if (by7 >= 0 && by7 <= n && n13 >= 0 && n13 <= n2) {
                            this.log.debug(" IC " + by7 + " " + n13);
                            this.screen52.setPendingInsert(true, by7, n13);
                            break;
                        }
                        this.sendNegResponse(16, 5, 1, 34, " IC/IM position invalid ");
                        bl2 = true;
                        break;
                    }
                    case 20: {
                        this.log.debug("MC - Move Cursor");
                        byte by8 = this.bk.getNextByte();
                        int n14 = this.bk.getNextByte() & 0xFF;
                        if (by8 >= 0 && by8 <= n && n14 >= 0 && n14 <= n2) {
                            this.log.debug(" MC " + by8 + " " + n14);
                            this.screen52.setPendingInsert(false, by8, n14);
                            break;
                        }
                        this.sendNegResponse(16, 5, 1, 34, " IC/IM position invalid ");
                        bl2 = true;
                        break;
                    }
                    case 21: {
                        this.log.debug("WTDSF - Write To Display Structured Field order");
                        byte[] byArray = this.bk.getSegment();
                        bl2 = this.sfParser.parseWriteToDisplayStructuredField(byArray);
                        break;
                    }
                    case 29: {
                        int n15;
                        this.log.debug("SF - Start of Field");
                        int n16 = 0;
                        int n17 = 0;
                        int n18 = 0;
                        int n19 = this.bk.getNextByte() & 0xFF;
                        if ((n19 & 0x40) == 64) {
                            n18 = this.bk.getNextByte() & 0xFF;
                            n16 = this.bk.getNextByte() & 0xFF;
                            if (n16 == 129) {
                                this.bk.getNextByte();
                                n16 = this.bk.getNextByte() & 0xFF;
                            }
                            if (!this.isAttribute(n16)) {
                                n17 = this.bk.getNextByte() & 0xFF;
                                n15 = this.bk.getNextByte() & 0xFF;
                                while (!this.isAttribute(n15)) {
                                    this.log.info(Integer.toHexString(n16) + " " + Integer.toHexString(n17) + " ");
                                    this.log.info(Integer.toHexString(n15) + " " + Integer.toHexString(this.bk.getNextByte() & 0xFF));
                                    n15 = this.bk.getNextByte() & 0xFF;
                                }
                            } else {
                                n15 = n16;
                                n16 = 0;
                            }
                        } else {
                            n15 = n19;
                        }
                        int n20 = (this.bk.getNextByte() & 0xFF) << 8 | this.bk.getNextByte() & 0xFF;
                        this.screen52.addField(n15, n20, n19, n18, n16, n17);
                        break;
                    }
                    case -128: {
                        int n21;
                        this.log.debug("STRPCCMD got a -128 command at " + this.screen52.getCurrentPos());
                        StringBuffer stringBuffer = new StringBuffer();
                        int[] nArray = new int[9];
                        int[] nArray2 = new int[]{252, 215, 195, 214, 64, 131, 128, 161, 128};
                        for (n21 = 0; n21 < 9; ++n21) {
                            byte by9 = this.bk.getNextByte();
                            nArray[n21] = by9 & 0xFF;
                            char c = this.codePage.ebcdic2uni(by9);
                            stringBuffer.append(c);
                        }
                        if (Arrays.equals(nArray, nArray2)) {
                            this.strpccmd = true;
                        }
                        for (n21 = 0; n21 < 9; ++n21) {
                            this.bk.setPrevByte();
                        }
                    }
                    default: {
                        int n21 = this.bk.getByteOffset(-1);
                        if (this.isAttribute(n21)) {
                            this.screen52.setAttr(n21);
                            break;
                        }
                        if (!this.screen52.isStatusErrorCode()) {
                            if (!this.isDataEBCDIC(n21)) {
                                this.screen52.setChar(n21);
                                break;
                            }
                            this.screen52.setChar(this.codePage.ebcdic2uni(n21));
                            break;
                        }
                        if (n21 == 0) {
                            this.screen52.setChar(n21);
                            break;
                        }
                        this.screen52.setChar(this.codePage.ebcdic2uni(n21));
                    }
                }
                if (!bl2) continue;
                bl3 = true;
            }
        }
        catch (Exception exception) {
            this.log.warn("write to display " + exception.getMessage(), exception);
        }
        this.processCC1(by2);
        return bl2;
    }

    private boolean processSOH() throws Exception {
        byte by = this.bk.getNextByte();
        this.log.debug(" byte 0 " + by);
        if (by > 0 && by <= 7) {
            this.bk.getNextByte();
            this.bk.getNextByte();
            this.bk.getNextByte();
            this.screen52.clearTable();
            if (by <= 3) {
                return false;
            }
            this.screen52.setErrorLine(this.bk.getNextByte());
            byte by2 = 0;
            if (by >= 5) {
                by2 = this.bk.getNextByte();
                this.dataIncluded[23] = (by2 & 0x80) == 128;
                this.dataIncluded[22] = (by2 & 0x40) == 64;
                this.dataIncluded[21] = (by2 & 0x20) == 32;
                this.dataIncluded[20] = (by2 & 0x10) == 16;
                this.dataIncluded[19] = (by2 & 8) == 8;
                this.dataIncluded[18] = (by2 & 4) == 4;
                this.dataIncluded[17] = (by2 & 2) == 2;
                boolean bl = this.dataIncluded[16] = (by2 & 1) == 1;
            }
            if (by >= 6) {
                by2 = this.bk.getNextByte();
                this.dataIncluded[15] = (by2 & 0x80) == 128;
                this.dataIncluded[14] = (by2 & 0x40) == 64;
                this.dataIncluded[13] = (by2 & 0x20) == 32;
                this.dataIncluded[12] = (by2 & 0x10) == 16;
                this.dataIncluded[11] = (by2 & 8) == 8;
                this.dataIncluded[10] = (by2 & 4) == 4;
                this.dataIncluded[9] = (by2 & 2) == 2;
                boolean bl = this.dataIncluded[8] = (by2 & 1) == 1;
            }
            if (by >= 7) {
                by2 = this.bk.getNextByte();
                this.dataIncluded[7] = (by2 & 0x80) == 128;
                this.dataIncluded[6] = (by2 & 0x40) == 64;
                this.dataIncluded[5] = (by2 & 0x20) == 32;
                this.dataIncluded[4] = (by2 & 0x10) == 16;
                this.dataIncluded[3] = (by2 & 8) == 8;
                this.dataIncluded[2] = (by2 & 4) == 4;
                this.dataIncluded[1] = (by2 & 2) == 2;
                this.dataIncluded[0] = (by2 & 1) == 1;
            }
            return false;
        }
        this.sendNegResponse(16, 5, 1, 43, "invalid SOH length");
        return true;
    }

    private void processCC0(byte by) {
        this.log.debug(" Control byte0 " + Integer.toBinaryString(by & 0xFF));
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if ((by & 0xE0) == 0) {
            bl = false;
        }
        switch (by & 0xE0) {
            case 64: {
                bl2 = true;
                break;
            }
            case 96: {
                bl3 = true;
                break;
            }
            case 128: {
                bl4 = true;
                break;
            }
            case 160: {
                bl2 = true;
                bl5 = true;
                break;
            }
            case 192: {
                bl2 = true;
                bl4 = true;
                break;
            }
            case 224: {
                bl3 = true;
                bl5 = true;
            }
        }
        if (bl) {
            this.screen52.getOIA().setKeyBoardLocked(true);
            this.pendingUnlock = false;
        } else {
            this.pendingUnlock = false;
        }
        if (bl2 || bl3 || bl4 || bl5) {
            int n = this.screen52.getScreenFields().getSize();
            for (int i = 0; i < n; ++i) {
                ScreenField screenField = this.screen52.getScreenFields().getField(i);
                if (!screenField.isBypassField() && (bl4 && screenField.mdt || bl5)) {
                    screenField.setFieldChar('\u0000');
                    this.screen52.drawField(screenField);
                }
                if (!bl3 && (!bl2 || screenField.isBypassField())) continue;
                screenField.resetMDT();
            }
        }
    }

    private void processCC1(byte by) {
        this.log.debug(" Control byte1 " + Integer.toBinaryString(by & 0xFF));
        if ((by & 4) == 4) {
            this.controller.signalBell();
        }
        if ((by & 2) == 2) {
            this.screen52.getOIA().setMessageLightOff();
        }
        if ((by & 1) == 1) {
            this.screen52.getOIA().setMessageLightOn();
        }
        if ((by & 1) == 1 && (by & 2) == 2) {
            this.screen52.getOIA().setMessageLightOn();
        }
        if ((by & 0x20) == 32 && (by & 8) == 0) {
            this.screen52.setPendingInsert(false);
            this.log.debug(" WTD position no move");
        } else {
            this.screen52.setPendingInsert(true);
            this.log.debug(" WTD position move to home" + this.screen52.homePos + " row " + this.screen52.getRow(this.screen52.homePos) + " col " + this.screen52.getCol(this.screen52.homePos));
        }
        if ((by & 0x20) == 32 && this.enhanced) {
            this.cursorOn = true;
        }
        if (!this.screen52.isStatusErrorCode() && (by & 8) == 8) {
            this.cursorOn = true;
        }
        if ((by & 0x20) == 32 && (by & 8) == 0) {
            this.screen52.setPendingInsert(false, 1, 1);
        }
    }

    private boolean isAttribute(int n) {
        int n2 = n & 0xFF;
        return (n2 & 0xE0) == 32;
    }

    private boolean isDataEBCDIC(int n) {
        int n2 = n & 0xFF;
        return n2 >= 64 && n2 < 255;
    }

    private boolean isDataUnicode(int n) {
        return (n < 0 || n >= 32) && n != 65535;
    }

    private void writeStructuredField() {
        boolean bl = false;
        try {
            int n = (this.bk.getNextByte() & 0xFF) << 8 | this.bk.getNextByte() & 0xFF;
            block8: while (this.bk.hasNext() && !bl) {
                switch (this.bk.getNextByte()) {
                    case -39: {
                        switch (this.bk.getNextByte()) {
                            case 112: {
                                this.bk.getNextByte();
                                this.sendQueryResponse();
                                continue block8;
                            }
                        }
                        this.log.debug("invalid structured field sub command " + this.bk.getByteOffset(-1));
                        continue block8;
                    }
                }
                this.log.debug("invalid structured field command " + this.bk.getByteOffset(-1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void writeErrorCode() throws Exception {
        this.screen52.setCursor(this.screen52.getErrorLine(), 1);
        this.screen52.setStatus((byte)2, (byte)1, null);
        this.screen52.saveErrorLine();
        this.cursorOn = true;
    }

    private final void writeErrorCodeToWindow() throws Exception {
        int n = this.bk.getNextByte() & 0xFF;
        int n2 = this.bk.getNextByte() & 0xFF;
        this.screen52.setCursor(this.screen52.getErrorLine(), n);
        this.screen52.setStatus((byte)2, (byte)1, null);
        this.screen52.saveErrorLine();
        this.cursorOn = true;
    }

    private final void sendQueryResponse() throws IOException {
        this.log.info("sending query response");
        byte[] byArray = new byte[64];
        byArray[0] = 0;
        byArray[1] = 0;
        byArray[2] = -120;
        if (this.enhanced) {
            byArray[3] = 0;
            byArray[4] = 64;
        } else {
            byArray[3] = 0;
            byArray[4] = 58;
        }
        byArray[5] = -39;
        byArray[6] = 112;
        byArray[7] = -128;
        byArray[8] = 6;
        byArray[9] = 0;
        byArray[10] = 1;
        byArray[11] = 1;
        byArray[12] = 0;
        byArray[13] = 0;
        byArray[14] = 0;
        byArray[15] = 0;
        byArray[16] = 0;
        byArray[17] = 0;
        byArray[18] = 0;
        byArray[19] = 0;
        byArray[20] = 0;
        byArray[21] = 0;
        byArray[22] = 0;
        byArray[23] = 0;
        byArray[24] = 0;
        byArray[25] = 0;
        byArray[26] = 0;
        byArray[27] = 0;
        byArray[28] = 0;
        byArray[29] = 1;
        byArray[30] = this.codePage.uni2ebcdic('5');
        byArray[31] = this.codePage.uni2ebcdic('2');
        byArray[32] = this.codePage.uni2ebcdic('5');
        byArray[33] = this.codePage.uni2ebcdic('1');
        byArray[34] = this.codePage.uni2ebcdic('0');
        byArray[35] = this.codePage.uni2ebcdic('1');
        byArray[36] = this.codePage.uni2ebcdic('1');
        byArray[37] = 2;
        byArray[38] = 0;
        byArray[39] = 0;
        byArray[40] = 0;
        byArray[41] = 36;
        byArray[42] = 36;
        byArray[43] = 0;
        byArray[44] = 1;
        byArray[45] = 0;
        byArray[46] = 0;
        byArray[47] = 0;
        byArray[48] = 0;
        byArray[49] = 1;
        byArray[50] = 17;
        byArray[51] = 0;
        byArray[52] = 0;
        if (this.enhanced) {
            byArray[53] = 7;
            this.log.info("enhanced options");
        } else {
            byArray[53] = 0;
        }
        byArray[54] = 24;
        byArray[54] = 8;
        byArray[55] = 0;
        byArray[56] = 0;
        byArray[57] = 0;
        byArray[58] = 0;
        byArray[59] = 0;
        byArray[60] = 0;
        byArray[61] = 0;
        byArray[62] = 0;
        byArray[63] = 0;
        this.writeGDS(0, 0, byArray);
        byArray = null;
    }

    protected final boolean negotiate(byte[] byArray) throws IOException {
        int n = 0;
        if (byArray[n] == -1) {
            block16: while (n < byArray.length && byArray[n++] == -1) {
                switch (byArray[n++]) {
                    default: {
                        continue block16;
                    }
                    case -3: {
                        if (n < byArray.length) {
                            switch (byArray[n]) {
                                case 24: {
                                    this.baosp.write(-1);
                                    this.baosp.write(-5);
                                    this.baosp.write(24);
                                    this.writeByte(this.baosp.toByteArray());
                                    this.baosp.reset();
                                    break;
                                }
                                case 25: {
                                    this.baosp.write(-1);
                                    this.baosp.write(-5);
                                    this.baosp.write(25);
                                    this.writeByte(this.baosp.toByteArray());
                                    this.baosp.reset();
                                    break;
                                }
                                case 0: {
                                    this.baosp.write(-1);
                                    this.baosp.write(-5);
                                    this.baosp.write(0);
                                    this.writeByte(this.baosp.toByteArray());
                                    this.baosp.reset();
                                    break;
                                }
                                case 6: {
                                    this.log.debug("Timing Mark Received and notifying the server that we will not do it.");
                                    this.baosp.write(-1);
                                    this.baosp.write(-4);
                                    this.baosp.write(6);
                                    this.writeByte(this.baosp.toByteArray());
                                    this.baosp.reset();
                                    break;
                                }
                                case 39: {
                                    this.baosp.write(-1);
                                    this.baosp.write(-5);
                                    this.baosp.write(39);
                                    this.writeByte(this.baosp.toByteArray());
                                    this.baosp.reset();
                                    break;
                                }
                                default: {
                                    this.baosp.write(-1);
                                    this.baosp.write(-4);
                                    this.baosp.write(byArray[n]);
                                    this.writeByte(this.baosp.toByteArray());
                                    this.baosp.reset();
                                }
                            }
                        }
                        ++n;
                        continue block16;
                    }
                    case -5: {
                        switch (byArray[n]) {
                            case 25: {
                                this.baosp.write(-1);
                                this.baosp.write(-3);
                                this.baosp.write(25);
                                this.writeByte(this.baosp.toByteArray());
                                this.baosp.reset();
                                break;
                            }
                            case 0: {
                                this.baosp.write(-1);
                                this.baosp.write(-3);
                                this.baosp.write(0);
                                this.writeByte(this.baosp.toByteArray());
                                this.baosp.reset();
                            }
                        }
                        ++n;
                        continue block16;
                    }
                    case -6: 
                }
                if (byArray[n] == 39 && byArray[n + 1] == 1) {
                    this.negNewEnvironment();
                    while (++n < byArray.length && byArray[n + 1] != -1) {
                    }
                }
                if (byArray[n] == 24 && byArray[n + 1] == 1) {
                    this.baosp.write(-1);
                    this.baosp.write(-6);
                    this.baosp.write(24);
                    this.baosp.write(0);
                    if (!this.support132) {
                        this.baosp.write("IBM-3179-2".getBytes());
                    } else {
                        this.baosp.write("IBM-3477-FC".getBytes());
                    }
                    this.baosp.write(-1);
                    this.baosp.write(-16);
                    this.writeByte(this.baosp.toByteArray());
                    this.baosp.reset();
                    ++n;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    private void negNewEnvironment() throws IOException {
        this.baosp.write(-1);
        this.baosp.write(-6);
        this.baosp.write(39);
        this.baosp.write(0);
        if (this.kbdTypesCodePage != null) {
            this.baosp.write(3);
            this.baosp.write("KBDTYPE".getBytes());
            this.baosp.write(1);
            this.baosp.write(this.kbdTypesCodePage.kbdType.getBytes());
            this.baosp.write(3);
            this.baosp.write("CODEPAGE".getBytes());
            this.baosp.write(1);
            this.baosp.write(this.kbdTypesCodePage.codepage.getBytes());
            this.baosp.write(3);
            this.baosp.write("CHARSET".getBytes());
            this.baosp.write(1);
            this.baosp.write(this.kbdTypesCodePage.charset.getBytes());
        }
        if (this.devName != null) {
            this.baosp.write(3);
            this.baosp.write("DEVNAME".getBytes());
            this.baosp.write(1);
            this.baosp.write(this.negDeviceName().getBytes());
        }
        if (this.user != null) {
            this.baosp.write(0);
            this.baosp.write("USER".getBytes());
            this.baosp.write(1);
            this.baosp.write(this.user.getBytes());
            if (this.password != null) {
                this.baosp.write(3);
                this.baosp.write("IBMRSEED".getBytes());
                this.baosp.write(1);
                this.baosp.write(2);
                this.baosp.write(0);
                this.baosp.write(0);
                this.baosp.write(0);
                this.baosp.write(0);
                this.baosp.write(0);
                this.baosp.write(0);
                this.baosp.write(0);
                this.baosp.write(0);
                this.baosp.write(3);
                this.baosp.write("IBMSUBSPW".getBytes());
                this.baosp.write(1);
                this.baosp.write(this.password.getBytes());
            }
            if (this.library != null) {
                this.baosp.write(3);
                this.baosp.write("IBMCURLIB".getBytes());
                this.baosp.write(1);
                this.baosp.write(this.library.getBytes());
            }
            if (this.initialMenu != null) {
                this.baosp.write(3);
                this.baosp.write("IBMIMENU".getBytes());
                this.baosp.write(1);
                this.baosp.write(this.initialMenu.getBytes());
            }
            if (this.program != null) {
                this.baosp.write(3);
                this.baosp.write("IBMPROGRAM".getBytes());
                this.baosp.write(1);
                this.baosp.write(this.program.getBytes());
            }
        }
        this.baosp.write(-1);
        this.baosp.write(-16);
        this.writeByte(this.baosp.toByteArray());
        this.baosp.reset();
    }

    private String negDeviceName() {
        if (this.devSeq++ == -1) {
            this.devNameUsed = this.devName;
            return this.devName;
        }
        StringBuilder stringBuilder = new StringBuilder(this.devName + this.devSeq);
        int n = 1;
        while (stringBuilder.length() > 10) {
            stringBuilder.setLength(0);
            stringBuilder.append(this.devName.substring(0, this.devName.length() - n++));
            stringBuilder.append(this.devSeq);
        }
        this.devNameUsed = stringBuilder.toString();
        return this.devNameUsed;
    }

    public final void setCodePage(String string) {
        this.codePage = CharMappings.getCodePage(string);
        string = string.toLowerCase();
        for (KbdTypesCodePages kbdTypesCodePages : KbdTypesCodePages.values()) {
            if (!("cp" + kbdTypesCodePages.codepage).equals(string) && !kbdTypesCodePages.ccsid.equals(string)) continue;
            this.kbdTypesCodePage = kbdTypesCodePages;
            break;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Choosed keyboard mapping " + this.kbdTypesCodePage.toString() + " for code page " + string);
        }
    }

    public final ICodePage getCodePage() {
        return this.codePage;
    }

    public void signalBell() {
        this.controller.signalBell();
    }
}

