/*
 * Decompiled with CFR 0.152.
 */
package org.tn5250j.framework.transport.SSL;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;
import org.tn5250j.framework.transport.SSLInterface;
import org.tn5250j.tools.logging.TN5250jLogFactory;
import org.tn5250j.tools.logging.TN5250jLogger;

public class SSLImplementation
implements SSLInterface,
X509TrustManager {
    SSLContext sslContext = null;
    KeyStore userks = null;
    private String userKsPath;
    private char[] userksPassword = "changeit".toCharArray();
    KeyManagerFactory userkmf = null;
    TrustManagerFactory usertmf = null;
    TrustManager[] userTrustManagers = null;
    X509Certificate[] acceptedIssuers;
    TN5250jLogger logger = TN5250jLogFactory.getLogger(this.getClass());

    @Override
    public void init(String string) {
        try {
            this.logger.debug("Initializing User KeyStore");
            this.userKsPath = System.getProperty("user.home") + File.separator + ".tn5250j" + File.separator + "keystore";
            File file = new File(this.userKsPath);
            this.userks = KeyStore.getInstance(KeyStore.getDefaultType());
            this.userks.load(file.exists() ? new FileInputStream(file) : null, this.userksPassword);
            this.logger.debug("Initializing User Key Manager Factory");
            this.userkmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            this.userkmf.init(this.userks, this.userksPassword);
            this.logger.debug("Initializing User Trust Manager Factory");
            this.usertmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            this.usertmf.init(this.userks);
            this.userTrustManagers = this.usertmf.getTrustManagers();
            this.logger.debug("Initializing SSL Context");
            this.sslContext = SSLContext.getInstance(string);
            this.sslContext.init(this.userkmf.getKeyManagers(), new TrustManager[]{this}, null);
        }
        catch (Exception exception) {
            this.logger.error("Error initializing SSL [" + exception.getMessage() + "]");
        }
    }

    @Override
    public Socket createSSLSocket(String string, int n) {
        if (this.sslContext == null) {
            throw new IllegalStateException("SSL Context Not Initialized");
        }
        SSLSocket sSLSocket = null;
        try {
            sSLSocket = (SSLSocket)this.sslContext.getSocketFactory().createSocket(string, n);
        }
        catch (Exception exception) {
            this.logger.error("Error creating ssl socket [" + exception.getMessage() + "]");
        }
        return sSLSocket;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.acceptedIssuers;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        throw new SecurityException("checkClientTrusted unsupported");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        try {
            for (int i = 0; i < this.userTrustManagers.length; ++i) {
                if (!(this.userTrustManagers[i] instanceof X509TrustManager)) continue;
                X509TrustManager x509TrustManager = (X509TrustManager)this.userTrustManagers[i];
                X509Certificate[] x509CertificateArray2 = x509TrustManager.getAcceptedIssuers();
                if (x509CertificateArray2.length > 0) {
                    x509TrustManager.checkServerTrusted(x509CertificateArray, string);
                    continue;
                }
                throw new CertificateException("Empty list of accepted issuers (a.k.a. root CA list).");
            }
            return;
        }
        catch (CertificateException certificateException) {
            X509Certificate x509Certificate = x509CertificateArray[0];
            String string2 = "Version: " + x509Certificate.getVersion() + "\n";
            string2 = string2.concat("Serial Number: " + x509Certificate.getSerialNumber() + "\n");
            string2 = string2.concat("Signature Algorithm: " + x509Certificate.getSigAlgName() + "\n");
            string2 = string2.concat("Issuer: " + x509Certificate.getIssuerDN().getName() + "\n");
            string2 = string2.concat("Valid From: " + x509Certificate.getNotBefore() + "\n");
            string2 = string2.concat("Valid To: " + x509Certificate.getNotAfter() + "\n");
            string2 = string2.concat("Subject DN: " + x509Certificate.getSubjectDN().getName() + "\n");
            string2 = string2.concat("Public Key: " + x509Certificate.getPublicKey().getFormat() + "\n");
            int n = JOptionPane.showConfirmDialog(null, string2, "Unknown Certificate - Do you accept it?", 0);
            if (n != 0) {
                throw new CertificateException("Certificate Rejected");
            }
            int n2 = JOptionPane.showConfirmDialog(null, "Remember this certificate?", "Save Certificate", 0);
            if (n2 == 0) {
                try {
                    this.userks.setCertificateEntry(x509Certificate.getSubjectDN().getName(), x509Certificate);
                    this.userks.store(new FileOutputStream(this.userKsPath), this.userksPassword);
                }
                catch (Exception exception) {
                    this.logger.error("Error saving certificate [" + exception.getMessage() + "]");
                    exception.printStackTrace();
                }
            }
            return;
        }
    }
}

